/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.popup.content;

import ch.icit.pegasus.client.gui.submodules.popup.SubModulePopupContent;
import ch.icit.pegasus.client.gui.submodules.popup.SubModulePopupContentWithLoadBefore;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.ReportConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import com.google.common.collect.Ordering;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import junit.framework.Assert;

public class StyleSheetContent
extends SubModulePopupContent
implements SubModulePopupContentWithLoadBefore {
    protected RadioButtonBox reportTypeBox;
    private ReportTypeE reportType;
    private ListNode<List<ReportFileComplete>, ReportFileComplete> reports;

    public StyleSheetContent(ReportTypeE reportType) {
        this.reportType = reportType;
        this.reportTypeBox = new RadioButtonBox();
        this.setLayout(new Layout());
        this.add(this.reportTypeBox);
    }

    public ReportFileComplete getSelectedReport() {
        RadioButton b = null;
        if (this.reportTypeBox != null) {
            b = this.reportTypeBox.getSelectedButton() == null ? this.reportTypeBox.getAnyButton() : this.reportTypeBox.getSelectedButton();
        }
        if (b != null) {
            return ((DefaultScrollablePrintPopup2.ReportSelection)b).getUserObject();
        }
        return null;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.reportTypeBox.getFocusComponents();
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        this.reportTypeBox.requestFocusInWindow();
    }

    private void doLoadConfig() {
        if (this.reportType != null) {
            try {
                SearchResult r = ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getReportStyleSheet(this.reportType);
                List results = r.getResults();
                Collections.sort(results, Ordering.natural().onResultOf(input -> input.getDescription()));
                List reportConfig = ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getReportConfiguration(this.reportType).getList();
                if (reportConfig != null) {
                    block7: for (ReportConfigurationComplete rc : reportConfig) {
                        switch (rc.getType()) {
                            case HIDE_DEFAULT: {
                                Iterator it;
                                if (!rc.getShowDefault().booleanValue()) {
                                    it = results.iterator();
                                    while (it.hasNext()) {
                                        if (((ReportFileComplete)it.next()).getId() != null) continue;
                                        it.remove();
                                    }
                                }
                                if (!rc.getHideReport().booleanValue()) break;
                                it = results.iterator();
                                while (it.hasNext()) {
                                    ReportFileComplete report = (ReportFileComplete)it.next();
                                    if (!report.getDescription().equals(rc.getOriginReportName())) continue;
                                    it.remove();
                                }
                                continue block7;
                            }
                            case MAX_LABEL_ENTRIES: {
                                break;
                            }
                            case REPLACE_IN_LOCATION: {
                                Iterator it = results.iterator();
                                LocationComplete location = (LocationComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue();
                                if (rc.getShowReport().booleanValue() || !location.equals((Object)rc.getLocation())) break;
                                while (it.hasNext()) {
                                    ReportFileComplete rfc = (ReportFileComplete)it.next();
                                    if (!rfc.getDescription().equals(rc.getOriginReportName())) continue;
                                    it.remove();
                                }
                                break;
                            }
                        }
                    }
                }
                ListNode i = new ListNode();
                i.setValue((Object)results, 0L);
                this.reports = i;
            }
            catch (ClientServerCallException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public List<Runnable> getLoadBefore() {
        return Collections.singletonList(() -> this.doLoadConfig());
    }

    @Override
    public void processAfterLoadBeforeInSync() {
        Assert.assertTrue((String)"Is Swing Thread", (boolean)SwingUtilities.isEventDispatchThread());
        if (this.reportType != null && this.reportTypeBox != null) {
            for (ReportFileComplete r : (List)this.reports.getValue()) {
                if (!this.isReportAllowed(r)) continue;
                DefaultScrollablePrintPopup2.ReportSelection f = new DefaultScrollablePrintPopup2.ReportSelection(r);
                this.reportTypeBox.addBox(new TitledItem<DefaultScrollablePrintPopup2.ReportSelection>(f, r.getDescription(), TitledItem.TitledItemOrientation.EAST), f);
            }
            if (this.reportTypeBox.getAnyButton() != null) {
                this.reportTypeBox.getAnyButton().setChecked(true);
            }
        }
    }

    public boolean isReportAllowed(ReportFileComplete reportFile) {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return StyleSheetContent.this.reportTypeBox.getPreferredSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            StyleSheetContent.this.reportTypeBox.setLocation(0, 0);
            StyleSheetContent.this.reportTypeBox.setSize(parent.getWidth(), (int)StyleSheetContent.this.reportTypeBox.getPreferredSize().getHeight());
        }
    }
}

