/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.article.spec;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class PrintArticleSupplierSpecificationComponent
extends DefaultScrollablePrintPopup2<BasicArticleLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private Node<BasicArticleLight> currentArticle;
    private BasicArticleComplete articleComplete;
    private TitledItem<DateChooser> validFrom;
    private TextLabel supplierSelection;
    private List<TitledItem<CheckBox>> suppliers = new ArrayList<TitledItem<CheckBox>>();

    public PrintArticleSupplierSpecificationComponent(Node<BasicArticleLight> node) {
        super(false, false, false, false, null);
        this.currentArticle = node;
        this.loadBeforeShowing(() -> {
            BasicArticleLight artL = (BasicArticleLight)this.currentArticle.getValue();
            try {
                BasicArticleComplete artC;
                this.articleComplete = artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(artL.getId())).getValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        for (SupplierConditionBaseComplete supplier : this.articleComplete.getSuppliers()) {
            TitledItem<CheckBox> box = new TitledItem<CheckBox>(new CheckBox(), supplier.getSupplier().getName(), TitledItem.TitledItemOrientation.EAST);
            box.setUserObject(supplier.getSupplier());
            this.suppliers.add(box);
            this.getViewContainer().add(box);
        }
        TitledItem<CheckBox> all = new TitledItem<CheckBox>(new CheckBox(), Words.ALL, TitledItem.TitledItemOrientation.EAST);
        all.setUserObject(null);
        this.suppliers.add(all);
        this.getViewContainer().add(all);
        Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false);
        this.validFrom = new TitledItem<DateChooser>(new DateChooser(node), Words.VALIDITY_FROM, TitledItem.TitledItemOrientation.NORTH);
        this.validFrom.getElement().setNode(node);
        this.getViewContainer().add(this.validFrom);
        this.supplierSelection = new TextLabel(Words.SUPPLIER_SELECTION);
        this.getViewContainer().add(this.supplierSelection);
        this.createComponents();
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.ARTICLE;
    }

    @Override
    public String getTitleValue() {
        if (this.currentArticle.getChildNamed(BasicArticleLight_.number).getValue() == null) {
            return "-";
        }
        return "" + this.currentArticle.getChildNamed(BasicArticleLight_.number).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public boolean validateContent() {
        return true;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArrayList<SupplierReference> supplierList = new ArrayList<SupplierReference>();
                boolean useAll = false;
                for (TitledItem t : PrintArticleSupplierSpecificationComponent.this.suppliers) {
                    if (t.getUserObject() != null) continue;
                    useAll = true;
                }
                for (TitledItem t : PrintArticleSupplierSpecificationComponent.this.suppliers) {
                    SupplierLight supplierLight;
                    if (!useAll && !((CheckBox)t.getElement()).isChecked() || (supplierLight = (SupplierLight)t.getUserObject()) == null) continue;
                    supplierList.add(new SupplierReference(supplierLight.getId()));
                }
                java.util.Date d = ((DateChooser)PrintArticleSupplierSpecificationComponent.this.validFrom.getElement()).getSelectedDate();
                Date date = new Date(d.getTime());
                List t = ((SupplyReportServiceManager)ServiceManagerRegistry.getService(SupplyReportServiceManager.class)).getArticleSupplierSpecificationsForArticle(new BasicArticleReference(((BasicArticleLight)PrintArticleSupplierSpecificationComponent.this.currentArticle.getValue()).getId()), new ListWrapper(supplierList), new DateWrapper(date)).getList();
                if (t.isEmpty()) {
                    ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NO_SUPPLIER_SPECIFICATION_FOUND));
                    Node b = new Node();
                    b.setValue(a, 0L);
                    return b;
                }
                for (PegasusFileComplete f : t) {
                    if (!f.getUri().toString().toLowerCase().endsWith("pdf")) continue;
                    PrintArticleSupplierSpecificationComponent.this.processFile(f);
                }
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintArticleSupplierSpecificationComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<BasicArticleLight> getCurrentNode() {
        return this.currentArticle;
    }

    @Override
    public BatchJob<BasicArticleLight> createBatchJob(Node<BasicArticleLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintArticleSupplierSpecificationComponent.this.layoutInheritedComponents(parent);
            PrintArticleSupplierSpecificationComponent.this.validFrom.setLocation(PrintArticleSupplierSpecificationComponent.this.border, y + PrintArticleSupplierSpecificationComponent.this.border);
            PrintArticleSupplierSpecificationComponent.this.validFrom.setSize(PrintArticleSupplierSpecificationComponent.this.validFrom.getPreferredSize());
            y = PrintArticleSupplierSpecificationComponent.this.validFrom.getY() + PrintArticleSupplierSpecificationComponent.this.validFrom.getHeight() + PrintArticleSupplierSpecificationComponent.this.border;
            PrintArticleSupplierSpecificationComponent.this.supplierSelection.setLocation(PrintArticleSupplierSpecificationComponent.this.border, y);
            PrintArticleSupplierSpecificationComponent.this.supplierSelection.setSize(PrintArticleSupplierSpecificationComponent.this.supplierSelection.getPreferredSize());
            y = PrintArticleSupplierSpecificationComponent.this.supplierSelection.getY() + PrintArticleSupplierSpecificationComponent.this.supplierSelection.getHeight() + PrintArticleSupplierSpecificationComponent.this.border / 2;
            for (TitledItem box : PrintArticleSupplierSpecificationComponent.this.suppliers) {
                box.setLocation(PrintArticleSupplierSpecificationComponent.this.border * 2, y + PrintArticleSupplierSpecificationComponent.this.border / 2);
                box.setSize(box.getPreferredSize());
                y = box.getY() + box.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintArticleSupplierSpecificationComponent.this.getInheritedComponentsHeight();
            h += PrintArticleSupplierSpecificationComponent.this.border;
            if (PrintArticleSupplierSpecificationComponent.this.animation != null) {
                h = (int)((double)h + PrintArticleSupplierSpecificationComponent.this.animation.getPreferredSize().getHeight());
                return new Dimension((int)((double)(PrintArticleSupplierSpecificationComponent.this.border * 2) + PrintArticleSupplierSpecificationComponent.this.animation.getPreferredSize().getWidth()), h += PrintArticleSupplierSpecificationComponent.this.border);
            }
            h = (int)((double)h + PrintArticleSupplierSpecificationComponent.this.validFrom.getPreferredSize().getHeight());
            h += PrintArticleSupplierSpecificationComponent.this.border;
            h = (int)((double)h + PrintArticleSupplierSpecificationComponent.this.supplierSelection.getPreferredSize().getHeight());
            h += PrintArticleSupplierSpecificationComponent.this.border;
            for (TitledItem s : PrintArticleSupplierSpecificationComponent.this.suppliers) {
                h = (int)((double)h + s.getPreferredSize().getHeight());
                h += PrintArticleSupplierSpecificationComponent.this.border / 2;
            }
            return new Dimension(0, h += PrintArticleSupplierSpecificationComponent.this.border / 2);
        }
    }
}

