/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.article.stock;

import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.PriceConverter1;
import ch.icit.pegasus.client.converter.QuantityConverter1Decimal;
import ch.icit.pegasus.client.converter.QuantityConverter3Decimal;
import ch.icit.pegasus.client.converter.StorePositionShortNameConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateTimeChooser;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.print.BasicArticlePrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.BackgroundFadeSkin;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.report.ArticleStockReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.StoreTypeE;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.dtos.utils.ArticlePriceCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;

public class PrintArticleStockComponent
extends DefaultScrollablePrintPopupInsert
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private Node<BasicArticleLight> currentArticle;
    private Table2 table;
    private BackgroundFadeSkin fade;
    private TextLabel totalQuantity;
    private TextLabel totalQuantityHL;
    private TextLabel remark;
    private RadioButtonBox box;
    private TitledItem<RadioButton> asXLS;
    private HorizontalSeparator sep3;
    private TitledItem<DateTimeChooser> dateTimeChooser;
    private boolean isLoadingRemains = false;
    private RowModel<BasicArticleLight> model;
    private boolean loadingStock = false;
    private Timestamp latestTimeStamp;
    private Map<StorePositionLight, Date> expiryDates;

    public PrintArticleStockComponent(Node currentNode, RowModel<BasicArticleLight> model) {
        super(true, false);
        this.currentArticle = currentNode;
        this.model = model;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.model.getView().revalidate();
        this.model = null;
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return new BasicArticlePrintConfigurationComplete();
    }

    @Override
    public void errorOccurred(ClientException exception) {
        super.errorOccurred(exception);
        this.loadingStock = false;
        if (this.table != null) {
            this.table.hideLoadingAnimation();
        }
        this.removeAnimation(false);
        this.popup.enablePreviewButton();
        this.popup.enableOKButton(true);
        this.isLoadingRemains = false;
        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)this);
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
        this.createComponents();
        this.isLoadingRemains = true;
        this.popup.enableOKButton(false);
        this.popup.enableCancelButton(false);
        this.removeInheritedComponents();
        this.ensureAnimation(Words.LOAD_DATA);
        ThreadSafeExecutable getBasicArticle = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                BasicArticleLight artL = (BasicArticleLight)PrintArticleStockComponent.this.currentArticle.getValue(BasicArticleLight.class);
                if (PrintArticleStockComponent.this.currentArticle.getValue(BasicArticleComplete.class) == null) {
                    BasicArticleComplete a = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(artL.getId())).getValue();
                    PrintArticleStockComponent.this.currentArticle.removeExistingValues();
                    PrintArticleStockComponent.this.currentArticle.setValue((Object)a, 0L);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        PrintArticleStockComponent.this.runStockAccess(new Timestamp(System.currentTimeMillis()));
                    }

                    public void errorOccurred(ClientException exception) {
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(getBasicArticle);
    }

    private ThreadSafeExecutable getStockAccessor(final Timestamp timestamp) {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                BasicArticleLight artL = (BasicArticleLight)PrintArticleStockComponent.this.currentArticle.getValue(BasicArticleLight.class);
                Map stock = ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStockPerStorePositionAtTime(new BasicArticleReference(artL.getId()), new TimestampWrapper(timestamp)).getMap();
                PrintArticleStockComponent.this.expiryDates = ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getExpiryDatePerStorePositionAtTime(new BasicArticleReference(artL.getId()), new TimestampWrapper(timestamp)).getMap();
                ViewNode searchResults = new ViewNode("");
                if (stock != null) {
                    Iterator it = stock.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry nn = it.next();
                        if (((StorePositionLight)nn.getKey()).getStore().getStoreType() == StoreTypeE.IRREGULARITY) {
                            it.remove();
                            continue;
                        }
                        ViewNode nNode = new ViewNode("");
                        ViewNode storeN = new ViewNode("");
                        ViewNode quantNode = new ViewNode("");
                        storeN.setValue(nn.getKey(), 0L);
                        storeN.setName(DtoFieldConstants.STORE_POSITION);
                        quantNode.setValue(nn.getValue(), 0L);
                        quantNode.setName(DtoFieldConstants.QUANTITY);
                        nNode.addChild((Node)storeN, 0L);
                        nNode.addChild((Node)quantNode, 0L);
                        searchResults.addChild((Node)nNode, 0L);
                    }
                }
                searchResults.setValue((Object)stock, 0L);
                return searchResults;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintArticleStockComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    public void remoteObjectLoaded(Node node) {
        if (this.latestTimeStamp != null) {
            this.runStockAccess(this.latestTimeStamp);
            this.latestTimeStamp = null;
            return;
        }
        this.loadingStock = false;
        if (this.isLoadingRemains) {
            this.removeAnimation(false);
            this.createComponents();
            this.createInners();
            this.table.getModel().setNode(node);
            this.popup.enableCancelButton(true);
        } else {
            if (this.table != null) {
                this.table.hideLoadingAnimation();
                this.table.getModel().setNode(node);
            }
            this.removeAnimation(false);
        }
        this.popup.enablePreviewButton();
        this.popup.enableOKButton(true);
        this.updateTotalStock((Map)node.getValue());
        this.isLoadingRemains = false;
    }

    private void updateTotalStock(Map<StorePositionLight, StoreQuantityComplete> stockMap) {
        if (stockMap == null) {
            return;
        }
        BasicArticleComplete art = (BasicArticleComplete)this.currentArticle.getValue(BasicArticleComplete.class);
        double totalAmountInStoreUnit = 0.0;
        double totalAmountInStoreUnitHL = 0.0;
        for (Map.Entry<StorePositionLight, StoreQuantityComplete> entry : stockMap.entrySet()) {
            StoreQuantityComplete stock;
            if (Boolean.TRUE.equals(entry.getKey().getStore().getMainStore())) {
                stock = entry.getValue();
                totalAmountInStoreUnitHL += UnitConversionToolkit.convertUnit((UnitComplete)stock.getUnit(), (UnitComplete)art.getMainStoreUnit(), (double)stock.getAmount().longValue(), (BasicArticleLight)art, (Timestamp)new Timestamp(System.currentTimeMillis()));
            }
            stock = entry.getValue();
            totalAmountInStoreUnit += UnitConversionToolkit.convertUnit((UnitComplete)stock.getUnit(), (UnitComplete)art.getMainStoreUnit(), (double)stock.getAmount().longValue(), (BasicArticleLight)art, (Timestamp)new Timestamp(System.currentTimeMillis()));
        }
        String t = "~ Main Store " + ((QuantityConverter1Decimal)ConverterRegistry.getConverter(QuantityConverter1Decimal.class)).convert((Object)new QuantityComplete(Double.valueOf(totalAmountInStoreUnitHL), art.getMainStoreUnit()), null, new Object[0]);
        String t2 = "~ Total " + ((QuantityConverter1Decimal)ConverterRegistry.getConverter(QuantityConverter1Decimal.class)).convert((Object)new QuantityComplete(Double.valueOf(totalAmountInStoreUnit), art.getMainStoreUnit()), null, new Object[0]);
        this.totalQuantity.setText(t2);
        this.totalQuantityHL.setText(t);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.table != null) {
            this.table.setVisible(false);
            this.totalQuantity.setVisible(false);
            this.totalQuantityHL.setVisible(false);
            this.remark.setVisible(false);
            this.dateTimeChooser.setVisible(false);
            this.asXLS.setVisible(false);
            this.sep3.setVisible(false);
        }
    }

    private void createInners() {
        this.fade = SkinRegistry.getSkin(BackgroundFadeSkin.class);
        this.box = new RadioButtonBox();
        this.box.setOrientation(0);
        this.asXLS = new TitledItem<RadioButton>(new RadioButton(), "Excel", TitledItem.TitledItemOrientation.EAST);
        this.box.addBox(this.asXLS, this.asXLS.getElement());
        this.sep3 = new HorizontalSeparator();
        this.getViewContainer().add(this.box);
        this.getViewContainer().add(this.sep3);
        this.asXLS.getElement().setChecked(true);
        this.table = new Table2(false, "", true, false);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.STORE, null, null, null, "", 30, 30, 30));
        int tw = QuantityRenderer.getPreferredSize(this);
        columns.add(new TableColumnInfo(Words.QUANTITY, null, null, null, "", tw += this.table.getCellPadding() * 2, tw, tw));
        columns.add(new TableColumnInfo(Words.VALUE + "*", null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.NEXT_EXPIRY, null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
        this.totalQuantity = new TextLabel();
        this.totalQuantity.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type")));
        this.totalQuantityHL = new TextLabel();
        this.totalQuantityHL.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type")));
        this.dateTimeChooser = new TitledItem<DateTimeChooser>(new DateTimeChooser((Node<Timestamp>)INodeCreator.getDefaultImpl().getNode4DTO((Object)new Timestamp(System.currentTimeMillis()), false, false)), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.getViewContainer().add(this.dateTimeChooser);
        this.dateTimeChooser.getElement().getNode().addNodeListener((NodeListener)this);
        this.remark = new TextLabel();
        this.remark.setText("* calculated with Standard Price");
        this.getViewContainer().setLayout(new Layout());
        this.popup.createFocusCycle();
        this.getViewContainer().add(this.table);
        this.getViewContainer().add(this.totalQuantity);
        this.getViewContainer().add(this.totalQuantityHL);
        this.getViewContainer().add(this.remark);
    }

    @Override
    public String getTitleString() {
        return Words.ARTICLE_NAME;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusComponents = super.getFocusComponents();
        CheckedListAdder.addToList(focusComponents, this.dateTimeChooser);
        return focusComponents;
    }

    @Override
    protected String getProgressText() {
        if (this.isLoadingRemains) {
            return Words.LOADING_ARTICLE_DATA;
        }
        return WordsToolkit.toCapitalLetter((String)Words.PRINT);
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentArticle.getChildNamed(BasicArticleLight_.name).getValue();
    }

    @Override
    public boolean withSecondSeparator() {
        return true;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportingOutputFormatE format = null;
                if (((RadioButton)PrintArticleStockComponent.this.asXLS.getElement()).isChecked()) {
                    format = ReportingOutputFormatE.XLSX;
                }
                ReportFileComplete styleSheet = null;
                ArrayList<BasicArticleReference> articles = new ArrayList<BasicArticleReference>();
                articles.add(new BasicArticleReference(((BasicArticleLight)PrintArticleStockComponent.this.currentArticle.getValue()).getId()));
                ArticleStockReportConfiguration config = new ArticleStockReportConfiguration(ReportTypeE.ARTICLE_STOCK, format, styleSheet);
                config.setArticleReferences(articles);
                config.setTimestamp(((DateTimeChooser)PrintArticleStockComponent.this.dateTimeChooser.getElement()).getTimestamp());
                PegasusFileComplete file = (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).printArticleStockPerStorePositionAtTime(config).getValue();
                PrintPopupToolkit.previewFile(file);
                PrintArticleStockComponent.super.remoteObjectLoaded((Node)new ViewNode(""));
                return new ViewNode("");
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintArticleStockComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    public void valueChanged(Node<?> node) {
        this.reloadAndShowStock((Timestamp)node.getValue());
    }

    private void reloadAndShowStock(Timestamp timeStamp) {
        if (this.loadingStock) {
            this.latestTimeStamp = timeStamp;
            return;
        }
        this.loadingStock = true;
        this.runStockAccess(timeStamp);
    }

    private void runStockAccess(Timestamp timeStamp) {
        if (this.table != null) {
            this.table.showLoadingAnimation(Phrase.getPhrase((String)Phrase.LOAD_STOCK_FOR_DATE, (Object[])new Object[]{((DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class)).convert((Object)timeStamp, null, new Object[0])}));
        }
        ThreadSafeLoader.run(this.getStockAccessor(timeStamp));
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?>[] nodes) {
    }

    public boolean isSwingOnly() {
        return false;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements NodeListener {
        private static final long serialVersionUID = 1L;
        private TextLabel storeName;
        private QuantityRenderer quantity;
        private TextLabel price;
        private TextLabel expiryDate;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new Layout());
            this.storeName = new TextLabel(m.getNode().getChildNamed(DtoFieldConstants.STORE_POSITION), ConverterRegistry.getConverter(StorePositionShortNameConverter.class));
            StorePositionLight storePosition = (StorePositionLight)m.getNode().getChildNamed(DtoFieldConstants.STORE_POSITION).getValue();
            BasicArticleComplete artC = (BasicArticleComplete)PrintArticleStockComponent.this.currentArticle.getValue(BasicArticleComplete.class);
            StoreQuantityComplete old = (StoreQuantityComplete)m.getNode().getChildNamed(DtoFieldConstants.QUANTITY).getValue();
            UnitComplete targetUnit = null;
            targetUnit = Boolean.TRUE.equals(storePosition.getStore().getMainStore()) ? artC.getMainStoreUnit() : artC.getFloatStoreUnit();
            double qtyInStoreUnit = UnitConversionToolkit.convertUnit((UnitComplete)old.getUnit(), (UnitComplete)targetUnit, (double)old.getAmount().longValue(), (BasicArticleLight)artC, (Timestamp)new Timestamp(System.currentTimeMillis()));
            QuantityComplete storeUnitQuantity = new QuantityComplete(Double.valueOf(qtyInStoreUnit), targetUnit);
            this.quantity = new QuantityRenderer((Node<?>)INodeCreator.getDefaultImpl().getNode4DTO((Object)storeUnitQuantity, false, false));
            this.quantity.setViewConverter(ConverterRegistry.getConverter(QuantityConverter3Decimal.class));
            this.price = new TextLabel();
            this.calculatePrice();
            this.storeName.setProgress(1.0f);
            Object thing = PrintArticleStockComponent.this.expiryDates.get(m.getNode().getChildNamed(DtoFieldConstants.STORE_POSITION).getValue());
            Date exp = null;
            if (thing instanceof XMLGregorianCalendar) {
                XMLGregorianCalendar t = (XMLGregorianCalendar)thing;
                exp = DateUtil.getSQLDate((int)t.getYear(), (int)t.getMonth(), (int)t.getDay(), (int)t.getHour(), (int)t.getMinute(), (int)t.getSecond());
            } else {
                exp = (Date)thing;
            }
            this.expiryDate = new TextLabel(((DateConverter)ConverterRegistry.getConverter(DateConverter.class)).convert((Object)exp, null, new Object[0]));
            this.add(this.storeName);
            this.add(this.quantity);
            this.add(this.price);
            this.add(this.expiryDate);
        }

        private void calculatePrice() {
            StoreQuantityComplete q1 = (StoreQuantityComplete)this.model.getNode().getChildNamed(DtoFieldConstants.QUANTITY).getValue();
            double a = q1.getAmount().longValue();
            BasicArticleComplete artC = (BasicArticleComplete)PrintArticleStockComponent.this.currentArticle.getValue(BasicArticleComplete.class);
            UnitComplete storeU = (UnitComplete)PrintArticleStockComponent.this.currentArticle.getChildNamed(BasicArticleLight_.priceUnit).getValue();
            a = UnitConversionToolkit.convertUnit((UnitComplete)q1.getUnit(), (UnitComplete)storeU, (double)a, (BasicArticleLight)artC, (Timestamp)new Timestamp(System.currentTimeMillis()));
            PriceComplete p = ArticlePriceCalculationToolkit.getBruttoForQuantity((BasicArticleComplete)artC, (QuantityComplete)new QuantityComplete(Double.valueOf(a), storeU), (Timestamp)new Timestamp(System.currentTimeMillis()), null, (boolean)false);
            String t = ((PriceConverter1)ConverterRegistry.getConverter(PriceConverter1.class)).convert(p, null, new Object[0]);
            this.price.setText(t);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.storeName.getText();
                }
                case 1: {
                    return this.quantity.getText();
                }
                case 2: {
                    return this.price.getText();
                }
                case 3: {
                    return this.expiryDate.getText();
                }
            }
            return null;
        }

        public QuantityComplete getQuantity() {
            return (QuantityComplete)this.quantity.getNode().getValue();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.storeName.setEnabled(isEnabled);
            this.quantity.setEnabled(isEnabled);
            this.price.setEnabled(isEnabled);
            PrintArticleStockComponent.this.dateTimeChooser.setEnabled(isEnabled);
            this.expiryDate.setEnabled(isEnabled);
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.storeName = null;
            this.quantity = null;
            this.price = null;
            this.expiryDate = null;
        }

        public void valueChanged(Node<?> node) {
            this.calculatePrice();
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return false;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.storeName.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.storeName.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.storeName.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.storeName.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.quantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.quantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.quantity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.quantity.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.price.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.price.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.price.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.expiryDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.expiryDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.expiryDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.expiryDate.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int cy = PrintArticleStockComponent.this.layoutInheritedComponents(parent);
            cy += PrintArticleStockComponent.this.border;
            if (PrintArticleStockComponent.this.table != null) {
                int backHeight = (int)((double)PrintArticleStockComponent.this.fade.getImage(11).getHeight() * 1.5);
                if (PrintArticleStockComponent.this.box != null) {
                    PrintArticleStockComponent.this.box.setLocation(PrintArticleStockComponent.this.border, cy);
                    PrintArticleStockComponent.this.box.setSize(parent.getWidth() - 2 * PrintArticleStockComponent.this.border, (int)PrintArticleStockComponent.this.box.getPreferredSize().getHeight());
                    cy = PrintArticleStockComponent.this.box.getY() + PrintArticleStockComponent.this.box.getHeight() + PrintArticleStockComponent.this.border;
                }
                if (PrintArticleStockComponent.this.sep3 != null) {
                    PrintArticleStockComponent.this.sep3.setLocation(0, cy);
                    PrintArticleStockComponent.this.sep3.setSize(parent.getWidth(), (int)PrintArticleStockComponent.this.sep3.getPreferredSize().getHeight());
                    cy = PrintArticleStockComponent.this.sep3.getY() + PrintArticleStockComponent.this.sep3.getHeight() + PrintArticleStockComponent.this.border;
                }
                if (PrintArticleStockComponent.this.dateTimeChooser != null) {
                    PrintArticleStockComponent.this.dateTimeChooser.setLocation(PrintArticleStockComponent.this.border, cy);
                    PrintArticleStockComponent.this.dateTimeChooser.setSize(parent.getWidth() - 2 * PrintArticleStockComponent.this.border, (int)PrintArticleStockComponent.this.dateTimeChooser.getPreferredSize().getHeight());
                    cy = PrintArticleStockComponent.this.dateTimeChooser.getY() + PrintArticleStockComponent.this.dateTimeChooser.getHeight() + PrintArticleStockComponent.this.border * 2;
                }
                PrintArticleStockComponent.this.table.setLocation(PrintArticleStockComponent.this.border, cy);
                PrintArticleStockComponent.this.table.setSize(parent.getWidth() - 2 * PrintArticleStockComponent.this.border, parent.getHeight() - (cy + PrintArticleStockComponent.this.border + backHeight));
                int w = (parent.getWidth() - 2 * PrintArticleStockComponent.this.border * 3) / 2;
                PrintArticleStockComponent.this.totalQuantityHL.setLocation(PrintArticleStockComponent.this.border, PrintArticleStockComponent.this.table.getY() + PrintArticleStockComponent.this.table.getHeight() + PrintArticleStockComponent.this.border);
                PrintArticleStockComponent.this.totalQuantityHL.setSize(w, (int)PrintArticleStockComponent.this.totalQuantityHL.getPreferredSize().getHeight());
                PrintArticleStockComponent.this.totalQuantity.setLocation(PrintArticleStockComponent.this.border, PrintArticleStockComponent.this.totalQuantityHL.getY() + PrintArticleStockComponent.this.totalQuantityHL.getHeight());
                PrintArticleStockComponent.this.totalQuantity.setSize(w, (int)PrintArticleStockComponent.this.totalQuantity.getPreferredSize().getHeight());
                PrintArticleStockComponent.this.remark.setLocation(2 * PrintArticleStockComponent.this.border + w, (int)((double)(parent.getHeight() - backHeight) + ((double)backHeight - PrintArticleStockComponent.this.remark.getPreferredSize().getHeight()) / 2.0));
                PrintArticleStockComponent.this.remark.setSize(w, (int)PrintArticleStockComponent.this.remark.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintArticleStockComponent.this.getInheritedComponentsHeight() + PrintArticleStockComponent.this.border;
            return new Dimension(0, h);
        }
    }
}

