/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.article.transactions;

import ch.icit.pegasus.client.converter.BondedStateEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDateTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.SearchReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.report.StockTransactionSearchReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.StockTransactionSearchReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StockTransactionSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StockTransactionSearchConfiguration_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;

public class PrintArticleTransactionsComponent
extends DefaultScrollablePrintPopup2<BasicArticleLight> {
    private static final long serialVersionUID = 1L;
    private Node<StockTransactionSearchReportConfiguration> configNode;
    private TitledDateTimePeriodChooser period;
    private TitledItem<ComboBox> bonded;
    private TitledItem<CheckBox> groupTransactions;
    private TitledItem<CheckBox> includeIrregularity;
    private TitledItem<CheckBox> includeHistoryIrregularity;
    private TitledItem<CheckBox> includeCustomerData;
    private Node<BasicArticleLight> articleNode;
    private TitledItem<ComboBox> inout;

    public PrintArticleTransactionsComponent(Node<BasicArticleLight> node) {
        super(true, false, false, true, false, ReportTypeE.STOCK_TRANSACTION);
        this.articleNode = node;
        StockTransactionSearchReportConfiguration config = new StockTransactionSearchReportConfiguration(ReportTypeE.STOCK_TRANSACTION, ReportingOutputFormatE.PDF, null);
        config.setSearchConfig((ADtoSearchConfiguration)new StockTransactionSearchConfiguration());
        ((StockTransactionSearchConfiguration)config.getSearchConfig()).setArticle(new BasicArticleReference(((BasicArticleLight)node.getValue()).getId()));
        config.setPeriod(new TimestampPeriodComplete(new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis())));
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            if (n.equals("startDate")) {
                try {
                    long l = Long.valueOf(v);
                    this.period.getStartTimeChooser().getDateChooser().getNode().setValue((Object)new Timestamp(l), 0L);
                }
                catch (Exception l) {}
                continue;
            }
            if (!n.equals("endDate")) continue;
            try {
                long l = Long.valueOf(v);
                this.period.getEndTimeChooser().getDateChooser().getNode().setValue((Object)new Timestamp(l), 0L);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("bonded", "" + this.bonded.getElement().getSelectedItem().toString());
        conf.addProperty("startDate", "" + this.period.getTimePeriod().getStartTime().getTime());
        conf.addProperty("endDate", "" + this.period.getTimePeriod().getEndTime().getTime());
        return conf;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.period);
        CheckedListAdder.addToList(focusList, this.bonded);
        CheckedListAdder.addToList(focusList, this.inout);
        CheckedListAdder.addToList(focusList, this.groupTransactions);
        CheckedListAdder.addToList(focusList, this.includeIrregularity);
        CheckedListAdder.addToList(focusList, this.includeHistoryIrregularity);
        CheckedListAdder.addToList(focusList, this.includeCustomerData);
        return focusList;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        Node start = new Node();
        start.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        Node end = new Node();
        end.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.period = new TitledDateTimePeriodChooser((Node<TimestampPeriodComplete>)this.configNode.getChildNamed(StockTransactionSearchReportConfiguration_.period));
        this.bonded = new TitledItem<ComboBox>(new ComboBox(this.configNode.getChildNamed(new DtoField[]{SearchReportConfiguration_.searchConfig, StockTransactionSearchConfiguration_.bonded}), NodeToolkit.getAffixList(BondedStateE.class), ConverterRegistry.getConverter(BondedStateEConverter.class)), "Bonded only", TitledItem.TitledItemOrientation.NORTH);
        this.bonded.getTitle().setFont(f);
        this.bonded.getTitle().setForeground(fb);
        this.inout = new TitledItem<ComboBox>(new ComboBox(), Words.RECEIPT_OUTGOING, TitledItem.TitledItemOrientation.NORTH);
        this.inout.getElement().addItem(IN_OUT.BOTH);
        this.inout.getElement().addItem(IN_OUT.IN);
        this.inout.getElement().addItem(IN_OUT.OUT);
        this.inout.getTitle().setFont(f);
        this.inout.getTitle().setForeground(fb);
        this.groupTransactions = new TitledItem<CheckBox>(new CheckBox(), Words.GROUP_TRANSACTIONS, TitledItem.TitledItemOrientation.EAST);
        this.includeIrregularity = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_IRREGULARITY, TitledItem.TitledItemOrientation.EAST);
        this.includeIrregularity.getElement().addButtonListener(this);
        this.includeHistoryIrregularity = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_HISTORY_IRREGULARITY, TitledItem.TitledItemOrientation.EAST);
        this.includeHistoryIrregularity.getElement().setEnabled(false);
        this.includeCustomerData = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_CUSTOMER_DATA, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.period);
        this.getViewContainer().add(this.bonded);
        this.getViewContainer().add(this.inout);
        this.getViewContainer().add(this.groupTransactions);
        this.getViewContainer().add(this.includeIrregularity);
        this.getViewContainer().add(this.includeHistoryIrregularity);
        this.getViewContainer().add(this.includeCustomerData);
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.bonded != null) {
            this.bonded.setEnabled(isEnabled);
            this.inout.setEnabled(isEnabled);
            this.period.setEnabled(isEnabled);
        }
        boolean b = isEnabled;
        if (this.asXLS != null) {
            boolean bl = b = b && ((RadioButton)this.asXLS.getElement()).isChecked();
        }
        if (this.includeIrregularity != null) {
            this.includeIrregularity.setEnabled(b);
        }
        if (this.includeHistoryIrregularity != null) {
            if (b && this.includeIrregularity != null && this.includeIrregularity.getElement().isChecked()) {
                this.includeHistoryIrregularity.setEnabled(b);
            } else {
                this.includeHistoryIrregularity.getElement().setChecked(false);
                this.includeHistoryIrregularity.setEnabled(false);
            }
        }
        if (this.groupTransactions != null) {
            this.groupTransactions.setEnabled(!b);
        }
        if (this.includeCustomerData != null) {
            this.includeCustomerData.setEnabled(b);
        }
    }

    @Override
    public String getTitleString() {
        return Words.ARTICLE_TRANSACTIONS;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.bonded != null && this.bonded.isInnerComponent(c)) {
            return true;
        }
        return super.isInnerComponent(c);
    }

    @Override
    public String getTitleValue() {
        return ((BasicArticleLight)this.articleNode.getValue()).getNumber() + " - " + ((BasicArticleLight)this.articleNode.getValue()).getName();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.period != null) {
            this.period.kill();
        }
        if (this.bonded != null) {
            this.bonded.kill();
        }
        if (this.inout != null) {
            this.inout.kill();
        }
        if (this.groupTransactions != null) {
            this.groupTransactions.kill();
        }
        if (this.includeIrregularity != null) {
            this.includeIrregularity.kill();
        }
        if (this.includeHistoryIrregularity != null) {
            this.includeHistoryIrregularity.kill();
        }
        if (this.includeCustomerData != null) {
            this.includeCustomerData.kill();
        }
        this.period = null;
        this.bonded = null;
        this.inout = null;
        this.groupTransactions = null;
        this.includeIrregularity = null;
        this.includeHistoryIrregularity = null;
        this.includeCustomerData = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.period != null) {
            this.period.setVisible(true);
        }
        if (this.bonded != null) {
            this.bonded.setVisible(true);
        }
        if (this.inout != null) {
            this.inout.setVisible(true);
        }
        if (this.groupTransactions != null) {
            this.groupTransactions.setVisible(true);
        }
        if (this.includeIrregularity != null) {
            this.includeIrregularity.setVisible(true);
        }
        if (this.includeHistoryIrregularity != null) {
            this.includeHistoryIrregularity.setVisible(true);
        }
        if (this.includeCustomerData != null) {
            this.includeCustomerData.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.period != null) {
            this.period.setVisible(false);
        }
        if (this.bonded != null) {
            this.bonded.setVisible(false);
        }
        if (this.inout != null) {
            this.inout.setVisible(false);
        }
        if (this.groupTransactions != null) {
            this.groupTransactions.setVisible(false);
        }
        if (this.includeIrregularity != null) {
            this.includeIrregularity.setVisible(false);
        }
        if (this.includeHistoryIrregularity != null) {
            this.includeHistoryIrregularity.setVisible(false);
        }
        if (this.includeCustomerData != null) {
            this.includeCustomerData.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintArticleTransactionsComponent.this.getSelectedReport();
                PrintArticleTransactionsComponent.this.configNode.commit();
                StockTransactionSearchReportConfiguration config = (StockTransactionSearchReportConfiguration)PrintArticleTransactionsComponent.this.configNode.getValue();
                config.setStylesheet(file);
                config.setFormat(ReportingOutputFormatE.XLSX);
                if (PrintArticleTransactionsComponent.this.inout != null) {
                    if (((ComboBox)PrintArticleTransactionsComponent.this.inout.getElement()).getSelectedItem() == IN_OUT.IN) {
                        ((StockTransactionSearchConfiguration)config.getSearchConfig()).setCheckinOnly(Boolean.valueOf(true));
                    } else if (((ComboBox)PrintArticleTransactionsComponent.this.inout.getElement()).getSelectedItem() == IN_OUT.OUT) {
                        ((StockTransactionSearchConfiguration)config.getSearchConfig()).setCheckinOnly(Boolean.valueOf(false));
                    } else {
                        ((StockTransactionSearchConfiguration)config.getSearchConfig()).setCheckinOnly(null);
                    }
                }
                ((StockTransactionSearchConfiguration)config.getSearchConfig()).setIncludeAllTransactions(Boolean.valueOf(true));
                if (PrintArticleTransactionsComponent.this.bonded != null) {
                    ((StockTransactionSearchConfiguration)config.getSearchConfig()).setBonded((BondedStateE)((Node)((ComboBox)PrintArticleTransactionsComponent.this.bonded.getElement()).getSelectedItem()).getValue());
                }
                if (PrintArticleTransactionsComponent.this.groupTransactions != null) {
                    config.setGroupByType(Boolean.valueOf(((CheckBox)PrintArticleTransactionsComponent.this.groupTransactions.getElement()).isChecked()));
                }
                if (PrintArticleTransactionsComponent.this.includeIrregularity != null) {
                    config.setIncludeIrregularity(Boolean.valueOf(((CheckBox)PrintArticleTransactionsComponent.this.includeIrregularity.getElement()).isChecked()));
                }
                if (PrintArticleTransactionsComponent.this.includeHistoryIrregularity != null) {
                    config.setIncludeHistoryIrregularity(Boolean.valueOf(((CheckBox)PrintArticleTransactionsComponent.this.includeHistoryIrregularity.getElement()).isChecked()));
                }
                if (PrintArticleTransactionsComponent.this.includeCustomerData != null) {
                    config.setIncludeCustomerData(Boolean.valueOf(((CheckBox)PrintArticleTransactionsComponent.this.includeCustomerData.getElement()).isChecked()));
                }
                config.setPeriod(PrintArticleTransactionsComponent.this.period.getTimePeriod());
                PegasusFileComplete t = (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createFlightTransactionReport(config).getValue();
                PrintArticleTransactionsComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintArticleTransactionsComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<BasicArticleLight> getCurrentNode() {
        return this.articleNode;
    }

    @Override
    public BatchJob<BasicArticleLight> createBatchJob(Node<BasicArticleLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintArticleTransactionsComponent.this.layoutInheritedComponents(parent) + PrintArticleTransactionsComponent.this.border;
            if (PrintArticleTransactionsComponent.this.period != null) {
                PrintArticleTransactionsComponent.this.period.setLocation(PrintArticleTransactionsComponent.this.border, y + PrintArticleTransactionsComponent.this.border / 2);
                PrintArticleTransactionsComponent.this.period.setSize(parent.getWidth() - 2 * PrintArticleTransactionsComponent.this.border, (int)PrintArticleTransactionsComponent.this.period.getPreferredSize().getHeight());
                PrintArticleTransactionsComponent.this.bonded.setLocation(PrintArticleTransactionsComponent.this.border, PrintArticleTransactionsComponent.this.period.getY() + PrintArticleTransactionsComponent.this.period.getHeight() + PrintArticleTransactionsComponent.this.border / 2);
                PrintArticleTransactionsComponent.this.bonded.setSize(parent.getWidth() - 2 * PrintArticleTransactionsComponent.this.border, (int)PrintArticleTransactionsComponent.this.bonded.getPreferredSize().getHeight());
                PrintArticleTransactionsComponent.this.inout.setLocation(PrintArticleTransactionsComponent.this.border, PrintArticleTransactionsComponent.this.bonded.getY() + PrintArticleTransactionsComponent.this.bonded.getHeight() + PrintArticleTransactionsComponent.this.border / 2);
                PrintArticleTransactionsComponent.this.inout.setSize(parent.getWidth() - 2 * PrintArticleTransactionsComponent.this.border, (int)PrintArticleTransactionsComponent.this.inout.getPreferredSize().getHeight());
                PrintArticleTransactionsComponent.this.groupTransactions.setLocation(PrintArticleTransactionsComponent.this.border, PrintArticleTransactionsComponent.this.inout.getY() + PrintArticleTransactionsComponent.this.inout.getHeight() + PrintArticleTransactionsComponent.this.border / 2);
                PrintArticleTransactionsComponent.this.groupTransactions.setSize(parent.getWidth() - 2 * PrintArticleTransactionsComponent.this.border, (int)PrintArticleTransactionsComponent.this.groupTransactions.getPreferredSize().getHeight());
                PrintArticleTransactionsComponent.this.includeIrregularity.setLocation(PrintArticleTransactionsComponent.this.border, PrintArticleTransactionsComponent.this.groupTransactions.getY() + PrintArticleTransactionsComponent.this.groupTransactions.getHeight() + PrintArticleTransactionsComponent.this.border / 2);
                PrintArticleTransactionsComponent.this.includeIrregularity.setSize(parent.getWidth() - 2 * PrintArticleTransactionsComponent.this.border, (int)PrintArticleTransactionsComponent.this.includeIrregularity.getPreferredSize().getHeight());
                PrintArticleTransactionsComponent.this.includeHistoryIrregularity.setLocation(PrintArticleTransactionsComponent.this.border, PrintArticleTransactionsComponent.this.includeIrregularity.getY() + PrintArticleTransactionsComponent.this.includeIrregularity.getHeight() + PrintArticleTransactionsComponent.this.border / 2);
                PrintArticleTransactionsComponent.this.includeHistoryIrregularity.setSize(parent.getWidth() - 2 * PrintArticleTransactionsComponent.this.border, (int)PrintArticleTransactionsComponent.this.includeHistoryIrregularity.getPreferredSize().getHeight());
                PrintArticleTransactionsComponent.this.includeCustomerData.setLocation(PrintArticleTransactionsComponent.this.border, PrintArticleTransactionsComponent.this.includeHistoryIrregularity.getY() + PrintArticleTransactionsComponent.this.includeHistoryIrregularity.getHeight() + PrintArticleTransactionsComponent.this.border / 2);
                PrintArticleTransactionsComponent.this.includeCustomerData.setSize(parent.getWidth() - 2 * PrintArticleTransactionsComponent.this.border, (int)PrintArticleTransactionsComponent.this.includeCustomerData.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintArticleTransactionsComponent.this.getInheritedComponentsHeight();
            int w = 250;
            if (PrintArticleTransactionsComponent.this.period != null) {
                h = (int)((double)h + PrintArticleTransactionsComponent.this.period.getPreferredSize().getHeight());
                h += PrintArticleTransactionsComponent.this.border / 2;
                h = (int)((double)h + PrintArticleTransactionsComponent.this.bonded.getPreferredSize().getHeight());
                h += PrintArticleTransactionsComponent.this.border / 2;
                h = (int)((double)h + PrintArticleTransactionsComponent.this.inout.getPreferredSize().getHeight());
                h += PrintArticleTransactionsComponent.this.border / 2;
                h = (int)((double)h + PrintArticleTransactionsComponent.this.groupTransactions.getPreferredSize().getHeight());
                h += PrintArticleTransactionsComponent.this.border / 2;
                h = (int)((double)h + PrintArticleTransactionsComponent.this.includeIrregularity.getPreferredSize().getHeight());
                h += PrintArticleTransactionsComponent.this.border / 2;
                h = (int)((double)h + PrintArticleTransactionsComponent.this.includeHistoryIrregularity.getPreferredSize().getHeight());
                h += PrintArticleTransactionsComponent.this.border / 2;
                h = (int)((double)h + PrintArticleTransactionsComponent.this.includeCustomerData.getPreferredSize().getHeight());
                h += PrintArticleTransactionsComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }

    public static enum IN_OUT {
        IN,
        OUT,
        BOTH;


        public String toString() {
            switch (this) {
                case BOTH: {
                    return Words.BOTH;
                }
                case IN: {
                    return Words.RECEIPT;
                }
                case OUT: {
                    return Words.OUTGOING;
                }
            }
            return "-";
        }
    }
}

