/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.articlestockswap.batchposition;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.ArticleSwapServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.swap.stock.ArticleStockSwapBatchPositionConfiguration;
import ch.icit.pegasus.server.core.dtos.swap.stock.ArticleStockSwapDataImportLight;
import ch.icit.pegasus.server.core.dtos.swap.stock.ArticleStockSwapDataImportLight_;
import ch.icit.pegasus.server.core.dtos.swap.stock.ArticleStockSwapDataImportReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class PrintArticleSwapBatchPositionComponent
extends DefaultScrollablePrintPopup2<ArticleStockSwapDataImportLight> {
    private static final long serialVersionUID = 1L;
    private List<StoreLight> availableStores;
    private Node<ArticleStockSwapDataImportLight> order;
    private TitledItem<CheckBox> includeMainStore;
    private TitledItem<CheckBox> includeFloatStore;
    private HorizontalSeparator sep;
    private TitledItem<CheckBox> newPageByStore;
    private TitledItem<CheckBox> newPageByArticle;
    private TitledItem<RadioButton> chooseByStore;
    private TitledItem<RadioButton> chooseByStoreType;
    private List<TitledItem<CheckBox>> stores = new ArrayList<TitledItem<CheckBox>>();

    public PrintArticleSwapBatchPositionComponent(Node<ArticleStockSwapDataImportLight> currentNode) {
        super(true, true, false, true, ReportTypeE.STOCK_SWAP_BATCH_POSITION);
        this.order = currentNode;
        this.loadBeforeShowing(() -> {
            try {
                this.availableStores = ((ArticleSwapServiceManager)ServiceManagerRegistry.getService(ArticleSwapServiceManager.class)).getStores(new ArticleStockSwapDataImportReference(((ArticleStockSwapDataImportLight)currentNode.getValue()).getId())).getList();
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), "Unable to load Stores", (Component)this);
            }
        });
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public String getTitleString() {
        return Words.STOCK_SWAP;
    }

    @Override
    public String getTitleValue() {
        return "" + (String)this.order.getChildNamed(ArticleStockSwapDataImportLight_.name).getValue();
    }

    @Override
    public void createComponents() {
        super.createComponents();
        this.getViewContainer().setLayout(new Layout());
        this.includeMainStore = new TitledItem<CheckBox>(new CheckBox(), "Print Main Store Labels", TitledItem.TitledItemOrientation.EAST);
        this.includeFloatStore = new TitledItem<CheckBox>(new CheckBox(), "Print Float Store Labels", TitledItem.TitledItemOrientation.EAST);
        this.sep = new HorizontalSeparator();
        this.chooseByStore = new TitledItem<RadioButton>(new RadioButton(), "Filter by Store", TitledItem.TitledItemOrientation.EAST);
        this.chooseByStoreType = new TitledItem<RadioButton>(new RadioButton(), "Filter by Store Type", TitledItem.TitledItemOrientation.EAST);
        this.newPageByArticle = new TitledItem<CheckBox>(new CheckBox(), "New Page by Article", TitledItem.TitledItemOrientation.EAST);
        this.newPageByStore = new TitledItem<CheckBox>(new CheckBox(), "New Page by Store", TitledItem.TitledItemOrientation.EAST);
        this.chooseByStore.getElement().setChecked(true);
        this.chooseByStore.getElement().addButtonListener((e, x, y) -> {
            for (TitledItem<CheckBox> store : this.stores) {
                store.fadeIn();
            }
            this.includeMainStore.fadeOut(false);
            this.includeFloatStore.fadeOut(false);
            this.setEnabled(this.isEnabled());
        });
        this.chooseByStoreType.getElement().addButtonListener((e, x, y) -> {
            for (TitledItem<CheckBox> store : this.stores) {
                store.fadeOut(false);
            }
            this.includeMainStore.fadeIn();
            this.includeFloatStore.fadeIn();
            this.setEnabled(this.isEnabled());
        });
        this.includeFloatStore.getFader().setPermanent(true);
        this.includeMainStore.getFader().setPermanent(true);
        this.includeFloatStore.getFader().setProgress(0.0f);
        this.includeMainStore.getFader().setProgress(0.0f);
        this.getViewContainer().add(this.includeMainStore);
        this.getViewContainer().add(this.includeFloatStore);
        this.getViewContainer().add(this.sep);
        this.getViewContainer().add(this.chooseByStore);
        this.getViewContainer().add(this.chooseByStoreType);
        this.getViewContainer().add(this.newPageByArticle);
        this.getViewContainer().add(this.newPageByStore);
        for (StoreLight availableStore : this.availableStores) {
            TitledItem<CheckBox> checkBoxTitledItem = new TitledItem<CheckBox>(new CheckBox(), availableStore.getCode(), TitledItem.TitledItemOrientation.EAST);
            checkBoxTitledItem.setUserObject(availableStore);
            this.stores.add(checkBoxTitledItem);
            checkBoxTitledItem.getFader().setPermanent(true);
            this.getViewContainer().add(checkBoxTitledItem);
        }
        this.validate();
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.includeMainStore);
        CheckedListAdder.addToList(focusList, this.includeFloatStore);
        CheckedListAdder.addToList(focusList, this.newPageByArticle);
        CheckedListAdder.addToList(focusList, this.newPageByStore);
        CheckedListAdder.addToList(focusList, this.chooseByStore);
        CheckedListAdder.addToList(focusList, this.chooseByStoreType);
        CheckedListAdder.addToList(focusList, this.includeMainStore);
        CheckedListAdder.addToList(focusList, this.includeFloatStore);
        for (TitledItem<CheckBox> store : this.stores) {
            CheckedListAdder.addToList(focusList, store);
        }
        return focusList;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.includeFloatStore.kill();
        this.includeMainStore.kill();
        this.sep.kill();
        this.chooseByStoreType.kill();
        this.chooseByStoreType.kill();
        this.newPageByStore.kill();
        this.newPageByArticle.kill();
        this.stores.forEach(checkBoxTitledItem -> checkBoxTitledItem.kill());
        this.includeMainStore = null;
        this.includeFloatStore = null;
        this.sep = null;
        this.chooseByStoreType = null;
        this.chooseByStore = null;
        this.newPageByArticle = null;
        this.newPageByStore = null;
        this.stores.clear();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean filterStores = this.chooseByStore.getElement().isChecked();
        this.includeMainStore.setEnabled(isEnabled && !filterStores);
        this.includeFloatStore.setEnabled(isEnabled && !filterStores);
        this.chooseByStore.setEnabled(isEnabled);
        this.chooseByStoreType.setEnabled(isEnabled);
        this.newPageByStore.setEnabled(isEnabled);
        this.newPageByArticle.setEnabled(isEnabled);
        for (TitledItem<CheckBox> store : this.stores) {
            store.setEnabled(isEnabled && filterStores);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete selectedReport = PrintArticleSwapBatchPositionComponent.this.getSelectedReport();
                ArticleStockSwapBatchPositionConfiguration conf = new ArticleStockSwapBatchPositionConfiguration();
                conf.setStyleSheet(selectedReport);
                conf.setSwapReference(new ArticleStockSwapDataImportReference(((ArticleStockSwapDataImportLight)PrintArticleSwapBatchPositionComponent.this.order.getValue()).getId()));
                if (((RadioButton)PrintArticleSwapBatchPositionComponent.this.asPDF.getElement()).isChecked()) {
                    conf.setFormat(ReportingOutputFormatE.PDF);
                } else {
                    conf.setFormat(ReportingOutputFormatE.XLSX);
                }
                conf.setIncludeMainStore(((CheckBox)PrintArticleSwapBatchPositionComponent.this.includeMainStore.getElement()).isChecked());
                conf.setIncludeFloatStore(((CheckBox)PrintArticleSwapBatchPositionComponent.this.includeFloatStore.getElement()).isChecked());
                conf.setFilterByStore(((RadioButton)PrintArticleSwapBatchPositionComponent.this.chooseByStore.getElement()).isChecked());
                conf.setNewPageByStore(((CheckBox)PrintArticleSwapBatchPositionComponent.this.newPageByStore.getElement()).isChecked());
                conf.setNewPageByArticle(((CheckBox)PrintArticleSwapBatchPositionComponent.this.newPageByArticle.getElement()).isChecked());
                for (TitledItem store : PrintArticleSwapBatchPositionComponent.this.stores) {
                    if (!((CheckBox)store.getElement()).isChecked()) continue;
                    StoreLight userObject = (StoreLight)store.getUserObject();
                    conf.getStores().add(new StoreReference(userObject.getId()));
                }
                PegasusFileComplete t = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createStockSwapBatchPositionReport(conf).getValue();
                PrintArticleSwapBatchPositionComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintArticleSwapBatchPositionComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<ArticleStockSwapDataImportLight> getCurrentNode() {
        return this.order;
    }

    @Override
    public BatchJob<ArticleStockSwapDataImportLight> createBatchJob(Node<ArticleStockSwapDataImportLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public void insertElements() {
        this.createComponents();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintArticleSwapBatchPositionComponent.this.layoutInheritedComponents(parent);
            PrintArticleSwapBatchPositionComponent.this.newPageByArticle.setLocation(PrintArticleSwapBatchPositionComponent.this.border, y + PrintArticleSwapBatchPositionComponent.this.border);
            PrintArticleSwapBatchPositionComponent.this.newPageByArticle.setSize(PrintArticleSwapBatchPositionComponent.this.newPageByArticle.getPreferredSize());
            PrintArticleSwapBatchPositionComponent.this.newPageByStore.setLocation(PrintArticleSwapBatchPositionComponent.this.border, PrintArticleSwapBatchPositionComponent.this.newPageByArticle.getY() + PrintArticleSwapBatchPositionComponent.this.newPageByArticle.getHeight() + PrintArticleSwapBatchPositionComponent.this.border);
            PrintArticleSwapBatchPositionComponent.this.newPageByStore.setSize(PrintArticleSwapBatchPositionComponent.this.newPageByStore.getPreferredSize());
            PrintArticleSwapBatchPositionComponent.this.sep.setLocation(0, PrintArticleSwapBatchPositionComponent.this.newPageByStore.getY() + PrintArticleSwapBatchPositionComponent.this.newPageByStore.getHeight() + PrintArticleSwapBatchPositionComponent.this.border);
            PrintArticleSwapBatchPositionComponent.this.sep.setSize(parent.getWidth(), (int)PrintArticleSwapBatchPositionComponent.this.sep.getPreferredSize().getHeight());
            PrintArticleSwapBatchPositionComponent.this.chooseByStore.setLocation(PrintArticleSwapBatchPositionComponent.this.border, PrintArticleSwapBatchPositionComponent.this.sep.getY() + PrintArticleSwapBatchPositionComponent.this.sep.getHeight() + PrintArticleSwapBatchPositionComponent.this.border);
            PrintArticleSwapBatchPositionComponent.this.chooseByStore.setSize(PrintArticleSwapBatchPositionComponent.this.chooseByStore.getPreferredSize());
            PrintArticleSwapBatchPositionComponent.this.chooseByStoreType.setLocation(PrintArticleSwapBatchPositionComponent.this.border, PrintArticleSwapBatchPositionComponent.this.chooseByStore.getY() + PrintArticleSwapBatchPositionComponent.this.chooseByStore.getHeight() + PrintArticleSwapBatchPositionComponent.this.border);
            PrintArticleSwapBatchPositionComponent.this.chooseByStoreType.setSize(PrintArticleSwapBatchPositionComponent.this.chooseByStoreType.getPreferredSize());
            int cy = PrintArticleSwapBatchPositionComponent.this.chooseByStoreType.getY() + PrintArticleSwapBatchPositionComponent.this.chooseByStoreType.getHeight() + PrintArticleSwapBatchPositionComponent.this.border;
            if (PrintArticleSwapBatchPositionComponent.this.includeMainStore.getFader().getProgress() > 0.0f) {
                PrintArticleSwapBatchPositionComponent.this.includeMainStore.setLocation(PrintArticleSwapBatchPositionComponent.this.border, PrintArticleSwapBatchPositionComponent.this.chooseByStoreType.getY() + PrintArticleSwapBatchPositionComponent.this.chooseByStoreType.getHeight() + PrintArticleSwapBatchPositionComponent.this.border);
                PrintArticleSwapBatchPositionComponent.this.includeMainStore.setSize(PrintArticleSwapBatchPositionComponent.this.includeMainStore.getPreferredSize());
                PrintArticleSwapBatchPositionComponent.this.includeFloatStore.setLocation(PrintArticleSwapBatchPositionComponent.this.border, PrintArticleSwapBatchPositionComponent.this.includeMainStore.getY() + PrintArticleSwapBatchPositionComponent.this.includeMainStore.getHeight() + PrintArticleSwapBatchPositionComponent.this.border);
                PrintArticleSwapBatchPositionComponent.this.includeFloatStore.setSize(PrintArticleSwapBatchPositionComponent.this.includeFloatStore.getPreferredSize());
                cy = PrintArticleSwapBatchPositionComponent.this.includeFloatStore.getY() + PrintArticleSwapBatchPositionComponent.this.includeFloatStore.getHeight() + PrintArticleSwapBatchPositionComponent.this.border / 2;
            }
            for (TitledItem store : PrintArticleSwapBatchPositionComponent.this.stores) {
                if (!(store.getProgress() > 0.0f)) continue;
                store.setLocation(PrintArticleSwapBatchPositionComponent.this.border, cy + PrintArticleSwapBatchPositionComponent.this.border / 2);
                store.setSize(store.getPreferredSize());
                cy = store.getY() + store.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (PrintArticleSwapBatchPositionComponent.this.animation != null) {
                return PrintArticleSwapBatchPositionComponent.this.animation.getPreferredSize();
            }
            int h = PrintArticleSwapBatchPositionComponent.this.getInheritedComponentsHeight();
            h = (int)((double)h + PrintArticleSwapBatchPositionComponent.this.newPageByStore.getPreferredSize().getHeight());
            h += PrintArticleSwapBatchPositionComponent.this.border;
            h = (int)((double)h + PrintArticleSwapBatchPositionComponent.this.newPageByArticle.getPreferredSize().getHeight());
            h += PrintArticleSwapBatchPositionComponent.this.border;
            h = (int)((double)h + PrintArticleSwapBatchPositionComponent.this.sep.getPreferredSize().getHeight());
            h += PrintArticleSwapBatchPositionComponent.this.border;
            h = (int)((double)h + PrintArticleSwapBatchPositionComponent.this.chooseByStoreType.getPreferredSize().getHeight());
            h += PrintArticleSwapBatchPositionComponent.this.border;
            h = (int)((double)h + PrintArticleSwapBatchPositionComponent.this.chooseByStore.getPreferredSize().getHeight());
            h += PrintArticleSwapBatchPositionComponent.this.border;
            h = (int)((double)h + PrintArticleSwapBatchPositionComponent.this.includeMainStore.getPreferredSize().getHeight());
            h += PrintArticleSwapBatchPositionComponent.this.border;
            h = (int)((double)h + PrintArticleSwapBatchPositionComponent.this.includeFloatStore.getPreferredSize().getHeight());
            h += PrintArticleSwapBatchPositionComponent.this.border;
            for (TitledItem store : PrintArticleSwapBatchPositionComponent.this.stores) {
                h = (int)((double)h + store.getPreferredSize().getHeight());
                h += PrintArticleSwapBatchPositionComponent.this.border / 2;
            }
            h -= PrintArticleSwapBatchPositionComponent.this.border / 2;
            return new Dimension(100, h += PrintArticleSwapBatchPositionComponent.this.border);
        }
    }
}

