/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.charge.labels;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.report.ChargeLabelConfiguration;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class PrintChargeLabelsComponent
extends DefaultScrollablePrintPopup2<ArticleChargeLight> {
    private static final long serialVersionUID = 1L;
    private Node<ArticleChargeLight> chargeNode;
    private TitledItem<TextField> startPosition;
    private TitledItem<TextField> labelCount;
    private TitledItem<CheckBox> includeBarCode;

    public PrintChargeLabelsComponent(Node<ArticleChargeLight> currentNode) {
        super(true, true, false, false, ReportTypeE.ARTICLE_STORE_INFO_SHEET);
        this.chargeNode = currentNode;
    }

    @Override
    public boolean isReportAllowed(ReportFileComplete reportFile) {
        return reportFile.getDescription().contains("Label");
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public String getTitleString() {
        return Words.ORDER;
    }

    @Override
    public String getTitleValue() {
        return "" + this.chargeNode.getChildNamed(ArticleChargeLight_.number).getValue();
    }

    @Override
    public void createComponents() {
        super.createComponents();
        this.getViewContainer().setLayout(new Layout());
        this.includeBarCode = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_BAR_CODE, TitledItem.TitledItemOrientation.EAST);
        this.includeBarCode.getElement().setChecked(true);
        this.getViewContainer().add(this.includeBarCode);
        this.startPosition = new TitledItem<TextField>(new TextField((Node)new DTONode(), TextFieldType.INT), Words.START_POSITION, TitledItem.TitledItemOrientation.NORTH);
        this.startPosition.getElement().setText("1");
        this.getViewContainer().add(this.startPosition);
        this.labelCount = new TitledItem<TextField>(new TextField((Node)new DTONode(), TextFieldType.INT), Words.LABEL_COUNT, TitledItem.TitledItemOrientation.NORTH);
        this.labelCount.getElement().setText("1");
        this.getViewContainer().add(this.labelCount);
        this.validate();
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.startPosition);
        CheckedListAdder.addToList(focusList, this.labelCount);
        CheckedListAdder.addToList(focusList, this.includeBarCode);
        return focusList;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.startPosition != null) {
            this.startPosition.kill();
        }
        this.startPosition = null;
        if (this.labelCount != null) {
            this.labelCount.kill();
        }
        this.labelCount = null;
        if (this.includeBarCode != null) {
            this.includeBarCode.kill();
        }
        this.includeBarCode = null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                int count;
                int startPosition;
                ReportFileComplete selectedReport = PrintChargeLabelsComponent.this.getSelectedReport();
                try {
                    startPosition = Integer.valueOf(((TextField)PrintChargeLabelsComponent.this.startPosition.getElement()).getText());
                }
                catch (NumberFormatException e) {
                    startPosition = 1;
                }
                try {
                    count = Integer.valueOf(((TextField)PrintChargeLabelsComponent.this.labelCount.getElement()).getText());
                }
                catch (NumberFormatException e) {
                    count = 1;
                }
                boolean inclBarCode = ((CheckBox)PrintChargeLabelsComponent.this.includeBarCode.getElement()).isChecked();
                ChargeLabelConfiguration conf = new ChargeLabelConfiguration();
                conf.setChargeReference(new ArticleChargeReference(((ArticleChargeLight)PrintChargeLabelsComponent.this.chargeNode.getValue()).getId()));
                conf.setStyleSheet(selectedReport);
                conf.setIncludeBarCode(Boolean.valueOf(inclBarCode));
                conf.setStartPosition(Integer.valueOf(startPosition));
                conf.setCount(Integer.valueOf(count));
                PegasusFileComplete t = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createArticleLabelsForCharge(conf).getValue();
                PrintChargeLabelsComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintChargeLabelsComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<ArticleChargeLight> getCurrentNode() {
        return this.chargeNode;
    }

    @Override
    public BatchJob<ArticleChargeLight> createBatchJob(Node<ArticleChargeLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public void insertElements() {
        this.createComponents();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintChargeLabelsComponent.this.layoutInheritedComponents(parent);
            PrintChargeLabelsComponent.this.includeBarCode.setLocation(PrintChargeLabelsComponent.this.border, PrintChargeLabelsComponent.this.border + y);
            PrintChargeLabelsComponent.this.includeBarCode.setSize(parent.getWidth() - 2 * PrintChargeLabelsComponent.this.border, (int)PrintChargeLabelsComponent.this.includeBarCode.getPreferredSize().getHeight());
            PrintChargeLabelsComponent.this.labelCount.setLocation(PrintChargeLabelsComponent.this.border, PrintChargeLabelsComponent.this.includeBarCode.getY() + PrintChargeLabelsComponent.this.includeBarCode.getHeight() + PrintChargeLabelsComponent.this.border);
            PrintChargeLabelsComponent.this.labelCount.setSize(parent.getWidth() - 2 * PrintChargeLabelsComponent.this.border, (int)PrintChargeLabelsComponent.this.labelCount.getPreferredSize().getHeight());
            PrintChargeLabelsComponent.this.startPosition.setLocation(PrintChargeLabelsComponent.this.border, PrintChargeLabelsComponent.this.labelCount.getY() + PrintChargeLabelsComponent.this.labelCount.getHeight() + PrintChargeLabelsComponent.this.border);
            PrintChargeLabelsComponent.this.startPosition.setSize(parent.getWidth() - 2 * PrintChargeLabelsComponent.this.border, (int)PrintChargeLabelsComponent.this.startPosition.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (PrintChargeLabelsComponent.this.animation != null) {
                return PrintChargeLabelsComponent.this.animation.getPreferredSize();
            }
            int h = PrintChargeLabelsComponent.this.getInheritedComponentsHeight();
            return new Dimension(100, h);
        }
    }
}

