/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.equipmenttemplate;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Date;
import java.util.ArrayList;

public class PrintEquipmentTemplateComponent
extends DefaultScrollablePrintPopup2<EquipmentTemplateComplete> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> dueDate;
    Node<EquipmentTemplateComplete> node;

    public PrintEquipmentTemplateComponent(Node<EquipmentTemplateComplete> node) {
        super(false, false, false, false, ReportTypeE.STOCK_TRANSACTION);
        this.node = node;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String string = s[1];
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false);
        this.dueDate.getElement().setNode(n);
        this.getViewContainer().add(this.dueDate);
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.dueDate != null) {
            this.dueDate.setEnabled(isEnabled);
            this.dueDate.setEnabled(isEnabled);
        }
    }

    @Override
    public String getTitleString() {
        return Words.FLIGHT_TRANSACTIONS;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.dueDate != null && this.dueDate.isInnerComponent(c)) {
            return true;
        }
        return super.isInnerComponent(c);
    }

    @Override
    public String getTitleValue() {
        return ((EquipmentTemplateComplete)this.node.getValue()).getCurrentVariant().getName();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.dueDate != null) {
            this.dueDate.kill();
        }
        this.dueDate = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.dueDate != null) {
            this.dueDate.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.dueDate != null) {
            this.dueDate.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArrayList<Object> temps = new ArrayList<Object>();
                temps.add(PrintEquipmentTemplateComponent.this.node.getValue());
                PegasusFileComplete t = (PegasusFileComplete)((SupplyReportServiceManager)ServiceManagerRegistry.getService(SupplyReportServiceManager.class)).createEquipmentExport(new ListWrapper(temps), new DateWrapper(((DateChooser)PrintEquipmentTemplateComponent.this.dueDate.getElement()).getSelectedDate().getTime())).getValue();
                PrintEquipmentTemplateComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintEquipmentTemplateComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<EquipmentTemplateComplete> getCurrentNode() {
        return this.node;
    }

    @Override
    public BatchJob<EquipmentTemplateComplete> createBatchJob(Node<EquipmentTemplateComplete> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintEquipmentTemplateComponent.this.layoutInheritedComponents(parent) + PrintEquipmentTemplateComponent.this.border;
            if (PrintEquipmentTemplateComponent.this.dueDate != null) {
                PrintEquipmentTemplateComponent.this.dueDate.setLocation(PrintEquipmentTemplateComponent.this.border, y + PrintEquipmentTemplateComponent.this.border / 2);
                PrintEquipmentTemplateComponent.this.dueDate.setSize(parent.getWidth() - 2 * PrintEquipmentTemplateComponent.this.border, (int)PrintEquipmentTemplateComponent.this.dueDate.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintEquipmentTemplateComponent.this.getInheritedComponentsHeight();
            int w = 250;
            if (PrintEquipmentTemplateComponent.this.dueDate != null) {
                h = (int)((double)h + PrintEquipmentTemplateComponent.this.dueDate.getPreferredSize().getHeight());
                h += PrintEquipmentTemplateComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

