/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.flight.flightchecker;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.report.FlightCheckerSheetConfiguration;
import ch.icit.pegasus.server.core.dtos.report.SingleDTOReportConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class PrintFlightCheckerSheetComponent
extends DefaultScrollablePrintPopup2<FlightLight> {
    private static final long serialVersionUID = 1L;
    private Node<FlightLight> currentFlight;
    private TextLabel option;
    private TitledItem<CheckBox> finalizePaxType;
    private TextLabel sheetSelection;
    private TitledItem<CheckBox> overviewSheet;
    private TitledItem<CheckBox> mealRatioSheet;
    private TitledItem<CheckBox> productByEquipmentSheet;
    private TitledItem<CheckBox> productByEquipmentAll;
    private TitledItem<CheckBox> productByEquipmentMealPlanOnly;
    private TitledItem<CheckBox> productByEquipmentMealPlanWithMealType;
    private TitledItem<CheckBox> productByEquipmentMealPlanWithoutMealType;
    private TitledItem<CheckBox> productByEquipmentStandardOnly;
    private TitledItem<CheckBox> productByEquipmentAll_ClassSplit;
    private TitledItem<CheckBox> productByEquipmentMealPlanOnly_ClassSplit;
    private TitledItem<CheckBox> productByEquipmentMealPlanWithMealType_ClassSplit;
    private TitledItem<CheckBox> productByEquipmentMealPlanWithoutMealType_ClassSplit;
    private TitledItem<CheckBox> productByEquipmentStandardOnly_ClassSplit;
    private TitledItem<CheckBox> productByEquipmentAll_splitByGalley;
    private TitledItem<CheckBox> productByEquipmentMealPlanOnly_splitByGalley;
    private TitledItem<CheckBox> productByEquipmentMealPlanWithMealType_splitByGalley;
    private TitledItem<CheckBox> productByEquipmentMealPlanWithoutMealType_splitByGalley;
    private TitledItem<CheckBox> productByEquipmentStandardOnly_splitByGalley;
    private TitledItem<CheckBox> labelSheet;
    private TitledItem<CheckBox> includeGalleyMap;
    private TitledItem<CheckBox> deliverySlip;
    private TitledItem<CheckBox> equipmentChecker;
    private TitledItem<CheckBox> productForecast;
    private TitledItem<CheckBox> includeAllDepartments;
    private TitledItem<CheckBox> includeMeals;
    private TitledItem<CheckBox> includeStandards;
    private TitledItem<CheckBox> includeArticles;

    public PrintFlightCheckerSheetComponent(Node<FlightLight> node) {
        super(false, false, ReportTypeE.FLIGHT_CHECKER);
        this.currentFlight = node;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.option = new TextLabel(Words.OPTIONS);
        this.finalizePaxType = new TitledItem<CheckBox>(new CheckBox(), Words.SET_PAX_TO_FINAL, TitledItem.TitledItemOrientation.EAST);
        this.sheetSelection = new TextLabel(Words.SELECTION);
        this.overviewSheet = new TitledItem<CheckBox>(new CheckBox(), Words.OVERVIEW, TitledItem.TitledItemOrientation.EAST);
        this.overviewSheet.getElement().setChecked(true);
        this.equipmentChecker = new TitledItem<CheckBox>(new CheckBox(), Words.EQUIPMENT_CHECKER, TitledItem.TitledItemOrientation.EAST);
        this.equipmentChecker.getElement().setChecked(true);
        this.mealRatioSheet = new TitledItem<CheckBox>(new CheckBox(), Words.MEAL_RATIO_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.mealRatioSheet.getElement().setChecked(true);
        this.productForecast = new TitledItem<CheckBox>(new CheckBox(), Words.KITCHEN_FORECAST, TitledItem.TitledItemOrientation.EAST);
        this.productForecast.getElement().setChecked(true);
        this.productForecast.getElement().addButtonListener(this);
        this.includeAllDepartments = new TitledItem<CheckBox>(new CheckBox(), Words.ALL_DEPARTMENTS, TitledItem.TitledItemOrientation.EAST);
        this.includeAllDepartments.getElement().setChecked(false);
        this.labelSheet = new TitledItem<CheckBox>(new CheckBox(), Words.LABELS, TitledItem.TitledItemOrientation.EAST);
        this.labelSheet.getElement().setChecked(true);
        this.labelSheet.getElement().addButtonListener(this);
        this.includeGalleyMap = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_GALLEY_MAP, TitledItem.TitledItemOrientation.EAST);
        this.deliverySlip = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_DELIVERY_SLIP, TitledItem.TitledItemOrientation.EAST);
        this.deliverySlip.getElement().setChecked(true);
        this.productByEquipmentSheet = new TitledItem<CheckBox>(new CheckBox(), Words.PRODUCTS_TO_EQUIPMENT_TABLE, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentSheet.getElement().setChecked(true);
        this.productByEquipmentSheet.getElement().addButtonListener(this);
        this.productByEquipmentAll = new TitledItem<CheckBox>(new CheckBox(), Words.ALL, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentAll.getElement().setChecked(true);
        this.productByEquipmentMealPlanOnly = new TitledItem<CheckBox>(new CheckBox(), Words.MEALS_ONLY, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentMealPlanWithMealType = new TitledItem<CheckBox>(new CheckBox(), Words.MEALS_WITH_MEAL_TYPE_ONLY, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentMealPlanWithoutMealType = new TitledItem<CheckBox>(new CheckBox(), Words.MEALS_WITHOUT_MEAL_TYPE_ONLY, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentStandardOnly = new TitledItem<CheckBox>(new CheckBox(), Words.STANDARDS_ONLY, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentAll.getElement().addButtonListener(this);
        this.productByEquipmentMealPlanOnly.getElement().addButtonListener(this);
        this.productByEquipmentMealPlanWithMealType.getElement().addButtonListener(this);
        this.productByEquipmentMealPlanWithoutMealType.getElement().addButtonListener(this);
        this.productByEquipmentStandardOnly.getElement().addButtonListener(this);
        this.productByEquipmentAll_ClassSplit = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_CLASS, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentAll_ClassSplit.getElement().setChecked(true);
        this.productByEquipmentMealPlanOnly_ClassSplit = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_CLASS, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentMealPlanWithMealType_ClassSplit = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_CLASS, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentMealPlanWithoutMealType_ClassSplit = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_CLASS, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentStandardOnly_ClassSplit = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_CLASS, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentAll_splitByGalley = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_GALLEY, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentAll_splitByGalley.getElement().setChecked(true);
        this.productByEquipmentMealPlanOnly_splitByGalley = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_GALLEY, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentMealPlanWithMealType_splitByGalley = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_GALLEY, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentMealPlanWithoutMealType_splitByGalley = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_GALLEY, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentStandardOnly_splitByGalley = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_GALLEY, TitledItem.TitledItemOrientation.EAST);
        this.includeMeals = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_MEALS, TitledItem.TitledItemOrientation.EAST);
        this.includeMeals.getElement().setChecked(true);
        this.includeStandards = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_STANDARD, TitledItem.TitledItemOrientation.EAST);
        this.includeStandards.getElement().setChecked(true);
        this.includeArticles = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ARTICLE, TitledItem.TitledItemOrientation.EAST);
        this.includeArticles.getElement().setChecked(true);
        this.getViewContainer().add(this.option);
        this.getViewContainer().add(this.finalizePaxType);
        this.getViewContainer().add(this.sheetSelection);
        this.getViewContainer().add(this.mealRatioSheet);
        this.getViewContainer().add(this.overviewSheet);
        this.getViewContainer().add(this.equipmentChecker);
        this.getViewContainer().add(this.productForecast);
        this.getViewContainer().add(this.includeAllDepartments);
        this.getViewContainer().add(this.productByEquipmentSheet);
        this.getViewContainer().add(this.productByEquipmentAll);
        this.getViewContainer().add(this.productByEquipmentMealPlanOnly);
        this.getViewContainer().add(this.productByEquipmentMealPlanWithMealType);
        this.getViewContainer().add(this.productByEquipmentMealPlanWithoutMealType);
        this.getViewContainer().add(this.productByEquipmentStandardOnly);
        this.getViewContainer().add(this.productByEquipmentAll_ClassSplit);
        this.getViewContainer().add(this.productByEquipmentMealPlanOnly_ClassSplit);
        this.getViewContainer().add(this.productByEquipmentMealPlanWithMealType_ClassSplit);
        this.getViewContainer().add(this.productByEquipmentMealPlanWithoutMealType_ClassSplit);
        this.getViewContainer().add(this.productByEquipmentStandardOnly_ClassSplit);
        this.getViewContainer().add(this.productByEquipmentAll_splitByGalley);
        this.getViewContainer().add(this.productByEquipmentMealPlanOnly_splitByGalley);
        this.getViewContainer().add(this.productByEquipmentMealPlanWithMealType_splitByGalley);
        this.getViewContainer().add(this.productByEquipmentMealPlanWithoutMealType_splitByGalley);
        this.getViewContainer().add(this.productByEquipmentStandardOnly_splitByGalley);
        this.getViewContainer().add(this.labelSheet);
        this.getViewContainer().add(this.includeGalleyMap);
        this.getViewContainer().add(this.deliverySlip);
        this.getViewContainer().add(this.includeMeals);
        this.getViewContainer().add(this.includeStandards);
        this.getViewContainer().add(this.includeArticles);
        this.setEnabled(this.isEnabled());
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        this.setEnabled(this.isEnabled());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.option.setEnabled(isEnabled);
        this.finalizePaxType.setEnabled(isEnabled);
        this.mealRatioSheet.setEnabled(isEnabled);
        this.sheetSelection.setEnabled(isEnabled);
        this.overviewSheet.setEnabled(isEnabled);
        this.equipmentChecker.setEnabled(isEnabled);
        this.productForecast.setEnabled(isEnabled);
        this.includeAllDepartments.setEnabled(isEnabled && this.productForecast.getElement().isChecked());
        this.productByEquipmentSheet.setEnabled(isEnabled);
        boolean productByEquipment = this.productByEquipmentSheet.getElement().isChecked() && isEnabled;
        this.productByEquipmentAll.setEnabled(productByEquipment);
        this.productByEquipmentMealPlanOnly.setEnabled(productByEquipment);
        this.productByEquipmentMealPlanWithMealType.setEnabled(productByEquipment);
        this.productByEquipmentMealPlanWithoutMealType.setEnabled(productByEquipment);
        this.productByEquipmentStandardOnly.setEnabled(productByEquipment);
        this.productByEquipmentAll_ClassSplit.setEnabled(productByEquipment && this.productByEquipmentAll.getElement().isChecked());
        this.productByEquipmentMealPlanOnly_ClassSplit.setEnabled(productByEquipment && this.productByEquipmentMealPlanOnly.getElement().isChecked());
        this.productByEquipmentMealPlanWithMealType_ClassSplit.setEnabled(productByEquipment && this.productByEquipmentMealPlanWithMealType.getElement().isChecked());
        this.productByEquipmentMealPlanWithoutMealType_ClassSplit.setEnabled(productByEquipment && this.productByEquipmentMealPlanWithoutMealType.getElement().isChecked());
        this.productByEquipmentStandardOnly_ClassSplit.setEnabled(productByEquipment && this.productByEquipmentStandardOnly.getElement().isChecked());
        this.productByEquipmentAll_splitByGalley.setEnabled(productByEquipment && this.productByEquipmentAll.getElement().isChecked());
        this.productByEquipmentMealPlanOnly_splitByGalley.setEnabled(productByEquipment && this.productByEquipmentMealPlanOnly.getElement().isChecked());
        this.productByEquipmentMealPlanWithMealType_splitByGalley.setEnabled(productByEquipment && this.productByEquipmentMealPlanWithMealType.getElement().isChecked());
        this.productByEquipmentMealPlanWithoutMealType_splitByGalley.setEnabled(productByEquipment && this.productByEquipmentMealPlanWithoutMealType.getElement().isChecked());
        this.productByEquipmentStandardOnly_splitByGalley.setEnabled(productByEquipment && this.productByEquipmentStandardOnly.getElement().isChecked());
        this.labelSheet.setEnabled(isEnabled);
        this.includeGalleyMap.setEnabled(this.labelSheet.getElement().isChecked() && isEnabled);
        this.deliverySlip.setEnabled(isEnabled);
        this.includeMeals.setEnabled(isEnabled);
        this.includeStandards.setEnabled(isEnabled);
        this.includeArticles.setEnabled(isEnabled);
    }

    @Override
    public String getTitleString() {
        return Words.FLIGHT;
    }

    @Override
    public String getTitleValue() {
        if (this.currentFlight.getValue() != null) {
            return ((FlightLight)this.currentFlight.getValue()).getOutboundCode();
        }
        return "-";
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> a = super.validateBeforePrint();
        if (a == null) {
            a = new ArrayList<ScreenValidationObject>();
        }
        if (!this.includeStandards.getElement().isChecked() && !this.includeMeals.getElement().isChecked()) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_MEALS_OR_STANDARDS_ARE_SELECTED));
        }
        boolean isSheetSelected = false;
        if (this.overviewSheet.getElement().isChecked()) {
            isSheetSelected = true;
        }
        if (this.equipmentChecker.getElement().isChecked()) {
            isSheetSelected = true;
        }
        if (this.productByEquipmentSheet.getElement().isChecked()) {
            isSheetSelected = true;
        }
        if (this.labelSheet.getElement().isChecked()) {
            isSheetSelected = true;
        }
        if (this.deliverySlip.getElement().isChecked()) {
            isSheetSelected = true;
        }
        if (this.productForecast.getElement().isChecked()) {
            isSheetSelected = true;
        }
        if (this.mealRatioSheet.getElement().isChecked()) {
            isSheetSelected = true;
        }
        if (!isSheetSelected) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ATLEAST_ONE_SHEET_IS_SELECTED));
        }
        return a;
    }

    public FlightCheckerSheetConfiguration getReportConfiguration() {
        ReportFileComplete file = this.getSelectedReport();
        FlightLight flight = this.currentFlight != null ? (FlightLight)this.currentFlight.getValue() : null;
        FlightCheckerSheetConfiguration config = new FlightCheckerSheetConfiguration(file);
        if (flight != null) {
            config.setDto((IDTO)new FlightReference(flight.getId()));
        }
        config.setIncludeOverviewSheet(Boolean.valueOf(this.overviewSheet.getElement().isChecked()));
        config.setIncludeProductSheet(Boolean.valueOf(this.productByEquipmentSheet.getElement().isChecked()));
        config.setIncludeProductsAll(Boolean.valueOf(this.productByEquipmentAll.getElement().isChecked()));
        config.setIncludeProductsMealsOnly(Boolean.valueOf(this.productByEquipmentMealPlanOnly.getElement().isChecked()));
        config.setIncludeProductsMealsWithMealTypeOnly(Boolean.valueOf(this.productByEquipmentMealPlanWithMealType.getElement().isChecked()));
        config.setIncludeProductsMealsWithoutMealTypeOnly(Boolean.valueOf(this.productByEquipmentMealPlanWithoutMealType.getElement().isChecked()));
        config.setIncludeProductsStandardsOnly(Boolean.valueOf(this.productByEquipmentStandardOnly.getElement().isChecked()));
        config.setIncludeProductsAll_splitByClass(Boolean.valueOf(this.productByEquipmentAll_ClassSplit.getElement().isChecked()));
        config.setIncludeProductsMealsOnly_splitByClass(Boolean.valueOf(this.productByEquipmentMealPlanOnly_ClassSplit.getElement().isChecked()));
        config.setIncludeProductsMealsWithMealTypeOnly_splitByClass(Boolean.valueOf(this.productByEquipmentMealPlanWithMealType_ClassSplit.getElement().isChecked()));
        config.setIncludeProductsMealsWithoutMealTypeOnly_splitByClass(Boolean.valueOf(this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getElement().isChecked()));
        config.setIncludeProductsStandardsOnly_splitByClass(Boolean.valueOf(this.productByEquipmentStandardOnly_ClassSplit.getElement().isChecked()));
        config.setIncludeProductsAll_splitByGalley(Boolean.valueOf(this.productByEquipmentAll_splitByGalley.getElement().isChecked()));
        config.setIncludeProductsMealsOnly_splitByGalley(Boolean.valueOf(this.productByEquipmentMealPlanOnly_splitByGalley.getElement().isChecked()));
        config.setIncludeProductsMealsWithMealTypeOnly_splitByGalley(Boolean.valueOf(this.productByEquipmentMealPlanWithMealType_splitByGalley.getElement().isChecked()));
        config.setIncludeProductsMealsWithoutMealTypeOnly_splitByGalley(Boolean.valueOf(this.productByEquipmentMealPlanWithoutMealType_splitByGalley.getElement().isChecked()));
        config.setIncludeProductsStandardsOnly_splitByGalley(Boolean.valueOf(this.productByEquipmentStandardOnly_splitByGalley.getElement().isChecked()));
        config.setIncludeLabelSheet(Boolean.valueOf(this.labelSheet.getElement().isChecked()));
        config.setIncludeMeals(Boolean.valueOf(this.includeMeals.getElement().isChecked()));
        config.setIncludeStandards(Boolean.valueOf(this.includeStandards.getElement().isChecked()));
        config.setIncludeGalleyMap(Boolean.valueOf(this.includeGalleyMap.getElement().isChecked()));
        config.setIncludeDeliverySlip(Boolean.valueOf(this.deliverySlip.getElement().isChecked()));
        config.setIncludeKitchenForecast(Boolean.valueOf(this.productForecast.getElement().isChecked()));
        config.setIncludeAllDepartments(Boolean.valueOf(this.productForecast.getElement().isChecked() && this.includeAllDepartments.getElement().isChecked()));
        config.setIncludeEquipmentChecker(Boolean.valueOf(this.equipmentChecker.getElement().isChecked()));
        config.setIncludeArticles(Boolean.valueOf(this.includeArticles.getElement().isChecked()));
        config.setIncludeMealsByTypeAndRatio(Boolean.valueOf(this.mealRatioSheet.getElement().isChecked()));
        if (this.finalizePaxType != null) {
            config.setFinalizePaxType(Boolean.valueOf(this.finalizePaxType.getElement().isChecked()));
        }
        return config;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                FlightCheckerSheetConfiguration config = PrintFlightCheckerSheetComponent.this.getReportConfiguration();
                PegasusFileComplete t = null;
                t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createFlightCheckerSheet((SingleDTOReportConfiguration)config).getValue();
                PrintFlightCheckerSheetComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintFlightCheckerSheetComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return this.currentFlight;
    }

    @Override
    public BatchJob<FlightLight> createBatchJob(Node<FlightLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            switch (n) {
                case "overview": {
                    this.overviewSheet.getElement().setChecked(b);
                    break;
                }
                case "equipment_checker": {
                    this.equipmentChecker.getElement().setChecked(b);
                    break;
                }
                case "matrix": {
                    this.productByEquipmentSheet.getElement().setChecked(b);
                    break;
                }
                case "mealsByType": {
                    this.mealRatioSheet.getElement().setChecked(b);
                    break;
                }
                case "matrix_all": {
                    this.productByEquipmentAll.getElement().setChecked(b);
                    break;
                }
                case "matrix_all_class": {
                    this.productByEquipmentAll_ClassSplit.getElement().setChecked(b);
                    break;
                }
                case "matrix_all_galley": {
                    this.productByEquipmentAll_splitByGalley.getElement().setChecked(b);
                    break;
                }
                case "matrix_mp": {
                    this.productByEquipmentMealPlanOnly.getElement().setChecked(b);
                    break;
                }
                case "matrix_mp_class": {
                    this.productByEquipmentMealPlanOnly_ClassSplit.getElement().setChecked(b);
                    break;
                }
                case "matrix_mp_galley": {
                    this.productByEquipmentMealPlanOnly_splitByGalley.getElement().setChecked(b);
                    break;
                }
                case "matrix_mpwithmt": {
                    this.productByEquipmentMealPlanWithMealType.getElement().setChecked(b);
                    break;
                }
                case "matrix_mpwithmt_class": {
                    this.productByEquipmentMealPlanWithMealType_ClassSplit.getElement().setChecked(b);
                    break;
                }
                case "matrix_mpwithmt_galley": {
                    this.productByEquipmentMealPlanWithMealType_splitByGalley.getElement().setChecked(b);
                    break;
                }
                case "matrix_mpohnemt": {
                    this.productByEquipmentMealPlanWithoutMealType.getElement().setChecked(b);
                    break;
                }
                case "matrix_mpohnemt_class": {
                    this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getElement().setChecked(b);
                    break;
                }
                case "matrix_mpohnemt_galley": {
                    this.productByEquipmentMealPlanWithoutMealType_splitByGalley.getElement().setChecked(b);
                    break;
                }
                case "matrix_std": {
                    this.productByEquipmentStandardOnly.getElement().setChecked(b);
                    break;
                }
                case "matrix_std_class": {
                    this.productByEquipmentStandardOnly_ClassSplit.getElement().setChecked(b);
                    break;
                }
                case "matrix_std_galley": {
                    this.productByEquipmentStandardOnly_splitByGalley.getElement().setChecked(b);
                    break;
                }
                case "label": {
                    this.labelSheet.getElement().setChecked(b);
                    break;
                }
                case "label_galley": {
                    this.includeGalleyMap.getElement().setChecked(b);
                    break;
                }
                case "deliveryslip": {
                    this.deliverySlip.getElement().setChecked(b);
                    break;
                }
                case "kitchenforecast": {
                    this.productForecast.getElement().setChecked(b);
                    break;
                }
                case "includeAllDepartments": {
                    this.includeAllDepartments.getElement().setChecked(b);
                    break;
                }
                case "meals": {
                    this.includeMeals.getElement().setChecked(b);
                    break;
                }
                case "std": {
                    this.includeStandards.getElement().setChecked(b);
                    break;
                }
                case "articles": {
                    this.includeArticles.getElement().setChecked(b);
                }
            }
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("overview", "" + this.overviewSheet.getElement().isChecked());
        conf.addProperty("equipment_checker", "" + this.equipmentChecker.getElement().isChecked());
        conf.addProperty("mealsByType", "" + this.mealRatioSheet.getElement().isChecked());
        conf.addProperty("matrix", "" + this.productByEquipmentSheet.getElement().isChecked());
        conf.addProperty("matrix_all", "" + this.productByEquipmentAll.getElement().isChecked());
        conf.addProperty("matrix_all_class", "" + this.productByEquipmentAll_ClassSplit.getElement().isChecked());
        conf.addProperty("matrix_all_galley", "" + this.productByEquipmentAll_splitByGalley.getElement().isChecked());
        conf.addProperty("matrix_mp", "" + this.productByEquipmentMealPlanOnly.getElement().isChecked());
        conf.addProperty("matrix_mp_class", "" + this.productByEquipmentMealPlanOnly_ClassSplit.getElement().isChecked());
        conf.addProperty("matrix_mp_galley", "" + this.productByEquipmentMealPlanOnly_splitByGalley.getElement().isChecked());
        conf.addProperty("matrix_mpwithmt", "" + this.productByEquipmentMealPlanWithMealType.getElement().isChecked());
        conf.addProperty("matrix_mpwithmt_class", "" + this.productByEquipmentMealPlanWithMealType_ClassSplit.getElement().isChecked());
        conf.addProperty("matrix_mpwithmt_galley", "" + this.productByEquipmentMealPlanWithMealType_splitByGalley.getElement().isChecked());
        conf.addProperty("matrix_mpohnemt", "" + this.productByEquipmentMealPlanWithoutMealType.getElement().isChecked());
        conf.addProperty("matrix_mpohnemt_class", "" + this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getElement().isChecked());
        conf.addProperty("matrix_mpohnemt_galley", "" + this.productByEquipmentMealPlanWithoutMealType_splitByGalley.getElement().isChecked());
        conf.addProperty("matrix_std", "" + this.productByEquipmentStandardOnly.getElement().isChecked());
        conf.addProperty("matrix_std_class", "" + this.productByEquipmentStandardOnly_ClassSplit.getElement().isChecked());
        conf.addProperty("matrix_std_galley", "" + this.productByEquipmentStandardOnly_splitByGalley.getElement().isChecked());
        conf.addProperty("label", "" + this.labelSheet.getElement().isChecked());
        conf.addProperty("label_galley", "" + this.includeGalleyMap.getElement().isChecked());
        conf.addProperty("deliveryslip", "" + this.deliverySlip.getElement().isChecked());
        conf.addProperty("kitchenforecast", "" + this.productForecast.getElement().isChecked());
        conf.addProperty("includeAllDepartments", "" + this.includeAllDepartments.getElement().isChecked());
        conf.addProperty("meals", "" + this.includeMeals.getElement().isChecked());
        conf.addProperty("std", "" + this.includeStandards.getElement().isChecked());
        conf.addProperty("articles", "" + this.includeArticles.getElement().isChecked());
        return conf;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintFlightCheckerSheetComponent.this.layoutInheritedComponents(parent);
            if (PrintFlightCheckerSheetComponent.this.option != null) {
                PrintFlightCheckerSheetComponent.this.option.setLocation(PrintFlightCheckerSheetComponent.this.border, y + PrintFlightCheckerSheetComponent.this.border);
                PrintFlightCheckerSheetComponent.this.option.setSize(PrintFlightCheckerSheetComponent.this.option.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.finalizePaxType.setLocation(PrintFlightCheckerSheetComponent.this.border, PrintFlightCheckerSheetComponent.this.option.getY() + PrintFlightCheckerSheetComponent.this.option.getHeight() + PrintFlightCheckerSheetComponent.this.border / 2);
                PrintFlightCheckerSheetComponent.this.finalizePaxType.setSize(PrintFlightCheckerSheetComponent.this.finalizePaxType.getPreferredSize());
                y = PrintFlightCheckerSheetComponent.this.finalizePaxType.getY() + PrintFlightCheckerSheetComponent.this.finalizePaxType.getHeight();
            }
            if (PrintFlightCheckerSheetComponent.this.sheetSelection != null) {
                PrintFlightCheckerSheetComponent.this.sheetSelection.setLocation(PrintFlightCheckerSheetComponent.this.border, y + PrintFlightCheckerSheetComponent.this.border);
                PrintFlightCheckerSheetComponent.this.sheetSelection.setSize(PrintFlightCheckerSheetComponent.this.sheetSelection.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.overviewSheet.setLocation(PrintFlightCheckerSheetComponent.this.border, PrintFlightCheckerSheetComponent.this.sheetSelection.getY() + PrintFlightCheckerSheetComponent.this.sheetSelection.getHeight() + PrintFlightCheckerSheetComponent.this.border / 2);
                PrintFlightCheckerSheetComponent.this.overviewSheet.setSize(PrintFlightCheckerSheetComponent.this.overviewSheet.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.equipmentChecker.setLocation(PrintFlightCheckerSheetComponent.this.border, PrintFlightCheckerSheetComponent.this.overviewSheet.getY() + PrintFlightCheckerSheetComponent.this.overviewSheet.getHeight() + PrintFlightCheckerSheetComponent.this.border / 4);
                PrintFlightCheckerSheetComponent.this.equipmentChecker.setSize(PrintFlightCheckerSheetComponent.this.equipmentChecker.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.mealRatioSheet.setLocation(PrintFlightCheckerSheetComponent.this.border, PrintFlightCheckerSheetComponent.this.equipmentChecker.getY() + PrintFlightCheckerSheetComponent.this.equipmentChecker.getHeight() + PrintFlightCheckerSheetComponent.this.border / 4);
                PrintFlightCheckerSheetComponent.this.mealRatioSheet.setSize(PrintFlightCheckerSheetComponent.this.mealRatioSheet.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.productByEquipmentSheet.setLocation(PrintFlightCheckerSheetComponent.this.border, PrintFlightCheckerSheetComponent.this.mealRatioSheet.getY() + PrintFlightCheckerSheetComponent.this.mealRatioSheet.getHeight() + PrintFlightCheckerSheetComponent.this.border / 4);
                PrintFlightCheckerSheetComponent.this.productByEquipmentSheet.setSize(PrintFlightCheckerSheetComponent.this.productByEquipmentSheet.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.productByEquipmentAll.setLocation(PrintFlightCheckerSheetComponent.this.border * 2, PrintFlightCheckerSheetComponent.this.productByEquipmentSheet.getY() + PrintFlightCheckerSheetComponent.this.productByEquipmentSheet.getHeight() + PrintFlightCheckerSheetComponent.this.border / 8);
                PrintFlightCheckerSheetComponent.this.productByEquipmentAll.setSize(PrintFlightCheckerSheetComponent.this.productByEquipmentAll.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanOnly.setLocation(PrintFlightCheckerSheetComponent.this.border * 2, PrintFlightCheckerSheetComponent.this.productByEquipmentAll.getY() + PrintFlightCheckerSheetComponent.this.productByEquipmentAll.getHeight() + PrintFlightCheckerSheetComponent.this.border / 8);
                PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanOnly.setSize(PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanOnly.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithMealType.setLocation(PrintFlightCheckerSheetComponent.this.border * 2, PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanOnly.getY() + PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanOnly.getHeight() + PrintFlightCheckerSheetComponent.this.border / 8);
                PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithMealType.setSize(PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithMealType.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType.setLocation(PrintFlightCheckerSheetComponent.this.border * 2, PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithMealType.getY() + PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithMealType.getHeight() + PrintFlightCheckerSheetComponent.this.border / 8);
                PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType.setSize(PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.productByEquipmentStandardOnly.setLocation(PrintFlightCheckerSheetComponent.this.border * 2, PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType.getY() + PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType.getHeight() + PrintFlightCheckerSheetComponent.this.border / 8);
                PrintFlightCheckerSheetComponent.this.productByEquipmentStandardOnly.setSize(PrintFlightCheckerSheetComponent.this.productByEquipmentStandardOnly.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.productByEquipmentAll_ClassSplit.setLocation(PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType.getX() + PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType.getWidth() + 5, PrintFlightCheckerSheetComponent.this.productByEquipmentAll.getY());
                PrintFlightCheckerSheetComponent.this.productByEquipmentAll_ClassSplit.setSize(PrintFlightCheckerSheetComponent.this.productByEquipmentAll_ClassSplit.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanOnly_ClassSplit.setLocation(PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType.getX() + PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType.getWidth() + 5, PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanOnly.getY());
                PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanOnly_ClassSplit.setSize(PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanOnly_ClassSplit.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithMealType_ClassSplit.setLocation(PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType.getX() + PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType.getWidth() + 5, PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithMealType.getY());
                PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithMealType_ClassSplit.setSize(PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithMealType_ClassSplit.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.setLocation(PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType.getX() + PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType.getWidth() + 5, PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType.getY());
                PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.setSize(PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.productByEquipmentStandardOnly_ClassSplit.setLocation(PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType.getX() + PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType.getWidth() + 5, PrintFlightCheckerSheetComponent.this.productByEquipmentStandardOnly.getY());
                PrintFlightCheckerSheetComponent.this.productByEquipmentStandardOnly_ClassSplit.setSize(PrintFlightCheckerSheetComponent.this.productByEquipmentStandardOnly_ClassSplit.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.productByEquipmentAll_splitByGalley.setLocation(PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getX() + PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getWidth() + 5, PrintFlightCheckerSheetComponent.this.productByEquipmentAll.getY());
                PrintFlightCheckerSheetComponent.this.productByEquipmentAll_splitByGalley.setSize(PrintFlightCheckerSheetComponent.this.productByEquipmentAll_splitByGalley.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanOnly_splitByGalley.setLocation(PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getX() + PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getWidth() + 5, PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanOnly.getY());
                PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanOnly_splitByGalley.setSize(PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanOnly_splitByGalley.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithMealType_splitByGalley.setLocation(PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getX() + PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getWidth() + 5, PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithMealType.getY());
                PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithMealType_splitByGalley.setSize(PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithMealType_splitByGalley.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType_splitByGalley.setLocation(PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getX() + PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getWidth() + 5, PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType.getY());
                PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType_splitByGalley.setSize(PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType_splitByGalley.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.productByEquipmentStandardOnly_splitByGalley.setLocation(PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getX() + PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getWidth() + 5, PrintFlightCheckerSheetComponent.this.productByEquipmentStandardOnly.getY());
                PrintFlightCheckerSheetComponent.this.productByEquipmentStandardOnly_splitByGalley.setSize(PrintFlightCheckerSheetComponent.this.productByEquipmentStandardOnly_splitByGalley.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.labelSheet.setLocation(PrintFlightCheckerSheetComponent.this.border, PrintFlightCheckerSheetComponent.this.productByEquipmentStandardOnly.getY() + PrintFlightCheckerSheetComponent.this.productByEquipmentStandardOnly.getHeight() + PrintFlightCheckerSheetComponent.this.border / 4);
                PrintFlightCheckerSheetComponent.this.labelSheet.setSize(PrintFlightCheckerSheetComponent.this.labelSheet.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.includeGalleyMap.setLocation(2 * PrintFlightCheckerSheetComponent.this.border, PrintFlightCheckerSheetComponent.this.labelSheet.getY() + PrintFlightCheckerSheetComponent.this.labelSheet.getHeight() + PrintFlightCheckerSheetComponent.this.border / 8);
                PrintFlightCheckerSheetComponent.this.includeGalleyMap.setSize(PrintFlightCheckerSheetComponent.this.includeGalleyMap.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.deliverySlip.setLocation(PrintFlightCheckerSheetComponent.this.border, PrintFlightCheckerSheetComponent.this.includeGalleyMap.getY() + PrintFlightCheckerSheetComponent.this.includeGalleyMap.getHeight() + PrintFlightCheckerSheetComponent.this.border / 4);
                PrintFlightCheckerSheetComponent.this.deliverySlip.setSize(PrintFlightCheckerSheetComponent.this.deliverySlip.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.productForecast.setLocation(PrintFlightCheckerSheetComponent.this.border, PrintFlightCheckerSheetComponent.this.deliverySlip.getY() + PrintFlightCheckerSheetComponent.this.deliverySlip.getHeight() + PrintFlightCheckerSheetComponent.this.border / 4);
                PrintFlightCheckerSheetComponent.this.productForecast.setSize(PrintFlightCheckerSheetComponent.this.productForecast.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.includeAllDepartments.setLocation(2 * PrintFlightCheckerSheetComponent.this.border, PrintFlightCheckerSheetComponent.this.productForecast.getY() + PrintFlightCheckerSheetComponent.this.productForecast.getHeight() + PrintFlightCheckerSheetComponent.this.border / 4);
                PrintFlightCheckerSheetComponent.this.includeAllDepartments.setSize(PrintFlightCheckerSheetComponent.this.includeAllDepartments.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.includeMeals.setLocation(PrintFlightCheckerSheetComponent.this.border, PrintFlightCheckerSheetComponent.this.includeAllDepartments.getY() + PrintFlightCheckerSheetComponent.this.includeAllDepartments.getHeight() + PrintFlightCheckerSheetComponent.this.border);
                PrintFlightCheckerSheetComponent.this.includeMeals.setSize(PrintFlightCheckerSheetComponent.this.includeMeals.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.includeStandards.setLocation(PrintFlightCheckerSheetComponent.this.border, PrintFlightCheckerSheetComponent.this.includeMeals.getY() + PrintFlightCheckerSheetComponent.this.includeMeals.getHeight() + PrintFlightCheckerSheetComponent.this.border / 4);
                PrintFlightCheckerSheetComponent.this.includeStandards.setSize(PrintFlightCheckerSheetComponent.this.includeStandards.getPreferredSize());
                PrintFlightCheckerSheetComponent.this.includeArticles.setLocation(PrintFlightCheckerSheetComponent.this.border, PrintFlightCheckerSheetComponent.this.includeStandards.getY() + PrintFlightCheckerSheetComponent.this.includeStandards.getHeight() + PrintFlightCheckerSheetComponent.this.border / 4);
                PrintFlightCheckerSheetComponent.this.includeArticles.setSize(PrintFlightCheckerSheetComponent.this.includeArticles.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintFlightCheckerSheetComponent.this.getInheritedComponentsHeight();
            int w = 250;
            if (PrintFlightCheckerSheetComponent.this.option != null) {
                h += PrintFlightCheckerSheetComponent.this.border;
                h = (int)((double)h + PrintFlightCheckerSheetComponent.this.option.getPreferredSize().getHeight());
                h += PrintFlightCheckerSheetComponent.this.border / 2;
                h = (int)((double)h + PrintFlightCheckerSheetComponent.this.finalizePaxType.getPreferredSize().getHeight());
            }
            if (PrintFlightCheckerSheetComponent.this.sheetSelection != null) {
                h += PrintFlightCheckerSheetComponent.this.border;
                h = (int)((double)h + PrintFlightCheckerSheetComponent.this.sheetSelection.getPreferredSize().getHeight());
                h += PrintFlightCheckerSheetComponent.this.border / 2;
                h = (int)((double)h + PrintFlightCheckerSheetComponent.this.overviewSheet.getPreferredSize().getHeight());
                h += PrintFlightCheckerSheetComponent.this.border / 4;
                h = (int)((double)h + PrintFlightCheckerSheetComponent.this.equipmentChecker.getPreferredSize().getHeight());
                h += PrintFlightCheckerSheetComponent.this.border / 4;
                h = (int)((double)h + PrintFlightCheckerSheetComponent.this.mealRatioSheet.getPreferredSize().getHeight());
                h += PrintFlightCheckerSheetComponent.this.border / 4;
                h = (int)((double)h + PrintFlightCheckerSheetComponent.this.productByEquipmentSheet.getPreferredSize().getHeight());
                h += PrintFlightCheckerSheetComponent.this.border / 4;
                h = (int)((double)h + PrintFlightCheckerSheetComponent.this.productByEquipmentAll.getPreferredSize().getHeight());
                h += PrintFlightCheckerSheetComponent.this.border / 8;
                h = (int)((double)h + PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanOnly.getPreferredSize().getHeight());
                h += PrintFlightCheckerSheetComponent.this.border / 8;
                h = (int)((double)h + PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithMealType.getPreferredSize().getHeight());
                h += PrintFlightCheckerSheetComponent.this.border / 8;
                h = (int)((double)h + PrintFlightCheckerSheetComponent.this.productByEquipmentMealPlanWithoutMealType.getPreferredSize().getHeight());
                h += PrintFlightCheckerSheetComponent.this.border / 8;
                h = (int)((double)h + PrintFlightCheckerSheetComponent.this.productByEquipmentStandardOnly.getPreferredSize().getHeight());
                h += PrintFlightCheckerSheetComponent.this.border / 4;
                h = (int)((double)h + PrintFlightCheckerSheetComponent.this.labelSheet.getPreferredSize().getHeight());
                h += PrintFlightCheckerSheetComponent.this.border / 8;
                h = (int)((double)h + PrintFlightCheckerSheetComponent.this.includeGalleyMap.getPreferredSize().getHeight());
                h += PrintFlightCheckerSheetComponent.this.border / 4;
                h = (int)((double)h + PrintFlightCheckerSheetComponent.this.deliverySlip.getPreferredSize().getHeight());
                h += PrintFlightCheckerSheetComponent.this.border / 4;
                h = (int)((double)h + PrintFlightCheckerSheetComponent.this.productForecast.getPreferredSize().getHeight());
                h += PrintFlightCheckerSheetComponent.this.border / 4;
                h = (int)((double)h + PrintFlightCheckerSheetComponent.this.includeAllDepartments.getPreferredSize().getHeight());
                h += PrintFlightCheckerSheetComponent.this.border;
                h = (int)((double)h + PrintFlightCheckerSheetComponent.this.includeMeals.getPreferredSize().getHeight());
                h += PrintFlightCheckerSheetComponent.this.border / 4;
                h = (int)((double)h + PrintFlightCheckerSheetComponent.this.includeStandards.getPreferredSize().getHeight());
                h += PrintFlightCheckerSheetComponent.this.border / 4;
                h = (int)((double)h + PrintFlightCheckerSheetComponent.this.includeArticles.getPreferredSize().getHeight());
            }
            return new Dimension(w, h += PrintFlightCheckerSheetComponent.this.border);
        }
    }
}

