/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.flight.manuallabel;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.panels.ManualFlightLabelPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PrintManualLabelComponent
extends DefaultScrollablePrintPopup2<FlightLight> {
    private static final long serialVersionUID = 1L;
    private Node<FlightLight> currentFlight;
    private ManualFlightLabelPanel labels;

    public PrintManualLabelComponent(Node<FlightLight> node) {
        super(true, false, false, false, null);
        this.currentFlight = node;
    }

    @Override
    public void insertElements() {
        this.labels = new ManualFlightLabelPanel();
        this.createComponents();
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.labels);
    }

    @Override
    public String getTitleString() {
        return Words.FLIGHT;
    }

    @Override
    public String getTitleValue() {
        if (this.currentFlight.getValue() != null) {
            return ((FlightLight)this.currentFlight.getValue()).getOutboundCode();
        }
        return "-";
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.labels.setEnabled(isEnabled);
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.labels);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.labels.kill();
        this.labels = null;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.labels.setVisible(true);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.labels.setVisible(false);
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                String equipmentCode = PrintManualLabelComponent.this.labels.getEquipmentTypeName();
                FlightReference flight = new FlightReference(((FlightLight)PrintManualLabelComponent.this.currentFlight.getValue()).getId());
                Map<String, Integer> manualLabels = PrintManualLabelComponent.this.labels.getEntries();
                ArrayList<FlightReference> flights = new ArrayList<FlightReference>();
                flights.add(flight);
                PegasusFileComplete t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).generateManualLabels(new ListWrapper(flights), new MapWrapper(manualLabels), equipmentCode).getValue();
                PrintManualLabelComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintManualLabelComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return this.currentFlight;
    }

    @Override
    public BatchJob<FlightLight> createBatchJob(Node<FlightLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintManualLabelComponent.this.layoutInheritedComponents(parent);
            PrintManualLabelComponent.this.labels.setLocation(PrintManualLabelComponent.this.border, y += PrintManualLabelComponent.this.border / 2);
            PrintManualLabelComponent.this.labels.setSize(parent.getWidth() - 2 * PrintManualLabelComponent.this.border, parent.getHeight() - (PrintManualLabelComponent.this.labels.getY() + PrintManualLabelComponent.this.border));
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintManualLabelComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += PrintManualLabelComponent.this.border / 2;
            h += 350;
            return new Dimension(w, h += PrintManualLabelComponent.this.border);
        }
    }
}

