/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.flight.manualseallabel;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.panels.ManualSealLabelPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PrintSealLabelComponent
extends DefaultScrollablePrintPopup2<FlightLight> {
    private static final long serialVersionUID = 1L;
    private Node<FlightLight> currentFlight;
    private ManualSealLabelPanel labels;

    public PrintSealLabelComponent(Node<FlightLight> node) {
        super(true, false, false, false, null);
        this.currentFlight = node;
    }

    @Override
    public void insertElements() {
        this.labels = new ManualSealLabelPanel();
        this.createComponents();
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.labels);
    }

    @Override
    public String getTitleString() {
        return Words.FLIGHT;
    }

    @Override
    public String getTitleValue() {
        if (this.currentFlight.getValue() != null) {
            return ((FlightLight)this.currentFlight.getValue()).getOutboundCode();
        }
        return "-";
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.labels.setEnabled(isEnabled);
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.labels);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.labels.kill();
        this.labels = null;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.labels.setVisible(true);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.labels.setVisible(false);
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                boolean autoGenerate;
                Map<ColorComplete, Integer> seals = null;
                FlightReference flight = new FlightReference(((FlightLight)PrintSealLabelComponent.this.currentFlight.getValue()).getId());
                if (PrintSealLabelComponent.this.labels.getUseFlightSeals()) {
                    autoGenerate = true;
                } else {
                    autoGenerate = false;
                    seals = PrintSealLabelComponent.this.labels.getSealsCount();
                }
                boolean useEquipmentLabels = PrintSealLabelComponent.this.labels.getUseEquipmentLabels();
                ArrayList<FlightReference> flights = new ArrayList<FlightReference>();
                flights.add(flight);
                PegasusFileComplete t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).generateManualSealLabels(new ListWrapper(flights), autoGenerate, useEquipmentLabels, new MapWrapper(seals)).getValue();
                PrintSealLabelComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintSealLabelComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return this.currentFlight;
    }

    @Override
    public BatchJob<FlightLight> createBatchJob(Node<FlightLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintSealLabelComponent.this.layoutInheritedComponents(parent);
            PrintSealLabelComponent.this.labels.setLocation(PrintSealLabelComponent.this.border, y += PrintSealLabelComponent.this.border / 2);
            PrintSealLabelComponent.this.labels.setSize(parent.getWidth() - 2 * PrintSealLabelComponent.this.border, parent.getHeight() - (PrintSealLabelComponent.this.labels.getY() + PrintSealLabelComponent.this.border));
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintSealLabelComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += PrintSealLabelComponent.this.border / 2;
            h += 350;
            return new Dimension(w, h += PrintSealLabelComponent.this.border);
        }
    }
}

