/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.flight.scanning;

import ch.icit.pegasus.client.gui.table.commiter.ClientFileTransferListener;
import ch.icit.pegasus.client.gui.table.commiter.FileCommitter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.print.FlightPrintConfigurationComplete;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.List;

public class PrintScanningComponent
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private FlightLight currentFlight;

    public PrintScanningComponent(FlightLight currentFlight) {
        super(true, false);
        this.currentFlight = currentFlight;
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return new FlightPrintConfigurationComplete();
    }

    @Override
    public String getTitleString() {
        return Words.FLIGHT;
    }

    @Override
    public String getTitleValue() {
        return this.currentFlight.getOutboundCode();
    }

    @Override
    public boolean withSecondSeparator() {
        return false;
    }

    @Override
    protected String getProgressText() {
        return "Remove Retail inMotion Transactions";
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[2];
        return o;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                File f = FileChooserUtil.loadFile();
                FileCommitter c = new FileCommitter(f, FileCategoryE.IMPORT);
                c.commit(new ClientFileTransferListener(){

                    @Override
                    public void statusChanged(File file, FileTransferState state) {
                    }

                    @Override
                    public void fileUploaded(File file, PegasusFileComplete ref) {
                    }

                    @Override
                    public void fileDownloaded(File file) {
                    }

                    @Override
                    public void exceptionOccurred(Exception exception) {
                    }
                });
                PegasusFileComplete pf = c.getRemoteRef();
                ((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).printScanningReport(new FlightReference(PrintScanningComponent.this.currentFlight.getId()), pf);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintScanningComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public List<Component> getFocusComponents() {
        return super.getFocusComponents();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintScanningComponent.this.getInheritedComponentsHeight();
            return new Dimension(0, h += PrintScanningComponent.this.border);
        }

        @Override
        public void layoutContainer(Container parent) {
            int h = PrintScanningComponent.this.layoutInheritedComponents(parent);
            h += PrintScanningComponent.this.border;
        }
    }
}

