/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.flight.stowingreport;

import ch.icit.pegasus.client.converter.CustomerConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.print.shared.stowinglistreport.PrintStowingListComponent;
import ch.icit.pegasus.client.gui.utils.TransferObject;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.StowingListReportConfiguration;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.dtos.IDTO;

public class PrintFlightStowingListComponent
extends PrintStowingListComponent<FlightLight> {
    private static final long serialVersionUID = -44930111910706168L;
    private final TransferObject<FlightLight> flight;

    public PrintFlightStowingListComponent(TransferObject<FlightLight> transferObject, PeriodComplete p) {
        super(p, false);
        this.flight = transferObject;
    }

    @Override
    public boolean showPaxFinalize() {
        return true;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintFlightStowingListComponent.this.getSelectedReport();
                StowingListReportConfiguration config = new StowingListReportConfiguration(ReportTypeE.STOWINGLIST_REPORT, ReportingOutputFormatE.PDF, file);
                PrintFlightStowingListComponent.this.getConfig(config);
                config.setDto((IDTO)new FlightReference(((FlightLight)PrintFlightStowingListComponent.this.flight.getDto()).getId()));
                PegasusFileComplete t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createFlightStowingListReport(config, new ListWrapper()).getValue();
                PrintFlightStowingListComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintFlightStowingListComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return this.flight.getNode();
    }

    @Override
    public String getTitleValue() {
        CustomerConverter c1 = (CustomerConverter)ConverterRegistry.getConverter(CustomerConverter.class);
        return c1.convert(this.flight.getDto().getCustomer(), null, new Object[0]) + " " + this.flight.getDto().getOutboundCode();
    }
}

