/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.flightschedule.deliveryslip;

import ch.icit.pegasus.client.converter.CustomerConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.print.shared.deliveryslip.PrintDeliverySlipComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.TransferObject;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserPopup;
import ch.icit.pegasus.client.gui.utils.panels.PaxLegTable;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.DeliverySlipReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.FlightScheduleDeliverySlipReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrintFlightScheduleDeliverySlipComponent
extends PrintDeliverySlipComponent<FlightScheduleLight, FlightScheduleLegComplete> {
    private static final long serialVersionUID = 935825502529198929L;
    private final TransferObject<FlightScheduleLight> flightschedule;
    private final PeriodComplete period;

    public PrintFlightScheduleDeliverySlipComponent(TransferObject<FlightScheduleLight> transferObject, PeriodComplete period, RDProvider provider) {
        super(provider, false);
        this.period = period;
        this.flightschedule = transferObject;
    }

    protected Map<FlightScheduleLegComplete, Map<CabinClassComplete, Integer>> convertFlightScheduleLeg(Map<? extends ALegComplete, Map<CabinClassComplete, Integer>> pax) {
        HashMap<FlightScheduleLegComplete, Map<CabinClassComplete, Integer>> nm = new HashMap<FlightScheduleLegComplete, Map<CabinClassComplete, Integer>>();
        for (ALegComplete aLegComplete : pax.keySet()) {
            Map<CabinClassComplete, Integer> t = pax.get(aLegComplete);
            nm.put((FlightScheduleLegComplete)aLegComplete, t);
        }
        return nm;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintFlightScheduleDeliverySlipComponent.this.getSelectedReport();
                FlightScheduleDeliverySlipReportConfiguration config = new FlightScheduleDeliverySlipReportConfiguration(ReportTypeE.DELIVERYSLIP, ReportingOutputFormatE.PDF, file);
                PrintFlightScheduleDeliverySlipComponent.this.getConfig(config);
                config.setDto((IDTO)PrintFlightScheduleDeliverySlipComponent.this.flightschedule.getDto());
                config.setValidityDate(new Date(((DateChooserPopup)PrintFlightScheduleDeliverySlipComponent.this.dateChooser.getElement()).getSelectedDate().getTimeInMillis()));
                config.setPax(PrintFlightScheduleDeliverySlipComponent.this.convertFlightScheduleLeg(((PaxLegTable)PrintFlightScheduleDeliverySlipComponent.this.paxCount.getElement()).getMap()));
                PegasusFileComplete t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createFlightScheduleDeliverySlipReport((DeliverySlipReportConfiguration)config, new ListWrapper()).getValue();
                PrintFlightScheduleDeliverySlipComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintFlightScheduleDeliverySlipComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public void insertElements() {
        super.insertElements();
        this.dateChooser = new TitledItem<DateChooserPopup>(new DateChooserPopup(new java.util.Date(this.period.getStartDate().getTime())), "Date", TitledItem.TitledItemOrientation.NORTH);
        ((DateChooserPopup)this.dateChooser.getElement()).enableSkin(true);
        this.getViewContainer().add(this.dateChooser);
        ArrayList<Node<SeatConfigurationComplete>> cabinClasses = new ArrayList<Node<SeatConfigurationComplete>>();
        ArrayList<Node<? extends ALegComplete>> legs = new ArrayList<Node<? extends ALegComplete>>();
        this.updateSeatConfiguration(cabinClasses, legs);
        this.paxCount = new TitledItem<PaxLegTable>(new PaxLegTable(cabinClasses, legs, null), Words.PAX_COUNT, TitledItem.TitledItemOrientation.NORTH);
        this.getViewContainer().add(this.paxCount);
    }

    private void updateSeatConfiguration(List<Node<SeatConfigurationComplete>> cabinClasses, List<Node<? extends ALegComplete>> legs) {
        for (SeatConfigurationComplete scc : this.flightschedule.getDto().getDefaultStowingList().getStowingList().getCurrentVariant().getSeatConfigurations()) {
            Node cc = INodeCreator.getDefaultImpl().getNode4DTO((Object)scc, false, false);
            cabinClasses.add((Node<SeatConfigurationComplete>)cc);
        }
        for (ALegComplete leg : this.flightschedule.getDto().getLegs()) {
            Node ln = INodeCreator.getDefaultImpl().getNode4DTO((Object)leg, false, false);
            legs.add((Node<? extends ALegComplete>)ln);
        }
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> l = super.validateBeforePrint();
        Date d = new Date(((DateChooserPopup)this.dateChooser.getElement()).getSelectedDate().getTimeInMillis());
        if (!CalendarUtil.isBetween((Date)d, (Date)this.flightschedule.getDto().getPeriod().getStartDate(), (Date)this.flightschedule.getDto().getPeriod().getEndDate())) {
            l.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Selected Date must be within Flight Schedule's period."));
        }
        return l;
    }

    @Override
    public String getTitleValue() {
        CustomerConverter c1 = (CustomerConverter)ConverterRegistry.getConverter(CustomerConverter.class);
        return c1.convert(this.flightschedule.getDto().getCustomer(), null, new Object[0]) + " " + this.flightschedule.getDto().getOutboundCode();
    }

    @Override
    public Node<FlightScheduleLight> getCurrentNode() {
        return this.flightschedule.getNode();
    }
}

