/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.inventory.difference;

import ch.icit.pegasus.client.converter.BondedStateEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.InventoryReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight_;
import ch.icit.pegasus.server.core.dtos.report.InventoryDifferenceReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.InventoryDifferenceReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Collections;

public class PrintInventoryDifferenceComponent
extends DefaultScrollablePrintPopup2<InventoryLight> {
    private static final long serialVersionUID = 1L;
    private Node<InventoryLight> currentInventory;
    private Node<InventoryDifferenceReportConfiguration> configNode;
    private TextLabel printOptionTitle;
    private TitledItem<ComboBox> bonded;
    private TitledItem<RadioButton> chargeBased;
    private TitledItem<RadioButton> positionBased;

    public PrintInventoryDifferenceComponent(Node<InventoryLight> node) {
        super(false, true, ReportTypeE.INVENTORY_DIFFERENCE_SHEET);
        this.currentInventory = node;
        InventoryDifferenceReportConfiguration config = new InventoryDifferenceReportConfiguration(null);
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        if (!isNoPro) {
            this.printOptionTitle = new TextLabel(Words.OPTIONS);
            this.printOptionTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
            this.printOptionTitle.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
            this.bonded = new TitledItem<ComboBox>(new ComboBox(this.configNode.getChildNamed(InventoryDifferenceReportConfiguration_.bonded), NodeToolkit.getAffixList(BondedStateE.class), ConverterRegistry.getConverter(BondedStateEConverter.class)), Words.BONDED, TitledItem.TitledItemOrientation.NORTH);
            this.chargeBased = new TitledItem<RadioButton>(new RadioButton(), "Charge Based", TitledItem.TitledItemOrientation.EAST);
            this.positionBased = new TitledItem<RadioButton>(new RadioButton(), "Position Based", TitledItem.TitledItemOrientation.EAST);
            this.chargeBased.getElement().setChecked(true);
            this.getViewContainer().add(this.printOptionTitle);
            this.getViewContainer().add(this.bonded);
            this.getViewContainer().add(this.chargeBased);
            this.getViewContainer().add(this.positionBased);
        }
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.INVENTORY;
    }

    @Override
    public String getTitleValue() {
        if (this.currentInventory.getChildNamed(InventoryLight_.number).getValue() == null) {
            return "-";
        }
        return "" + this.currentInventory.getChildNamed(InventoryLight_.number).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.kill();
        }
        if (this.bonded != null) {
            this.bonded.kill();
        }
        if (this.chargeBased != null) {
            this.chargeBased.kill();
        }
        if (this.positionBased != null) {
            this.positionBased.kill();
        }
        this.printOptionTitle = null;
        this.bonded = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(true);
        }
        if (this.bonded != null) {
            this.bonded.setVisible(true);
        }
        if (this.chargeBased != null) {
            this.chargeBased.setVisible(true);
        }
        if (this.positionBased != null) {
            this.positionBased.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(false);
        }
        if (this.bonded != null) {
            this.bonded.setVisible(false);
        }
        if (this.chargeBased != null) {
            this.chargeBased.setVisible(false);
        }
        if (this.positionBased != null) {
            this.positionBased.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintInventoryDifferenceComponent.this.getSelectedReport();
                PrintInventoryDifferenceComponent.this.configNode.commit();
                InventoryDifferenceReportConfiguration config = (InventoryDifferenceReportConfiguration)PrintInventoryDifferenceComponent.this.configNode.getValue();
                config.setStylesheet(file);
                if (PrintInventoryDifferenceComponent.this.asPDF != null && ((RadioButton)PrintInventoryDifferenceComponent.this.asPDF.getElement()).isChecked()) {
                    config.setFormat(ReportingOutputFormatE.PDF);
                } else {
                    config.setFormat(ReportingOutputFormatE.XLSX);
                }
                if (PrintInventoryDifferenceComponent.this.chargeBased != null) {
                    config.setChargeBased(Boolean.valueOf(((RadioButton)PrintInventoryDifferenceComponent.this.chargeBased.getElement()).isChecked()));
                } else {
                    config.setChargeBased(Boolean.valueOf(true));
                }
                config.setInventory(Collections.singletonList(PrintInventoryDifferenceComponent.this.currentInventory.getValue()));
                PegasusFileComplete t = (PegasusFileComplete)((InventoryReportServiceManager)ServiceManagerRegistry.getService(InventoryReportServiceManager.class)).getInventoryDifferenceReport(config).getValue();
                PrintInventoryDifferenceComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintInventoryDifferenceComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<InventoryLight> getCurrentNode() {
        return this.currentInventory;
    }

    @Override
    public BatchJob<InventoryLight> createBatchJob(Node<InventoryLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintInventoryDifferenceComponent.this.layoutInheritedComponents(parent);
            if (PrintInventoryDifferenceComponent.this.printOptionTitle != null) {
                PrintInventoryDifferenceComponent.this.printOptionTitle.setLocation(PrintInventoryDifferenceComponent.this.border, y + PrintInventoryDifferenceComponent.this.border);
                PrintInventoryDifferenceComponent.this.printOptionTitle.setSize(parent.getWidth() - 2 * PrintInventoryDifferenceComponent.this.border, (int)PrintInventoryDifferenceComponent.this.printOptionTitle.getPreferredSize().getHeight());
                y = PrintInventoryDifferenceComponent.this.printOptionTitle.getY() + PrintInventoryDifferenceComponent.this.printOptionTitle.getHeight();
            }
            if (PrintInventoryDifferenceComponent.this.chargeBased != null) {
                PrintInventoryDifferenceComponent.this.chargeBased.setLocation(PrintInventoryDifferenceComponent.this.border, y + PrintInventoryDifferenceComponent.this.border / 2);
                PrintInventoryDifferenceComponent.this.chargeBased.setSize(PrintInventoryDifferenceComponent.this.chargeBased.getPreferredSize());
                PrintInventoryDifferenceComponent.this.positionBased.setLocation(PrintInventoryDifferenceComponent.this.border, PrintInventoryDifferenceComponent.this.chargeBased.getY() + PrintInventoryDifferenceComponent.this.chargeBased.getHeight() + PrintInventoryDifferenceComponent.this.border / 4);
                PrintInventoryDifferenceComponent.this.positionBased.setSize(PrintInventoryDifferenceComponent.this.positionBased.getPreferredSize());
                y = PrintInventoryDifferenceComponent.this.positionBased.getY() + PrintInventoryDifferenceComponent.this.positionBased.getHeight();
            }
            if (PrintInventoryDifferenceComponent.this.bonded != null) {
                PrintInventoryDifferenceComponent.this.bonded.setLocation(PrintInventoryDifferenceComponent.this.border, y + PrintInventoryDifferenceComponent.this.border);
                PrintInventoryDifferenceComponent.this.bonded.setSize(parent.getWidth() - 2 * PrintInventoryDifferenceComponent.this.border, (int)PrintInventoryDifferenceComponent.this.bonded.getPreferredSize().getHeight());
                y = PrintInventoryDifferenceComponent.this.bonded.getY() + PrintInventoryDifferenceComponent.this.bonded.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintInventoryDifferenceComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += PrintInventoryDifferenceComponent.this.border;
            if (PrintInventoryDifferenceComponent.this.printOptionTitle != null) {
                h = (int)((double)h + PrintInventoryDifferenceComponent.this.printOptionTitle.getPreferredSize().getHeight());
            }
            if (PrintInventoryDifferenceComponent.this.chargeBased != null) {
                h += PrintInventoryDifferenceComponent.this.border / 2;
                h = (int)((double)h + PrintInventoryDifferenceComponent.this.chargeBased.getPreferredSize().getHeight());
                h += PrintInventoryDifferenceComponent.this.border / 4;
                h = (int)((double)h + PrintInventoryDifferenceComponent.this.positionBased.getPreferredSize().getHeight());
            }
            if (PrintInventoryDifferenceComponent.this.bonded != null) {
                h += PrintInventoryDifferenceComponent.this.border;
                h = (int)((double)h + PrintInventoryDifferenceComponent.this.bonded.getPreferredSize().getHeight());
            }
            return new Dimension(w, h += PrintInventoryDifferenceComponent.this.border);
        }
    }
}

