/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.inventory.store.overview;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.InventoryReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight_;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.report.InventoryReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;

public class PrintInventoryStoreOverviewComponent
extends DefaultScrollablePrintPopup2<InventoryLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private Node<InventoryLight> currentInventory;
    private Node<InventoryReportConfiguration> configNode;
    private TextLabel optionTitle;
    private RadioButtonBox box;
    private TitledItem<RadioButton> chargePrice;
    private TitledItem<RadioButton> standardPrice;
    private TitledItem<CheckBox> signed;
    private TitledItem<ComboBox> bondedState;

    public PrintInventoryStoreOverviewComponent(Node<InventoryLight> node) {
        super(false, true, ReportTypeE.INVENTORY_STORE_OVERVIEW);
        this.currentInventory = node;
        InventoryReportConfiguration config = new InventoryReportConfiguration(null, ReportTypeE.INVENTORY_STORE_OVERVIEW);
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        if (!isNoPro) {
            this.box = new RadioButtonBox();
            this.box.setOrientation(0);
            this.optionTitle = new TextLabel(Words.OPTIONS);
            this.signed = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(new String[]{"signed"})), Words.SIGNED, TitledItem.TitledItemOrientation.EAST);
            this.chargePrice = new TitledItem<RadioButton>(new RadioButton(), Words.CHARGE_PRICE, TitledItem.TitledItemOrientation.EAST);
            this.standardPrice = new TitledItem<RadioButton>(new RadioButton(), Words.STANDARD_PRICE, TitledItem.TitledItemOrientation.EAST);
            this.signed.getElement().setChecked(true);
            this.standardPrice.getElement().setChecked(true);
            this.bondedState = new TitledItem<ComboBox>(new ComboBox(), Words.BONDED, TitledItem.TitledItemOrientation.NORTH);
            this.bondedState.getElement().addItem(BondedStateE.ALL);
            this.bondedState.getElement().addItem(BondedStateE.NOT_BONDED);
            this.bondedState.getElement().addItem(BondedStateE.ONLY_BONDED);
            this.box.addBox(this.chargePrice, this.chargePrice.getElement());
            this.box.addBox(this.standardPrice, this.standardPrice.getElement());
            this.getViewContainer().add(this.optionTitle);
            this.getViewContainer().add(this.box);
            this.getViewContainer().add(this.signed);
            this.getViewContainer().add(this.bondedState);
        }
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.INVENTORY;
    }

    @Override
    public String getTitleValue() {
        if (this.currentInventory.getChildNamed(InventoryLight_.number).getValue() == null) {
            return "-";
        }
        return "" + this.currentInventory.getChildNamed(InventoryLight_.number).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.optionTitle != null) {
            this.optionTitle.kill();
            this.box.kill();
            this.signed.kill();
            this.bondedState.kill();
        }
        this.optionTitle = null;
        this.box = null;
        this.signed = null;
        this.bondedState = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.optionTitle != null) {
            this.optionTitle.setVisible(true);
            this.signed.setVisible(true);
            this.chargePrice.setVisible(true);
            this.standardPrice.setVisible(true);
            this.bondedState.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.optionTitle != null) {
            this.optionTitle.setVisible(false);
            this.signed.setVisible(false);
            this.chargePrice.setVisible(false);
            this.standardPrice.setVisible(false);
            this.bondedState.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintInventoryStoreOverviewComponent.this.getSelectedReport();
                PrintInventoryStoreOverviewComponent.this.configNode.commit();
                InventoryReportConfiguration config = (InventoryReportConfiguration)PrintInventoryStoreOverviewComponent.this.configNode.getValue();
                config.setStylesheet(file);
                if (PrintInventoryStoreOverviewComponent.this.asPDF != null && ((RadioButton)PrintInventoryStoreOverviewComponent.this.asPDF.getElement()).isChecked()) {
                    config.setFormat(ReportingOutputFormatE.PDF);
                } else {
                    config.setFormat(ReportingOutputFormatE.XLSX);
                }
                config.setInventory((InventoryReference)PrintInventoryStoreOverviewComponent.this.currentInventory.getValue());
                boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
                if (!isNoPro) {
                    config.setUseStandardPrice(Boolean.valueOf(((RadioButton)PrintInventoryStoreOverviewComponent.this.standardPrice.getElement()).isChecked()));
                } else {
                    config.setUseStandardPrice(Boolean.valueOf(false));
                    config.setSigned(Boolean.valueOf(true));
                }
                PegasusFileComplete t = (PegasusFileComplete)((InventoryReportServiceManager)ServiceManagerRegistry.getService(InventoryReportServiceManager.class)).getInventoryStoreOverviewReport(config).getValue();
                PrintInventoryStoreOverviewComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintInventoryStoreOverviewComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<InventoryLight> getCurrentNode() {
        return this.currentInventory;
    }

    @Override
    public BatchJob<InventoryLight> createBatchJob(Node<InventoryLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintInventoryStoreOverviewComponent.this.layoutInheritedComponents(parent);
            if (PrintInventoryStoreOverviewComponent.this.optionTitle != null) {
                PrintInventoryStoreOverviewComponent.this.box.setColumn((parent.getWidth() - 2 * PrintInventoryStoreOverviewComponent.this.border) / 2);
                PrintInventoryStoreOverviewComponent.this.optionTitle.setLocation(PrintInventoryStoreOverviewComponent.this.border, y);
                PrintInventoryStoreOverviewComponent.this.optionTitle.setSize(PrintInventoryStoreOverviewComponent.this.optionTitle.getPreferredSize());
                PrintInventoryStoreOverviewComponent.this.box.setLocation(PrintInventoryStoreOverviewComponent.this.border, PrintInventoryStoreOverviewComponent.this.optionTitle.getY() + PrintInventoryStoreOverviewComponent.this.optionTitle.getHeight() + PrintInventoryStoreOverviewComponent.this.border / 2);
                PrintInventoryStoreOverviewComponent.this.box.setSize(parent.getWidth() - 2 * PrintInventoryStoreOverviewComponent.this.border, (int)PrintInventoryStoreOverviewComponent.this.box.getPreferredSize().getHeight());
                PrintInventoryStoreOverviewComponent.this.signed.setLocation(PrintInventoryStoreOverviewComponent.this.border, PrintInventoryStoreOverviewComponent.this.box.getY() + PrintInventoryStoreOverviewComponent.this.box.getHeight() + PrintInventoryStoreOverviewComponent.this.border / 2);
                PrintInventoryStoreOverviewComponent.this.signed.setSize(PrintInventoryStoreOverviewComponent.this.signed.getPreferredSize());
                PrintInventoryStoreOverviewComponent.this.bondedState.setLocation(PrintInventoryStoreOverviewComponent.this.border, PrintInventoryStoreOverviewComponent.this.signed.getY() + PrintInventoryStoreOverviewComponent.this.signed.getHeight() + PrintInventoryStoreOverviewComponent.this.border);
                PrintInventoryStoreOverviewComponent.this.bondedState.setSize(120, (int)PrintInventoryStoreOverviewComponent.this.bondedState.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintInventoryStoreOverviewComponent.this.getInheritedComponentsHeight();
            h += PrintInventoryStoreOverviewComponent.this.border;
            if (PrintInventoryStoreOverviewComponent.this.animation != null) {
                h = (int)((double)h + PrintInventoryStoreOverviewComponent.this.animation.getPreferredSize().getHeight());
                return new Dimension((int)((double)(PrintInventoryStoreOverviewComponent.this.border * 2) + PrintInventoryStoreOverviewComponent.this.animation.getPreferredSize().getWidth()), h += PrintInventoryStoreOverviewComponent.this.border);
            }
            if (PrintInventoryStoreOverviewComponent.this.optionTitle != null) {
                h = (int)((double)h + PrintInventoryStoreOverviewComponent.this.optionTitle.getPreferredSize().getHeight());
                h += PrintInventoryStoreOverviewComponent.this.border / 2;
                h = (int)((double)h + PrintInventoryStoreOverviewComponent.this.box.getPreferredSize().getHeight());
                h += PrintInventoryStoreOverviewComponent.this.border / 2;
                h = (int)((double)h + PrintInventoryStoreOverviewComponent.this.signed.getPreferredSize().getHeight());
                h += PrintInventoryStoreOverviewComponent.this.border;
                h = (int)((double)h + PrintInventoryStoreOverviewComponent.this.bondedState.getPreferredSize().getHeight());
                h += PrintInventoryStoreOverviewComponent.this.border;
            }
            return new Dimension(0, h);
        }
    }
}

