/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.invoice;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.invoice.InvoiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.InvoiceReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.invoice.HistoricalInvoiceComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceLight;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceLight_;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceReference;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceStateE;
import ch.icit.pegasus.server.core.dtos.report.InvoiceReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.InvoiceReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;

public class PrintInvoiceComponent
extends DefaultScrollablePrintPopup2<InvoiceLight> {
    private static final long serialVersionUID = 1L;
    private Node<InvoiceLight> currentInvoice;
    private Node<InvoiceReportConfiguration> configNode;
    private TextLabel printOptionTitle;
    private TitledItem<CheckBox> titleOnly;
    private TitledItem<CheckBox> finalVersion;
    private TitledItem<CheckBox> includeNullValues;
    private TitledItem<CheckBox> groupTaxes;
    private RowModel<InvoiceLight> rowModel;
    private boolean invoiceClosedMode = false;
    private boolean isNoPro;

    public PrintInvoiceComponent(Node<InvoiceLight> node, RowModel<InvoiceLight> m, ReportTypeE reportType) {
        super(false, false, reportType);
        this.rowModel = m;
        this.currentInvoice = node;
        InvoiceReportConfiguration config = new InvoiceReportConfiguration(reportType, null, null);
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
        this.initInvoiceClosedMode();
    }

    private void initInvoiceClosedMode() {
        HistoricalInvoiceComplete historic;
        this.invoiceClosedMode = ((InvoiceLight)this.currentInvoice.getValue()).getState() == InvoiceStateE.PLANNED || ((InvoiceLight)this.currentInvoice.getValue()).getState() == InvoiceStateE.CHECKED ? false : (historic = ((InvoiceLight)this.currentInvoice.getValue()).getFinalData()) != null && !Boolean.TRUE.equals(((InvoiceLight)this.currentInvoice.getValue()).getHasError());
    }

    @Override
    public void insertElements() {
        this.isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        if (!this.invoiceClosedMode && !this.isNoPro) {
            Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
            Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
            this.printOptionTitle = new TextLabel(Words.OPTIONS);
            this.printOptionTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
            this.printOptionTitle.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
            this.titleOnly = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InvoiceReportConfiguration_.titlePageOnly)), Words.TITLE_PAGE_ONLY, TitledItem.TitledItemOrientation.EAST);
            this.titleOnly.setTitleFont(f);
            this.titleOnly.setTitleForeground(fb);
            this.titleOnly.getElement().setChecked(false);
            this.finalVersion = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InvoiceReportConfiguration_.finalVersion)), Words.PRINT_FINAL_VERSION_AND_CLOSE_INVOICE, TitledItem.TitledItemOrientation.EAST);
            this.finalVersion.setTitleFont(f);
            this.finalVersion.setTitleForeground(fb);
            this.includeNullValues = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InvoiceReportConfiguration_.includeNullValues)), Words.INCLUDE_NULL_VALUES, TitledItem.TitledItemOrientation.EAST);
            this.includeNullValues.setTitleFont(f);
            this.includeNullValues.setTitleForeground(fb);
            this.includeNullValues.getElement().setChecked(false);
            this.groupTaxes = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InvoiceReportConfiguration_.totalTaxGroups)), Words.GROUP_TAXES, TitledItem.TitledItemOrientation.EAST);
            this.groupTaxes.setTitleFont(f);
            this.groupTaxes.setTitleForeground(fb);
            this.getViewContainer().add(this.printOptionTitle);
            this.getViewContainer().add(this.titleOnly);
            this.getViewContainer().add(this.finalVersion);
            this.getViewContainer().add(this.includeNullValues);
            this.getViewContainer().add(this.groupTaxes);
        }
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        if (!this.invoiceClosedMode && !this.isNoPro) {
            if (!CompanyUtil.isSCK((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()))) {
                for (String[] s : conf.getProperties()) {
                    String n = s[0];
                    String v = s[1];
                    Boolean b = Boolean.valueOf(v);
                    switch (n) {
                        case "title": {
                            this.titleOnly.getElement().setChecked(b);
                            break;
                        }
                        case "include_null_values": {
                            this.includeNullValues.getElement().setChecked(b);
                            break;
                        }
                        case "group_taxes": {
                            this.groupTaxes.getElement().setChecked(b);
                        }
                    }
                }
            }
            if (((InvoiceLight)this.currentInvoice.getValue()).getState() == InvoiceStateE.CANCELLED) {
                this.titleOnly.getElement().setChecked(true);
                this.finalVersion.getElement().setChecked(true);
            }
        }
    }

    @Override
    protected void setEnabledFromRemoteLoad(boolean isEnabled) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (!this.invoiceClosedMode && !this.isNoPro) {
            boolean b;
            boolean bl = b = ((InvoiceLight)this.currentInvoice.getValue()).getState() != InvoiceStateE.CREDIT_NOTE && isEnabled;
            if (((InvoiceReportConfiguration)this.configNode.getValue()).getReportType() == ReportTypeE.INVOICE) {
                this.titleOnly.setEnabled(isEnabled);
                this.finalVersion.setEnabled(isEnabled);
                this.includeNullValues.setEnabled(isEnabled);
                this.groupTaxes.setEnabled(isEnabled);
            } else if (((InvoiceReportConfiguration)this.configNode.getValue()).getReportType() == ReportTypeE.INVOICE_SOB_ONLY || ((InvoiceReportConfiguration)this.configNode.getValue()).getReportType() == ReportTypeE.INVOICE_COMPLEMENTARY) {
                this.titleOnly.setEnabled(b);
                this.finalVersion.setEnabled(b);
                this.includeNullValues.setEnabled(false);
                this.groupTaxes.setEnabled(false);
            } else {
                this.titleOnly.setEnabled(false);
                this.finalVersion.setEnabled(b);
                this.includeNullValues.setEnabled(false);
                this.groupTaxes.setEnabled(false);
            }
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        if (!this.invoiceClosedMode && !this.isNoPro) {
            FilterChainConfiguration conf = new FilterChainConfiguration();
            conf.addProperty("title", "" + this.titleOnly.getElement().isChecked());
            conf.addProperty("include_null_values", "" + this.includeNullValues.getElement().isChecked());
            conf.addProperty("group_taxes", "" + this.groupTaxes.getElement().isChecked());
            return conf;
        }
        return null;
    }

    @Override
    public String getTitleString() {
        return Words.INVOICE;
    }

    @Override
    public String getTitleValue() {
        if (this.currentInvoice.getChildNamed(InvoiceLight_.number).getValue() == null) {
            return "-";
        }
        return "" + this.currentInvoice.getChildNamed(InvoiceLight_.number).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.kill();
        }
        if (this.titleOnly != null) {
            this.titleOnly.kill();
        }
        if (this.finalVersion != null) {
            this.finalVersion.kill();
        }
        if (this.includeNullValues != null) {
            this.includeNullValues.kill();
        }
        if (this.groupTaxes != null) {
            this.groupTaxes.kill();
        }
        this.printOptionTitle = null;
        this.titleOnly = null;
        this.finalVersion = null;
        this.includeNullValues = null;
        this.groupTaxes = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(true);
        }
        if (this.titleOnly != null) {
            this.titleOnly.setVisible(true);
        }
        if (this.finalVersion != null) {
            this.finalVersion.setVisible(true);
        }
        if (this.includeNullValues != null) {
            this.includeNullValues.setVisible(true);
        }
        if (this.groupTaxes != null) {
            this.groupTaxes.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(false);
        }
        if (this.titleOnly != null) {
            this.titleOnly.setVisible(false);
        }
        if (this.finalVersion != null) {
            this.finalVersion.setVisible(false);
        }
        if (this.includeNullValues != null) {
            this.includeNullValues.setVisible(false);
        }
        if (this.groupTaxes != null) {
            this.groupTaxes.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                if (!PrintInvoiceComponent.this.invoiceClosedMode) {
                    InvoiceComplete invoice;
                    ReportFileComplete file = PrintInvoiceComponent.this.getSelectedReport();
                    PrintInvoiceComponent.this.configNode.commit();
                    InvoiceReportConfiguration config = (InvoiceReportConfiguration)PrintInvoiceComponent.this.configNode.getValue();
                    config.setStylesheet(file);
                    config.setFormat(ReportingOutputFormatE.PDF);
                    config.setInvoice((InvoiceReference)PrintInvoiceComponent.this.currentInvoice.getValue());
                    if (config.getReportType().equals((Object)ReportTypeE.INVOICE_COMMISSION)) {
                        PegasusFileComplete t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createSobCommissionInvoice(config).getValue();
                        PrintInvoiceComponent.this.processFile(t);
                        Node b = new Node();
                        b.setValue((Object)true, 0L);
                        return b;
                    }
                    if (config.getReportType().equals((Object)ReportTypeE.INVOICE_FREE_SOB)) {
                        PegasusFileComplete t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createSobFreeSobInvoice(config).getValue();
                        PrintInvoiceComponent.this.processFile(t);
                        Node b = new Node();
                        b.setValue((Object)true, 0L);
                        return b;
                    }
                    if (config.getReportType().equals((Object)ReportTypeE.INVOICE_COMPLEMENTARY)) {
                        PegasusFileComplete t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createSobComplementaryInvoice(config).getValue();
                        PrintInvoiceComponent.this.processFile(t);
                        Node b = new Node();
                        b.setValue((Object)true, 0L);
                        return b;
                    }
                    if (config.getReportType().equals((Object)ReportTypeE.INVOICE_SOB_ONLY)) {
                        PegasusFileComplete t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createSobInvoice(config).getValue();
                        PrintInvoiceComponent.this.processFile(t);
                        Node b = new Node();
                        b.setValue((Object)true, 0L);
                        return b;
                    }
                    boolean wasClosing = false;
                    if (config.getFinalVersion().booleanValue() && ((InvoiceLight)PrintInvoiceComponent.this.currentInvoice.getValue()).getState() != InvoiceStateE.CLOSED && ((InvoiceLight)PrintInvoiceComponent.this.currentInvoice.getValue()).getState() != InvoiceStateE.CANCELLED && ((InvoiceLight)PrintInvoiceComponent.this.currentInvoice.getValue()).getState() != InvoiceStateE.CREDIT_NOTE) {
                        wasClosing = true;
                        PrintInvoiceComponent.this.ensureAnimation("Close Invoice");
                        ((InvoiceLight)PrintInvoiceComponent.this.currentInvoice.getValue()).setState(InvoiceStateE.CLOSED);
                        invoice = (InvoiceComplete)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).getInvoice(new InvoiceReference(((InvoiceLight)PrintInvoiceComponent.this.currentInvoice.getValue()).getId())).getValue();
                        invoice.setState(InvoiceStateE.CLOSED);
                        invoice = (InvoiceComplete)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).updateInvoice(invoice).getValue();
                        PrintInvoiceComponent.this.currentInvoice.removeExistingValues();
                        PrintInvoiceComponent.this.currentInvoice.setValue((Object)invoice, 0L);
                        PrintInvoiceComponent.this.currentInvoice.updateNode();
                    }
                    config.setInvoice((InvoiceReference)PrintInvoiceComponent.this.currentInvoice.getValue());
                    if (Boolean.TRUE.equals(((InvoiceLight)PrintInvoiceComponent.this.currentInvoice.getValue()).getHasError())) {
                        invoice = (InvoiceComplete)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).getInvoice(new InvoiceReference(((InvoiceLight)PrintInvoiceComponent.this.currentInvoice.getValue()).getId())).getValue();
                        invoice = (InvoiceComplete)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).updateInvoice(invoice).getValue();
                        PrintInvoiceComponent.this.currentInvoice.removeExistingValues();
                        PrintInvoiceComponent.this.currentInvoice.setValue((Object)invoice, 0L);
                        PrintInvoiceComponent.this.currentInvoice.updateNode();
                    }
                    if (wasClosing) {
                        PrintInvoiceComponent.this.ensureAnimation(PrintInvoiceComponent.this.getProgressText());
                    }
                    if (PrintInvoiceComponent.this.isNoPro) {
                        config.setTitlePageOnly(Boolean.valueOf(false));
                        config.setTotalTaxGroups(Boolean.valueOf(true));
                    }
                    PegasusFileComplete t = (PegasusFileComplete)((InvoiceReportServiceManager)ServiceManagerRegistry.getService(InvoiceReportServiceManager.class)).createInvoiceReport(config).getValue();
                    PrintInvoiceComponent.this.processFile(t);
                    Node b = new Node();
                    b.setValue((Object)true, 0L);
                    return b;
                }
                InvoiceLight i = (InvoiceLight)PrintInvoiceComponent.this.currentInvoice.getValue();
                HistoricalInvoiceComplete historic = i.getFinalData();
                if (historic == null) {
                    throw new Exception(Words.NO_HISTORIC_DATA_FOUND);
                }
                PegasusFileComplete t = historic.getReport();
                PrintInvoiceComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintInvoiceComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        this.rowModel.getView().refreshCells();
    }

    @Override
    public Node<InvoiceLight> getCurrentNode() {
        return this.currentInvoice;
    }

    @Override
    public BatchJob<InvoiceLight> createBatchJob(Node<InvoiceLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintInvoiceComponent.this.layoutInheritedComponents(parent);
            if (PrintInvoiceComponent.this.printOptionTitle != null) {
                PrintInvoiceComponent.this.printOptionTitle.setLocation(PrintInvoiceComponent.this.border, y + PrintInvoiceComponent.this.border);
                PrintInvoiceComponent.this.printOptionTitle.setSize(parent.getWidth() - 2 * PrintInvoiceComponent.this.border, (int)PrintInvoiceComponent.this.printOptionTitle.getPreferredSize().getHeight());
                y = PrintInvoiceComponent.this.printOptionTitle.getY() + PrintInvoiceComponent.this.printOptionTitle.getHeight();
            }
            if (PrintInvoiceComponent.this.titleOnly != null) {
                PrintInvoiceComponent.this.titleOnly.setLocation(PrintInvoiceComponent.this.border, y + PrintInvoiceComponent.this.border / 2);
                PrintInvoiceComponent.this.titleOnly.setSize(parent.getWidth() - 2 * PrintInvoiceComponent.this.border, (int)PrintInvoiceComponent.this.titleOnly.getPreferredSize().getHeight());
                y = PrintInvoiceComponent.this.titleOnly.getY() + PrintInvoiceComponent.this.titleOnly.getHeight();
            }
            if (PrintInvoiceComponent.this.finalVersion != null) {
                PrintInvoiceComponent.this.finalVersion.setLocation(PrintInvoiceComponent.this.border, y + PrintInvoiceComponent.this.border / 2);
                PrintInvoiceComponent.this.finalVersion.setSize((parent.getWidth() - 3 * PrintInvoiceComponent.this.border) / 2, (int)PrintInvoiceComponent.this.finalVersion.getPreferredSize().getHeight());
                y = PrintInvoiceComponent.this.finalVersion.getY() + PrintInvoiceComponent.this.finalVersion.getHeight();
            }
            if (PrintInvoiceComponent.this.includeNullValues != null) {
                PrintInvoiceComponent.this.includeNullValues.setLocation(PrintInvoiceComponent.this.border, y + PrintInvoiceComponent.this.border);
                PrintInvoiceComponent.this.includeNullValues.setSize(parent.getWidth() - 2 * PrintInvoiceComponent.this.border, (int)PrintInvoiceComponent.this.includeNullValues.getPreferredSize().getHeight());
                y = PrintInvoiceComponent.this.includeNullValues.getY() + PrintInvoiceComponent.this.includeNullValues.getHeight();
            }
            if (PrintInvoiceComponent.this.groupTaxes != null) {
                PrintInvoiceComponent.this.groupTaxes.setLocation(PrintInvoiceComponent.this.border, y + PrintInvoiceComponent.this.border / 2);
                PrintInvoiceComponent.this.groupTaxes.setSize(parent.getWidth() - 2 * PrintInvoiceComponent.this.border, (int)PrintInvoiceComponent.this.groupTaxes.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintInvoiceComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += PrintInvoiceComponent.this.border;
            if (PrintInvoiceComponent.this.printOptionTitle != null) {
                h = (int)((double)h + PrintInvoiceComponent.this.printOptionTitle.getPreferredSize().getHeight());
                h += PrintInvoiceComponent.this.border / 2;
            }
            if (PrintInvoiceComponent.this.titleOnly != null) {
                h = (int)((double)h + PrintInvoiceComponent.this.titleOnly.getPreferredSize().getHeight());
                h += PrintInvoiceComponent.this.border / 2;
            }
            if (PrintInvoiceComponent.this.finalVersion != null) {
                h = (int)((double)h + PrintInvoiceComponent.this.finalVersion.getPreferredSize().getHeight());
                h += PrintInvoiceComponent.this.border;
            }
            if (PrintInvoiceComponent.this.includeNullValues != null) {
                h = (int)((double)h + PrintInvoiceComponent.this.includeNullValues.getPreferredSize().getHeight());
                h += PrintInvoiceComponent.this.border / 2;
            }
            if (PrintInvoiceComponent.this.groupTaxes != null) {
                h = (int)((double)h + PrintInvoiceComponent.this.groupTaxes.getPreferredSize().getHeight());
                h += PrintInvoiceComponent.this.border / 2;
            }
            return new Dimension(w, h);
        }
    }
}

