/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.product.eandetails;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.report.ProductFactSheetReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ProductFactSheetReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.util.DateDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.DateUnitE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Date;
import java.util.Collections;
import org.joda.time.DateTime;

public class PrintProductEanDetailsSheetComponent
extends DefaultScrollablePrintPopup2<ProductComplete>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private final Node<ProductComplete> currentProduct;
    private final Node configNode;
    private TitledItem<DateChooser> preparationDate;
    private TitledItem<DateChooser> expiryDate;

    public PrintProductEanDetailsSheetComponent(Node<ProductComplete> node) {
        super(false, false, ReportTypeE.PRODUCT_EAN_DETAILS);
        this.currentProduct = node;
        ProductFactSheetReportConfiguration config = new ProductFactSheetReportConfiguration(null);
        config.setPreparationDate(new Date(System.currentTimeMillis()));
        config.setExpiryDate(new Date(DateUtil.addPeriod((DateTime)new DateTime(System.currentTimeMillis()), (DateDurationComplete)new DateDurationComplete(DateUnitE.MONTH, Double.valueOf(3.0))).getMillis()));
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.preparationDate = new TitledItem<DateChooser>(new DateChooser(this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.preparationDate)), "Preparation Date", TitledItem.TitledItemOrientation.NORTH);
        this.preparationDate.getElement().setIsTimestamp(false);
        this.expiryDate = new TitledItem<DateChooser>(new DateChooser(this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.expiryDate)), "Expiry Date", TitledItem.TitledItemOrientation.NORTH);
        this.expiryDate.getElement().setIsTimestamp(true);
        this.getViewContainer().add(this.preparationDate);
        this.getViewContainer().add(this.expiryDate);
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.preparationDate.setEnabled(isEnabled);
        this.expiryDate.setEnabled(isEnabled);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean bl = Boolean.valueOf(v);
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public String getTitleString() {
        return "Product EAN Details Sheet";
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentProduct.getChildNamed(new DtoField[]{ProductComplete_.currentVariant, ProductVariantLight_.name}).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.preparationDate != null) {
            this.preparationDate.kill();
        }
        if (this.expiryDate != null) {
            this.expiryDate.kill();
        }
        this.expiryDate = null;
        this.preparationDate = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.preparationDate != null) {
            this.preparationDate.setVisible(true);
        }
        if (this.expiryDate != null) {
            this.expiryDate.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.preparationDate != null) {
            this.preparationDate.setVisible(false);
        }
        if (this.expiryDate != null) {
            this.expiryDate.setVisible(false);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintProductEanDetailsSheetComponent.this.getSelectedReport();
                PrintProductEanDetailsSheetComponent.this.configNode.commit();
                ProductFactSheetReportConfiguration config = (ProductFactSheetReportConfiguration)PrintProductEanDetailsSheetComponent.this.configNode.getValue();
                config.setStylesheet(file);
                ProductReference productRef = new ProductReference(((ProductComplete)PrintProductEanDetailsSheetComponent.this.currentProduct.getValue()).getId());
                PegasusFileComplete t = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).getProductEANDetailsSheet(new ListWrapper(Collections.singletonList(productRef)), config).getValue();
                PrintProductEanDetailsSheetComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintProductEanDetailsSheetComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<ProductComplete> getCurrentNode() {
        return this.currentProduct;
    }

    @Override
    public BatchJob<ProductComplete> createBatchJob(Node<ProductComplete> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintProductEanDetailsSheetComponent.this.layoutInheritedComponents(parent);
            if (PrintProductEanDetailsSheetComponent.this.preparationDate != null) {
                PrintProductEanDetailsSheetComponent.this.preparationDate.setLocation(PrintProductEanDetailsSheetComponent.this.border, y + PrintProductEanDetailsSheetComponent.this.border / 2);
                PrintProductEanDetailsSheetComponent.this.preparationDate.setSize(parent.getWidth() - 2 * PrintProductEanDetailsSheetComponent.this.border, (int)PrintProductEanDetailsSheetComponent.this.preparationDate.getPreferredSize().getHeight());
                y = PrintProductEanDetailsSheetComponent.this.preparationDate.getY() + PrintProductEanDetailsSheetComponent.this.preparationDate.getHeight();
            }
            if (PrintProductEanDetailsSheetComponent.this.expiryDate != null) {
                PrintProductEanDetailsSheetComponent.this.expiryDate.setLocation(PrintProductEanDetailsSheetComponent.this.border, y + PrintProductEanDetailsSheetComponent.this.border / 2);
                PrintProductEanDetailsSheetComponent.this.expiryDate.setSize(parent.getWidth() - 2 * PrintProductEanDetailsSheetComponent.this.border, (int)PrintProductEanDetailsSheetComponent.this.expiryDate.getPreferredSize().getHeight());
                y = PrintProductEanDetailsSheetComponent.this.expiryDate.getY() + PrintProductEanDetailsSheetComponent.this.expiryDate.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintProductEanDetailsSheetComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += PrintProductEanDetailsSheetComponent.this.border;
            if (PrintProductEanDetailsSheetComponent.this.preparationDate != null) {
                h = (int)((double)h + PrintProductEanDetailsSheetComponent.this.preparationDate.getPreferredSize().getHeight());
                h += PrintProductEanDetailsSheetComponent.this.border / 2;
            }
            if (PrintProductEanDetailsSheetComponent.this.expiryDate != null) {
                h = (int)((double)h + PrintProductEanDetailsSheetComponent.this.expiryDate.getPreferredSize().getHeight());
                h += PrintProductEanDetailsSheetComponent.this.border / 2;
            }
            return new Dimension(w, h);
        }
    }
}

