/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.product.factsheet.pdf;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.submodules.print.product.factsheet.pdf.ProductFactSheetConfigurationPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantReference;
import ch.icit.pegasus.server.core.dtos.report.ProductFactSheetReportConfiguration;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Container;
import java.awt.Dimension;

public class PrintProductFactSheetComponent
extends DefaultScrollablePrintPopup2<ProductComplete>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private ProductFactSheetConfigurationPanel configPanel;
    private Node<ProductComplete> node;

    public PrintProductFactSheetComponent(Node<ProductComplete> node) {
        super(false, false, ReportTypeE.PRODUCT);
        this.node = node;
        this.configPanel = new ProductFactSheetConfigurationPanel(this, node);
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.configPanel.createComponents();
        this.getViewContainer().add(this.configPanel);
        this.setEnabled(true);
    }

    @Override
    public boolean isReportAllowed(ReportFileComplete reportFile) {
        UserComplete user;
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (CompanyUtil.isFPB((SystemSettingsComplete)settings) && Boolean.TRUE.equals((user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser()).getRestaurantUser())) {
            return reportFile.getDescription().contains("Weisse Arena");
        }
        return super.isReportAllowed(reportFile);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.configPanel.setEnabled(isEnabled);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        this.configPanel.updateConfiguration(conf);
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return this.configPanel.createFilterChainConfig();
    }

    @Override
    protected String getProgressText() {
        return Words.PRINT;
    }

    @Override
    public String getTitleString() {
        return WordsToolkit.toUpperCase((String)Words.PRODUCT_FACT_SHEET);
    }

    @Override
    public String getTitleValue() {
        return (String)this.node.getChildNamed(new DtoField[]{ProductComplete_.currentVariant, ProductVariantLight_.name}).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.configPanel.kill();
        this.configPanel = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.configPanel.showComponents();
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.configPanel.hideComponents();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        this.setEnabled(this.isEnabled());
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductReference productRef = new ProductReference(((ProductComplete)PrintProductFactSheetComponent.this.node.getValue()).getId());
                ProductFactSheetReportConfiguration<ProductVariantReference> config = PrintProductFactSheetComponent.this.configPanel.createPrintConfiguration(PrintProductFactSheetComponent.this.getSelectedReport());
                PegasusFileComplete t = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).getProductFactSheet(productRef, config).getValue();
                PrintProductFactSheetComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintProductFactSheetComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<ProductComplete> getCurrentNode() {
        return this.node;
    }

    @Override
    public BatchJob<ProductComplete> createBatchJob(Node<ProductComplete> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintProductFactSheetComponent.this.layoutInheritedComponents(parent);
            if (PrintProductFactSheetComponent.this.configPanel != null) {
                PrintProductFactSheetComponent.this.configPanel.setLocation(PrintProductFactSheetComponent.this.border, y + PrintProductFactSheetComponent.this.border);
                PrintProductFactSheetComponent.this.configPanel.setSize(parent.getWidth() - 2 * PrintProductFactSheetComponent.this.border, parent.getHeight() - (2 * PrintProductFactSheetComponent.this.border + y));
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintProductFactSheetComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += PrintProductFactSheetComponent.this.border;
            if (PrintProductFactSheetComponent.this.configPanel != null) {
                h = (int)((double)h + PrintProductFactSheetComponent.this.configPanel.getPreferredSize().getHeight());
                h += PrintProductFactSheetComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

