/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.product.manhours;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.panels.ProductManHourExportConfigurationPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.report.ProductManHourReportConfiguration;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;

public class ExportProductManHoursComponent
extends DefaultScrollablePrintPopup2<ProductComplete>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private final Node<ProductComplete> currentProduct;
    private ProductManHourExportConfigurationPanel config;

    public ExportProductManHoursComponent(Node<ProductComplete> node) {
        super(false, false, false, false, ReportTypeE.PRODUCT);
        this.currentProduct = node;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.config = new ProductManHourExportConfigurationPanel();
        this.getViewContainer().add(this.config);
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean bl = Boolean.valueOf(v);
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    protected String getProgressText() {
        return Words.EXPORT;
    }

    @Override
    public String getTitleString() {
        return Words.MAN_HOURS;
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentProduct.getChildNamed(new DtoField[]{ProductComplete_.currentVariant, ProductVariantLight_.name}).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.config != null) {
            this.config.kill();
        }
        this.config = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.config != null) {
            this.config.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.config != null) {
            this.config.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductManHourReportConfiguration cc = ExportProductManHoursComponent.this.config.createConfig();
                ArrayList<Object> catalogs = new ArrayList<Object>();
                catalogs.add(ExportProductManHoursComponent.this.currentProduct.getValue());
                PegasusFileComplete t = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).createProductManMinutes(new ListWrapper(catalogs), cc).getValue();
                ExportProductManHoursComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ExportProductManHoursComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<ProductComplete> getCurrentNode() {
        return this.currentProduct;
    }

    @Override
    public BatchJob<ProductComplete> createBatchJob(Node<ProductComplete> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ExportProductManHoursComponent.this.layoutInheritedComponents(parent);
            if (ExportProductManHoursComponent.this.config != null) {
                ExportProductManHoursComponent.this.config.setLocation(ExportProductManHoursComponent.this.border, y + ExportProductManHoursComponent.this.border / 2);
                ExportProductManHoursComponent.this.config.setSize(parent.getWidth() - 2 * ExportProductManHoursComponent.this.border, (int)ExportProductManHoursComponent.this.config.getPreferredSize().getHeight());
                y = ExportProductManHoursComponent.this.config.getY() + ExportProductManHoursComponent.this.config.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ExportProductManHoursComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += ExportProductManHoursComponent.this.border / 2;
            if (ExportProductManHoursComponent.this.config != null) {
                h = (int)((double)h + ExportProductManHoursComponent.this.config.getPreferredSize().getHeight());
                h += ExportProductManHoursComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

