/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.product.productcopy;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.toolkits.copy.CopyTemplateToolkit;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.report.ProductFactSheetReportConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.HashSet;

public class CopyProductComponent
extends DefaultScrollablePrintPopup2<ProductComplete>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private final Node<ProductComplete> currentProduct;
    private final Node configNode;
    private TitledItem<DateChooser> dueDate;
    private TitledItem<CheckBox> allVariants;
    private TitledItem<SearchTextField2> sourceCustomer;
    private TitledItem<SearchTextField2> targetCustomer;
    private TitledItem<TextField> copyItems;
    private InfoButton infoButton;

    public CopyProductComponent(Node<ProductComplete> node) {
        super(false, false, false, false, null);
        this.currentProduct = node;
        ProductFactSheetReportConfiguration config = new ProductFactSheetReportConfiguration(null);
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.sourceCustomer = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, new DTOProxyNode()), Words.SOURCE_CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.targetCustomer = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, new DTOProxyNode()), Words.TARGET_CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.copyItems = new TitledItem<TextField>(new TextField(), Words.COPY, TitledItem.TitledItemOrientation.NORTH);
        this.copyItems.getElement().setMaxChar(Integer.MAX_VALUE);
        this.allVariants = new TitledItem<CheckBox>(new CheckBox(), Words.COPY_ALL_VARIANTS, TitledItem.TitledItemOrientation.EAST);
        this.infoButton = new InfoButton();
        this.infoButton.installStringViewer(this.getProductCopyInfoText());
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false);
        this.dueDate.getElement().setNode(n);
        this.getViewContainer().add(this.allVariants);
        this.getViewContainer().add(this.sourceCustomer);
        this.getViewContainer().add(this.targetCustomer);
        this.getViewContainer().add(this.copyItems);
        this.getViewContainer().add(this.infoButton);
        this.getViewContainer().add(this.dueDate);
    }

    private String getProductCopyInfoText() {
        String t = "Enter all Product Numbers you want to copy.<br/>";
        t = t + "Exp: 1-5,6,90 -> ";
        t = t + "copies Product 1,2,3,4,5,6,90";
        return t;
    }

    @Override
    protected String getProgressText() {
        return "Copy Products";
    }

    @Override
    public String getTitleString() {
        return "COPY PRODUCTS";
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentProduct.getChildNamed(new String[]{"currentVariant-name"}).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.sourceCustomer != null) {
            this.sourceCustomer.kill();
        }
        if (this.targetCustomer != null) {
            this.targetCustomer.kill();
        }
        if (this.copyItems != null) {
            this.copyItems.kill();
        }
        if (this.infoButton != null) {
            this.infoButton.kill();
        }
        if (this.dueDate != null) {
            this.dueDate.kill();
        }
        if (this.allVariants != null) {
            this.allVariants.kill();
        }
        this.allVariants = null;
        this.dueDate = null;
        this.sourceCustomer = null;
        this.targetCustomer = null;
        this.copyItems = null;
        this.infoButton = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.sourceCustomer.setVisible(true);
        this.targetCustomer.setVisible(true);
        this.copyItems.setVisible(true);
        this.infoButton.setVisible(true);
        this.dueDate.setVisible(true);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.sourceCustomer.setVisible(false);
        this.targetCustomer.setVisible(false);
        this.copyItems.setVisible(false);
        this.infoButton.setVisible(false);
        this.dueDate.setVisible(false);
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                CustomerLight sc = (CustomerLight)((SearchTextField2)CopyProductComponent.this.sourceCustomer.getElement()).getNode().getValue();
                CustomerLight tc = (CustomerLight)((SearchTextField2)CopyProductComponent.this.targetCustomer.getElement()).getNode().getValue();
                String text = ((TextField)CopyProductComponent.this.copyItems.getElement()).getText();
                HashSet<Integer> copyNumbers = new HashSet<Integer>();
                if (text != null && !text.isEmpty()) {
                    String[] s;
                    for (String ss : s = text.split(",")) {
                        try {
                            String[] sss = ss.split("-");
                            if (sss != null && sss.length > 1 && ss.contains("-")) {
                                int start = Integer.valueOf(sss[0]);
                                int end = Integer.valueOf(sss[1]);
                                for (int i = start; i <= end; ++i) {
                                    copyNumbers.add(i);
                                }
                                continue;
                            }
                            int i = Integer.valueOf(ss.trim());
                            copyNumbers.add(i);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                CopyTemplateToolkit.copyAllProducts(sc, tc, (Component)CopyProductComponent.this, ((DateChooser)CopyProductComponent.this.dueDate.getElement()).getSelectedDate(), ((CheckBox)CopyProductComponent.this.allVariants.getElement()).isChecked(), copyNumbers.toArray(new Integer[0]));
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return CopyProductComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<ProductComplete> getCurrentNode() {
        return this.currentProduct;
    }

    @Override
    public BatchJob<ProductComplete> createBatchJob(Node<ProductComplete> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = CopyProductComponent.this.layoutInheritedComponents(parent);
            if (CopyProductComponent.this.sourceCustomer != null) {
                CopyProductComponent.this.dueDate.setLocation(CopyProductComponent.this.border, y + CopyProductComponent.this.border);
                CopyProductComponent.this.dueDate.setSize(CopyProductComponent.this.dueDate.getPreferredSize());
                CopyProductComponent.this.allVariants.setLocation(CopyProductComponent.this.border, CopyProductComponent.this.dueDate.getY() + CopyProductComponent.this.dueDate.getHeight() + CopyProductComponent.this.border);
                CopyProductComponent.this.allVariants.setSize(parent.getWidth() - 2 * CopyProductComponent.this.border, (int)CopyProductComponent.this.allVariants.getPreferredSize().getHeight());
                CopyProductComponent.this.sourceCustomer.setLocation(CopyProductComponent.this.border, CopyProductComponent.this.allVariants.getY() + CopyProductComponent.this.allVariants.getHeight() + CopyProductComponent.this.border);
                CopyProductComponent.this.sourceCustomer.setSize(parent.getWidth() - 2 * CopyProductComponent.this.border, (int)CopyProductComponent.this.sourceCustomer.getPreferredSize().getHeight());
                CopyProductComponent.this.targetCustomer.setLocation(CopyProductComponent.this.border, CopyProductComponent.this.sourceCustomer.getY() + CopyProductComponent.this.sourceCustomer.getHeight() + CopyProductComponent.this.border);
                CopyProductComponent.this.targetCustomer.setSize(parent.getWidth() - 2 * CopyProductComponent.this.border, (int)CopyProductComponent.this.targetCustomer.getPreferredSize().getHeight());
                CopyProductComponent.this.copyItems.setLocation(CopyProductComponent.this.border, CopyProductComponent.this.targetCustomer.getY() + CopyProductComponent.this.targetCustomer.getHeight() + CopyProductComponent.this.border);
                CopyProductComponent.this.copyItems.setSize((int)((double)parent.getWidth() - ((double)(3 * CopyProductComponent.this.border) + CopyProductComponent.this.infoButton.getPreferredSize().getWidth())), (int)CopyProductComponent.this.copyItems.getPreferredSize().getHeight());
                CopyProductComponent.this.infoButton.setLocation(CopyProductComponent.this.copyItems.getX() + CopyProductComponent.this.copyItems.getWidth() + CopyProductComponent.this.border / 2, (int)((double)(CopyProductComponent.this.copyItems.getY() + CopyProductComponent.this.copyItems.getHeight()) - CopyProductComponent.this.infoButton.getPreferredSize().getHeight()) - 2);
                CopyProductComponent.this.infoButton.setSize(CopyProductComponent.this.infoButton.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = CopyProductComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += CopyProductComponent.this.border;
            if (CopyProductComponent.this.sourceCustomer != null) {
                h = (int)((double)h + CopyProductComponent.this.sourceCustomer.getPreferredSize().getHeight());
                h += CopyProductComponent.this.border;
                h = (int)((double)h + CopyProductComponent.this.allVariants.getPreferredSize().getHeight());
                h += CopyProductComponent.this.border;
                h = (int)((double)h + CopyProductComponent.this.targetCustomer.getPreferredSize().getHeight());
                h += CopyProductComponent.this.border;
                h = (int)((double)h + CopyProductComponent.this.copyItems.getPreferredSize().getHeight());
                h += CopyProductComponent.this.border;
                h = (int)((double)h + CopyProductComponent.this.dueDate.getPreferredSize().getHeight());
                h += CopyProductComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

