/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.product.stock;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.PriceConverter1;
import ch.icit.pegasus.client.converter.QuantityConverter1Decimal;
import ch.icit.pegasus.client.converter.QuantityConverter3Decimal;
import ch.icit.pegasus.client.converter.StorePositionShortNameConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.BackgroundFadeSkin;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.StoreTypeE;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PrintProductStockComponent
extends DefaultScrollablePrintPopupInsert
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private Node<ProductComplete> currentProduct;
    private Table2 table;
    private BackgroundFadeSkin fade;
    private TextLabel totalQuantity;
    private TextLabel totalQuantityHL;
    private HorizontalSeparator sep3;
    private boolean isLoadingRemains = false;
    private RowModel<ProductComplete> model;
    private boolean loadingStock = false;

    public PrintProductStockComponent(Node currentNode, RowModel<ProductComplete> model) {
        super(true, false);
        this.currentProduct = currentNode;
        this.model = model;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.model.getView().revalidate();
        this.model = null;
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    @Override
    public void errorOccurred(ClientException exception) {
        super.errorOccurred(exception);
        this.loadingStock = false;
        if (this.table != null) {
            this.table.hideLoadingAnimation();
        }
        this.removeAnimation(false);
        this.popup.enablePreviewButton();
        this.popup.enableOKButton(true);
        this.isLoadingRemains = false;
        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)this);
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
        this.createComponents();
        this.isLoadingRemains = true;
        this.popup.enableOKButton(false);
        this.popup.enableCancelButton(false);
        this.removeInheritedComponents();
        this.ensureAnimation(Words.LOAD_DATA);
        this.runStockAccess(new Timestamp(System.currentTimeMillis()));
    }

    private ThreadSafeExecutable getStockAccessor(Timestamp timestamp) {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductComplete prod = (ProductComplete)PrintProductStockComponent.this.currentProduct.getValue(ProductComplete.class);
                Map stock = ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).getProductStockPerStorePosition(new ProductReference(prod.getId())).getMap();
                ViewNode searchResults = new ViewNode("");
                if (stock != null) {
                    Iterator it = stock.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry nn = it.next();
                        if (((StorePositionLight)nn.getKey()).getStore().getStoreType() == StoreTypeE.IRREGULARITY) {
                            it.remove();
                            continue;
                        }
                        ViewNode nNode = new ViewNode("");
                        ViewNode storeN = new ViewNode("");
                        ViewNode quantNode = new ViewNode("");
                        storeN.setValue(nn.getKey(), 0L);
                        storeN.setName(DtoFieldConstants.STORE_POSITION);
                        quantNode.setValue(nn.getValue(), 0L);
                        quantNode.setName(DtoFieldConstants.QUANTITY);
                        nNode.addChild((Node)storeN, 0L);
                        nNode.addChild((Node)quantNode, 0L);
                        searchResults.addChild((Node)nNode, 0L);
                    }
                }
                searchResults.setValue((Object)stock, 0L);
                return searchResults;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintProductStockComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    public void remoteObjectLoaded(Node node) {
        this.loadingStock = false;
        if (this.isLoadingRemains) {
            this.removeAnimation(false);
            this.createComponents();
            this.createInners();
            this.table.getModel().setNode(node);
            this.popup.enableCancelButton(true);
        } else {
            if (this.table != null) {
                this.table.hideLoadingAnimation();
                this.table.getModel().setNode(node);
            }
            this.removeAnimation(false);
        }
        this.popup.enablePreviewButton();
        this.popup.enableOKButton(true);
        this.updateTotalStock((Map)node.getValue());
        this.isLoadingRemains = false;
    }

    private void updateTotalStock(Map<StorePositionLight, StoreQuantityComplete> stockMap) {
        if (stockMap == null) {
            return;
        }
        long totalAmountInStoreUnit = 0L;
        long totalAmountInStoreUnitHL = 0L;
        for (Map.Entry<StorePositionLight, StoreQuantityComplete> entry : stockMap.entrySet()) {
            if (Boolean.TRUE.equals(entry.getKey().getStore().getMainStore())) {
                totalAmountInStoreUnitHL += entry.getValue().getAmount().longValue();
            }
            totalAmountInStoreUnit += entry.getValue().getAmount().longValue();
        }
        UnitComplete pieceUnit = ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getPieceUnit();
        String t = "~ Main Store " + ((QuantityConverter1Decimal)ConverterRegistry.getConverter(QuantityConverter1Decimal.class)).convert((Object)new StoreQuantityComplete(Long.valueOf(totalAmountInStoreUnitHL), pieceUnit), null, new Object[0]);
        String t2 = "~ Total " + ((QuantityConverter1Decimal)ConverterRegistry.getConverter(QuantityConverter1Decimal.class)).convert((Object)new StoreQuantityComplete(Long.valueOf(totalAmountInStoreUnit), pieceUnit), null, new Object[0]);
        this.totalQuantity.setText(t2);
        this.totalQuantityHL.setText(t);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.table != null) {
            this.table.setVisible(false);
            this.totalQuantity.setVisible(false);
            this.totalQuantityHL.setVisible(false);
            this.sep3.setVisible(false);
        }
    }

    private void createInners() {
        this.fade = SkinRegistry.getSkin(BackgroundFadeSkin.class);
        this.box = new RadioButtonBox();
        this.box.setOrientation(0);
        this.sep3 = new HorizontalSeparator();
        this.getViewContainer().add(this.box);
        this.getViewContainer().add(this.sep3);
        this.table = new Table2(false, "", true, false);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.STORE, null, null, null, "", 30, 30, 30));
        int tw = QuantityRenderer.getPreferredSize(this);
        columns.add(new TableColumnInfo(Words.QUANTITY, null, null, null, "", tw += this.table.getCellPadding() * 2, tw, tw));
        columns.add(new TableColumnInfo(Words.VALUE + "*", null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.NEXT_EXPIRY, null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
        this.totalQuantity = new TextLabel();
        this.totalQuantity.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type")));
        this.totalQuantityHL = new TextLabel();
        this.totalQuantityHL.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type")));
        this.getViewContainer().setLayout(new Layout());
        this.popup.createFocusCycle();
        this.getViewContainer().add(this.table);
        this.getViewContainer().add(this.totalQuantity);
        this.getViewContainer().add(this.totalQuantityHL);
    }

    @Override
    public String getTitleString() {
        return Words.ARTICLE_NAME;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusComponents = super.getFocusComponents();
        return focusComponents;
    }

    @Override
    protected String getProgressText() {
        if (this.isLoadingRemains) {
            return Words.LOADING_ARTICLE_DATA;
        }
        return WordsToolkit.toCapitalLetter((String)Words.PRINT);
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentProduct.getChildNamed(new DtoField[]{ProductComplete_.currentVariant, ProductVariantLight_.name}).getValue();
    }

    @Override
    public boolean withSecondSeparator() {
        return true;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArrayList<ProductReference> products = new ArrayList<ProductReference>();
                products.add(new ProductReference(((ProductComplete)PrintProductStockComponent.this.currentProduct.getValue()).getId()));
                PegasusFileComplete file = (PegasusFileComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).printProductStockPerStorePosition(new ListWrapper(products)).getValue();
                PrintPopupToolkit.previewFile(file);
                PrintProductStockComponent.super.remoteObjectLoaded((Node)new ViewNode(""));
                return new ViewNode("");
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintProductStockComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    public void valueChanged(Node<?> node) {
        this.reloadAndShowStock((Timestamp)node.getValue());
    }

    private void reloadAndShowStock(Timestamp timeStamp) {
        this.loadingStock = true;
        this.runStockAccess(timeStamp);
    }

    private void runStockAccess(Timestamp timeStamp) {
        if (this.table != null) {
            this.table.showLoadingAnimation(Phrase.getPhrase((String)Phrase.LOAD_STOCK_FOR_DATE, (Object[])new Object[]{((DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class)).convert((Object)timeStamp, null, new Object[0])}));
        }
        ThreadSafeLoader.run(this.getStockAccessor(timeStamp));
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?>[] nodes) {
    }

    public boolean isSwingOnly() {
        return false;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements NodeListener {
        private static final long serialVersionUID = 1L;
        private TextLabel storeName;
        private QuantityRenderer quantity;
        private TextLabel price;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new Layout());
            this.storeName = new TextLabel(m.getNode().getChildNamed(DtoFieldConstants.STORE_POSITION), ConverterRegistry.getConverter(StorePositionShortNameConverter.class));
            StoreQuantityComplete old = (StoreQuantityComplete)m.getNode().getChildNamed(DtoFieldConstants.QUANTITY).getValue();
            this.quantity = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(DtoFieldConstants.QUANTITY));
            this.quantity.setViewConverter(ConverterRegistry.getConverter(QuantityConverter3Decimal.class));
            this.price = new TextLabel();
            this.calculatePrice();
            this.storeName.setProgress(1.0f);
            this.add(this.storeName);
            this.add(this.quantity);
            this.add(this.price);
        }

        private void calculatePrice() {
            StoreQuantityComplete q1 = (StoreQuantityComplete)this.model.getNode().getChildNamed(DtoFieldConstants.QUANTITY).getValue();
            ProductComplete prod = (ProductComplete)PrintProductStockComponent.this.currentProduct.getValue(ProductComplete.class);
            PriceComplete p = new PriceComplete(prod.getCurrentVariant().getSalesPrice());
            p.setPrice(Double.valueOf(p.getPrice() * (double)q1.getAmount().longValue()));
            String t = ((PriceConverter1)ConverterRegistry.getConverter(PriceConverter1.class)).convert(p, null, new Object[0]);
            this.price.setText(t);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.storeName.getText();
                }
                case 1: {
                    return this.quantity.getText();
                }
                case 2: {
                    return this.price.getText();
                }
            }
            return null;
        }

        public QuantityComplete getQuantity() {
            return (QuantityComplete)this.quantity.getNode().getValue();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.storeName.setEnabled(isEnabled);
            this.quantity.setEnabled(isEnabled);
            this.price.setEnabled(isEnabled);
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.storeName = null;
            this.quantity = null;
            this.price = null;
        }

        public void valueChanged(Node<?> node) {
            this.calculatePrice();
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return false;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.storeName.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.storeName.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.storeName.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.storeName.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.quantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.quantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.quantity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.quantity.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.price.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.price.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.price.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int cy = PrintProductStockComponent.this.layoutInheritedComponents(parent);
            cy += PrintProductStockComponent.this.border;
            if (PrintProductStockComponent.this.table != null) {
                int backHeight = (int)((double)PrintProductStockComponent.this.fade.getImage(11).getHeight() * 1.5);
                if (PrintProductStockComponent.this.box != null) {
                    PrintProductStockComponent.this.box.setLocation(PrintProductStockComponent.this.border, cy);
                    PrintProductStockComponent.this.box.setSize(parent.getWidth() - 2 * PrintProductStockComponent.this.border, (int)PrintProductStockComponent.this.box.getPreferredSize().getHeight());
                    cy = PrintProductStockComponent.this.box.getY() + PrintProductStockComponent.this.box.getHeight() + PrintProductStockComponent.this.border;
                }
                if (PrintProductStockComponent.this.sep3 != null) {
                    PrintProductStockComponent.this.sep3.setLocation(0, cy);
                    PrintProductStockComponent.this.sep3.setSize(parent.getWidth(), (int)PrintProductStockComponent.this.sep3.getPreferredSize().getHeight());
                    cy = PrintProductStockComponent.this.sep3.getY() + PrintProductStockComponent.this.sep3.getHeight() + PrintProductStockComponent.this.border;
                }
                PrintProductStockComponent.this.table.setLocation(PrintProductStockComponent.this.border, cy);
                PrintProductStockComponent.this.table.setSize(parent.getWidth() - 2 * PrintProductStockComponent.this.border, parent.getHeight() - (cy + PrintProductStockComponent.this.border + backHeight));
                int w = (parent.getWidth() - 2 * PrintProductStockComponent.this.border * 3) / 2;
                PrintProductStockComponent.this.totalQuantityHL.setLocation(PrintProductStockComponent.this.border, PrintProductStockComponent.this.table.getY() + PrintProductStockComponent.this.table.getHeight() + PrintProductStockComponent.this.border);
                PrintProductStockComponent.this.totalQuantityHL.setSize(w, (int)PrintProductStockComponent.this.totalQuantityHL.getPreferredSize().getHeight());
                PrintProductStockComponent.this.totalQuantity.setLocation(PrintProductStockComponent.this.border, PrintProductStockComponent.this.totalQuantityHL.getY() + PrintProductStockComponent.this.totalQuantityHL.getHeight());
                PrintProductStockComponent.this.totalQuantity.setSize(w, (int)PrintProductStockComponent.this.totalQuantity.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintProductStockComponent.this.getInheritedComponentsHeight() + PrintProductStockComponent.this.border;
            return new Dimension(0, h);
        }
    }
}

