/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.product.transaction;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;

public class PrintProductTransactionsComponent
extends DefaultScrollablePrintPopup2<ProductComplete> {
    private static final long serialVersionUID = 1L;
    private TitledPeriodEditor period;
    private Node<ProductComplete> productNode;

    public PrintProductTransactionsComponent(Node<ProductComplete> node) {
        super(false, false, false, true, false, ReportTypeE.STOCK_TRANSACTION);
        this.productNode = node;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            if (n.equals("startDate")) {
                try {
                    long l = Long.valueOf(v);
                    this.period.getStartDateChooser().getNode().setValue((Object)new Timestamp(l), 0L);
                }
                catch (Exception l) {}
                continue;
            }
            if (!n.equals("endDate")) continue;
            try {
                long l = Long.valueOf(v);
                this.period.getEndDateChooser().getNode().setValue((Object)new Timestamp(l), 0L);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("startDate", "" + this.period.getPeriod().getStartDate().getTime());
        conf.addProperty("endDate", "" + this.period.getPeriod().getEndDate().getTime());
        return conf;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.period);
        return focusList;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        PeriodComplete p = new PeriodComplete();
        p.setStartDate(new Date(System.currentTimeMillis()));
        p.setEndDate(new Date(System.currentTimeMillis()));
        Node periodNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false);
        this.period = new TitledPeriodEditor((Node<Date>)periodNode.getChildNamed(PeriodComplete_.startDate), (Node<Date>)periodNode.getChildNamed(PeriodComplete_.endDate), true, null);
        this.getViewContainer().add(this.period);
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.period.setEnabled(isEnabled);
        boolean b = isEnabled;
        if (this.asXLS != null) {
            b = b && ((RadioButton)this.asXLS.getElement()).isChecked();
        }
    }

    @Override
    public String getTitleString() {
        return Words.TRANSACTIONS;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public String getTitleValue() {
        return ((ProductComplete)this.productNode.getValue()).getNumber() + " - " + ((ProductComplete)this.productNode.getValue()).getCurrentVariant().getName();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.period != null) {
            this.period.kill();
        }
        this.period = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.period != null) {
            this.period.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.period != null) {
            this.period.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                PeriodComplete selectedPeriod = PrintProductTransactionsComponent.this.period.getPeriod();
                ProductComplete product = (ProductComplete)PrintProductTransactionsComponent.this.productNode.getValue();
                PegasusFileComplete t = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).createTransactionReport(new ListWrapper(Collections.singletonList(product)), selectedPeriod).getValue();
                PrintProductTransactionsComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintProductTransactionsComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<ProductComplete> getCurrentNode() {
        return this.productNode;
    }

    @Override
    public BatchJob<ProductComplete> createBatchJob(Node<ProductComplete> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintProductTransactionsComponent.this.layoutInheritedComponents(parent) + PrintProductTransactionsComponent.this.border;
            if (PrintProductTransactionsComponent.this.period != null) {
                PrintProductTransactionsComponent.this.period.setLocation(PrintProductTransactionsComponent.this.border, y + PrintProductTransactionsComponent.this.border / 2);
                PrintProductTransactionsComponent.this.period.setSize(parent.getWidth() - 2 * PrintProductTransactionsComponent.this.border, (int)PrintProductTransactionsComponent.this.period.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintProductTransactionsComponent.this.getInheritedComponentsHeight();
            int w = 250;
            if (PrintProductTransactionsComponent.this.period != null) {
                h = (int)((double)h + PrintProductTransactionsComponent.this.period.getPreferredSize().getHeight());
                h += PrintProductTransactionsComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

