/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.product.usage;

import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserListener;
import ch.icit.pegasus.client.gui.utils.icons.ToogleSkinIcon;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.SearchException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight_;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete_;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight_;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight_;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.HandlingCostVariantSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.MealPlanSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ProductCatalogSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StowingListTemplateVariantSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.TradeGoodsSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsLight;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsLight_;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class PrintProductUsageComponent
extends DefaultScrollablePrintPopupInsert
implements DateChooserListener {
    private static final long serialVersionUID = 1L;
    private final Node<ProductComplete> currentProduct;
    private TitledItem<Table2> table;
    private boolean isLoadingRemains = false;
    private TitledItem<DateChooser> dateChooser;

    public PrintProductUsageComponent(Node<ProductComplete> currentNode) {
        super(true, false);
        this.currentProduct = currentNode;
        this.getViewContainer().setLayout(new Layout());
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    private void loadItems() {
        this.createComponents();
        this.isLoadingRemains = true;
        this.popup.enableOKButton(false);
        this.popup.enableCancelButton(false);
        this.removeInheritedComponents();
        this.ensureAnimation(Words.LOAD_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node next;
                ProductComplete product = (ProductComplete)PrintProductUsageComponent.this.currentProduct.getValue();
                PeriodComplete searchPeriod = new PeriodComplete(product.getPeriod().getStartDate(), product.getPeriod().getEndDate());
                searchPeriod.setStartDate(new Date(PrintProductUsageComponent.this.dateChooser != null ? ((DateChooser)PrintProductUsageComponent.this.dateChooser.getElement()).getSelectedDate().getTime() : System.currentTimeMillis()));
                searchPeriod.setEndDate(new Date(searchPeriod.getStartDate().getTime()));
                HandlingCostVariantSearchConfiguration hs = new HandlingCostVariantSearchConfiguration();
                hs.setProduct(product);
                hs.setPeriod(searchPeriod);
                hs.setNumResults(Integer.MAX_VALUE);
                MealPlanSearchConfiguration ms = new MealPlanSearchConfiguration();
                ms.setProduct(product);
                ms.setPeriod(searchPeriod);
                ms.setSearchFillUp(Boolean.valueOf(false));
                ms.setNumResults(Integer.MAX_VALUE);
                MealPlanSearchConfiguration ms2 = new MealPlanSearchConfiguration();
                ms2.setProduct(product);
                ms2.setPeriod(searchPeriod);
                ms.setSearchFillUp(Boolean.valueOf(true));
                ms2.setNumResults(Integer.MAX_VALUE);
                StowingListTemplateVariantSearchConfiguration sts = new StowingListTemplateVariantSearchConfiguration();
                sts.setProduct(product);
                sts.setPeriod(searchPeriod);
                sts.setNumResults(Integer.MAX_VALUE);
                TradeGoodsSearchConfiguration ts = new TradeGoodsSearchConfiguration();
                ts.setProduct(product);
                ts.setPeriod(searchPeriod);
                ts.setNumResults(Integer.MAX_VALUE);
                ProductCatalogSearchConfiguration ps = new ProductCatalogSearchConfiguration();
                ps.setProduct(product);
                ps.setPeriod(searchPeriod);
                ps.setNumResults(Integer.MAX_VALUE);
                SearchResult r = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)hs);
                SearchResult r2 = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)ms);
                SearchResult r3 = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)sts);
                SearchResult r6 = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)ms2);
                Iterator itX = r3.getResults().iterator();
                while (itX.hasNext()) {
                    StowingListTemplateVariantLight stw = (StowingListTemplateVariantLight)itX.next();
                    if (stw.getValidityPeriod().within(searchPeriod.getStartDate()).booleanValue()) continue;
                    itX.remove();
                }
                SearchResult r4 = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)ts);
                SearchResult r5 = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)ps);
                ViewNode nn = new ViewNode("");
                HashSet mergedMealPlan = new HashSet(r2.getResults());
                mergedMealPlan.addAll(r6.getResults());
                Node p1 = INodeCreator.getDefaultImpl().createNodes(r.getResults(), false);
                Node p2 = INodeCreator.getDefaultImpl().createNodes(new ArrayList(mergedMealPlan), false);
                Node p3 = INodeCreator.getDefaultImpl().createNodes(r3.getResults(), false);
                Node p4 = INodeCreator.getDefaultImpl().createNodes(r4.getResults(), false);
                Node p5 = INodeCreator.getDefaultImpl().createNodes(r5.getResults(), false);
                Iterator it = p1.getChilds();
                while (it.hasNext()) {
                    next = (Node)it.next();
                    nn.addChild(next, 0L);
                }
                it = p2.getChilds();
                while (it.hasNext()) {
                    next = (Node)it.next();
                    nn.addChild(next, 0L);
                }
                it = p3.getChilds();
                while (it.hasNext()) {
                    next = (Node)it.next();
                    nn.addChild(next, 0L);
                }
                it = p4.getChilds();
                while (it.hasNext()) {
                    next = (Node)it.next();
                    nn.addChild(next, 0L);
                }
                it = p5.getChilds();
                while (it.hasNext()) {
                    next = (Node)it.next();
                    nn.addChild(next, 0L);
                }
                return nn;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintProductUsageComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        this.loadItems();
    }

    public void remoteObjectLoaded(Node node) {
        if (this.isLoadingRemains) {
            if (node.getValue() == null) {
                this.popup.enableCancelButton(true);
                if (this.errorMSG == null) {
                    this.removeAnimation(false);
                    if (this.table == null) {
                        this.createInners();
                    }
                    this.table.getElement().getModel().setNode(node);
                    this.createComponents();
                    this.dateChooser.setVisible(true);
                    this.table.setVisible(true);
                    this.popup.enableCancelButton(true);
                } else {
                    this.removeAnimation(true);
                }
            } else {
                ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
                for (SearchException e : (List)node.getValue()) {
                    rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, e.getMessage()));
                }
                this.isError = true;
                this.errorMSG = ScreenValidationObject.createMessageString(rets, (String)"Unable to load Product usage:");
                this.removeAnimation(true);
            }
            this.isLoadingRemains = false;
        } else {
            super.remoteObjectLoaded(node);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.table != null) {
            this.table.setVisible(false);
        }
        if (this.dateChooser != null) {
            this.dateChooser.setVisible(false);
        }
    }

    private void createInners() {
        this.table = new TitledItem<Table2>(new Table2(false, null, true, false), "PRODUCT IS USED IN (Period from TODAY)", TitledItem.TitledItemOrientation.NORTH);
        this.table.setIgnorePrefHeight(true);
        this.table.getElement().setRequestFocusOnAdd(true);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.TYPE, null, null, null, "", 90, 90, 90));
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth));
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 80, 80, 80));
        columns.add(new TableColumnInfo(Words.DELETED, null, null, null, "", DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.table.getElement().getCellPadding()));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        this.table.getElement().setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.setProgress(1.0f);
        this.dateChooser = new TitledItem<DateChooser>(new DateChooser(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false)), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dateChooser.getElement().setIsTimestamp(false);
        this.dateChooser.getElement().addDateChooserListener(this);
        this.getViewContainer().add(this.table);
        this.getViewContainer().add(this.dateChooser);
    }

    @Override
    public String getTitleString() {
        return Words.PRODUCT_NAME;
    }

    @Override
    protected String getProgressText() {
        if (this.isLoadingRemains) {
            return Words.LOAD_PRODUCT_USAGE;
        }
        return Words.PRINT_PRODUCT_USAGE;
    }

    @Override
    public void dateChanged(DateChooser source, java.util.Date selectedDate) {
        this.loadItems();
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentProduct.getChildNamed(new DtoField[]{ProductComplete_.currentVariant, ProductVariantLight_.name}).getValue();
    }

    @Override
    public boolean withSecondSeparator() {
        return true;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Date dueDate = (Date)((DateChooser)PrintProductUsageComponent.this.dateChooser.getElement()).getNode().getValue();
                PegasusFileComplete file = (PegasusFileComplete)((SupplyReportServiceManager)ServiceManagerRegistry.getService(SupplyReportServiceManager.class)).printProductUsage((ProductReference)PrintProductUsageComponent.this.currentProduct.getValue(), new DateWrapper(dueDate), ReportingOutputFormatE.XLSX).getValue();
                PrintPopupToolkit.previewFile(file);
                return new ViewNode("");
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintProductUsageComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel type;
        private TextLabel number;
        private TextLabel name;
        private ToogleSkinIcon skin;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            boolean deleted = false;
            this.type = new TextLabel();
            if (m.getNode().getValue() instanceof HandlingCostVariantComplete) {
                this.type.setText(Words.HANDLING);
                deleted = ((HandlingCostVariantComplete)m.getNode().getValue()).getBase() == null ? ((HandlingCostVariantComplete)m.getNode().getValue()).getBaseDeleted().booleanValue() : ((HandlingCostVariantComplete)m.getNode().getValue()).getBase().getIsDeleted().booleanValue();
            } else if (m.getNode().getValue() instanceof MealPlanLight) {
                this.type.setText(Words.MEAL_PLAN);
                deleted = ((MealPlanLight)m.getNode().getValue()).getIsDeleted();
            } else if (m.getNode().getValue() instanceof StowingListTemplateVariantLight) {
                this.type.setText(Words.STOWING);
                deleted = ((StowingListTemplateVariantLight)m.getNode().getValue()).getBase() == null ? ((StowingListTemplateVariantLight)m.getNode().getValue()).getBaseDeleted().booleanValue() : ((StowingListTemplateVariantLight)m.getNode().getValue()).getBase().getIsDeleted().booleanValue();
            } else if (m.getNode().getValue() instanceof ProductCatalogLight) {
                this.type.setText(Words.CATALOG);
                deleted = ((ProductCatalogLight)m.getNode().getValue()).getIsDeleted();
            } else if (m.getNode().getValue() instanceof TradeGoodsLight) {
                this.type.setText(Words.TRADE_GOODS);
                deleted = ((TradeGoodsLight)m.getNode().getValue()).getIsDeleted();
            }
            this.skin = new ToogleSkinIcon(DefaultSkins.CheckCrossBoxIcon, !deleted);
            if (m.getNode().getValue() instanceof HandlingCostVariantComplete) {
                this.name = new TextLabel(m.getNode().getChildNamed(HandlingCostVariantComplete_.name), ConverterRegistry.getConverter(StringConverter.class));
                this.number = ((HandlingCostVariantComplete)m.getNode().getValue()).getBase() == null ? new TextLabel(m.getNode().getChildNamed(HandlingCostVariantComplete_.baseNumber), ConverterRegistry.getConverter(IntegerConverter.class)) : new TextLabel(m.getNode().getChildNamed(new DtoField[]{HandlingCostVariantComplete_.base, HandlingCostComplete_.number}), ConverterRegistry.getConverter(IntegerConverter.class));
            } else if (m.getNode().getValue() instanceof StowingListTemplateVariantLight) {
                this.name = new TextLabel(m.getNode().getChildNamed(StowingListTemplateVariantLight_.name));
                this.number = ((StowingListTemplateVariantLight)m.getNode().getValue()).getBase() == null ? new TextLabel(m.getNode().getChildNamed(StowingListTemplateVariantLight_.baseNumber), ConverterRegistry.getConverter(IntegerConverter.class)) : new TextLabel(m.getNode().getChildNamed(new DtoField[]{StowingListTemplateVariantLight_.base, StowingListTemplateComplete_.number}), ConverterRegistry.getConverter(IntegerConverter.class));
            } else if (m.getNode().getValue() instanceof MealPlanLight) {
                this.name = new TextLabel(m.getNode().getChildNamed(MealPlanLight_.name), ConverterRegistry.getConverter(StringConverter.class));
                this.number = new TextLabel(m.getNode().getChildNamed(MealPlanLight_.number), ConverterRegistry.getConverter(IntegerConverter.class));
            } else if (m.getNode().getValue() instanceof ProductCatalogLight) {
                this.name = new TextLabel(m.getNode().getChildNamed(ProductCatalogLight_.title), ConverterRegistry.getConverter(StringConverter.class));
                this.number = new TextLabel(m.getNode().getChildNamed(ProductCatalogLight_.number), ConverterRegistry.getConverter(IntegerConverter.class));
            } else if (m.getNode().getValue() instanceof TradeGoodsLight) {
                this.name = new TextLabel(m.getNode().getChildNamed(TradeGoodsLight_.sellName), ConverterRegistry.getConverter(StringConverter.class));
                this.number = new TextLabel(m.getNode().getChildNamed(TradeGoodsLight_.number), ConverterRegistry.getConverter(IntegerConverter.class));
            }
            this.type.setProgress(1.0f);
            this.number.setProgress(1.0f);
            this.name.setProgress(1.0f);
            this.skin.setProgress(1.0f);
            this.setLayout(new Layout());
            this.add(this.type);
            this.add(this.number);
            this.add(this.name);
            this.add(this.skin);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.type.kill();
            this.number.kill();
            this.name.kill();
            this.skin.kill();
            this.type = null;
            this.number = null;
            this.name = null;
            this.skin = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.type.getText();
                }
                case 1: {
                    if (this.model.getNode().getValue() instanceof HandlingCostVariantComplete) {
                        return this.model.getNode().getChildNamed(new DtoField[]{HandlingCostVariantComplete_.base, HandlingCostComplete_.number});
                    }
                    if (this.model.getNode().getValue() instanceof StowingListTemplateVariantLight) {
                        return this.model.getNode().getChildNamed(new DtoField[]{StowingListTemplateVariantLight_.base, StowingListTemplateComplete_.number});
                    }
                    if (this.model.getNode().getValue() instanceof MealPlanLight) {
                        return this.model.getNode().getChildNamed(MealPlanLight_.number);
                    }
                    if (this.model.getNode().getValue() instanceof ProductCatalogLight) {
                        return this.model.getNode().getChildNamed(ProductCatalogLight_.number);
                    }
                    if (this.model.getNode().getValue() instanceof TradeGoodsLight) {
                        return this.model.getNode().getChildNamed(TradeGoodsLight_.number);
                    }
                }
                case 2: {
                    if (this.model.getNode().getValue() instanceof HandlingCostVariantComplete) {
                        return this.model.getNode().getChildNamed(HandlingCostVariantComplete_.name);
                    }
                    if (this.model.getNode().getValue() instanceof StowingListTemplateVariantLight) {
                        return this.model.getNode().getChildNamed(StowingListTemplateVariantLight_.name);
                    }
                    if (this.model.getNode().getValue() instanceof MealPlanLight) {
                        return this.model.getNode().getChildNamed(MealPlanLight_.name);
                    }
                    if (this.model.getNode().getValue() instanceof ProductCatalogLight) {
                        return this.model.getNode().getChildNamed(ProductCatalogLight_.title);
                    }
                    if (this.model.getNode().getValue() instanceof TradeGoodsLight) {
                        return this.model.getNode().getChildNamed(TradeGoodsLight_.sellName);
                    }
                }
                case 3: {
                    return null;
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.type.setEnabled(isEnabled);
            this.number.setEnabled(isEnabled);
            this.name.setEnabled(isEnabled);
            this.skin.setEnabled(isEnabled);
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.type.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.type.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.type.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.number.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.number.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.number.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.number.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.skin.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.skin.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.skin.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.skin.getPreferredSize().getHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int cy = PrintProductUsageComponent.this.layoutInheritedComponents(parent);
            cy += PrintProductUsageComponent.this.border;
            if (PrintProductUsageComponent.this.dateChooser != null) {
                PrintProductUsageComponent.this.dateChooser.setLocation(PrintProductUsageComponent.this.border, cy);
                PrintProductUsageComponent.this.dateChooser.setSize(PrintProductUsageComponent.this.dateChooser.getPreferredSize());
                cy = PrintProductUsageComponent.this.dateChooser.getY() + PrintProductUsageComponent.this.dateChooser.getHeight() + PrintProductUsageComponent.this.border;
            }
            if (PrintProductUsageComponent.this.table != null) {
                PrintProductUsageComponent.this.table.setLocation(PrintProductUsageComponent.this.border, cy);
                PrintProductUsageComponent.this.table.setSize(parent.getWidth() - 2 * PrintProductUsageComponent.this.border, parent.getHeight() - (cy + PrintProductUsageComponent.this.border));
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintProductUsageComponent.this.getInheritedComponentsHeight() + PrintProductUsageComponent.this.border;
            return new Dimension(0, h);
        }
    }
}

