/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.productcatalog.recipecards;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.RecipeReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationList;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientExceptionCollection;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.product.CatalogEntryComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight_;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogReference;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class PrintProductCatalogRecipeCardsComponent
extends DefaultScrollablePrintPopup2<ProductCatalogLight> {
    private static final long serialVersionUID = 1L;
    private final Node<ProductCatalogLight> currentProductCatalog;
    private Node<ProductCatalogComplete> completeProductCatalog;
    private TitledItem<DateChooser> dueDate;
    private TitledItem<CheckBox> printRecipesOny;
    private TitledItem<RadioButtonBox> sortBy;
    private TitledItem<RadioButton> byName;
    private TitledItem<RadioButton> byNumber;
    private TitledItem<RadioButton> bySequence;

    public PrintProductCatalogRecipeCardsComponent(Node<ProductCatalogLight> node) {
        super(false, false, ReportTypeE.RECIPECARD);
        this.currentProductCatalog = node;
        Runnable r = () -> {
            try {
                ProductCatalogComplete ret = (ProductCatalogComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductCatalog(new ProductCatalogReference(((ProductCatalogLight)this.currentProductCatalog.getValue(ProductCatalogLight.class)).getId())).getValue();
                this.completeProductCatalog = INodeCreator.getDefaultImpl().getNode4DTO((Object)ret, false, false);
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
        };
        this.loadBeforeShowing(r);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Node n = new Node();
        n.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(n), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.printRecipesOny = new TitledItem<CheckBox>(new CheckBox(), Words.RECIPES_ONLY, TitledItem.TitledItemOrientation.EAST);
        this.sortBy = new TitledItem<RadioButtonBox>(new RadioButtonBox(), "Sort by", TitledItem.TitledItemOrientation.NORTH);
        this.byName = new TitledItem<RadioButton>(new RadioButton(), "by Name", TitledItem.TitledItemOrientation.EAST);
        this.byNumber = new TitledItem<RadioButton>(new RadioButton(), "by Number", TitledItem.TitledItemOrientation.EAST);
        this.bySequence = new TitledItem<RadioButton>(new RadioButton(), "by Sequence", TitledItem.TitledItemOrientation.EAST);
        this.sortBy.getElement().addBox(this.byName, this.byName.getElement());
        this.sortBy.getElement().addBox(this.byNumber, this.byNumber.getElement());
        this.sortBy.getElement().addBox(this.bySequence, this.bySequence.getElement());
        this.bySequence.getElement().setChecked(true);
        this.getViewContainer().add(this.dueDate);
        this.getViewContainer().add(this.printRecipesOny);
        this.getViewContainer().add(this.sortBy);
        this.sortBy.getElement().setChecked(this.bySequence.getElement());
    }

    @Override
    public String getTitleString() {
        return Words.RECIPE_CARDS;
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentProductCatalog.getChildNamed(ProductCatalogLight_.title).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.printRecipesOny != null) {
            this.printRecipesOny.kill();
        }
        this.printRecipesOny = null;
        if (this.dueDate != null) {
            this.dueDate.kill();
        }
        if (this.sortBy != null) {
            this.sortBy.kill();
            this.byName.kill();
            this.byNumber.kill();
            this.bySequence.kill();
        }
        this.sortBy = null;
        this.byName = null;
        this.byNumber = null;
        this.bySequence = null;
        this.dueDate = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.dueDate.setVisible(true);
        this.printRecipesOny.setVisible(true);
        this.sortBy.setVisible(true);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.dueDate.setVisible(false);
        this.printRecipesOny.setVisible(false);
        this.sortBy.setVisible(false);
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ScreenValidationList errors = new ScreenValidationList();
                HashMap<ProductReference, ListWrapper> toPrint = new HashMap<ProductReference, ListWrapper>();
                PrintProductCatalogRecipeCardsComponent.this.ensureAnimation(Words.LOAD_PRODUCTS_AND_RECIPES);
                Date dd = (Date)((DateChooser)PrintProductCatalogRecipeCardsComponent.this.dueDate.getElement()).getNode().getValue();
                Timestamp validity = new Timestamp(dd.getTime());
                for (Object c : ((ProductCatalogComplete)PrintProductCatalogRecipeCardsComponent.this.completeProductCatalog.getValue(ProductCatalogComplete.class)).getGroups()) {
                    for (CatalogEntryComplete p : c.getEntries()) {
                        ListWrapper listWrapper = (ListWrapper)toPrint.get(p.getProduct());
                        ArrayList<RecipeReference> rec = null;
                        if (listWrapper != null) {
                            rec = listWrapper.getList();
                        }
                        if (rec == null) {
                            rec = new ArrayList<RecipeReference>();
                            toPrint.put(new ProductReference(p.getProduct().getId()), new ListWrapper(rec));
                        }
                        try {
                            Map recipes = ((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).getSubRecipes((ProductReference)p.getProduct(), new TimestampWrapper(validity)).getMap();
                            for (Long key : recipes.keySet()) {
                                rec.add(new RecipeReference(key));
                            }
                        }
                        catch (Exception e) {
                            errors.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.PRODUCT + " " + p.getProduct().getNumber()));
                        }
                    }
                }
                if (!errors.isEmpty()) {
                    throw new ClientExceptionCollection("Unable to print all Recipecards", errors);
                }
                PrintProductCatalogRecipeCardsComponent.this.ensureAnimation(Words.PRINT);
                if (((CheckBox)PrintProductCatalogRecipeCardsComponent.this.printRecipesOny.getElement()).isChecked()) {
                    HashSet allRecipes = new HashSet();
                    for (Map.Entry entry : toPrint.entrySet()) {
                        allRecipes.addAll(((ListWrapper)entry.getValue()).getList());
                    }
                    ArrayList recipes = new ArrayList();
                    recipes.addAll(allRecipes);
                    PegasusFileComplete pegasusFileComplete = (PegasusFileComplete)((RecipeReportServiceManager)ServiceManagerRegistry.getService(RecipeReportServiceManager.class)).getRecipeCards(new ListWrapper(recipes), new TimestampWrapper(validity)).getValue();
                    PrintProductCatalogRecipeCardsComponent.this.processFile(pegasusFileComplete);
                    Node b = new Node();
                    b.setValue((Object)true, 0L);
                    return b;
                }
                Boolean sortedBy = null;
                if (((RadioButton)PrintProductCatalogRecipeCardsComponent.this.byName.getElement()).isChecked()) {
                    sortedBy = true;
                } else if (((RadioButton)PrintProductCatalogRecipeCardsComponent.this.byNumber.getElement()).isChecked()) {
                    sortedBy = false;
                }
                PegasusFileComplete t = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).getProductRecipeCards(new MapWrapper(toPrint), new TimestampWrapper(validity), sortedBy).getValue();
                PrintProductCatalogRecipeCardsComponent.this.processFile(t);
                Node node = new Node();
                node.setValue((Object)true, 0L);
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintProductCatalogRecipeCardsComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<ProductCatalogLight> getCurrentNode() {
        return this.currentProductCatalog;
    }

    @Override
    public BatchJob<ProductCatalogLight> createBatchJob(Node<ProductCatalogLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public void errorOccurred(ClientException exception) {
        this.stopPrinting();
        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)this);
        this.popup.hidePopUp(new Object[0]);
        super.errorOccurred(exception);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintProductCatalogRecipeCardsComponent.this.layoutInheritedComponents(parent);
            if (PrintProductCatalogRecipeCardsComponent.this.dueDate != null) {
                PrintProductCatalogRecipeCardsComponent.this.dueDate.setLocation(PrintProductCatalogRecipeCardsComponent.this.border, y + PrintProductCatalogRecipeCardsComponent.this.border);
                PrintProductCatalogRecipeCardsComponent.this.dueDate.setSize(PrintProductCatalogRecipeCardsComponent.this.dueDate.getPreferredSize());
                y = PrintProductCatalogRecipeCardsComponent.this.dueDate.getY() + PrintProductCatalogRecipeCardsComponent.this.dueDate.getHeight();
            }
            if (PrintProductCatalogRecipeCardsComponent.this.printRecipesOny != null) {
                PrintProductCatalogRecipeCardsComponent.this.printRecipesOny.setLocation(PrintProductCatalogRecipeCardsComponent.this.border, y + PrintProductCatalogRecipeCardsComponent.this.border);
                PrintProductCatalogRecipeCardsComponent.this.printRecipesOny.setSize(PrintProductCatalogRecipeCardsComponent.this.printRecipesOny.getPreferredSize());
                y = PrintProductCatalogRecipeCardsComponent.this.printRecipesOny.getY() + PrintProductCatalogRecipeCardsComponent.this.printRecipesOny.getHeight();
            }
            if (PrintProductCatalogRecipeCardsComponent.this.sortBy != null) {
                PrintProductCatalogRecipeCardsComponent.this.sortBy.setLocation(PrintProductCatalogRecipeCardsComponent.this.border, y + PrintProductCatalogRecipeCardsComponent.this.border);
                PrintProductCatalogRecipeCardsComponent.this.sortBy.setSize(PrintProductCatalogRecipeCardsComponent.this.sortBy.getPreferredSize());
                y = PrintProductCatalogRecipeCardsComponent.this.sortBy.getY() + PrintProductCatalogRecipeCardsComponent.this.sortBy.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintProductCatalogRecipeCardsComponent.this.getInheritedComponentsHeight();
            int w = 250;
            return new Dimension(w, h);
        }
    }
}

