/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.purchase.articlelabels;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReceivingGroupComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReference;
import ch.icit.pegasus.server.core.dtos.report.PurchaseOrderLabelConfiguration;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.List;

public class PrintArticleLabelsComponent
extends DefaultScrollablePrintPopup2<PurchaseOrderLight> {
    private static final long serialVersionUID = 1L;
    private Node<PurchaseOrderLight> order;
    private TitledItem<TextField> startPosition;
    private TitledItem<CheckBox> includeBarCode;
    private TitledItem<CheckBox> printOnlyChargeLabels;
    private TitledItem<RadioButtonBox> checkinGroupSelection;

    public PrintArticleLabelsComponent(Node<PurchaseOrderLight> currentNode) {
        super(true, true, false, false, ReportTypeE.ARTICLE_STORE_INFO_SHEET);
        this.order = currentNode;
        this.loadBeforeShowing(() -> {
            PurchaseOrderLight orderLight = (PurchaseOrderLight)this.order.getValue();
            try {
                OptionalWrapper complete = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getPurchaseOrder(new PurchaseOrderReference(orderLight.getId()));
                this.order.removeExistingValues();
                this.order.setValue((Object)complete.getValue(), 0L);
                this.order.updateNode();
            }
            catch (ClientServerCallException e) {
                throw new IllegalStateException(e.getMessage());
            }
        });
    }

    @Override
    public boolean isReportAllowed(ReportFileComplete reportFile) {
        return reportFile.getDescription().contains("Label");
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public String getTitleString() {
        return Words.ORDER;
    }

    @Override
    public String getTitleValue() {
        return "" + this.order.getChildNamed(PurchaseOrderLight_.number).getValue();
    }

    @Override
    public void createComponents() {
        super.createComponents();
        this.getViewContainer().setLayout(new Layout());
        this.includeBarCode = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_BAR_CODE, TitledItem.TitledItemOrientation.EAST);
        this.includeBarCode.getElement().setChecked(true);
        this.startPosition = new TitledItem<TextField>(new TextField((Node)new DTONode(), TextFieldType.INT), Words.START_POSITION, TitledItem.TitledItemOrientation.NORTH);
        this.startPosition.getElement().setText("1");
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (!CompanyUtil.isFPB((SystemSettingsComplete)settings)) {
            this.printOnlyChargeLabels = new TitledItem<CheckBox>(new CheckBox(), "Print only Charge Labels", TitledItem.TitledItemOrientation.EAST);
            this.printOnlyChargeLabels.getElement().setChecked(true);
        }
        this.checkinGroupSelection = new TitledItem<RadioButtonBox>(new RadioButtonBox(), "Receiving Group", TitledItem.TitledItemOrientation.NORTH);
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        PurchaseOrderComplete purchase = (PurchaseOrderComplete)this.order.getValue(PurchaseOrderComplete.class);
        for (PurchaseOrderReceivingGroupComplete group : purchase.getCheckinGroups()) {
            RadioButton b = new RadioButton();
            b.setUserObject(group);
            TitledItem<RadioButton> rtitle = new TitledItem<RadioButton>(b, "Group " + df.format(group.getCreationDate()), TitledItem.TitledItemOrientation.EAST);
            this.checkinGroupSelection.getElement().addBox(rtitle, b);
        }
        if (!this.checkinGroupSelection.getElement().getButtons().isEmpty()) {
            this.checkinGroupSelection.getElement().getButtons().get(0).setChecked(true);
        } else {
            RadioButton b = new RadioButton();
            TitledItem<RadioButton> rtitle = new TitledItem<RadioButton>(b, "No receivings", TitledItem.TitledItemOrientation.EAST);
            this.checkinGroupSelection.getElement().addBox(rtitle, b);
        }
        this.getViewContainer().add(this.includeBarCode);
        this.getViewContainer().add(this.startPosition);
        if (this.printOnlyChargeLabels != null) {
            this.getViewContainer().add(this.printOnlyChargeLabels);
        }
        this.getViewContainer().add(this.checkinGroupSelection);
        this.validate();
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.startPosition);
        CheckedListAdder.addToList(focusList, this.includeBarCode);
        CheckedListAdder.addToList(focusList, this.printOnlyChargeLabels);
        CheckedListAdder.addToList(focusList, this.checkinGroupSelection);
        return focusList;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.startPosition != null) {
            this.startPosition.kill();
        }
        this.startPosition = null;
        if (this.includeBarCode != null) {
            this.includeBarCode.kill();
        }
        this.includeBarCode = null;
        if (this.printOnlyChargeLabels != null) {
            this.printOnlyChargeLabels.kill();
        }
        this.printOnlyChargeLabels = null;
        if (this.checkinGroupSelection != null) {
            this.checkinGroupSelection.kill();
        }
        this.checkinGroupSelection = null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete selectedReport = PrintArticleLabelsComponent.this.getSelectedReport();
                int startPosition = 1;
                try {
                    startPosition = Integer.valueOf(((TextField)PrintArticleLabelsComponent.this.startPosition.getElement()).getText());
                }
                catch (NumberFormatException e) {
                    startPosition = 1;
                }
                boolean inclBarCode = ((CheckBox)PrintArticleLabelsComponent.this.includeBarCode.getElement()).isChecked();
                PurchaseOrderLabelConfiguration conf = new PurchaseOrderLabelConfiguration();
                conf.setOrderReference(new PurchaseOrderReference(((PurchaseOrderLight)PrintArticleLabelsComponent.this.order.getValue()).getId()));
                conf.setStyleSheet(selectedReport);
                conf.setIncludeBarCode(Boolean.valueOf(inclBarCode));
                conf.setStartPosition(Integer.valueOf(startPosition));
                conf.setReceivingGroup(((RadioButtonBox)PrintArticleLabelsComponent.this.checkinGroupSelection.getElement()).getSelectedButton() != null ? (PurchaseOrderReceivingGroupComplete)((RadioButtonBox)PrintArticleLabelsComponent.this.checkinGroupSelection.getElement()).getSelectedButton().getUserObject() : null);
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                if (CompanyUtil.isFPB((SystemSettingsComplete)settings)) {
                    conf.setOnlyChargeLabels(Boolean.valueOf(false));
                } else {
                    conf.setOnlyChargeLabels(Boolean.valueOf(((CheckBox)PrintArticleLabelsComponent.this.printOnlyChargeLabels.getElement()).isChecked()));
                }
                PegasusFileComplete t = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createArticleLabelsForPurchase(conf).getValue();
                PrintArticleLabelsComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintArticleLabelsComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<PurchaseOrderLight> getCurrentNode() {
        return this.order;
    }

    @Override
    public BatchJob<PurchaseOrderLight> createBatchJob(Node<PurchaseOrderLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public void insertElements() {
        this.createComponents();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintArticleLabelsComponent.this.layoutInheritedComponents(parent);
            PrintArticleLabelsComponent.this.includeBarCode.setLocation(PrintArticleLabelsComponent.this.border, PrintArticleLabelsComponent.this.border + y);
            PrintArticleLabelsComponent.this.includeBarCode.setSize(parent.getWidth() - 2 * PrintArticleLabelsComponent.this.border, (int)PrintArticleLabelsComponent.this.includeBarCode.getPreferredSize().getHeight());
            PrintArticleLabelsComponent.this.startPosition.setLocation(PrintArticleLabelsComponent.this.border, PrintArticleLabelsComponent.this.includeBarCode.getY() + PrintArticleLabelsComponent.this.includeBarCode.getHeight() + PrintArticleLabelsComponent.this.border);
            PrintArticleLabelsComponent.this.startPosition.setSize(parent.getWidth() - 2 * PrintArticleLabelsComponent.this.border, (int)PrintArticleLabelsComponent.this.startPosition.getPreferredSize().getHeight());
            int currentY = PrintArticleLabelsComponent.this.startPosition.getY() + PrintArticleLabelsComponent.this.startPosition.getHeight() + PrintArticleLabelsComponent.this.border;
            if (PrintArticleLabelsComponent.this.printOnlyChargeLabels != null) {
                PrintArticleLabelsComponent.this.printOnlyChargeLabels.setLocation(PrintArticleLabelsComponent.this.border, currentY);
                PrintArticleLabelsComponent.this.printOnlyChargeLabels.setSize(parent.getWidth() - 2 * PrintArticleLabelsComponent.this.border, (int)PrintArticleLabelsComponent.this.printOnlyChargeLabels.getPreferredSize().getHeight());
                currentY = PrintArticleLabelsComponent.this.printOnlyChargeLabels.getY() + PrintArticleLabelsComponent.this.printOnlyChargeLabels.getHeight() + PrintArticleLabelsComponent.this.border;
            }
            PrintArticleLabelsComponent.this.checkinGroupSelection.setLocation(PrintArticleLabelsComponent.this.border, currentY);
            PrintArticleLabelsComponent.this.checkinGroupSelection.setSize(parent.getWidth() - 2 * PrintArticleLabelsComponent.this.border, (int)PrintArticleLabelsComponent.this.checkinGroupSelection.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (PrintArticleLabelsComponent.this.animation != null) {
                return PrintArticleLabelsComponent.this.animation.getPreferredSize();
            }
            int h = PrintArticleLabelsComponent.this.getInheritedComponentsHeight();
            return new Dimension(100, h);
        }
    }
}

