/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.purchase.order;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderOutputTypeE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReference;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderSendHistoryComplete;
import ch.icit.pegasus.server.core.dtos.report.PurchaseOrderReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.List;

public class PrintPurchaseOrderComponent
extends DefaultScrollablePrintPopup2<PurchaseOrderLight> {
    private static final long serialVersionUID = 1L;
    private TextLabel optionsTitle;
    private TitledItem<ComboBox> filterBonded;
    private TitledItem<CheckBox> includeCosts;
    private Node<PurchaseOrderLight> currentNode;

    public PrintPurchaseOrderComponent(Node<PurchaseOrderLight> currentNode) {
        super(true, true, false, true, ReportTypeE.PURCHASE_ORDER);
        this.currentNode = currentNode;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            if (!n.equals("costs") || this.includeCosts == null) continue;
            this.includeCosts.getElement().setChecked(b);
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        if (this.includeCosts != null) {
            conf.addProperty("costs", "" + this.includeCosts.getElement().isChecked());
        }
        return conf;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public String getTitleString() {
        return Words.ORDER_NO;
    }

    @Override
    public String getTitleValue() {
        if (this.currentNode == null || this.currentNode.getChildNamed(PurchaseOrderLight_.number) == null || this.currentNode.getChildNamed(PurchaseOrderLight_.number).getValue() == null) {
            return "";
        }
        return "" + this.currentNode.getChildNamed(PurchaseOrderLight_.number).getValue();
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.optionsTitle != null) {
            this.optionsTitle.setVisible(true);
        }
        if (this.includeCosts != null) {
            this.includeCosts.setVisible(true);
        }
        if (this.filterBonded != null) {
            this.filterBonded.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.optionsTitle != null) {
            this.optionsTitle.setVisible(false);
        }
        if (this.includeCosts != null) {
            this.includeCosts.setVisible(false);
        }
        if (this.filterBonded != null) {
            this.filterBonded.setVisible(false);
        }
    }

    @Override
    public void createComponents() {
        super.createComponents();
        this.getViewContainer().setLayout(new Layout());
        boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        if (!isNoPro) {
            this.optionsTitle = new TextLabel(Words.OPTIONS);
            this.optionsTitle.setFont(this.title.getTitle().getDefaultFont());
            this.optionsTitle.setForeground(this.title.getTitle().getComponentForeground());
            this.includeCosts = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COSTS, TitledItem.TitledItemOrientation.EAST);
            this.includeCosts.getElement().setChecked(false);
            this.includeCosts.setFont(((TextLabel)this.title.getElement()).getFont());
            this.includeCosts.setForeground(((TextLabel)this.title.getElement()).getForeground());
            this.filterBonded = new TitledItem<ComboBox>(new ComboBox(), Words.BONDED_STATE, TitledItem.TitledItemOrientation.NORTH);
            this.filterBonded.getElement().addItem(BondedStateE.ALL);
            this.filterBonded.getElement().addItem(BondedStateE.NOT_BONDED);
            this.filterBonded.getElement().addItem(BondedStateE.ONLY_BONDED);
            this.filterBonded.getElement().selectItem(BondedStateE.ALL);
            this.getViewContainer().add(this.filterBonded);
            this.getViewContainer().add(this.optionsTitle);
            this.getViewContainer().add(this.includeCosts);
        }
        this.validate();
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = super.getFocusComponents();
        if (this.includeCosts != null) {
            a.addAll(this.includeCosts.getFocusComponents());
        }
        return a;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.optionsTitle != null) {
            this.optionsTitle.kill();
        }
        if (this.includeCosts != null) {
            this.includeCosts.kill();
        }
        if (this.filterBonded != null) {
            this.filterBonded.kill();
        }
        this.optionsTitle = null;
        this.includeCosts = null;
        this.filterBonded = null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                PurchaseOrderLight order = (PurchaseOrderLight)PrintPurchaseOrderComponent.this.currentNode.getValue(PurchaseOrderLight.class);
                PurchaseOrderReportConfiguration config = new PurchaseOrderReportConfiguration();
                config.setDto((IDTO)new PurchaseOrderReference(order.getId()));
                config.setStylesheet(PrintPurchaseOrderComponent.this.getSelectedReport());
                config.setFormat(((RadioButton)PrintPurchaseOrderComponent.this.asPDF.getElement()).isChecked() ? ReportingOutputFormatE.PDF : ReportingOutputFormatE.XLSX);
                boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
                if (!isNoPro) {
                    config.setIncludeDayPrice(Boolean.valueOf(((CheckBox)PrintPurchaseOrderComponent.this.includeCosts.getElement()).isChecked()));
                    switch ((BondedStateE)((ComboBox)PrintPurchaseOrderComponent.this.filterBonded.getElement()).getSelectedItem()) {
                        case ALL: {
                            config.setBonded(null);
                            break;
                        }
                        case ONLY_BONDED: {
                            config.setBonded(Boolean.valueOf(true));
                            break;
                        }
                        case NOT_BONDED: {
                            config.setBonded(Boolean.valueOf(false));
                            break;
                        }
                        default: {
                            config.setBonded(null);
                            break;
                        }
                    }
                } else {
                    config.setBonded(null);
                    config.setIncludeDayPrice(Boolean.valueOf(false));
                }
                PegasusFileComplete t = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createPurchaseOrderSheet(config).getValue();
                PurchaseOrderSendHistoryComplete h = new PurchaseOrderSendHistoryComplete();
                h.setPrint(Boolean.valueOf(true));
                h.setSendDate(new Timestamp(System.currentTimeMillis()));
                h.setSentUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                h.setTarget("Printer");
                h.setPurchaseOrderOutputType(PurchaseOrderOutputTypeE.PRINTER);
                PurchaseOrderComplete oc = (PurchaseOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getPurchaseOrder(new PurchaseOrderReference(order.getId())).getValue();
                oc.getSendHistory().add(h);
                ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).updatePurchaseOrder(oc);
                PrintPurchaseOrderComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintPurchaseOrderComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<PurchaseOrderLight> getCurrentNode() {
        return this.currentNode;
    }

    @Override
    public BatchJob<PurchaseOrderLight> createBatchJob(Node<PurchaseOrderLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public void insertElements() {
        this.createComponents();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintPurchaseOrderComponent.this.layoutInheritedComponents(parent);
            if (PrintPurchaseOrderComponent.this.optionsTitle != null) {
                PrintPurchaseOrderComponent.this.optionsTitle.setLocation(PrintPurchaseOrderComponent.this.border, y + PrintPurchaseOrderComponent.this.border);
                PrintPurchaseOrderComponent.this.optionsTitle.setSize(PrintPurchaseOrderComponent.this.optionsTitle.getPreferredSize());
                PrintPurchaseOrderComponent.this.includeCosts.setLocation(PrintPurchaseOrderComponent.this.border, PrintPurchaseOrderComponent.this.optionsTitle.getY() + PrintPurchaseOrderComponent.this.optionsTitle.getHeight() + PrintPurchaseOrderComponent.this.border / 2);
                PrintPurchaseOrderComponent.this.includeCosts.setSize(PrintPurchaseOrderComponent.this.includeCosts.getPreferredSize());
                PrintPurchaseOrderComponent.this.filterBonded.setLocation(PrintPurchaseOrderComponent.this.border, PrintPurchaseOrderComponent.this.includeCosts.getY() + PrintPurchaseOrderComponent.this.includeCosts.getHeight() + PrintPurchaseOrderComponent.this.border / 2);
                PrintPurchaseOrderComponent.this.filterBonded.setSize(parent.getWidth() - 2 * PrintPurchaseOrderComponent.this.border, ((PrintPurchaseOrderComponent)PrintPurchaseOrderComponent.this).filterBonded.getPreferredSize().height);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (PrintPurchaseOrderComponent.this.animation != null) {
                return PrintPurchaseOrderComponent.this.animation.getPreferredSize();
            }
            int h = PrintPurchaseOrderComponent.this.getInheritedComponentsHeight();
            h += PrintPurchaseOrderComponent.this.border;
            boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
            if (!isNoPro) {
                h = (int)((double)h + PrintPurchaseOrderComponent.this.optionsTitle.getPreferredSize().getHeight());
                h += PrintPurchaseOrderComponent.this.border / 2;
                h = (int)((double)h + PrintPurchaseOrderComponent.this.includeCosts.getPreferredSize().getHeight());
                h += PrintPurchaseOrderComponent.this.border / 2;
                h = (int)((double)h + PrintPurchaseOrderComponent.this.filterBonded.getPreferredSize().getHeight());
                h += PrintPurchaseOrderComponent.this.border;
            }
            return new Dimension(100, h);
        }
    }
}

