/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.purchase.receive;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReference;
import ch.icit.pegasus.server.core.dtos.report.PurchaseOrderReceivingReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;

public class PrintReceiveOrderComponent2
extends DefaultScrollablePrintPopup2<PurchaseOrderLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> signed;
    private TitledItem<CheckBox> includeDayPrice;
    private TitledItem<ComboBox> filterBonded;
    private Node<PurchaseOrderLight> currentOrder;

    public PrintReceiveOrderComponent2(Node<PurchaseOrderLight> template) {
        super(false, false, ReportTypeE.PURCHASE_ORDER_RECEIVED);
        this.currentOrder = template;
    }

    @Override
    public void insertElements() {
        this.createComponents();
        this.signed = new TitledItem<CheckBox>(new CheckBox(), Words.SIGNED, TitledItem.TitledItemOrientation.EAST);
        this.signed.getElement().setChecked(true);
        this.includeDayPrice = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_DAY_PRICE, TitledItem.TitledItemOrientation.EAST);
        this.includeDayPrice.getElement().setChecked(true);
        this.filterBonded = new TitledItem<ComboBox>(new ComboBox(), Words.BONDED_STATE, TitledItem.TitledItemOrientation.NORTH);
        this.filterBonded.getElement().addItem(BondedStateE.ALL);
        this.filterBonded.getElement().addItem(BondedStateE.NOT_BONDED);
        this.filterBonded.getElement().addItem(BondedStateE.ONLY_BONDED);
        this.filterBonded.getElement().selectItem(BondedStateE.ALL);
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.signed);
        this.getViewContainer().add(this.includeDayPrice);
        this.getViewContainer().add(this.filterBonded);
        try {
            SystemSettingsComplete settings = (SystemSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached().getValue();
            Integer defaultPurchaseOrderReceiveSheetPrintCount = settings.getDefaultPurchaseOrderReceiveSheetPrintCount();
            this.setNumberOfCopies(defaultPurchaseOrderReceiveSheetPrintCount);
        }
        catch (ClientServerCallException clientServerCallException) {
            // empty catch block
        }
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            if (n.equals("sign")) {
                this.signed.getElement().setChecked(b);
                continue;
            }
            if (!n.equals("price")) continue;
            this.includeDayPrice.getElement().setChecked(b);
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("sign", "" + this.signed.getElement().isChecked());
        conf.addProperty("price", "" + this.includeDayPrice.getElement().isChecked());
        return conf;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.signed.setVisible(true);
        this.includeDayPrice.setVisible(true);
        this.filterBonded.setVisible(true);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.signed.setVisible(false);
        this.includeDayPrice.setVisible(false);
        this.filterBonded.setVisible(false);
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                PurchaseOrderReceivingReportConfiguration config = new PurchaseOrderReceivingReportConfiguration();
                config.setStylesheet(PrintReceiveOrderComponent2.this.getSelectedReport());
                config.setDto((IDTO)new PurchaseOrderReference(((PurchaseOrderLight)PrintReceiveOrderComponent2.this.currentOrder.getValue()).getId()));
                config.setFormat(ReportingOutputFormatE.PDF);
                config.setIncludeDayPrice(Boolean.valueOf(((CheckBox)PrintReceiveOrderComponent2.this.includeDayPrice.getElement()).isChecked()));
                config.setSigned(Boolean.valueOf(((CheckBox)PrintReceiveOrderComponent2.this.signed.getElement()).isChecked()));
                config.setPreview(Boolean.valueOf(PrintReceiveOrderComponent2.this.popup.isPreview()));
                config.setCopies(Integer.valueOf(PrintReceiveOrderComponent2.this.getCopies()));
                switch ((BondedStateE)((ComboBox)PrintReceiveOrderComponent2.this.filterBonded.getElement()).getSelectedItem()) {
                    case ALL: {
                        config.setBonded(null);
                        break;
                    }
                    case ONLY_BONDED: {
                        config.setBonded(Boolean.valueOf(true));
                        break;
                    }
                    case NOT_BONDED: {
                        config.setBonded(Boolean.valueOf(false));
                        break;
                    }
                    default: {
                        config.setBonded(null);
                    }
                }
                OptionalWrapper t = ((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createPurchaseOrderReceivingWorksheet(config);
                if (t.getValue() != null) {
                    PrintReceiveOrderComponent2.this.processFile((PegasusFileComplete)t.getValue());
                }
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintReceiveOrderComponent2.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<PurchaseOrderLight> getCurrentNode() {
        return this.currentOrder;
    }

    @Override
    public BatchJob<PurchaseOrderLight> createBatchJob(Node<PurchaseOrderLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public String getTitleString() {
        return Words.PURCHASE_ORDER;
    }

    @Override
    public String getTitleValue() {
        return "" + ((PurchaseOrderLight)this.currentOrder.getValue()).getNumber();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int y = PrintReceiveOrderComponent2.this.getInheritedComponentsHeight();
            y += PrintReceiveOrderComponent2.this.border;
            y = (int)((double)y + PrintReceiveOrderComponent2.this.signed.getPreferredSize().getHeight());
            y += PrintReceiveOrderComponent2.this.border / 2;
            y = (int)((double)y + PrintReceiveOrderComponent2.this.includeDayPrice.getPreferredSize().getHeight());
            y += PrintReceiveOrderComponent2.this.border;
            y = (int)((double)y + PrintReceiveOrderComponent2.this.filterBonded.getPreferredSize().getHeight());
            return new Dimension(0, y += PrintReceiveOrderComponent2.this.border);
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintReceiveOrderComponent2.this.layoutInheritedComponents(parent);
            PrintReceiveOrderComponent2.this.signed.setLocation(PrintReceiveOrderComponent2.this.border, y += PrintReceiveOrderComponent2.this.border);
            PrintReceiveOrderComponent2.this.signed.setSize(parent.getWidth() - 2 * PrintReceiveOrderComponent2.this.border, (int)PrintReceiveOrderComponent2.this.signed.getPreferredSize().getHeight());
            PrintReceiveOrderComponent2.this.includeDayPrice.setLocation(PrintReceiveOrderComponent2.this.border, PrintReceiveOrderComponent2.this.signed.getY() + PrintReceiveOrderComponent2.this.signed.getHeight() + PrintReceiveOrderComponent2.this.border / 2);
            PrintReceiveOrderComponent2.this.includeDayPrice.setSize(parent.getWidth() - 2 * PrintReceiveOrderComponent2.this.border, (int)PrintReceiveOrderComponent2.this.includeDayPrice.getPreferredSize().getHeight());
            PrintReceiveOrderComponent2.this.filterBonded.setLocation(PrintReceiveOrderComponent2.this.border, PrintReceiveOrderComponent2.this.includeDayPrice.getY() + PrintReceiveOrderComponent2.this.includeDayPrice.getHeight() + PrintReceiveOrderComponent2.this.border / 2);
            PrintReceiveOrderComponent2.this.filterBonded.setSize(parent.getWidth() - 2 * PrintReceiveOrderComponent2.this.border, ((PrintReceiveOrderComponent2)PrintReceiveOrderComponent2.this).filterBonded.getPreferredSize().height);
        }
    }
}

