/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.requisition.deliverworksheet;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.StoreViewConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderReference;
import ch.icit.pegasus.server.core.dtos.report.RequisitionOrderReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.RequisitionOrderReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionTypeE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PrintDeliverWorksheetComponent
extends DefaultScrollablePrintPopup2<RequisitionOrderLight> {
    private static final long serialVersionUID = 1L;
    private Node<RequisitionOrderLight> requisitionOrder;
    private RequisitionOrderComplete completeOrder;
    private Node allDepartments;
    private Node<RequisitionOrderReportConfiguration> configNode;
    private TitledItem<CheckBox> sign;
    private TitledItem<ComboBox> department;
    private TitledItem<ComboBox> store;
    private RowModel<RequisitionOrderLight> rowModel;
    private List<BasicArticleComplete> articles = new ArrayList<BasicArticleComplete>();

    public PrintDeliverWorksheetComponent(Node<RequisitionOrderLight> node, RowModel<RequisitionOrderLight> rowModel) {
        super(false, false, ReportTypeE.REQUISITION_ORDER_DELIVER);
        this.requisitionOrder = node;
        this.rowModel = rowModel;
        RequisitionOrderReportConfiguration config = new RequisitionOrderReportConfiguration();
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
        this.loadBeforeShowing(() -> this.loadRequisitionData());
    }

    private void loadRequisitionData() {
        try {
            RequisitionOrderComplete requisition;
            HashSet<CostCenterComplete> usedCostCenters = new HashSet<CostCenterComplete>();
            ViewNode retNode = new ViewNode("");
            this.completeOrder = requisition = (RequisitionOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getRequisitionOrderByReference(new RequisitionOrderReference(((RequisitionOrderLight)this.requisitionOrder.getValue()).getId())).getValue();
            for (RequisitionOrderPositionComplete o : requisition.getOrderPositions()) {
                BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(o.getArticle().getId())).getValue();
                this.articles.add(artC);
                if (artC.getDefaultRequisitionDeliverDepartment() == null) continue;
                usedCostCenters.add(artC.getDefaultRequisitionDeliverDepartment());
            }
            for (CostCenterComplete cc : usedCostCenters) {
                Node nc = INodeCreator.getDefaultImpl().getNode4DTO((Object)cc, false, true);
                retNode.addChild(nc, 0L);
            }
            this.allDepartments = retNode;
        }
        catch (ClientServerCallException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.sign = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(RequisitionOrderReportConfiguration_.signed)), Words.SIGNED, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.sign);
        this.department = new TitledItem<ComboBox>(new ComboBox(this.configNode.getChildNamed(RequisitionOrderReportConfiguration_.deliverDepartment), null, ConverterRegistry.getConverter(CostCenterConverter.class), false, true), Words.DELIVERED_BY_DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        this.store = new TitledItem<ComboBox>(new ComboBox(this.configNode.getChildNamed(RequisitionOrderReportConfiguration_.deliverStore), null, ConverterRegistry.getConverter(StoreViewConverter.class), false, true), Words.DELIVER_STORE, TitledItem.TitledItemOrientation.NORTH);
        this.department.getElement().addItemListener(this);
        this.department.getElement().refreshPossibleValues(this.allDepartments);
        this.department.getElement().addItem(Words.ALL);
        this.department.getElement().setSelectedItem(Words.ALL);
        this.getViewContainer().add(this.department);
        this.getViewContainer().add(this.store);
        this.createComponents();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        if (this.department != null && e.getSource() == this.department.getElement() && e.getStateChange() == 1) {
            Node stores;
            if (e.getItem() instanceof Node) {
                Node dep = (Node)e.getItem();
                stores = this.createStoreList((CostCenterComplete)dep.getValue());
            } else {
                stores = this.createStoreList(null);
            }
            this.store.getElement().refreshPossibleValues(stores);
            this.store.getElement().addItem(Words.ALL);
            this.store.getElement().setSelectedItem(Words.ALL);
        }
    }

    public Node createStoreList(CostCenterComplete selectedCostCenter) {
        HashSet<StoreLight> usedStores = new HashSet<StoreLight>();
        ViewNode retNode = new ViewNode("");
        for (BasicArticleComplete bac : this.articles) {
            if (selectedCostCenter != null && !selectedCostCenter.equals((Object)bac.getDefaultRequisitionDeliverDepartment())) continue;
            for (StoreConditionComplete sc : bac.getStoreConditions()) {
                if (sc.getType() != StoreConditionTypeE.REQUISITION_DELIVER || sc.getPosition() == null || sc.getPosition().getStore() == null) continue;
                usedStores.add(sc.getPosition().getStore());
            }
        }
        for (StoreLight cc : usedStores) {
            Node nc = INodeCreator.getDefaultImpl().getNode4DTO((Object)cc, false, true);
            retNode.addChild(nc, 0L);
        }
        return retNode;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            if (!n.equals("signed")) continue;
            this.sign.getElement().setChecked(b);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.sign.setEnabled(isEnabled);
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("signed", "" + this.sign.getElement().isChecked());
        return conf;
    }

    @Override
    protected String getProgressText() {
        return WordsToolkit.toCapitalLetter((String)Words.PRINT);
    }

    @Override
    public String getTitleString() {
        return Words.ORDER_NO;
    }

    @Override
    public String getTitleValue() {
        return "" + this.requisitionOrder.getChildNamed(RequisitionOrderLight_.number).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.sign != null) {
            this.sign.kill();
        }
        this.sign = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.sign != null) {
            this.sign.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.sign != null) {
            this.sign.setVisible(false);
        }
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        super.enterPressed(isOK);
        this.rowModel.getView().repaint(32L);
        this.rowModel.getView().revalidate();
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintDeliverWorksheetComponent.this.getSelectedReport();
                PrintDeliverWorksheetComponent.this.configNode.commit();
                RequisitionOrderReportConfiguration config = (RequisitionOrderReportConfiguration)PrintDeliverWorksheetComponent.this.configNode.getValue();
                config.setStylesheet(file);
                config.setDto((IDTO)PrintDeliverWorksheetComponent.this.requisitionOrder.getValue());
                config.setUseUnitFromOrder(Boolean.valueOf(true));
                PegasusFileComplete t = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createRequisitionOrderDeliverSheet(config).getValue();
                PrintDeliverWorksheetComponent.this.processFile(t);
                ViewNode ret = new ViewNode("batchReturn");
                ret.setValue((Object)true, 0L);
                PrintDeliverWorksheetComponent.this.rowModel.getView().repaint(32L);
                PrintDeliverWorksheetComponent.this.rowModel.getView().revalidate();
                return ret;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintDeliverWorksheetComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<RequisitionOrderLight> getCurrentNode() {
        return this.requisitionOrder;
    }

    @Override
    public BatchJob<RequisitionOrderLight> createBatchJob(Node<RequisitionOrderLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintDeliverWorksheetComponent.this.layoutInheritedComponents(parent);
            if (PrintDeliverWorksheetComponent.this.sign != null) {
                PrintDeliverWorksheetComponent.this.department.setLocation(PrintDeliverWorksheetComponent.this.border, y + PrintDeliverWorksheetComponent.this.border);
                PrintDeliverWorksheetComponent.this.department.setSize(parent.getWidth() - 2 * PrintDeliverWorksheetComponent.this.border, (int)PrintDeliverWorksheetComponent.this.department.getPreferredSize().getHeight());
                y = PrintDeliverWorksheetComponent.this.department.getY() + PrintDeliverWorksheetComponent.this.department.getHeight();
                PrintDeliverWorksheetComponent.this.store.setLocation(PrintDeliverWorksheetComponent.this.border, y + PrintDeliverWorksheetComponent.this.border);
                PrintDeliverWorksheetComponent.this.store.setSize(parent.getWidth() - 2 * PrintDeliverWorksheetComponent.this.border, (int)PrintDeliverWorksheetComponent.this.store.getPreferredSize().getHeight());
                y = PrintDeliverWorksheetComponent.this.store.getY() + PrintDeliverWorksheetComponent.this.store.getHeight();
                PrintDeliverWorksheetComponent.this.sign.setLocation(PrintDeliverWorksheetComponent.this.border, y + PrintDeliverWorksheetComponent.this.border);
                PrintDeliverWorksheetComponent.this.sign.setSize(PrintDeliverWorksheetComponent.this.sign.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintDeliverWorksheetComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += PrintDeliverWorksheetComponent.this.border;
            if (PrintDeliverWorksheetComponent.this.sign != null) {
                h = (int)((double)h + PrintDeliverWorksheetComponent.this.sign.getPreferredSize().getHeight());
                h += PrintDeliverWorksheetComponent.this.border;
                h = (int)((double)h + PrintDeliverWorksheetComponent.this.department.getPreferredSize().getHeight());
                h += PrintDeliverWorksheetComponent.this.border;
                h = (int)((double)h + PrintDeliverWorksheetComponent.this.store.getPreferredSize().getHeight());
                h += PrintDeliverWorksheetComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

