/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.shared.productionlist;

import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.batch.impl.FlightPrintBatch;
import ch.icit.pegasus.client.gui.submodules.print.flight.TitleConverter;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.TransferObject;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserPopup;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.panels.PaxLegTable;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.IFlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

public abstract class PrintProductionListComponent<T extends IFlightReference>
extends DefaultScrollablePrintPopup2<T> {
    private static final long serialVersionUID = 1L;
    private TextLabel options;
    protected TitledItem<CheckBox> includeArticles;
    protected TitledItem<CheckBox> sortByMealPlan;
    protected MultiLineTextLabel infoLabel;
    protected TitledItem<DateChooserPopup> dateChooser;
    protected TitledItem<PaxLegTable> paxCount;
    protected T dto;
    protected PeriodComplete period;

    public PrintProductionListComponent(TransferObject<T> transferObject, PeriodComplete period) {
        super(true, false, false, false, ReportTypeE.PRODUCTION_FLIGHT);
        this.period = period;
        this.dto = (IFlightReference)transferObject.getDto();
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.options = new TextLabel(Words.OPTIONS);
        this.options.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
        this.options.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.infoLabel = new MultiLineTextLabel("<html>* Be aware of<ul><li>Articles show their Label Name, if none is defined, Article's Name is shown</li></ul></html>");
        this.infoLabel.setForeground(fb);
        this.infoLabel.setFont(f);
        this.includeArticles = new TitledItem<CheckBox>(new CheckBox(), "Include Articles", TitledItem.TitledItemOrientation.EAST);
        this.includeArticles.getElement().setChecked(true);
        this.includeArticles.getTitle().setForeground(fb);
        this.includeArticles.getTitle().setFont(f);
        this.sortByMealPlan = new TitledItem<CheckBox>(new CheckBox(), "Sort by Meal Plan", TitledItem.TitledItemOrientation.EAST);
        this.sortByMealPlan.getTitle().setForeground(fb);
        this.sortByMealPlan.getTitle().setFont(f);
        if (this.dateChooser != null) {
            this.getViewContainer().add(this.dateChooser);
        }
        this.getViewContainer().add(this.options);
        this.getViewContainer().add(this.infoLabel);
        this.getViewContainer().add(this.includeArticles);
        this.getViewContainer().add(this.sortByMealPlan);
        if (this.paxCount != null) {
            this.getViewContainer().add(this.paxCount);
        }
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            if (n.equals("overview")) {
                this.includeArticles.getElement().setChecked(b);
                continue;
            }
            if (!n.equals("mealplan")) continue;
            this.sortByMealPlan.getElement().setChecked(b);
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("overview", "" + this.includeArticles.getElement().isChecked());
        conf.addProperty("mealplan", "" + this.sortByMealPlan.getElement().isChecked());
        return conf;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.dateChooser != null) {
            this.dateChooser.setVisible(true);
        }
        this.options.setVisible(true);
        this.infoLabel.setVisible(true);
        this.includeArticles.setVisible(true);
        this.sortByMealPlan.setVisible(true);
        if (this.paxCount != null) {
            this.paxCount.setVisible(true);
        }
    }

    @Override
    public String getTitleString() {
        return Words.FLIGHT;
    }

    @Override
    public String getTitleValue() {
        return ((TitleConverter)ConverterRegistry.getConverter(TitleConverter.class)).convert((Object)this.dto, (Node)null, new Object[0]);
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[5];
        if (this.dateChooser != null) {
            o[0] = this.dateChooser.getElement().getSelectedDate();
        }
        o[1] = true;
        o[2] = this.includeArticles.getElement().isChecked();
        o[3] = this.sortByMealPlan.getElement().isChecked();
        if (this.paxCount != null) {
            o[4] = this.paxCount.getElement().getMap();
        }
        return o;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.includeArticles);
        CheckedListAdder.addToList(focusList, this.sortByMealPlan);
        if (this.dateChooser != null) {
            CheckedListAdder.addToList(focusList, this.dateChooser);
        }
        if (this.paxCount != null) {
            CheckedListAdder.addToList(focusList, this.paxCount);
        }
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.dateChooser != null) {
            this.dateChooser.kill();
        }
        this.dateChooser = null;
        this.includeArticles.kill();
        this.includeArticles = null;
        this.infoLabel.kill();
        this.infoLabel = null;
        this.sortByMealPlan.kill();
        this.sortByMealPlan = null;
        if (this.paxCount != null) {
            this.paxCount.kill();
        }
        this.paxCount = null;
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.dateChooser != null) {
            this.dateChooser.setVisible(false);
        }
        this.options.setVisible(false);
        this.includeArticles.setVisible(false);
        this.infoLabel.setVisible(false);
        this.sortByMealPlan.setVisible(false);
        if (this.paxCount != null) {
            this.paxCount.setVisible(false);
        }
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> a;
        List<ScreenValidationObject> b;
        ArrayList<ScreenValidationObject> l = new ArrayList<ScreenValidationObject>();
        if (this.paxCount != null && (b = this.paxCount.getElement().validatePaxTable()) != null) {
            l.addAll(b);
        }
        if ((a = super.validateBeforePrint()) != null) {
            l.addAll(a);
        }
        return l;
    }

    @Override
    public BatchJob<T> createBatchJob(Node<T> value, ThreadSafeExecutable job) {
        return new FlightPrintBatch<T>(job, value, this.getPrintProcessor(), false);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintProductionListComponent.this.getInheritedComponentsHeight();
            if (PrintProductionListComponent.this.options != null) {
                h += PrintProductionListComponent.this.border;
                h = (int)((double)h + PrintProductionListComponent.this.options.getPreferredSize().getHeight());
                h += PrintProductionListComponent.this.border / 2;
                h = (int)((double)h + PrintProductionListComponent.this.includeArticles.getPreferredSize().getHeight());
                h += PrintProductionListComponent.this.border / 2;
                h = (int)((double)h + PrintProductionListComponent.this.sortByMealPlan.getPreferredSize().getHeight());
                h += PrintProductionListComponent.this.border;
                h = (int)((double)h + PrintProductionListComponent.this.infoLabel.getPreferredSize().getHeight());
                h += PrintProductionListComponent.this.border;
                if (PrintProductionListComponent.this.dateChooser != null) {
                    h = (int)((double)h + PrintProductionListComponent.this.dateChooser.getPreferredSize().getHeight());
                    h += PrintProductionListComponent.this.border;
                }
                if (PrintProductionListComponent.this.paxCount != null) {
                    h = (int)((double)h + PrintProductionListComponent.this.paxCount.getPreferredSize().getHeight());
                    h += PrintProductionListComponent.this.border;
                }
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int h = PrintProductionListComponent.this.layoutInheritedComponents(parent);
            h += PrintProductionListComponent.this.border;
            if (PrintProductionListComponent.this.options != null) {
                PrintProductionListComponent.this.options.setLocation(PrintProductionListComponent.this.border, h);
                PrintProductionListComponent.this.options.setSize(PrintProductionListComponent.this.options.getPreferredSize());
                PrintProductionListComponent.this.includeArticles.setLocation(PrintProductionListComponent.this.border, h += PrintProductionListComponent.this.options.getHeight() + PrintProductionListComponent.this.border / 2);
                PrintProductionListComponent.this.includeArticles.setSize(parent.getWidth() - 2 * PrintProductionListComponent.this.border, (int)PrintProductionListComponent.this.includeArticles.getPreferredSize().getHeight());
                PrintProductionListComponent.this.sortByMealPlan.setLocation(PrintProductionListComponent.this.border, h += PrintProductionListComponent.this.includeArticles.getHeight() + PrintProductionListComponent.this.border / 2);
                PrintProductionListComponent.this.sortByMealPlan.setSize(parent.getWidth() - 2 * PrintProductionListComponent.this.border, (int)PrintProductionListComponent.this.sortByMealPlan.getPreferredSize().getHeight());
                PrintProductionListComponent.this.infoLabel.setLocation(PrintProductionListComponent.this.border, h += PrintProductionListComponent.this.sortByMealPlan.getHeight() + PrintProductionListComponent.this.border);
                PrintProductionListComponent.this.infoLabel.setSize(parent.getWidth() - 2 * PrintProductionListComponent.this.infoLabel.getX(), (int)PrintProductionListComponent.this.infoLabel.getPreferredSize().getHeight());
                h += PrintProductionListComponent.this.infoLabel.getHeight() + PrintProductionListComponent.this.border;
                if (PrintProductionListComponent.this.dateChooser != null) {
                    PrintProductionListComponent.this.dateChooser.setLocation(PrintProductionListComponent.this.border, h);
                    PrintProductionListComponent.this.dateChooser.setSize(PrintProductionListComponent.this.dateChooser.getPreferredSize());
                    h += PrintProductionListComponent.this.dateChooser.getHeight() + PrintProductionListComponent.this.border;
                }
                if (PrintProductionListComponent.this.paxCount != null) {
                    PrintProductionListComponent.this.paxCount.setLocation(PrintProductionListComponent.this.border, h);
                    PrintProductionListComponent.this.paxCount.setSize(parent.getWidth() - 2 * PrintProductionListComponent.this.border, (int)PrintProductionListComponent.this.paxCount.getPreferredSize().getHeight());
                }
            }
        }
    }
}

