/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.store.storelabel;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.StockReportConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Collections;

public class PrintStoreBarcodeSheetComponent
extends DefaultScrollablePrintPopup2<StoreLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> includePositions;
    private Node<StoreLight> node;

    public PrintStoreBarcodeSheetComponent(Node<StoreLight> node) {
        super(false, false, ReportTypeE.STORE_BARCODE);
        this.node = node;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.includePositions.setEnabled(isEnabled);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.includePositions.setVisible(false);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.includePositions != null) {
            this.includePositions.kill();
        }
        this.includePositions = null;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.includePositions = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_STORE_POSITION, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.includePositions);
        this.setEnabled(this.isEnabled());
    }

    @Override
    public String getTitleString() {
        return Words.STORE;
    }

    @Override
    public String getTitleValue() {
        return ((StoreLight)this.node.getValue()).getName();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StoreLight value = (StoreLight)PrintStoreBarcodeSheetComponent.this.node.getValue();
                StockReportConfiguration config = new StockReportConfiguration();
                config.setStylesheet(PrintStoreBarcodeSheetComponent.this.getSelectedReport());
                config.setFormat(ReportingOutputFormatE.PDF);
                config.setIncludedStores(Collections.singletonList(new StoreReference(value.getId())));
                config.setIncludePositions(Boolean.valueOf(((CheckBox)PrintStoreBarcodeSheetComponent.this.includePositions.getElement()).isChecked()));
                PegasusFileComplete t = (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createStockBarcode(config).getValue();
                PrintStoreBarcodeSheetComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintStoreBarcodeSheetComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<StoreLight> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<StoreLight> createBatchJob(Node<StoreLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintStoreBarcodeSheetComponent.this.layoutInheritedComponents(parent) + PrintStoreBarcodeSheetComponent.this.border;
            if (PrintStoreBarcodeSheetComponent.this.includePositions != null) {
                PrintStoreBarcodeSheetComponent.this.includePositions.setLocation(PrintStoreBarcodeSheetComponent.this.border, y);
                PrintStoreBarcodeSheetComponent.this.includePositions.setSize(PrintStoreBarcodeSheetComponent.this.includePositions.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintStoreBarcodeSheetComponent.this.getInheritedComponentsHeight();
            int w = 250;
            if (PrintStoreBarcodeSheetComponent.this.includePositions != null) {
                h += PrintStoreBarcodeSheetComponent.this.border;
                h = (int)((double)h + PrintStoreBarcodeSheetComponent.this.includePositions.getPreferredSize().getHeight());
                h += PrintStoreBarcodeSheetComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

