/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.store.transaction.article;

import ch.icit.pegasus.client.converter.BondedStateEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDateTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.SearchReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.report.StockTransactionSearchReportConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StockTransactionSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StockTransactionSearchConfiguration_;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Timestamp;

public class PrintStoreTransactionsComponent
extends DefaultScrollablePrintPopup2<StoreLight> {
    private static final long serialVersionUID = 1L;
    private Node<StockTransactionSearchReportConfiguration> configNode;
    private TitledItem<ComboBox> bonded;
    private TitledDateTimePeriodChooser period;
    private TitledItem<CheckBox> groupTransactions;
    private Node<StoreLight> storeNode;
    private TitledItem<ComboBox> inout;
    private TitledItem<ComboBox> type;
    private TitledItem<CheckBox> includeCustomerData;

    public PrintStoreTransactionsComponent(Node<StoreLight> node) {
        super(false, true, false, ReportTypeE.STOCK_TRANSACTION);
        this.storeNode = node;
        StockTransactionSearchReportConfiguration config = new StockTransactionSearchReportConfiguration(ReportTypeE.STOCK_TRANSACTION, ReportingOutputFormatE.PDF, null);
        config.setSearchConfig((ADtoSearchConfiguration)new StockTransactionSearchConfiguration());
        ((StockTransactionSearchConfiguration)config.getSearchConfig()).setStore(new StoreReference(((StoreLight)node.getValue()).getId()));
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String string = s[1];
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("bonded", "" + this.bonded.getElement().getSelectedItem().toString());
        return conf;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.bonded = new TitledItem<ComboBox>(new ComboBox(this.configNode.getChildNamed(new DtoField[]{SearchReportConfiguration_.searchConfig, StockTransactionSearchConfiguration_.bonded}), NodeToolkit.getAffixList(BondedStateE.class), ConverterRegistry.getConverter(BondedStateEConverter.class)), "Bonded only", TitledItem.TitledItemOrientation.NORTH);
        this.bonded.getTitle().setFont(f);
        this.bonded.getTitle().setForeground(fb);
        this.inout = new TitledItem<ComboBox>(new ComboBox(), Words.RECEIPT_OUTGOING, TitledItem.TitledItemOrientation.NORTH);
        this.inout.getElement().addItem(IN_OUT.BOTH);
        this.inout.getElement().addItem(IN_OUT.IN);
        this.inout.getElement().addItem(IN_OUT.OUT);
        this.inout.getTitle().setFont(f);
        this.inout.getTitle().setForeground(fb);
        this.type = new TitledItem<ComboBox>(new ComboBox(), Words.TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.type.getElement().addItem(Words.ALL);
        this.type.getElement().addItem(Words.FLIGHT);
        this.type.getElement().addItem(Words.SCM);
        this.type.getTitle().setFont(f);
        this.type.getTitle().setForeground(fb);
        this.period = new TitledDateTimePeriodChooser((Node<TimestampPeriodComplete>)INodeCreator.getDefaultImpl().getNode4DTO((Object)new TimestampPeriodComplete(new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis())), false, false));
        this.period.setTitleText(Words.PERIOD, " ");
        this.groupTransactions = new TitledItem<CheckBox>(new CheckBox(), Words.GROUP_TRANSACTIONS, TitledItem.TitledItemOrientation.EAST);
        this.includeCustomerData = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_CUSTOMER_DATA, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.period);
        this.getViewContainer().add(this.bonded);
        this.getViewContainer().add(this.inout);
        this.getViewContainer().add(this.type);
        this.getViewContainer().add(this.groupTransactions);
        this.getViewContainer().add(this.includeCustomerData);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.bonded != null) {
            this.bonded.setEnabled(isEnabled);
            this.inout.setEnabled(false);
            this.type.setEnabled(false);
        }
        if (this.period != null) {
            this.period.setEnabled(isEnabled);
        }
        if (this.groupTransactions != null) {
            this.groupTransactions.setEnabled(isEnabled);
        }
        if (this.includeCustomerData != null) {
            this.includeCustomerData.setEnabled(isEnabled);
        }
    }

    @Override
    public String getTitleString() {
        return Words.TRANSACTIONS;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.bonded != null && this.bonded.isInnerComponent(c)) {
            return true;
        }
        return super.isInnerComponent(c);
    }

    @Override
    public String getTitleValue() {
        return ((StoreLight)this.storeNode.getValue()).getCode();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.bonded != null) {
            this.bonded.kill();
        }
        if (this.inout != null) {
            this.inout.kill();
        }
        if (this.type != null) {
            this.type.kill();
        }
        if (this.period != null) {
            this.period.kill();
        }
        if (this.groupTransactions != null) {
            this.groupTransactions.kill();
        }
        if (this.includeCustomerData != null) {
            this.includeCustomerData.kill();
        }
        this.bonded = null;
        this.inout = null;
        this.period = null;
        this.groupTransactions = null;
        this.type = null;
        this.includeCustomerData = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.period != null) {
            this.period.setVisible(true);
        }
        if (this.bonded != null) {
            this.bonded.setVisible(true);
        }
        if (this.inout != null) {
            this.inout.setVisible(true);
        }
        if (this.type != null) {
            this.type.setVisible(true);
        }
        if (this.groupTransactions != null) {
            this.groupTransactions.setVisible(true);
        }
        if (this.includeCustomerData != null) {
            this.includeCustomerData.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.period != null) {
            this.period.setVisible(false);
        }
        if (this.bonded != null) {
            this.bonded.setVisible(false);
        }
        if (this.inout != null) {
            this.inout.setVisible(false);
        }
        if (this.type != null) {
            this.type.setVisible(false);
        }
        if (this.groupTransactions != null) {
            this.groupTransactions.setVisible(false);
        }
        if (this.includeCustomerData != null) {
            this.includeCustomerData.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintStoreTransactionsComponent.this.getSelectedReport();
                PrintStoreTransactionsComponent.this.configNode.commit();
                StockTransactionSearchReportConfiguration config = (StockTransactionSearchReportConfiguration)PrintStoreTransactionsComponent.this.configNode.getValue();
                config.setStylesheet(file);
                config.setFormat(ReportingOutputFormatE.XLSX);
                if (PrintStoreTransactionsComponent.this.inout != null) {
                    if (((ComboBox)PrintStoreTransactionsComponent.this.inout.getElement()).getSelectedItem() == IN_OUT.IN) {
                        ((StockTransactionSearchConfiguration)config.getSearchConfig()).setCheckinOnly(Boolean.valueOf(true));
                    } else if (((ComboBox)PrintStoreTransactionsComponent.this.inout.getElement()).getSelectedItem() == IN_OUT.OUT) {
                        ((StockTransactionSearchConfiguration)config.getSearchConfig()).setCheckinOnly(Boolean.valueOf(false));
                    } else {
                        ((StockTransactionSearchConfiguration)config.getSearchConfig()).setCheckinOnly(null);
                    }
                }
                if (PrintStoreTransactionsComponent.this.bonded != null) {
                    ((StockTransactionSearchConfiguration)config.getSearchConfig()).setBonded((BondedStateE)((Node)((ComboBox)PrintStoreTransactionsComponent.this.bonded.getElement()).getSelectedItem()).getValue());
                }
                if (PrintStoreTransactionsComponent.this.period != null) {
                    ((StockTransactionSearchConfiguration)config.getSearchConfig()).setTimestampPeriod(PrintStoreTransactionsComponent.this.period.getTimePeriod());
                }
                if (PrintStoreTransactionsComponent.this.groupTransactions != null) {
                    config.setGroupByType(Boolean.valueOf(((CheckBox)PrintStoreTransactionsComponent.this.groupTransactions.getElement()).isChecked()));
                }
                if (PrintStoreTransactionsComponent.this.includeCustomerData != null) {
                    config.setIncludeCustomerData(Boolean.valueOf(((CheckBox)PrintStoreTransactionsComponent.this.includeCustomerData.getElement()).isChecked()));
                }
                if (PrintStoreTransactionsComponent.this.type != null) {
                    if (((ComboBox)PrintStoreTransactionsComponent.this.type.getElement()).getSelectedItem().equals(Words.ALL)) {
                        config.setShowFlightOnly(null);
                    } else if (((ComboBox)PrintStoreTransactionsComponent.this.type.getElement()).getSelectedItem().equals(Words.FLIGHT)) {
                        config.setShowFlightOnly(Boolean.valueOf(true));
                    } else if (((ComboBox)PrintStoreTransactionsComponent.this.type.getElement()).getSelectedItem().equals(Words.STORE)) {
                        config.setShowFlightOnly(Boolean.valueOf(false));
                    }
                }
                PegasusFileComplete t = (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createStoreTransactionReport(config).getValue();
                PrintStoreTransactionsComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintStoreTransactionsComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<StoreLight> getCurrentNode() {
        return this.storeNode;
    }

    @Override
    public BatchJob<StoreLight> createBatchJob(Node<StoreLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintStoreTransactionsComponent.this.layoutInheritedComponents(parent) + PrintStoreTransactionsComponent.this.border;
            if (PrintStoreTransactionsComponent.this.period != null) {
                PrintStoreTransactionsComponent.this.period.setLocation(PrintStoreTransactionsComponent.this.border, y);
                PrintStoreTransactionsComponent.this.period.setSize(parent.getWidth() - 2 * PrintStoreTransactionsComponent.this.border, (int)PrintStoreTransactionsComponent.this.period.getPreferredSize().getHeight());
                y = PrintStoreTransactionsComponent.this.period.getY() + PrintStoreTransactionsComponent.this.period.getHeight();
            }
            if (PrintStoreTransactionsComponent.this.bonded != null) {
                PrintStoreTransactionsComponent.this.bonded.setLocation(PrintStoreTransactionsComponent.this.border, y + PrintStoreTransactionsComponent.this.border / 2);
                PrintStoreTransactionsComponent.this.bonded.setSize(parent.getWidth() - 2 * PrintStoreTransactionsComponent.this.border, (int)PrintStoreTransactionsComponent.this.bonded.getPreferredSize().getHeight());
                PrintStoreTransactionsComponent.this.inout.setLocation(PrintStoreTransactionsComponent.this.border, PrintStoreTransactionsComponent.this.bonded.getY() + PrintStoreTransactionsComponent.this.bonded.getHeight() + PrintStoreTransactionsComponent.this.border / 2);
                PrintStoreTransactionsComponent.this.inout.setSize((parent.getWidth() - 3 * PrintStoreTransactionsComponent.this.border) / 2, (int)PrintStoreTransactionsComponent.this.inout.getPreferredSize().getHeight());
                PrintStoreTransactionsComponent.this.type.setLocation(PrintStoreTransactionsComponent.this.inout.getX() + PrintStoreTransactionsComponent.this.inout.getWidth() + PrintStoreTransactionsComponent.this.border, PrintStoreTransactionsComponent.this.inout.getY());
                PrintStoreTransactionsComponent.this.type.setSize((parent.getWidth() - 3 * PrintStoreTransactionsComponent.this.border) / 2, (int)PrintStoreTransactionsComponent.this.type.getPreferredSize().getHeight());
                PrintStoreTransactionsComponent.this.groupTransactions.setLocation(PrintStoreTransactionsComponent.this.border, PrintStoreTransactionsComponent.this.inout.getY() + PrintStoreTransactionsComponent.this.inout.getHeight() + PrintStoreTransactionsComponent.this.border / 2);
                PrintStoreTransactionsComponent.this.groupTransactions.setSize(parent.getWidth() - 2 * PrintStoreTransactionsComponent.this.border, (int)PrintStoreTransactionsComponent.this.groupTransactions.getPreferredSize().getHeight());
                PrintStoreTransactionsComponent.this.includeCustomerData.setLocation(PrintStoreTransactionsComponent.this.border, PrintStoreTransactionsComponent.this.groupTransactions.getY() + PrintStoreTransactionsComponent.this.groupTransactions.getHeight() + PrintStoreTransactionsComponent.this.border / 2);
                PrintStoreTransactionsComponent.this.includeCustomerData.setSize(parent.getWidth() - 2 * PrintStoreTransactionsComponent.this.border, (int)PrintStoreTransactionsComponent.this.includeCustomerData.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintStoreTransactionsComponent.this.getInheritedComponentsHeight();
            int w = 250;
            if (PrintStoreTransactionsComponent.this.bonded != null) {
                h = (int)((double)h + PrintStoreTransactionsComponent.this.period.getPreferredSize().getHeight());
                h += PrintStoreTransactionsComponent.this.border / 2;
                h = (int)((double)h + PrintStoreTransactionsComponent.this.bonded.getPreferredSize().getHeight());
                h += PrintStoreTransactionsComponent.this.border / 2;
                h = (int)((double)h + PrintStoreTransactionsComponent.this.inout.getPreferredSize().getHeight());
                h += PrintStoreTransactionsComponent.this.border / 2;
                h = (int)((double)h + PrintStoreTransactionsComponent.this.groupTransactions.getPreferredSize().getHeight());
                h += PrintStoreTransactionsComponent.this.border / 2;
                h = (int)((double)h + PrintStoreTransactionsComponent.this.includeCustomerData.getPreferredSize().getHeight());
                h += PrintStoreTransactionsComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }

    public static enum IN_OUT {
        IN,
        OUT,
        BOTH;


        public String toString() {
            switch (this) {
                case BOTH: {
                    return "Both";
                }
                case IN: {
                    return "Receipt";
                }
                case OUT: {
                    return "Outgoing";
                }
            }
            return "-";
        }
    }
}

