/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.stowinglist.loading;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.TransferObject;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.report.FlightDataReportConfig;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class PrintStwArticleLoadingSheetComponent
extends DefaultScrollablePrintPopup2<StowingListTemplateComplete>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    protected TextLabel printOptionTitle;
    private TitledItem<ComboBox> department;
    private TitledItem<DateChooser> dueDate;
    private Node<StowingListTemplateComplete> node;

    public PrintStwArticleLoadingSheetComponent(TransferObject<StowingListTemplateComplete> transferObject) {
        super(true, false, false, true, ReportTypeE.ARTICLE_LOADING_SHEET);
        this.node = transferObject.getNode();
        Runnable r = () -> {
            try {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
        };
        this.loadBeforeShowing(r);
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.printOptionTitle = new TextLabel(Words.OPTIONS);
        this.printOptionTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
        this.printOptionTitle.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
        this.getViewContainer().add(this.printOptionTitle);
        this.department = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(CostCenterComplete.class), ConverterRegistry.getConverter(CostCenterConverter.class), true, true), WordsToolkit.toCapitalLetter((String)Words.DEPARTMENT), TitledItem.TitledItemOrientation.NORTH);
        this.department.getTitle().setForeground(fb);
        this.department.getTitle().setFont(f);
        this.getViewContainer().add(this.department);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dueDate.getElement().setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false));
        this.getViewContainer().add(this.dueDate);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.printOptionTitle.setEnabled(isEnabled);
        this.department.setEnabled(isEnabled);
        this.dueDate.setEnabled(isEnabled);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.LOADING_SHEET;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[2];
        return o;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.department);
        return focusList;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        boolean b = super.isInnerComponent(c);
        if (b) {
            return b;
        }
        return this.department != null && this.department.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.kill();
        }
        if (this.department != null) {
            this.department.kill();
        }
        if (this.dueDate != null) {
            this.dueDate.kill();
        }
        this.department = null;
        this.printOptionTitle = null;
        this.dueDate = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(true);
        }
        if (this.department != null) {
            this.department.setVisible(true);
        }
        if (this.popup != null) {
            this.popup.createFocusCycle();
        }
        if (this.dueDate != null) {
            this.dueDate.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(false);
        }
        if (this.department != null) {
            this.department.setVisible(false);
        }
        if (this.dueDate != null) {
            this.dueDate.setVisible(false);
        }
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        ArrayList<ScreenValidationObject> l = new ArrayList<ScreenValidationObject>();
        List<ScreenValidationObject> a = super.validateBeforePrint();
        if (a != null) {
            l.addAll(a);
        }
        return l;
    }

    @Override
    public BatchJob<StowingListTemplateComplete> createBatchJob(Node<StowingListTemplateComplete> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                CostCenterComplete costCenter = null;
                if (((ComboBox)PrintStwArticleLoadingSheetComponent.this.department.getElement()).getSelectedItem() instanceof Node) {
                    Node d = (Node)((ComboBox)PrintStwArticleLoadingSheetComponent.this.department.getElement()).getSelectedItem();
                    costCenter = (CostCenterComplete)d.getValue();
                }
                boolean isPdf = PrintStwArticleLoadingSheetComponent.this.asPDF != null ? ((RadioButton)PrintStwArticleLoadingSheetComponent.this.asPDF.getElement()).isChecked() : false;
                Date date = (Date)((DateChooser)PrintStwArticleLoadingSheetComponent.this.dueDate.getElement()).getNode().getValue();
                FlightDataReportConfig config = new FlightDataReportConfig();
                config.setDepartment(costCenter);
                PegasusFileComplete t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).generateArticleLoadingSheetFromStowingList(new StowingListTemplateReference(((StowingListTemplateComplete)PrintStwArticleLoadingSheetComponent.this.node.getValue()).getId()), config, PrintStwArticleLoadingSheetComponent.this.getSelectedReport(), isPdf, new DateWrapper(date)).getValue();
                PrintStwArticleLoadingSheetComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintStwArticleLoadingSheetComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public String getTitleValue() {
        return ((StowingListTemplateComplete)this.node.getValue()).getCurrentVariant().getName();
    }

    @Override
    public Node<StowingListTemplateComplete> getCurrentNode() {
        return this.node;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintStwArticleLoadingSheetComponent.this.layoutInheritedComponents(parent);
            if (PrintStwArticleLoadingSheetComponent.this.printOptionTitle != null) {
                PrintStwArticleLoadingSheetComponent.this.printOptionTitle.setLocation(PrintStwArticleLoadingSheetComponent.this.border, y + PrintStwArticleLoadingSheetComponent.this.border);
                PrintStwArticleLoadingSheetComponent.this.printOptionTitle.setSize(parent.getWidth() - 2 * PrintStwArticleLoadingSheetComponent.this.border, (int)PrintStwArticleLoadingSheetComponent.this.printOptionTitle.getPreferredSize().getHeight());
                y = PrintStwArticleLoadingSheetComponent.this.printOptionTitle.getY() + PrintStwArticleLoadingSheetComponent.this.printOptionTitle.getHeight() + PrintStwArticleLoadingSheetComponent.this.border / 2;
            }
            if (PrintStwArticleLoadingSheetComponent.this.dueDate != null) {
                PrintStwArticleLoadingSheetComponent.this.dueDate.setLocation(PrintStwArticleLoadingSheetComponent.this.border, y + PrintStwArticleLoadingSheetComponent.this.border);
                PrintStwArticleLoadingSheetComponent.this.dueDate.setSize(parent.getWidth() - 2 * PrintStwArticleLoadingSheetComponent.this.border, (int)PrintStwArticleLoadingSheetComponent.this.dueDate.getPreferredSize().getHeight());
                y = PrintStwArticleLoadingSheetComponent.this.dueDate.getY() + PrintStwArticleLoadingSheetComponent.this.dueDate.getHeight() + PrintStwArticleLoadingSheetComponent.this.border / 2;
            }
            if (PrintStwArticleLoadingSheetComponent.this.department != null) {
                PrintStwArticleLoadingSheetComponent.this.department.setLocation(PrintStwArticleLoadingSheetComponent.this.border, y + PrintStwArticleLoadingSheetComponent.this.border);
                PrintStwArticleLoadingSheetComponent.this.department.setSize(parent.getWidth() - 2 * PrintStwArticleLoadingSheetComponent.this.border, (int)PrintStwArticleLoadingSheetComponent.this.department.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintStwArticleLoadingSheetComponent.this.getInheritedComponentsHeight();
            h += PrintStwArticleLoadingSheetComponent.this.border;
            if (PrintStwArticleLoadingSheetComponent.this.printOptionTitle != null) {
                h = (int)((double)h + PrintStwArticleLoadingSheetComponent.this.printOptionTitle.getPreferredSize().getHeight());
                h += PrintStwArticleLoadingSheetComponent.this.border / 2;
            }
            if (PrintStwArticleLoadingSheetComponent.this.dueDate != null) {
                h = (int)((double)h + PrintStwArticleLoadingSheetComponent.this.dueDate.getPreferredSize().getHeight());
                h += PrintStwArticleLoadingSheetComponent.this.border / 2;
            }
            if (PrintStwArticleLoadingSheetComponent.this.department != null) {
                h = (int)((double)h + PrintStwArticleLoadingSheetComponent.this.department.getPreferredSize().getHeight());
            }
            int w = 2 * PrintStwArticleLoadingSheetComponent.this.border;
            return new Dimension(w, h += PrintStwArticleLoadingSheetComponent.this.border);
        }
    }
}

