/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.customer.crew.utils;

import ch.icit.pegasus.client.converter.SoBAccessLevelConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.RestoreButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.SoBAccessLevelComplete;
import ch.icit.pegasus.server.core.dtos.sob.CrewMemberComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.ADeletableDTO_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class CrewTable
extends Table2 {
    private static final long serialVersionUID = 1L;
    private CustomerLight customer;

    public CrewTable(CustomerLight customer) {
        super(true, Words.TABLE_ADD, true, true);
        this.customer = customer;
        this.setTitleText(Words.CREW);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                CrewMemberComplete c = new CrewMemberComplete();
                c.setClientOId(Long.valueOf(ADTO.getNextId()));
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)c, true, false);
                CrewTable.this.getModel().getNode().addChild(n, 0L);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.FORENAME, null, null, null, "", 200, 200, 200));
        columns.add(new TableColumnInfo(Words.SURNAME, null, null, null, "", 200, 200, 200));
        columns.add(new TableColumnInfo(WordsToolkit.toUpperCase((String)Words.ACCESS_LEVEL), null, null, null, "", 150, 150, 150));
        columns.add(new TableColumnInfo(WordsToolkit.toUpperCase((String)Words.CREWID), null, null, null, "", 150, 150, 150));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.4);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.4);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        this.setSortedColumn(1);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
        this.setProgress(1.0f);
    }

    public List<ScreenValidationObject> validateTable() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        for (Table2RowPanel p : this.getRows()) {
            TableRowImpl i = (TableRowImpl)p;
            i.validateRow(a);
        }
        return a;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextField forename;
        private TextField surname;
        private ComboBox accessLevel;
        private TextField crewID;
        private Component delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.forename = new TextField(m.getNode().getChildNamed(new String[]{"foreName"}));
            this.surname = new TextField(m.getNode().getChildNamed(new String[]{"surName"}));
            this.accessLevel = new ComboBox(m.getNode().getChildNamed(new String[]{"accessLevel"}), NodeToolkit.getAffixList(SoBAccessLevelComplete.class), ConverterRegistry.getConverter(SoBAccessLevelConverter.class));
            this.crewID = new TextField(m.getNode().getChildNamed(new String[]{"crewID"}));
            this.setLayout(new Layout());
            this.ensureDeleteButton();
            this.add(this.forename);
            this.add(this.surname);
            this.add(this.accessLevel);
            this.add(this.crewID);
        }

        @Override
        public boolean isRowValid() {
            if (this.forename.getText().isEmpty()) {
                return false;
            }
            if (this.surname.getText().isEmpty()) {
                return false;
            }
            if (this.accessLevel.getNode().getValue() == null) {
                return false;
            }
            return !this.crewID.getText().isEmpty();
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.forename.getFocusComponents();
            CheckedListAdder.addToList(a, this.surname);
            CheckedListAdder.addToList(a, this.accessLevel);
            CheckedListAdder.addToList(a, this.crewID);
            CheckedListAdder.addToList(a, (Focusable)((Object)this.delete));
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new String[]{"foreName"}).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(new String[]{"surName"}).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(new String[]{"accessLevel"}).getValue();
                }
                case 3: {
                    return this.model.getNode().getChildNamed(new String[]{"crewID"}).getValue();
                }
                case 4: {
                    return this.model.getNode().getChildNamed(new String[]{"pin"}).getValue();
                }
                case 5: {
                    return this.model.getNode().getChildNamed(new String[]{"commission"}).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.forename.setEnabled(isEnabled);
            this.surname.setEnabled(isEnabled);
            this.accessLevel.setEnabled(isEnabled);
            this.crewID.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.forename.kill();
            this.forename = null;
            this.surname.kill();
            this.surname = null;
            this.accessLevel.kill();
            this.accessLevel = null;
            this.crewID.kill();
            this.crewID = null;
            ((Killable)((Object)this.delete)).kill();
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                if (this.model.getNode().getChildNamed(new String[]{"id"}).getValue() == null) {
                    this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
                } else {
                    if (((Boolean)this.model.getNode().getChildNamed(ADeletableDTO_.isDeleted).getValue()).booleanValue()) {
                        this.model.getNode().getChildNamed(ADeletableDTO_.isDeleted).setValue((Object)false, 0L);
                    } else {
                        this.model.getNode().getChildNamed(ADeletableDTO_.isDeleted).setValue((Object)true, 0L);
                    }
                    this.ensureDeleteButton();
                }
            }
        }

        private void ensureDeleteButton() {
            boolean readded = false;
            if (((Boolean)this.model.getNode().getChildNamed(ADeletableDTO_.isDeleted).getValue()).booleanValue()) {
                if (!(this.delete instanceof RestoreButton)) {
                    if (this.delete != null && this.delete instanceof Killable) {
                        ((Killable)((Object)this.delete)).kill();
                    }
                    readded = true;
                    this.delete = new RestoreButton();
                }
            } else if (!(this.delete instanceof DeleteButton)) {
                if (this.delete != null && this.delete instanceof Killable) {
                    ((Killable)((Object)this.delete)).kill();
                }
                readded = true;
                this.delete = new DeleteButton();
            }
            if (readded) {
                if (this.delete instanceof Button) {
                    ((Button)this.delete).addButtonListener(this);
                }
                this.add(this.delete);
                CrewTable.this.revalidate();
            }
        }

        public void validateRow(List<ScreenValidationObject> a) {
            String fN = (String)this.model.getNode().getChildNamed(new String[]{"foreName"}).getValue();
            String sN = (String)this.model.getNode().getChildNamed(new String[]{"surName"}).getValue();
            SoBAccessLevelComplete al = (SoBAccessLevelComplete)this.model.getNode().getChildNamed(new String[]{"accessLevel"}).getValue();
            String cID = (String)this.model.getNode().getChildNamed(new String[]{"crewID"}).getValue();
            if (fN == null || fN.isEmpty()) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Crew's forename is set"));
            }
            if (sN == null || sN.isEmpty()) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Crew's surname is set"));
            }
            if (cID == null || cID.isEmpty()) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Crew's ID is set"));
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.forename.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.forename.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.forename.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.forename.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.surname.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.surname.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.surname.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.surname.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.accessLevel.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.accessLevel.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.accessLevel.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.accessLevel.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.crewID.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.crewID.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.crewID.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.crewID.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

