/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.customer.edwconfig;

import ch.icit.pegasus.client.gui.submodules.tool.customer.edwconfig.utils.HandlingGroup;
import ch.icit.pegasus.client.gui.submodules.tool.customer.edwconfig.utils.PaxGroupTable;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.edelweiss.reportconfig.EdelweissReportConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.edelweiss.reportconfig.EdelweissReportConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.edelweiss.reportconfig.EdelweissReportConfigurationHandlingGroupComplete;
import ch.icit.pegasus.server.core.dtos.edelweiss.reportconfig.EdelweissReportConfigurationPaxGroupsComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;

public class EDWInvoiceConfigurationToolComponent
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private final CustomerLight customerLight;
    private Node<CustomerComplete> customerComplete;
    private TitledItem<HandlingGroup> mealHandlings;
    private TitledItem<HandlingGroup> transactionHandlings;
    private TitledItem<PaxGroupTable> paxGroups;
    private TitledItem<HandlingGroup> totalGroup;
    private TitledItem<HandlingGroup> aircraftGroup;
    private TitledItem<PaxGroupTable> totalGroups;
    private boolean isLoadingRemains = false;

    public EDWInvoiceConfigurationToolComponent(CustomerLight customerNode) {
        super(false, false);
        this.customerLight = customerNode;
        this.getViewContainer().setLayout(new Layout());
        this.mealHandlings = new TitledItem<HandlingGroup>(new HandlingGroup((Node<CustomerLight>)INodeCreator.getDefaultImpl().getNode4DTO((Object)customerNode, false, false)), "Meal Handling", TitledItem.TitledItemOrientation.NORTH);
        this.transactionHandlings = new TitledItem<HandlingGroup>(new HandlingGroup((Node<CustomerLight>)INodeCreator.getDefaultImpl().getNode4DTO((Object)customerNode, false, false)), "Transaction Handling", TitledItem.TitledItemOrientation.NORTH);
        this.paxGroups = new TitledItem<PaxGroupTable>(new PaxGroupTable(), "Pax Groups", TitledItem.TitledItemOrientation.NORTH);
        this.paxGroups.setIgnorePrefHeight(true);
        this.totalGroup = new TitledItem<HandlingGroup>(new HandlingGroup((Node<CustomerLight>)INodeCreator.getDefaultImpl().getNode4DTO((Object)customerNode, false, false)), "Total Handling", TitledItem.TitledItemOrientation.NORTH);
        this.aircraftGroup = new TitledItem<HandlingGroup>(new HandlingGroup((Node<CustomerLight>)INodeCreator.getDefaultImpl().getNode4DTO((Object)customerNode, false, false)), "Aircraft Handling", TitledItem.TitledItemOrientation.NORTH);
        this.totalGroups = new TitledItem<PaxGroupTable>(new PaxGroupTable(), "Total Pax Groups", TitledItem.TitledItemOrientation.NORTH);
        this.totalGroups.setIgnorePrefHeight(true);
        this.mealHandlings.setProgress(1.0f);
        this.transactionHandlings.setProgress(1.0f);
        this.paxGroups.setProgress(1.0f);
        this.totalGroup.setProgress(1.0f);
        this.aircraftGroup.setProgress(1.0f);
        this.totalGroups.setProgress(1.0f);
        this.getViewContainer().add(this.mealHandlings);
        this.getViewContainer().add(this.transactionHandlings);
        this.getViewContainer().add(this.paxGroups);
        this.getViewContainer().add(this.totalGroup);
        this.getViewContainer().add(this.aircraftGroup);
        this.getViewContainer().add(this.totalGroups);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.mealHandlings.setEnabled(isEnabled);
        this.transactionHandlings.setEnabled(isEnabled);
        this.paxGroups.setEnabled(isEnabled);
        this.totalGroup.setEnabled(isEnabled);
        this.aircraftGroup.setEnabled(isEnabled);
        this.totalGroups.setEnabled(isEnabled);
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        this.createComponents();
        this.isLoadingRemains = true;
        this.popup.setOkButtonText(Words.SAVE);
        this.removeInheritedComponents();
        this.ensureAnimation(Words.LOAD_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                CustomerComplete cc = (CustomerComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getCustomer(new CustomerReference(EDWInvoiceConfigurationToolComponent.this.customerLight.getId())).getValue();
                if (cc.getEdelweissReportConfiguration() == null) {
                    EdelweissReportConfigurationComplete config = new EdelweissReportConfigurationComplete();
                    config.setClientOId(Long.valueOf(ADTO.getNextId()));
                    config.setMealGroup(new EdelweissReportConfigurationHandlingGroupComplete());
                    config.setTransactionGroup(new EdelweissReportConfigurationHandlingGroupComplete());
                    config.setTotalHandlingGroup(new EdelweissReportConfigurationHandlingGroupComplete());
                    config.setAircraftHandlingGroup(new EdelweissReportConfigurationHandlingGroupComplete());
                    config.setPaxGroups(new EdelweissReportConfigurationPaxGroupsComplete());
                    config.setTotalPaxGroups(new EdelweissReportConfigurationPaxGroupsComplete());
                    config.getMealGroup().setClientOId(Long.valueOf(ADTO.getNextId()));
                    config.getTransactionGroup().setClientOId(Long.valueOf(ADTO.getNextId()));
                    config.getTotalHandlingGroup().setClientOId(Long.valueOf(ADTO.getNextId()));
                    config.getAircraftHandlingGroup().setClientOId(Long.valueOf(ADTO.getNextId()));
                    config.getPaxGroups().setClientOId(Long.valueOf(ADTO.getNextId()));
                    config.getTotalPaxGroups().setClientOId(Long.valueOf(ADTO.getNextId()));
                    cc.setEdelweissReportConfiguration(config);
                }
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)cc, false, false);
            }

            @Override
            public RemoteLoader getInvoker() {
                return EDWInvoiceConfigurationToolComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void remoteObjectLoaded(Node node) {
        if (this.isLoadingRemains) {
            this.customerComplete = node;
            this.removeAnimation(false);
            this.mealHandlings.getElement().setNode(node.getChildNamed(new DtoField[]{CustomerComplete_.edelweissReportConfiguration, EdelweissReportConfigurationComplete_.mealGroup}));
            this.transactionHandlings.getElement().setNode(node.getChildNamed(new DtoField[]{CustomerComplete_.edelweissReportConfiguration, EdelweissReportConfigurationComplete_.transactionGroup}));
            this.paxGroups.getElement().setNode(node.getChildNamed(new DtoField[]{CustomerComplete_.edelweissReportConfiguration, EdelweissReportConfigurationComplete_.paxGroups}));
            this.totalGroup.getElement().setNode(node.getChildNamed(new DtoField[]{CustomerComplete_.edelweissReportConfiguration, EdelweissReportConfigurationComplete_.totalHandlingGroup}));
            this.aircraftGroup.getElement().setNode(node.getChildNamed(new DtoField[]{CustomerComplete_.edelweissReportConfiguration, EdelweissReportConfigurationComplete_.aircraftHandlingGroup}));
            this.totalGroups.getElement().setNode(node.getChildNamed(new DtoField[]{CustomerComplete_.edelweissReportConfiguration, EdelweissReportConfigurationComplete_.totalPaxGroups}));
            this.isLoadingRemains = false;
            this.showInheritedComponents();
        } else {
            super.remoteObjectLoaded(node);
        }
    }

    @Override
    public void showInheritedComponents() {
        super.showInheritedComponents();
        if (this.mealHandlings != null) {
            this.mealHandlings.setVisible(true);
        }
        if (this.transactionHandlings != null) {
            this.transactionHandlings.setVisible(true);
        }
        if (this.paxGroups != null) {
            this.paxGroups.setVisible(true);
        }
        if (this.totalGroup != null) {
            this.totalGroup.setVisible(true);
        }
        if (this.aircraftGroup != null) {
            this.aircraftGroup.setVisible(true);
        }
        if (this.totalGroups != null) {
            this.totalGroups.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.mealHandlings != null) {
            this.mealHandlings.setVisible(false);
        }
        if (this.transactionHandlings != null) {
            this.transactionHandlings.setVisible(false);
        }
        if (this.paxGroups != null) {
            this.paxGroups.setVisible(false);
        }
        if (this.totalGroup != null) {
            this.totalGroup.setVisible(false);
        }
        if (this.aircraftGroup != null) {
            this.aircraftGroup.setVisible(false);
        }
        if (this.totalGroups != null) {
            this.totalGroups.setVisible(false);
        }
    }

    @Override
    public String getTitleString() {
        return WordsToolkit.toUpperCase((String)"EDW Invoice Config");
    }

    @Override
    protected String getFinishedText() {
        return Words.DATA_SAVED;
    }

    @Override
    protected String getProgressText() {
        if (this.isLoadingRemains) {
            return Words.LOAD_DATA;
        }
        return Words.SAVE_DATA;
    }

    @Override
    public String getTitleValue() {
        return this.customerLight.getCode();
    }

    @Override
    public boolean withSecondSeparator() {
        return true;
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            this.popup.hidePopUp(new Object[0]);
        } else if (isOK == PopupAction.OK_FOREGROUND) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    EDWInvoiceConfigurationToolComponent.this.ensureAnimation();
                    EDWInvoiceConfigurationToolComponent.this.setEnabled(false);
                    EDWInvoiceConfigurationToolComponent.this.customerComplete.commitThis(CustomerComplete.class);
                    CustomerComplete cc = (CustomerComplete)EDWInvoiceConfigurationToolComponent.this.customerComplete.getValue(CustomerComplete.class);
                    cc = (CustomerComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateCustomer((CustomerReference)cc).getValue();
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            EDWInvoiceConfigurationToolComponent.this.popup.hidePopUp(new Object[0]);
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog("Error while saving", (Component)EDWInvoiceConfigurationToolComponent.this);
                            EDWInvoiceConfigurationToolComponent.this.popup.hidePopUp(new Object[0]);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int cy = EDWInvoiceConfigurationToolComponent.this.layoutInheritedComponents(parent);
            EDWInvoiceConfigurationToolComponent.this.mealHandlings.setLocation(EDWInvoiceConfigurationToolComponent.this.border, cy + EDWInvoiceConfigurationToolComponent.this.border);
            EDWInvoiceConfigurationToolComponent.this.mealHandlings.setSize(parent.getWidth() - 2 * EDWInvoiceConfigurationToolComponent.this.border, (int)EDWInvoiceConfigurationToolComponent.this.mealHandlings.getPreferredSize().getHeight());
            EDWInvoiceConfigurationToolComponent.this.transactionHandlings.setLocation(EDWInvoiceConfigurationToolComponent.this.border, EDWInvoiceConfigurationToolComponent.this.mealHandlings.getY() + EDWInvoiceConfigurationToolComponent.this.mealHandlings.getHeight() + EDWInvoiceConfigurationToolComponent.this.border);
            EDWInvoiceConfigurationToolComponent.this.transactionHandlings.setSize(parent.getWidth() - 2 * EDWInvoiceConfigurationToolComponent.this.border, (int)EDWInvoiceConfigurationToolComponent.this.transactionHandlings.getPreferredSize().getHeight());
            EDWInvoiceConfigurationToolComponent.this.paxGroups.setLocation(EDWInvoiceConfigurationToolComponent.this.border, EDWInvoiceConfigurationToolComponent.this.transactionHandlings.getY() + EDWInvoiceConfigurationToolComponent.this.transactionHandlings.getHeight() + EDWInvoiceConfigurationToolComponent.this.border);
            EDWInvoiceConfigurationToolComponent.this.paxGroups.setSize(parent.getWidth() - 2 * EDWInvoiceConfigurationToolComponent.this.border, 300);
            EDWInvoiceConfigurationToolComponent.this.totalGroup.setLocation(EDWInvoiceConfigurationToolComponent.this.border, EDWInvoiceConfigurationToolComponent.this.paxGroups.getY() + EDWInvoiceConfigurationToolComponent.this.paxGroups.getHeight() + EDWInvoiceConfigurationToolComponent.this.border);
            EDWInvoiceConfigurationToolComponent.this.totalGroup.setSize(parent.getWidth() - 2 * EDWInvoiceConfigurationToolComponent.this.border, (int)EDWInvoiceConfigurationToolComponent.this.totalGroup.getPreferredSize().getHeight());
            EDWInvoiceConfigurationToolComponent.this.aircraftGroup.setLocation(EDWInvoiceConfigurationToolComponent.this.border, EDWInvoiceConfigurationToolComponent.this.totalGroup.getY() + EDWInvoiceConfigurationToolComponent.this.totalGroup.getHeight() + EDWInvoiceConfigurationToolComponent.this.border);
            EDWInvoiceConfigurationToolComponent.this.aircraftGroup.setSize(parent.getWidth() - 2 * EDWInvoiceConfigurationToolComponent.this.border, (int)EDWInvoiceConfigurationToolComponent.this.aircraftGroup.getPreferredSize().getHeight());
            EDWInvoiceConfigurationToolComponent.this.totalGroups.setLocation(EDWInvoiceConfigurationToolComponent.this.border, EDWInvoiceConfigurationToolComponent.this.aircraftGroup.getY() + EDWInvoiceConfigurationToolComponent.this.aircraftGroup.getHeight() + EDWInvoiceConfigurationToolComponent.this.border);
            EDWInvoiceConfigurationToolComponent.this.totalGroups.setSize(parent.getWidth() - 2 * EDWInvoiceConfigurationToolComponent.this.border, 300);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = EDWInvoiceConfigurationToolComponent.this.getInheritedComponentsHeight() + EDWInvoiceConfigurationToolComponent.this.border;
            h = (int)((double)h + (EDWInvoiceConfigurationToolComponent.this.mealHandlings.getPreferredSize().getHeight() + (double)EDWInvoiceConfigurationToolComponent.this.border));
            h = (int)((double)h + (EDWInvoiceConfigurationToolComponent.this.transactionHandlings.getPreferredSize().getHeight() + (double)EDWInvoiceConfigurationToolComponent.this.border));
            h += 300 + EDWInvoiceConfigurationToolComponent.this.border;
            h = (int)((double)h + (EDWInvoiceConfigurationToolComponent.this.totalGroup.getPreferredSize().getHeight() + (double)EDWInvoiceConfigurationToolComponent.this.border));
            h = (int)((double)h + (EDWInvoiceConfigurationToolComponent.this.aircraftGroup.getPreferredSize().getHeight() + (double)EDWInvoiceConfigurationToolComponent.this.border));
            h += 300;
            return new Dimension(0, h += EDWInvoiceConfigurationToolComponent.this.border);
        }
    }
}

