/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.customer.sobconfiguration.utils;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.CurrencyConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.customer.sobconfiguration.utils.SobCurrencyConfigurationTable;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.SortableTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowSelectionListener;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.ArrowButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.tables.comparators.SequenceNumberComparator;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.sob.SobCurrencyComplete;
import ch.icit.pegasus.server.core.dtos.sob.SobCurrencyComplete_;
import ch.icit.pegasus.server.core.dtos.sob.SobCurrencyExchangeComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class SobCurrencySequenceTable
extends Table2
implements Table2RowSelectionListener {
    private static final long serialVersionUID = 1L;
    private SobCurrencyConfigurationTable currencyTable;
    private CustomerLight customer;

    public SobCurrencySequenceTable(SobCurrencyConfigurationTable currencyTable) {
        super(true, Words.ADD, true, true);
        this.currencyTable = currencyTable;
        this.setTitleText("Currencies");
        this.setTableText(Words.CURRENCY_SPECIFICATION);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                SobCurrencySequenceTable.this.writeNumber(SobCurrencyComplete_.sequenceNumber, 0);
                SobCurrencySequenceTable.this.updateOrder();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                SobCurrencyComplete c = new SobCurrencyComplete();
                c.setClientOId(Long.valueOf(ADTO.getNextId()));
                c.setSequenceNumber(Integer.valueOf(SobCurrencySequenceTable.this.getRowCount()));
                c.setEligibleLocations(SobCurrencySequenceTable.this.customer.getEligibleLocations());
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)c, true, false);
                SobCurrencySequenceTable.this.getModel().getNode().addChild(n, 0L);
                SobCurrencySequenceTable.this.writeNumber(SobCurrencyComplete_.sequenceNumber, 0);
                SobCurrencySequenceTable.this.updateOrder();
            }
        });
        this.setComparator(ComparatorRegistry.getComparator(SequenceNumberComparator.class));
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(0.0, 0.0, Words.CURRENCY, null, null, null, "", 120, 120, 120));
        int tw = 2 * this.getCellPadding() + 2 * this.getInnerCellPadding() + 2 * ArrowButton.getPreferredWidth() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo(0.0, 0.0, "", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
        this.getModel().addTableSelectionListener(this);
    }

    public void setCustomer(CustomerLight customerDTO) {
        this.customer = customerDTO;
    }

    public List<ScreenValidationObject> validateTable() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        List<SobCurrencyComplete> b = this.getData();
        HashSet<CurrencyComplete> s = new HashSet<CurrencyComplete>();
        for (SobCurrencyComplete c : b) {
            if (c.getCurrency() == null) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Currencies are set"));
            } else {
                if (s.contains(c.getCurrency())) {
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Duplicate Currency Configuration for " + c.getCurrency().getCode()));
                } else if (c.getVariants().isEmpty()) {
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Currency " + c.getCurrency().getCode() + " should at least have one Period "));
                }
                s.add(c.getCurrency());
            }
            a.addAll(this.validateSobCurrencyExchange(c.getVariants()));
        }
        return a;
    }

    public List<ScreenValidationObject> validateSobCurrencyExchange(List<SobCurrencyExchangeComplete> nodesGoHome) {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        for (SobCurrencyExchangeComplete se : nodesGoHome) {
            if (se.getValidityPeriod().getStartDate() == null || se.getValidityPeriod().getEndDate() == null) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Validitydates need to be set"));
                continue;
            }
            if (TimeUtil.getDateWithMidnightTime((Date)se.getValidityPeriod().getStartDate()).getTime() == TimeUtil.getDateWithMidnightTime((Date)se.getValidityPeriod().getEndDate()).getTime()) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "A Validityperiod needs to last at least one Day"));
                continue;
            }
            if (se.getValidityPeriod().getStartDate().getTime() <= se.getValidityPeriod().getEndDate().getTime()) continue;
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "The Enddate should be after the Startdate"));
        }
        if (!a.isEmpty()) {
            return a;
        }
        Collections.sort(nodesGoHome, new Comparator<SobCurrencyExchangeComplete>(){

            @Override
            public int compare(SobCurrencyExchangeComplete o1, SobCurrencyExchangeComplete o2) {
                return o1.getValidityPeriod().getStartDate().compareTo(o2.getValidityPeriod().getStartDate());
            }
        });
        SobCurrencyExchangeComplete lastSe = null;
        for (SobCurrencyExchangeComplete se : nodesGoHome) {
            if (lastSe != null) {
                Calendar lastEnd = TimeUtil.createCalendar();
                lastEnd.setTime(TimeUtil.getDateWithMidnightTime((Date)lastSe.getValidityPeriod().getEndDate()));
                Calendar thisStart = TimeUtil.createCalendar();
                thisStart.setTime(TimeUtil.getDateWithMidnightTime((Date)se.getValidityPeriod().getStartDate()));
                if (lastEnd.getTimeInMillis() >= thisStart.getTimeInMillis()) {
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Periods should not overlap"));
                } else {
                    lastEnd.add(5, 1);
                    if (lastEnd.getTimeInMillis() != thisStart.getTimeInMillis()) {
                        a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "No Gaps should exist between Periods"));
                    }
                }
            }
            lastSe = se;
        }
        return a;
    }

    public List<SobCurrencyComplete> getData() {
        ArrayList<SobCurrencyComplete> currencies = new ArrayList<SobCurrencyComplete>();
        for (Table2RowPanel r : this.getRows()) {
            r.getModel().getNode().commit(SobCurrencyComplete.class);
            SobCurrencyComplete c = (SobCurrencyComplete)r.getModel().getNode().getValue(SobCurrencyComplete.class);
            currencies.add(c);
        }
        return currencies;
    }

    @Override
    public void tableRowSelected(Table2 sourceTable, Table2RowPanel panel) {
        if (panel != null) {
            this.currencyTable.setNode(panel.getModel().getNode().getChildNamed(new String[]{"variants"}));
        } else {
            this.currencyTable.setNode(null);
        }
    }

    private class TableRowImpl
    extends SortableTable2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private ComboBox currency;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.THREE);
            this.setSelectable(true);
            this.setSortAttributeName(SobCurrencyComplete_.sequenceNumber);
            this.setStartEndOffset(0, 1);
            this.currency = new ComboBox(m.getNode().getChildNamed(new String[]{"currency"}), NodeToolkit.getAffixList(CurrencyComplete.class), ConverterRegistry.getConverter(CurrencyConverter.class));
            this.add(this.currency);
            this.setLayout(new Layout());
        }

        @Override
        public List<Component> getFocusComponents() {
            return new ArrayList<Component>();
        }

        @Override
        public Object getObject4Column(int column) {
            return this.model.getNode().getChildNamed(SobCurrencyComplete_.sequenceNumber).getValue();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.currency.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.currency.kill();
            this.currency = null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                TableRowImpl.this.currency.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.currency.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.currency.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.currency.getPreferredSize().getHeight());
                TableRowImpl.this.setControlsX(currentX += w);
                TableRowImpl.this.layoutSortButtons(currentX, parent.getHeight());
            }
        }
    }
}

