/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.flight.rcequipmentbased;

import ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.ReturnsCountDrawerBasedSubModule;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.StowingToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountDeliverySpaceComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountEquipmentComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountFlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountParameterConfig;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountProductComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountProductComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.SubModuleAccessDefinition;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightAccess;
import java.util.HashMap;
import java.util.Iterator;

public class ReturnsCountEquipmentBasedSubModule
extends ReturnsCountDrawerBasedSubModule {
    private static final long serialVersionUID = 1L;
    private ViewNode groupedByEquipment;

    @Override
    public ReturnsCountDrawerBasedSubModule.EditorType isManualSales() {
        return ReturnsCountDrawerBasedSubModule.EditorType.RETURNS_COUNT_EQUIMENT_BASED;
    }

    @Override
    public SubModuleDefinitionComplete getSubModuleDefinition() {
        return FlightAccess.getSubModuleDefinition((SubModuleAccessDefinition)FlightAccess.TOOL_RETURNS_COUNT_EQUIPMENT_BASED);
    }

    @Override
    public ReturnsCountFlightComplete updateReturnsCountFlight(ReturnsCountFlightComplete r) throws ClientServerCallException {
        return (ReturnsCountFlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).updateCountItems(r, this.getAutoUpdateSales(), false).getValue();
    }

    @Override
    public String getScreenTitle() {
        return FlightAccess.TOOL_RETURNS_COUNT_EQUIPMENT_BASED.getDisplayName();
    }

    @Override
    public ReturnsCountFlightComplete getReturnsCountFlight(Node<CostCenterComplete> cc) throws ClientServerCallException {
        return (ReturnsCountFlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getCountItems(new FlightReference(this.getFlight().getId()), new ReturnsCountParameterConfig(cc != null ? (CostCenterComplete)cc.getValue() : null, this.getFlight().getUpliftCount())).getValue();
    }

    @Override
    public void performTransactionReturnsCountData(FlightReference r) throws ClientServerCallException {
        ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).performTransactionReturnsCountData(r);
    }

    @Override
    public void updateProductsBeforeSaving() {
        this.flightNode.commit();
        Iterator it = this.groupedByEquipment.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node c1n = (Node)it.next();
            Iterator it3 = c1n.getFailSafeChildIterator();
            while (it3.hasNext()) {
                Node cn = (Node)it3.next();
                int sold = (Integer)cn.getChildNamed(ReturnsCountProductComplete_.soldAmount).getValue();
                int counted = (Integer)cn.getChildNamed(ReturnsCountProductComplete_.countedAmount).getValue();
                int waste = (Integer)cn.getChildNamed(ReturnsCountProductComplete_.wasteAmount).getValue();
                int missing = (Integer)cn.getChildNamed(ReturnsCountProductComplete_.missingAmount).getValue();
                Iterator it2 = cn.getChildNamed(new String[]{"affectedThings"}).getFailSafeChildIterator();
                while (it2.hasNext()) {
                    Node rc = (Node)it2.next();
                    int load = ((ReturnsCountProductComplete)rc.getValue()).getUseRevisedDeliveredAmount() != false ? ((ReturnsCountProductComplete)rc.getValue()).getRevisedDeliveredAmount() : ((ReturnsCountProductComplete)rc.getValue()).getCalculatedDeliveredAmount();
                    int use = Math.min(load, sold);
                    ((ReturnsCountProductComplete)rc.getValue()).setSoldAmount(Integer.valueOf(use));
                    sold -= use;
                    load -= use;
                    use = Math.min(load, counted);
                    ((ReturnsCountProductComplete)rc.getValue()).setCountedAmount(Integer.valueOf(use));
                    counted -= use;
                    load -= use;
                    use = Math.min(load, waste);
                    ((ReturnsCountProductComplete)rc.getValue()).setWasteAmount(Integer.valueOf(use));
                    waste -= use;
                    load -= use;
                    use = Math.min(load, missing);
                    ((ReturnsCountProductComplete)rc.getValue()).setMissingAmount(Integer.valueOf(use));
                    missing -= use;
                    load -= use;
                }
            }
        }
    }

    @Override
    public void doSaveDocument() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReturnsCountFlightComplete r = (ReturnsCountFlightComplete)ReturnsCountEquipmentBasedSubModule.this.flightNode.getValue();
                if (r.getEquipments().isEmpty()) {
                    ViewNode rt = new ViewNode("Error");
                    rt.setValue((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "No Equipments found in current Flight."), 0L);
                    return rt;
                }
                boolean updateSeals = false;
                switch (ReturnsCountEquipmentBasedSubModule.this.getFlight().getFlightState()) {
                    case CANCELLED: 
                    case CLOSED: 
                    case DISPATCHED: {
                        updateSeals = true;
                        break;
                    }
                    case EN_ROUTE: 
                    case OPEN: 
                    case PLANNED: {
                        updateSeals = false;
                        break;
                    }
                }
                if (updateSeals) {
                    StowingToolkit.ensureSeals((ReturnsCountFlightComplete)r);
                }
                ReturnsCountEquipmentBasedSubModule.this.currentFlight = ReturnsCountEquipmentBasedSubModule.this.updateReturnsCountFlight(r);
                ReturnsCountEquipmentBasedSubModule.this.performTransactionReturnsCountData((FlightReference)r.getFlight());
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ReturnsCountEquipmentBasedSubModule.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node createView(Node node) {
        this.groupedByEquipment = new ViewNode("");
        ViewNode all = new ViewNode("");
        this.groupedByEquipment.addChild((Node)all, 0L);
        HashMap<Object, ViewNode> equipments = new HashMap<Object, ViewNode>();
        Iterator it = node.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node nn = (Node)it.next();
            ViewNode n2 = (ViewNode)equipments.get(nn.getValue());
            if (n2 == null) {
                n2 = new ViewNode("");
                n2.setValue(nn.getValue(), 0L);
                equipments.put(nn.getValue(), n2);
                this.groupedByEquipment.addChild((Node)n2, 0L);
            }
            HashMap<ProductComplete, Node> productsMap = new HashMap<ProductComplete, Node>();
            Iterator it2 = nn.getChildNamed(ReturnsCountEquipmentComplete_.deliverySpaces).getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node d = (Node)it2.next();
                Iterator it3 = d.getChildNamed(ReturnsCountDeliverySpaceComplete_.products).getFailSafeChildIterator();
                while (it3.hasNext()) {
                    Node p = (Node)it3.next();
                    Node r = (Node)productsMap.get(((ReturnsCountProductComplete)p.getValue()).getProduct());
                    if (r == null) {
                        r = new Node();
                        ReturnsCountProductComplete prod = new ReturnsCountProductComplete();
                        prod.setClientOId(Long.valueOf(ADTO.getNextId()));
                        prod.setCrewPrice(((ReturnsCountProductComplete)p.getValue()).getCrewPrice());
                        prod.setArticle(((ReturnsCountProductComplete)p.getValue()).getArticle());
                        prod.setArticleQuantity(new QuantityComplete(((ReturnsCountProductComplete)p.getValue()).getArticleQuantity()));
                        prod.setConversionFactor(((ReturnsCountProductComplete)p.getValue()).getConversionFactor());
                        prod.setDeliverySpace(((ReturnsCountProductComplete)p.getValue()).getDeliverySpace());
                        prod.setProduct(((ReturnsCountProductComplete)p.getValue()).getProduct());
                        r.setValue((Object)prod, 0L);
                        ViewNode allAffectedThings = new ViewNode("affectedThings");
                        r.addChild((Node)allAffectedThings, 0L);
                        productsMap.put(((ReturnsCountProductComplete)p.getValue()).getProduct(), r);
                    }
                    ((ReturnsCountProductComplete)r.getValue()).setCalculatedDeliveredAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getCalculatedDeliveredAmount() + ((ReturnsCountProductComplete)p.getValue()).getCalculatedDeliveredAmount()));
                    ((ReturnsCountProductComplete)r.getValue()).setComplementarySalesAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getComplementarySalesAmount() + ((ReturnsCountProductComplete)p.getValue()).getComplementarySalesAmount()));
                    ((ReturnsCountProductComplete)r.getValue()).setCountedAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getCountedAmount() + ((ReturnsCountProductComplete)p.getValue()).getCountedAmount()));
                    ((ReturnsCountProductComplete)r.getValue()).setCrewSalesAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getCrewSalesAmount() + ((ReturnsCountProductComplete)p.getValue()).getCrewSalesAmount()));
                    ((ReturnsCountProductComplete)r.getValue()).setDiscountAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getDiscountAmount() + ((ReturnsCountProductComplete)p.getValue()).getDiscountAmount()));
                    ((ReturnsCountProductComplete)r.getValue()).setMachineSalesAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getMachineSalesAmount() + ((ReturnsCountProductComplete)p.getValue()).getMachineSalesAmount()));
                    ((ReturnsCountProductComplete)r.getValue()).setMachineSoldAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getMachineSoldAmount() + ((ReturnsCountProductComplete)p.getValue()).getMachineSoldAmount()));
                    ((ReturnsCountProductComplete)r.getValue()).setMissingAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getMissingAmount() + ((ReturnsCountProductComplete)p.getValue()).getMissingAmount()));
                    ((ReturnsCountProductComplete)r.getValue()).setRevisedDeliveredAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getRevisedDeliveredAmount() + ((ReturnsCountProductComplete)p.getValue()).getRevisedDeliveredAmount()));
                    ((ReturnsCountProductComplete)r.getValue()).setSoldAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getSoldAmount() + ((ReturnsCountProductComplete)p.getValue()).getSoldAmount()));
                    ((ReturnsCountProductComplete)r.getValue()).setWasteAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getWasteAmount() + ((ReturnsCountProductComplete)p.getValue()).getWasteAmount()));
                    ViewNode allAffectedThings = (ViewNode)r.getChildNamed(new String[]{"affectedThings"});
                    Node pr = INodeCreator.getDefaultImpl().getNode4DTO(p.getValue(), false, true);
                    allAffectedThings.addChild(pr, 0L);
                    all.addChild(r, 0L);
                    n2.addChild(r, 0L);
                }
            }
        }
        return this.groupedByEquipment;
    }
}

