/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.flight.seals;

import ch.icit.pegasus.client.converter.ColorConverter;
import ch.icit.pegasus.client.converter.SealTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.search.GalleyEquipmentSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.tracking.EquipmentSealsComplete;
import ch.icit.pegasus.server.core.dtos.tracking.FlightSealsComplete;
import ch.icit.pegasus.server.core.dtos.tracking.SealComplete;
import ch.icit.pegasus.server.core.dtos.tracking.SealComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SealToolComponent
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private final FlightLight flightLight;
    private Node<FlightSealsComplete> seals;
    private Table2 table;
    private boolean isLoadingRemains = false;

    public SealToolComponent(FlightLight flightLight) {
        super(false, false);
        this.flightLight = flightLight;
        this.getViewContainer().setLayout(new Layout());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        this.createComponents();
        this.isLoadingRemains = true;
        this.popup.setOkButtonText(Words.SAVE);
        this.removeInheritedComponents();
        this.ensureAnimation(Words.LOAD_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                GalleyEquipmentSearchConfiguration g = new GalleyEquipmentSearchConfiguration();
                g.setFlight(new FlightReference(SealToolComponent.this.flightLight.getId()));
                SealToolComponent.this.seals = INodeCreator.getDefaultImpl().getNode4DTO((Object)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlightSeals(g).getValue(), false, false);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ColorComplete.class);
                return SealToolComponent.this.seals;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SealToolComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void remoteObjectLoaded(Node node) {
        if (this.isLoadingRemains) {
            this.removeAnimation(false);
            this.createInners();
            this.table.getModel().setNode(this.createSealList());
            this.isLoadingRemains = false;
        } else {
            super.remoteObjectLoaded(node);
        }
    }

    private Node createSealList() {
        ViewNode node = new ViewNode("seals");
        for (EquipmentSealsComplete equipmentSealsComplete : ((FlightSealsComplete)this.seals.getValue()).getEquipments()) {
            for (Map.Entry entry : equipmentSealsComplete.getSeals().entrySet()) {
                for (SealComplete sealComplete : (List)entry.getValue()) {
                    Node nSeal = INodeCreator.getDefaultImpl().getNode4DTO((Object)sealComplete, true, false);
                    node.addChild(nSeal, 0L);
                }
            }
        }
        return node;
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.table != null) {
            this.table.setVisible(false);
        }
    }

    private void createInners() {
        this.table = new Table2(false, Words.ADD, true, false);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.TYPE, null, null, null, "", 150, 150, 150));
        columns.add(new TableColumnInfo(Words.COLOR, null, null, null, "", 150, 150, 150));
        columns.add(new TableColumnInfo(Words.SEAL_NO, null, null, null, "", 150, Integer.MAX_VALUE, 150));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(1.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.getViewContainer().add(this.table);
    }

    @Override
    public String getTitleString() {
        return WordsToolkit.toUpperCase((String)Words.ARTICLE_NAME);
    }

    @Override
    protected String getFinishedText() {
        return Words.DATA_SAVED;
    }

    @Override
    protected String getProgressText() {
        if (this.isLoadingRemains) {
            return Words.LOAD_DATA;
        }
        return Words.SAVE_DATA;
    }

    @Override
    public String getTitleValue() {
        return this.flightLight.getOutboundCode();
    }

    @Override
    public boolean withSecondSeparator() {
        return true;
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            this.popup.hidePopUp(new Object[0]);
        } else if (isOK == PopupAction.OK_FOREGROUND) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    SealToolComponent.this.ensureAnimation();
                    SealToolComponent.this.setEnabled(false);
                    SealToolComponent.this.seals.commitThis();
                    for (Table2RowPanel row : SealToolComponent.this.table.getRows()) {
                        row.getModel().getNode().commitThis();
                    }
                    FlightSealsComplete sealsComplete = (FlightSealsComplete)SealToolComponent.this.seals.getValue();
                    ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).updateSeals(sealsComplete);
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            SealToolComponent.this.popup.hidePopUp(new Object[0]);
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog("Error while saving", (Component)SealToolComponent.this);
                            SealToolComponent.this.popup.hidePopUp(new Object[0]);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel type;
        private ComboBox color;
        private TextField sealNo;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.type = new TextLabel(m.getNode().getChildNamed(SealComplete_.type), ConverterRegistry.getConverter(SealTypeConverter.class));
            this.color = new ComboBox(m.getNode().getChildNamed(SealComplete_.color), NodeToolkit.getAffixList(ColorComplete.class), ConverterRegistry.getConverter(ColorConverter.class));
            this.sealNo = new TextField(m.getNode().getChildNamed(SealComplete_.sealNumber), TextFieldType.INT);
            this.setLayout(new Layout());
            this.add(this.type);
            this.add(this.color);
            this.add(this.sealNo);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.type.kill();
            this.color.kill();
            this.sealNo.kill();
            this.type = null;
            this.color = null;
            this.sealNo = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.type.setEnabled(isEnabled);
            this.color.setEnabled(isEnabled);
            this.sealNo.setEnabled(isEnabled);
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.type.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.type.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.type.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.color.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.color.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.color.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.color.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.sealNo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.sealNo.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.sealNo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.sealNo.getPreferredSize().getHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int cy = SealToolComponent.this.layoutInheritedComponents(parent);
            if (SealToolComponent.this.table != null) {
                SealToolComponent.this.table.setLocation(SealToolComponent.this.border, SealToolComponent.this.border);
                SealToolComponent.this.table.setSize(parent.getWidth() - 2 * SealToolComponent.this.border, parent.getHeight() - SealToolComponent.this.border);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SealToolComponent.this.getInheritedComponentsHeight() + SealToolComponent.this.border;
            return new Dimension(0, h);
        }
    }
}

