/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.deliveryinstruction;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.ChoiceCalculationStrategyConverter;
import ch.icit.pegasus.client.converter.EquipmentFillStrategyEConverter;
import ch.icit.pegasus.client.converter.FillStrategyConverter;
import ch.icit.pegasus.client.converter.GalleyFillStrategyEConverter;
import ch.icit.pegasus.client.converter.RoundingStrategyEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.deliveryinstruction.LoadingInstructionDetailsView;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.deliveryinstruction.utils.ALaCarteConfigurationPopup;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.deliveryinstruction.utils.SPMLConfigurationPopup;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.FadeInOutPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.FadebleShape;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.focus.CustomFocusCyclePolicy;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.toolkits.LogicToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.APassengerSetComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.AbsolutQuantityCalculationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ChoiceCalculationStrategyE;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.DeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.EquipmentFillStrategyE;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.GalleyFillStrategyE;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.LinearFunctionComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.LinearFunctionSetQuantityCalculationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.PassengerSetComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.PassengerSetTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ServiceDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.StepComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.StepFunctionQuantityCalculationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliveryInstructionComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.RoundingStrategyE;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FillStrategyTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FillOptionDetailsView
extends FadeInOutPanel
implements NodeListener,
ItemListener,
ButtonListener {
    private static final long serialVersionUID = 1L;
    static Logger log = LoggerFactory.getLogger(FillOptionDetailsView.class);
    private TitledItem<ComboBox> instructionCB;
    private TitledItem<ComboBox> choiceCalculationCB;
    private TitledItem<ComboBox> stratAmogGalleyCB;
    private TitledItem<ComboBox> stratWithinGalleyCB;
    private TitledItem<ComboBox> fillInStrategyCB;
    private TitledItem<ComboBox> roundStratCB;
    private TitledItem<EditButton> configSPMLDistribution;
    private TitledItem<EditButton> configALACARTEDistribution;
    private LoadingInstructionDetailsView loadingInstructionPanel;
    private final FadebleShape shape;
    private int horizontalBorder = 10;
    private final int verticalBorder = 1;
    private final boolean possibleValuesInited = false;
    private int state;
    public static final int STATE_DISABLED = 3;
    public static final int STATE_READY = 5;
    private PegasusSubModule pegasus;
    private Node<DeliverableComplete> node;

    public FillOptionDetailsView(PegasusSubModule pegasus, Node<DeliverableComplete> node, LoadingInstructionDetailsView loadingInstr) {
        super(true);
        this.pegasus = pegasus;
        this.horizontalBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_details_horizontal_border"));
        this.node = node;
        this.setHasBackground(true);
        this.loadingInstructionPanel = loadingInstr;
        this.setProgress(1.0f);
        this.setTitleString(Words.FILL_OPTIONS);
        this.generateComponents();
        this.changeState(null);
        this.shape = new FadebleShape(false);
        this.instructionCB.setInnerGap(-3);
        this.choiceCalculationCB.setInnerGap(-3);
        this.stratAmogGalleyCB.setInnerGap(-3);
        this.stratWithinGalleyCB.setInnerGap(-3);
        this.fillInStrategyCB.setInnerGap(-3);
        this.roundStratCB.setInnerGap(-3);
        this.configSPMLDistribution.setIgnorePrefWidth(true);
        this.configALACARTEDistribution.setIgnorePrefWidth(true);
        this.instructionCB.getFader().setPermanent(true);
        this.choiceCalculationCB.getFader().setPermanent(true);
        this.stratAmogGalleyCB.getFader().setPermanent(true);
        this.stratWithinGalleyCB.getFader().setPermanent(true);
        this.fillInStrategyCB.getFader().setPermanent(true);
        this.roundStratCB.getFader().setPermanent(true);
        this.shape.getFader().setPermanent(true);
        this.configSPMLDistribution.getFader().setPermanent(true);
        this.configALACARTEDistribution.getFader().setPermanent(true);
        float[] dash = new float[]{AttributesConverter.getFloat4String(AttributeLoader.getAttributeLoader().getAttribute("table_detailsparagraph_shape_dash")).floatValue()};
        this.shape.setShapeStroke(new BasicStroke(1.0f, 0, 0, 1.0f, dash, 0.0f));
        Color lineColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_line_color"));
        this.shape.setOutLineColor(lineColor);
        this.setLayout(new Layout());
        this.add(this.instructionCB);
        this.add(this.choiceCalculationCB);
        this.add(this.stratAmogGalleyCB);
        this.add(this.stratWithinGalleyCB);
        this.add(this.fillInStrategyCB);
        this.add(this.roundStratCB);
        this.add(this.configSPMLDistribution);
        this.add(this.configALACARTEDistribution);
        this.add(this.shape);
        this.generateShape(20, 20);
        this.setState(5);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.node != null) {
            this.node.removeNodeListenerRecursively((NodeListener)this);
        }
        this.instructionCB.kill();
        this.choiceCalculationCB.kill();
        this.stratAmogGalleyCB.kill();
        this.stratWithinGalleyCB.kill();
        this.fillInStrategyCB.kill();
        this.roundStratCB.kill();
        this.shape.kill();
        this.configSPMLDistribution.kill();
        this.configALACARTEDistribution.kill();
        this.loadingInstructionPanel = null;
        this.choiceCalculationCB = null;
        this.instructionCB = null;
        this.stratAmogGalleyCB = null;
        this.stratWithinGalleyCB = null;
        this.fillInStrategyCB = null;
        this.roundStratCB = null;
        this.configSPMLDistribution = null;
        this.configALACARTEDistribution = null;
    }

    private void generateComponents() {
        this.instructionCB = new TitledItem<ComboBox>(new ComboBox(), Words.LOAD_WITH_INSTRUCTIONS, TitledItem.TitledItemOrientation.NORTH);
        this.instructionCB.getElement().addItem(Words.FIX);
        this.instructionCB.getElement().addItem(Words.PASSENGER_RELATED);
        this.instructionCB.getElement().addItem(Words.STEP_FUNCTION);
        this.choiceCalculationCB = new TitledItem<ComboBox>(new ComboBox(null, null, ConverterRegistry.getConverter(ChoiceCalculationStrategyConverter.class)), "Choice Calculation Rule", TitledItem.TitledItemOrientation.NORTH);
        this.stratAmogGalleyCB = new TitledItem<ComboBox>(new ComboBox(null, null, ConverterRegistry.getConverter(GalleyFillStrategyEConverter.class)), Words.FILL_STRATEGY_AMONG_GALLEYS, TitledItem.TitledItemOrientation.NORTH);
        this.stratWithinGalleyCB = new TitledItem<ComboBox>(new ComboBox(null, null, ConverterRegistry.getConverter(EquipmentFillStrategyEConverter.class)), Words.FILL_STRATEGY_WITHIN_GALLEYS, TitledItem.TitledItemOrientation.NORTH);
        this.fillInStrategyCB = new TitledItem<ComboBox>(new ComboBox(null, null, ConverterRegistry.getConverter(FillStrategyConverter.class)), "FillIn Strategy", TitledItem.TitledItemOrientation.NORTH);
        this.roundStratCB = new TitledItem<ComboBox>(new ComboBox(null, null, ConverterRegistry.getConverter(RoundingStrategyEConverter.class)), Words.ROUNDING_STRATEGY, TitledItem.TitledItemOrientation.NORTH);
        this.configSPMLDistribution = new TitledItem<EditButton>(new EditButton(), "SPML Dist. Config", TitledItem.TitledItemOrientation.WEST);
        this.configALACARTEDistribution = new TitledItem<EditButton>(new EditButton(), "a la Carte Dist. Config", TitledItem.TitledItemOrientation.WEST);
        this.instructionCB.getElement().addItemListener(this);
        this.choiceCalculationCB.getElement().addItemListener(this);
        this.stratAmogGalleyCB.getElement().addItemListener(this);
        this.stratWithinGalleyCB.getElement().addItemListener(this);
        this.fillInStrategyCB.getElement().addItemListener(this);
        this.roundStratCB.getElement().addItemListener(this);
        this.configSPMLDistribution.getElement().addButtonListener(this);
        this.configALACARTEDistribution.getElement().addButtonListener(this);
        this.createFocusCycle();
    }

    private void createFocusCycle() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.instructionCB);
        if (this.stratAmogGalleyCB.isEnabled()) {
            CheckedListAdder.addToList(a, this.choiceCalculationCB);
            CheckedListAdder.addToList(a, this.stratAmogGalleyCB);
            CheckedListAdder.addToList(a, this.stratWithinGalleyCB);
            CheckedListAdder.addToList(a, this.fillInStrategyCB);
            CheckedListAdder.addToList(a, this.roundStratCB);
            CheckedListAdder.addToList(a, this.configSPMLDistribution);
            CheckedListAdder.addToList(a, this.configALACARTEDistribution);
        }
        CustomFocusCyclePolicy.revalidateFocusCyclePolicy(a, this);
    }

    private void generateShape(int w, int h) {
        GeneralPath g = new GeneralPath();
        g.moveTo(0.0f, 0.0f);
        g.lineTo(w, h);
        g.moveTo(0.0f, h);
        g.lineTo(w, 0.0f);
        this.shape.setShape(g);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(AlphaComposite.getInstance(3, this.theProgress));
        if (this.hasBackground) {
            g2.setColor(this.innerBackground);
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.arcW, this.arcH);
        }
        if (this.hasSkin) {
            this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        }
        if (this.useCliping) {
            Shape r = this.getClipingArea();
            g2.clip(r);
        }
        this.paintChildren(g2);
    }

    protected void setState(int newState) {
        if (newState != this.state) {
            switch (newState) {
                case 3: {
                    this.instructionCB.fadeOut(false);
                    this.choiceCalculationCB.fadeOut(false);
                    this.stratAmogGalleyCB.fadeOut(false);
                    this.stratWithinGalleyCB.fadeOut(false);
                    this.fillInStrategyCB.fadeOut(false);
                    this.roundStratCB.fadeOut(false);
                    this.configSPMLDistribution.fadeOut(false);
                    this.configALACARTEDistribution.fadeOut(false);
                    this.shape.fadeIn();
                    break;
                }
                case 5: {
                    this.instructionCB.fadeIn();
                    this.choiceCalculationCB.fadeIn();
                    this.stratAmogGalleyCB.fadeIn();
                    this.stratWithinGalleyCB.fadeIn();
                    this.fillInStrategyCB.fadeIn();
                    this.roundStratCB.fadeIn();
                    this.configSPMLDistribution.fadeIn();
                    this.configALACARTEDistribution.fadeIn();
                    this.shape.fadeOut(false);
                }
            }
            this.state = newState;
        }
    }

    public void setNode(Node<DeliverableComplete> node) {
        if (this.node != null) {
            this.node.removeNodeListenerRecursively((NodeListener)this);
        }
        this.node = node;
        if (this.node != null) {
            Node li = node.getChildNamed(new String[]{"quantityCalculation"});
            li.removeNodeListener((NodeListener)this);
            li.addNodeListener((NodeListener)this);
            int i = 0;
            if (li.getValue() instanceof AbsolutQuantityCalculationComplete) {
                i = 0;
            } else if (li.getValue() instanceof StepFunctionQuantityCalculationComplete) {
                i = 2;
            } else if (li.getValue() instanceof LinearFunctionSetQuantityCalculationComplete) {
                i = 1;
            }
            this.instructionCB.getElement().removeItemListener(this);
            this.instructionCB.getElement().setSelectedIndex(i);
            this.instructionCB.getElement().addItemListener(this);
            this.stratAmogGalleyCB.getElement().refreshPossibleValues(NodeToolkit.getAffixList(GalleyFillStrategyE.class));
            this.stratWithinGalleyCB.getElement().refreshPossibleValues(NodeToolkit.getAffixList(EquipmentFillStrategyE.class));
            this.fillInStrategyCB.getElement().refreshPossibleValues(NodeToolkit.getAffixList(FillStrategyTypeComplete.class));
            this.roundStratCB.getElement().refreshPossibleValues(NodeToolkit.getAffixList(RoundingStrategyE.class));
            this.choiceCalculationCB.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ChoiceCalculationStrategyE.class));
            Node di = node.getChildNamed(new String[]{"deliveryInstruction"});
            this.stratAmogGalleyCB.getElement().setNode(di.getChildNamed(new String[]{"galleyFillStrategy"}));
            this.stratWithinGalleyCB.getElement().setNode(di.getChildNamed(new String[]{"equipmentFillStrategy"}));
            this.fillInStrategyCB.getElement().setNode(di.getChildNamed(new String[]{"fillInStrategy"}));
            this.roundStratCB.getElement().setNode(di.getChildNamed(new String[]{"roundingStrategy"}));
            this.choiceCalculationCB.getElement().setNode(di.getChildNamed(new String[]{"choiceCalculationStrategy"}));
            this.changeState(li);
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean enable = isEnabled && !this.pegasus.isLocked();
        super.setEnabled(enable);
        this.instructionCB.setEnabled(enable);
        boolean en = true;
        this.changeEnableStateOfCombos(enable && en, isEnabled);
    }

    @Override
    public void layoutPanel(int w, int h, boolean resize) {
    }

    @Override
    public void movePanel(int x, int y, boolean smooth) {
    }

    private void changeEnableStateOfCombos(boolean enable, boolean isEnabled) {
        this.stratAmogGalleyCB.setEnabled(enable);
        this.fillInStrategyCB.setEnabled(enable);
        this.stratWithinGalleyCB.setEnabled(enable);
        this.roundStratCB.setEnabled(enable);
        this.choiceCalculationCB.setEnabled(enable);
        this.configSPMLDistribution.setEnabled(isEnabled);
        this.configALACARTEDistribution.setEnabled(isEnabled);
    }

    private void changeState(Node d) {
        if (d == null) {
            this.instructionCB.setEnabled(false);
            this.changeEnableStateOfCombos(false, false);
            return;
        }
        this.instructionCB.setEnabled(true);
        if (d.getValue() instanceof AbsolutQuantityCalculationComplete) {
            this.changeEnableStateOfCombos(true, true);
            this.loadingInstructionPanel.setState(3);
        } else if (d.getValue() instanceof LinearFunctionSetQuantityCalculationComplete) {
            this.changeEnableStateOfCombos(true, true);
            this.loadingInstructionPanel.setFormulaState(3);
            this.loadingInstructionPanel.setState(5);
        } else if (d.getValue() instanceof StepFunctionQuantityCalculationComplete) {
            this.changeEnableStateOfCombos(true, true);
            this.loadingInstructionPanel.setFormulaState(5);
            this.loadingInstructionPanel.setState(5);
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void valueChanged(Node<?> node) {
        if (node.getName().equals("quantityCalculation")) {
            Node<?> d = node;
            this.changeState(d);
        }
    }

    private void writeValues(int index) {
        switch (index) {
            case 0: {
                if (this.node != null) {
                    AbsolutQuantityCalculationComplete dto = null;
                    Object t = this.instructionCB.getElement().getSelectedItem();
                    if (t.equals(Words.FIX)) {
                        dto = new AbsolutQuantityCalculationComplete();
                        int amount = LogicToolkit.getTotalAmount((Node<DeliveryInstructionComplete>)this.node.getChildNamed(new String[]{"deliveryInstruction"}));
                        dto.setAmount(Integer.valueOf(amount));
                    } else if (t.equals(Words.PASSENGER_RELATED)) {
                        dto = new LinearFunctionSetQuantityCalculationComplete();
                        LinearFunctionComplete f = new LinearFunctionComplete();
                        f.setFactor(Double.valueOf(1.0));
                        f.setConstant(Integer.valueOf(0));
                        f.setPaxKeySets(this.createPaxSet());
                        ((LinearFunctionSetQuantityCalculationComplete)dto).getFunctions().add(f);
                    } else if (t.equals(Words.STEP_FUNCTION)) {
                        dto = new StepFunctionQuantityCalculationComplete();
                        ((StepFunctionQuantityCalculationComplete)dto).setPaxKeySets(this.createPaxSet());
                        StepComplete s = new StepComplete();
                        s.setQuantity(Integer.valueOf(1));
                        s.setUpperLimit(Integer.valueOf(100));
                        ((StepFunctionQuantityCalculationComplete)dto).getSteps().add(s);
                    } else {
                        throw new IllegalStateException("Unknown Calculation Type found");
                    }
                    dto.setClientOId(Long.valueOf(ADTO.getNextId()));
                    long currentID = System.currentTimeMillis();
                    Node nLi = INodeCreator.getDefaultImpl().getNode4DTO((Object)dto, false, false);
                    nLi.setName("quantityCalculation");
                    Node li = this.node.getChildNamed(new String[]{"quantityCalculation"});
                    this.node.removeChild(li, currentID);
                    this.node.addChild(nLi, currentID);
                }
                this.createFocusCycle();
                break;
            }
            default: {
                log.trace("bad STATE REACHED!!!!");
            }
        }
    }

    private List<APassengerSetComplete> createPaxSet() {
        DeliverableComplete delivery;
        ADTO aDTO = (ADTO)this.node.getChildNamed(new String[]{"deliveryInstruction"}).getValue();
        if (aDTO instanceof DeliveryInstructionComplete && (delivery = (DeliverableComplete)this.node.getValue()) instanceof ServiceDeliverableComplete) {
            ServiceDeliverableComplete d = (ServiceDeliverableComplete)delivery;
            CabinClassComplete cc = d.getLoadingGroup().getContainingService().getCabinClass();
            Object pax = d.getLoadingGroup().getContainingService() instanceof CateringServiceScheduleVariantComplete ? new PassengerSetTemplateComplete() : new PassengerSetComplete();
            pax.setPaxClass(cc);
            ArrayList<APassengerSetComplete> paxs = new ArrayList<APassengerSetComplete>();
            paxs.add((APassengerSetComplete)pax);
            return paxs;
        }
        return null;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        if (e.getSource() == this.instructionCB.getElement()) {
            this.writeValues(0);
        }
        if (this.node != null) {
            this.changeState(this.node.getChildNamed(new String[]{"quantityCalculation"}));
        }
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    public void resetTable() {
        this.setNode(null);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.configSPMLDistribution.getElement() && this.node != null) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(source, true, true, "SPML Distribution Order");
            popUp.setView(new SPMLConfigurationPopup(this.pegasus, (Node<DeliveryInstructionComplete>)this.node.getChildNamed(new String[]{"deliveryInstruction"})));
            popUp.showPopUp(x, y, 450, 300, null, source, PopupType.FRAMELESS);
        } else if (source == this.configALACARTEDistribution.getElement() && this.node != null) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(source, true, true, "a la Carte Distribution Order");
            popUp.setView(new ALaCarteConfigurationPopup(this.pegasus, (Node<DeliveryInstructionComplete>)this.node.getChildNamed(new String[]{"deliveryInstruction"})));
            popUp.showPopUp(x, y, 450, 300, null, source, PopupType.FRAMELESS);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            FillOptionDetailsView.this.layoutTitle(parent);
            int currentY = FillOptionDetailsView.this.getTitleHeight();
            FillOptionDetailsView.this.instructionCB.setLocation(FillOptionDetailsView.this.horizontalBorder, ++currentY);
            FillOptionDetailsView.this.instructionCB.setSize(w - 2 * FillOptionDetailsView.this.horizontalBorder, (int)FillOptionDetailsView.this.instructionCB.getPreferredSize().getHeight());
            FillOptionDetailsView.this.choiceCalculationCB.setLocation(FillOptionDetailsView.this.horizontalBorder, currentY += FillOptionDetailsView.this.instructionCB.getHeight() + 1);
            FillOptionDetailsView.this.choiceCalculationCB.setSize(w - 2 * FillOptionDetailsView.this.horizontalBorder, (int)FillOptionDetailsView.this.choiceCalculationCB.getPreferredSize().getHeight());
            FillOptionDetailsView.this.stratAmogGalleyCB.setLocation(FillOptionDetailsView.this.horizontalBorder, currentY += FillOptionDetailsView.this.choiceCalculationCB.getHeight() + 1);
            FillOptionDetailsView.this.stratAmogGalleyCB.setSize(w - 2 * FillOptionDetailsView.this.horizontalBorder, (int)FillOptionDetailsView.this.stratAmogGalleyCB.getPreferredSize().getHeight());
            FillOptionDetailsView.this.stratWithinGalleyCB.setLocation(FillOptionDetailsView.this.horizontalBorder, currentY += FillOptionDetailsView.this.stratAmogGalleyCB.getHeight() + 1);
            FillOptionDetailsView.this.stratWithinGalleyCB.setSize(w - 2 * FillOptionDetailsView.this.horizontalBorder, (int)FillOptionDetailsView.this.stratWithinGalleyCB.getPreferredSize().getHeight());
            FillOptionDetailsView.this.fillInStrategyCB.setLocation(FillOptionDetailsView.this.horizontalBorder, currentY += FillOptionDetailsView.this.stratWithinGalleyCB.getHeight() + 1);
            FillOptionDetailsView.this.fillInStrategyCB.setSize(w - 2 * FillOptionDetailsView.this.horizontalBorder, (int)FillOptionDetailsView.this.fillInStrategyCB.getPreferredSize().getHeight());
            FillOptionDetailsView.this.roundStratCB.setLocation(FillOptionDetailsView.this.horizontalBorder, currentY += FillOptionDetailsView.this.fillInStrategyCB.getHeight() + 1);
            FillOptionDetailsView.this.roundStratCB.setSize(w - 2 * FillOptionDetailsView.this.horizontalBorder, (int)FillOptionDetailsView.this.roundStratCB.getPreferredSize().getHeight());
            FillOptionDetailsView.this.configSPMLDistribution.setLocation(FillOptionDetailsView.this.horizontalBorder, currentY += FillOptionDetailsView.this.roundStratCB.getHeight() + 1);
            FillOptionDetailsView.this.configSPMLDistribution.setSize(w - 2 * FillOptionDetailsView.this.horizontalBorder, (int)FillOptionDetailsView.this.configSPMLDistribution.getPreferredSize().getHeight());
            FillOptionDetailsView.this.configALACARTEDistribution.setLocation(FillOptionDetailsView.this.horizontalBorder, currentY += FillOptionDetailsView.this.configSPMLDistribution.getHeight() + 1);
            FillOptionDetailsView.this.configALACARTEDistribution.setSize(w - 2 * FillOptionDetailsView.this.horizontalBorder, (int)FillOptionDetailsView.this.configALACARTEDistribution.getPreferredSize().getHeight());
            FillOptionDetailsView.this.shape.setLocation(2, FillOptionDetailsView.this.getTitleHeight());
            FillOptionDetailsView.this.shape.setSize(w - 4, parent.getHeight() - (FillOptionDetailsView.this.getTitleHeight() + 2));
            FillOptionDetailsView.this.generateShape(FillOptionDetailsView.this.shape.getWidth(), FillOptionDetailsView.this.shape.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int currentY = 2;
            currentY += FillOptionDetailsView.this.getTitleHeight();
            ++currentY;
            currentY = (int)((double)currentY + (FillOptionDetailsView.this.instructionCB.getPreferredSize().getHeight() + 1.0));
            currentY = (int)((double)currentY + (FillOptionDetailsView.this.choiceCalculationCB.getPreferredSize().getHeight() + 1.0));
            currentY = (int)((double)currentY + (FillOptionDetailsView.this.stratAmogGalleyCB.getPreferredSize().getHeight() + 1.0));
            currentY = (int)((double)currentY + (FillOptionDetailsView.this.stratWithinGalleyCB.getPreferredSize().getHeight() + 1.0));
            currentY = (int)((double)currentY + (FillOptionDetailsView.this.fillInStrategyCB.getPreferredSize().getHeight() + 1.0));
            currentY = (int)((double)currentY + (FillOptionDetailsView.this.roundStratCB.getPreferredSize().getHeight() + 1.0));
            currentY = (int)((double)currentY + (FillOptionDetailsView.this.configSPMLDistribution.getPreferredSize().getHeight() + 1.0));
            currentY = (int)((double)currentY + (FillOptionDetailsView.this.configALACARTEDistribution.getPreferredSize().getHeight() + 1.0));
            return new Dimension(10, currentY += FillOptionDetailsView.this.horizontalBorder);
        }
    }
}

