/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.deliveryinstruction;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.FormattedDoubleConverter1Decimals;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.formatter.FormatterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.deliveryinstruction.utils.StepSorter;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.popuppanels.PaxKeyChooserPanel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.FadeInOutPanel;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.EditPaxButton;
import ch.icit.pegasus.client.gui.utils.buttons.LinearFunctionSign;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.icons.ArrowConnectorIcon;
import ch.icit.pegasus.client.gui.utils.numericstepper.NumericStepper;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.ViewNodeDataChangeHandler;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.toolkits.LogicToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.APassengerSetComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.AbsolutQuantityCalculationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ArticleDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ArticleDeliverableLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.DeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.EquipmentTemplateDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.LinearFunctionComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.LinearFunctionSetQuantityCalculationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.LinearFunctionSetQuantityCalculationComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.PassengerSetComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.PassengerSetTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ProductDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ServiceDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.StepComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.StepFunctionQuantityCalculationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliveryInstructionComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.RoundingStrategyE;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.ALoadingGroupComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServicePartChoiceCalculationTypeE;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServicePartChoiceComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServicePartComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.RoundingToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class LoadingInstructionDetailsView
extends FadeInOutPanel
implements NodeListener,
ButtonListener {
    private static final long serialVersionUID = 1L;
    private DecimalFormat formatTotal;
    private Node<DeliverableComplete> node;
    private Node formulaList;
    private int state;
    public static final int STATE_DISABLED = 3;
    public static final int STATE_READY = 5;
    private int formulaState;
    public static final int STATE_PAX_FORMULA = 3;
    public static final int STATE_STEP_FORMULA = 5;
    private Table2 table;
    private TitledItem<TextField> maxLoad;
    private CheckBox box;
    private TextLabel fixTotal;
    private InnerPanel c;
    private PegasusSubModule pegasus;
    private ViewNode<String> totalView;

    public LoadingInstructionDetailsView(Node stowingList, PegasusSubModule peg) {
        super(true);
        this.pegasus = peg;
        this.box = new CheckBox();
        this.box.addButtonListener(this);
        this.maxLoad = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.INT), Words.MAX_LOAD_PER_LEG, TitledItem.TitledItemOrientation.EAST);
        this.maxLoad.setEnabled(false);
        this.formatTotal = FormatterRegistry.getDecimalFormat(Words.LOADINGINSTRUCTION_TOTAL_AMOUNT_PATTERN);
        this.c = new InnerPanel();
        this.c.getFader().setPermanent(true);
        this.c.add(this.box);
        this.c.add(this.maxLoad);
        this.setHasBackground(true);
        this.setTitleString(Words.LOADING_INSTRUCTIONS);
        this.setProgress(1.0f);
        this.table = new Table2(true, Words.ADD_FORMULA, false, false);
        this.table.setHasLastLine(true);
        this.table.enableAdditionalComponent(this.c);
        this.table.setRequestFocusOnAdd(true);
        this.table.setProgress(1.0f);
        this.totalView = new ViewNode("TotalView");
        this.totalView.setChangeHandler((ViewNodeDataChangeHandler)new ViewNodeDataChangeHandler<String>(){

            public String calculateNewValue(ViewNode node) {
                int nV = 0;
                if (LoadingInstructionDetailsView.this.formulaState == 3) {
                    Node nn = node.getChildNamed(new String[]{"roundingStrategy"});
                    RoundingStrategyE rStrat = RoundingStrategyE.STANDARD;
                    if (nn != null && nn.getValue() != null) {
                        rStrat = (RoundingStrategyE)nn.getValue();
                    }
                    Iterator it = node.getAllChildsNamed("rowPreview");
                    int totalAmount = 0;
                    while (it.hasNext()) {
                        Node n = (Node)it.next();
                        double d = (Double)n.getValue();
                        d = RoundingToolkit.round((Double)d, (RoundingStrategyE)rStrat);
                        totalAmount = (int)((double)totalAmount + d);
                    }
                    nV = totalAmount;
                } else if (LoadingInstructionDetailsView.this.formulaState == 5) {
                    Iterator it = node.getAllChildsNamed("paxView");
                    int paxCount = -1;
                    int lastValue = 0;
                    boolean found = false;
                    while (it.hasNext() && !found) {
                        Node step;
                        Node steV = (Node)it.next();
                        if (paxCount == -1) {
                            paxCount = (Integer)steV.getValue();
                        }
                        if ((step = steV.getChildNamed(new String[]{"pax"})) == null) continue;
                        Node upp = step.getChildNamed(new String[]{"upperLimit"});
                        if (paxCount >= lastValue && paxCount < (Integer)upp.getValue()) {
                            found = true;
                            nV = (Integer)step.getChildNamed(new String[]{"quantity"}).getValue();
                        }
                        lastValue = (Integer)upp.getValue();
                    }
                }
                String t = LoadingInstructionDetailsView.this.formatTotal.format(nV);
                return Words.TOTAL + " " + t + "    *Service amount can differ if uses Fix/Steps in MealPlan.";
            }
        });
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                LoadingInstructionDetailsView.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                switch (LoadingInstructionDetailsView.this.formulaState) {
                    case 3: {
                        LinearFunctionComplete f = new LinearFunctionComplete();
                        f.setClientOId(Long.valueOf(ADTO.getNextId()));
                        f.setPaxKeySets(LoadingInstructionDetailsView.this.createPaxSet());
                        f.setIsAdd(Boolean.valueOf(true));
                        f.setConstant(Integer.valueOf(0));
                        f.setFactor(Double.valueOf(1.0));
                        Node fn = INodeCreator.getDefaultImpl().getNode4DTO((Object)f, true, false);
                        LoadingInstructionDetailsView.this.formulaList.addChild(fn, System.currentTimeMillis());
                        break;
                    }
                    case 5: {
                        Integer uL;
                        StepComplete s = new StepComplete();
                        s.setClientOId(Long.valueOf(ADTO.getNextId()));
                        Table2RowPanel lastRow = LoadingInstructionDetailsView.this.table.getRowAt(LoadingInstructionDetailsView.this.table.getRowCount() - 1);
                        Integer n = uL = Integer.valueOf(lastRow != null ? (Integer)lastRow.getModel().getNode().getChildNamed(new String[]{"upperLimit"}).getValue() : 0);
                        Integer n2 = uL = Integer.valueOf(uL + 1);
                        Integer qL = lastRow != null ? (Integer)lastRow.getModel().getNode().getChildNamed(new String[]{"quantity"}).getValue() : 0;
                        s.setUpperLimit(uL);
                        s.setQuantity(qL);
                        Node sn = INodeCreator.getDefaultImpl().getNode4DTO((Object)s, true, false);
                        LoadingInstructionDetailsView.this.formulaList.addChild(sn, System.currentTimeMillis());
                    }
                }
                LoadingInstructionDetailsView.this.revalidate();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(0.4, 0.0, Words.PASSENGERS, null, null, null, "", 50, 50, 50));
        columns.add(new TableColumnInfo(0.0, 0.0, "", null, null, null, "", 20, 20, 20));
        columns.add(new TableColumnInfo(0.2, 0.0, Words.FACTOR, null, null, null, "", 50, 50, 50));
        columns.add(new TableColumnInfo(0.0, 0.0, "", null, null, null, "", 20, 20, 20));
        columns.add(new TableColumnInfo(0.2, 0.0, Words.RESERVE, null, null, null, "", 50, 50, 50));
        columns.add(new TableColumnInfo(0.0, 0.0, "", null, null, null, "", 20, 20, 20));
        columns.add(new TableColumnInfo(0.2, 0.0, Words.PREVIEW, null, null, null, "", 50, 50, 50));
        this.table.setModel(new Table2Model(columns, model -> {
            if (model.getNode().getValue() instanceof LinearFunctionComplete) {
                return new FormulaRow(model);
            }
            if (model.getNode().getValue() instanceof StepComplete) {
                return new StepRow(model);
            }
            return null;
        }));
        this.table.getFader().setPermanent(true);
        this.table.getModel().allInitiated();
        this.table.setSortable(false);
        this.fixTotal = new TextLabel();
        this.fixTotal.setShouldValidate(false);
        this.fixTotal.getFader().setPermanent(true);
        this.setProgress(1.0f);
        this.setLayout(new Layout());
        this.add(this.table);
        this.add(this.fixTotal);
        this.setState(3);
    }

    protected List<APassengerSetComplete> createPaxSet() {
        DeliverableComplete delivery;
        ADTO aDTO = (ADTO)this.node.getChildNamed(new String[]{"deliveryInstruction"}).getValue();
        if (aDTO instanceof DeliveryInstructionComplete && (delivery = (DeliverableComplete)this.node.getValue()) instanceof ServiceDeliverableComplete) {
            ServiceDeliverableComplete d = (ServiceDeliverableComplete)delivery;
            CabinClassComplete cc = d.getLoadingGroup().getContainingService().getCabinClass();
            Object pax = d.getLoadingGroup().getContainingService() instanceof CateringServiceScheduleVariantComplete ? new PassengerSetTemplateComplete() : new PassengerSetComplete();
            pax.setPaxClass(cc);
            ArrayList<APassengerSetComplete> paxs = new ArrayList<APassengerSetComplete>();
            paxs.add((APassengerSetComplete)pax);
            return paxs;
        }
        return new ArrayList<APassengerSetComplete>();
    }

    private ViewNode<String> getTotalView() {
        return this.totalView;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.table = null;
        this.formatTotal = null;
        this.fixTotal.kill();
        this.fixTotal = null;
        if (this.box != null) {
            this.box.kill();
        }
        if (this.maxLoad != null) {
            this.maxLoad.kill();
        }
        if (this.node != null) {
            this.node.getChildNamed(new String[]{"quantityCalculation"}).removeNodeListener((NodeListener)this);
            this.node.removeNodeListener((NodeListener)this);
        }
        this.node = null;
        if (this.formulaList != null) {
            this.formulaList.removeNodeListener((NodeListener)this);
        }
        this.formulaList = null;
        this.pegasus = null;
        this.totalView.kill();
        this.totalView = null;
        this.maxLoad = null;
        this.box = null;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(AlphaComposite.getInstance(3, this.theProgress));
        if (this.hasBackground) {
            g2.setColor(this.innerBackground);
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.arcW, this.arcH);
        }
        if (this.hasSkin) {
            this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        }
        this.paintChildren(g2);
    }

    public void setFormulaState(int state) {
        if (state != this.formulaState) {
            this.formulaState = state;
            switch (this.formulaState) {
                case 3: {
                    this.table.setButtonText(Words.ADD_FORMULA);
                    this.table.getModel().getColumn(0).setColumnName(Words.PASSENGERS);
                    this.table.getModel().getColumn(1).setColumnName("");
                    this.table.getModel().getColumn(2).setColumnName(Words.FACTOR);
                    this.table.getModel().getColumn(3).setColumnName("");
                    this.table.getModel().getColumn(4).setColumnName(Words.RESERVE);
                    this.table.getModel().getColumn(5).setColumnName("");
                    this.table.getModel().getColumn(6).setColumnName(Words.PREVIEW);
                    this.table.getModel().getColumn(0).setxExpand(0.4);
                    this.table.getModel().getColumn(1).setxExpand(0.0);
                    this.table.getModel().getColumn(2).setxExpand(0.2);
                    this.table.getModel().getColumn(3).setxExpand(0.0);
                    this.table.getModel().getColumn(4).setxExpand(0.2);
                    this.table.getModel().getColumn(5).setxExpand(0.0);
                    this.table.getModel().getColumn(6).setxExpand(0.2);
                    this.table.getModel().getColumn(0).setMaxWidth(50);
                    this.table.getModel().getColumn(0).setMinWidth(50);
                    this.table.getModel().getColumn(0).setPreferredWidth(50);
                    this.table.getModel().getColumn(1).setMaxWidth(20);
                    this.table.getModel().getColumn(1).setMinWidth(20);
                    this.table.getModel().getColumn(1).setPreferredWidth(20);
                    this.table.getModel().getColumn(2).setMaxWidth(45);
                    this.table.getModel().getColumn(2).setMinWidth(45);
                    this.table.getModel().getColumn(2).setPreferredWidth(45);
                    this.table.getModel().getColumn(3).setMaxWidth(20);
                    this.table.getModel().getColumn(3).setMinWidth(20);
                    this.table.getModel().getColumn(3).setPreferredWidth(20);
                    this.table.getModel().getColumn(4).setMaxWidth(45);
                    this.table.getModel().getColumn(4).setMinWidth(45);
                    this.table.getModel().getColumn(4).setPreferredWidth(45);
                    this.table.getModel().getColumn(5).setMaxWidth(20);
                    this.table.getModel().getColumn(5).setMinWidth(20);
                    this.table.getModel().getColumn(5).setPreferredWidth(20);
                    this.table.getModel().getColumn(6).setMaxWidth(50);
                    this.table.getModel().getColumn(6).setMinWidth(50);
                    this.table.getModel().getColumn(6).setPreferredWidth(50);
                    this.table.getModel().updateColumnWiths();
                    this.table.getModel().generateNewHeader();
                    this.table.getModel().ensureColumnWidths(-1, 0, false, true);
                    break;
                }
                case 5: {
                    this.table.setButtonText(Words.ADD_STEP);
                    this.table.getModel().getColumn(0).setColumnName(Words.STEP);
                    this.table.getModel().getColumn(1).setColumnName(Words.FROM_PAX);
                    this.table.getModel().getColumn(2).setColumnName("");
                    this.table.getModel().getColumn(3).setColumnName(Words.TO_PAX);
                    this.table.getModel().getColumn(4).setColumnName("");
                    this.table.getModel().getColumn(5).setColumnName(Words.AMOUNT);
                    this.table.getModel().getColumn(6).setColumnName("");
                    this.table.getModel().getColumn(0).setxExpand(0.4);
                    this.table.getModel().getColumn(1).setxExpand(0.2);
                    this.table.getModel().getColumn(2).setxExpand(0.0);
                    this.table.getModel().getColumn(3).setxExpand(0.2);
                    this.table.getModel().getColumn(4).setxExpand(0.0);
                    this.table.getModel().getColumn(5).setxExpand(0.2);
                    this.table.getModel().getColumn(6).setxExpand(0.0);
                    this.table.getModel().getColumn(0).setMaxWidth(50);
                    this.table.getModel().getColumn(0).setMinWidth(50);
                    this.table.getModel().getColumn(0).setPreferredWidth(50);
                    this.table.getModel().getColumn(1).setMaxWidth(50);
                    this.table.getModel().getColumn(1).setMinWidth(50);
                    this.table.getModel().getColumn(1).setPreferredWidth(50);
                    this.table.getModel().getColumn(2).setMaxWidth(20);
                    this.table.getModel().getColumn(2).setMinWidth(20);
                    this.table.getModel().getColumn(2).setPreferredWidth(20);
                    this.table.getModel().getColumn(3).setMaxWidth(50);
                    this.table.getModel().getColumn(3).setMinWidth(50);
                    this.table.getModel().getColumn(3).setPreferredWidth(50);
                    this.table.getModel().getColumn(4).setMaxWidth(20);
                    this.table.getModel().getColumn(4).setMinWidth(20);
                    this.table.getModel().getColumn(4).setPreferredWidth(20);
                    this.table.getModel().getColumn(5).setMaxWidth(50);
                    this.table.getModel().getColumn(5).setMinWidth(50);
                    this.table.getModel().getColumn(5).setPreferredWidth(50);
                    int aw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
                    this.table.getModel().getColumn(6).setMaxWidth(aw += this.table.getCellPadding() * 2);
                    this.table.getModel().getColumn(6).setMinWidth(aw);
                    this.table.getModel().getColumn(6).setPreferredWidth(aw);
                    this.table.getModel().updateColumnWiths();
                    this.table.getModel().generateNewHeader();
                    this.table.getModel().ensureColumnWidths(-1, 0, false, true);
                }
            }
        }
        this.table.setSortable(false);
    }

    public void setNode(Node<DeliverableComplete> n) {
        this.totalView.removeAllChilds();
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
            this.node.getChildNamed(new String[]{"quantityCalculation"}).removeNodeListener((NodeListener)this);
        }
        this.node = n;
        if (this.node != null) {
            this.node.addNodeListener((NodeListener)this);
            this.node.getAllChildAddEventsFor((NodeListener)this, new String[0]);
            Node child = this.node.getChildNamed(new String[]{"quantityCalculation"});
            if (child.getValue() instanceof AbsolutQuantityCalculationComplete) {
                this.fixTotal.setNode((Node)null);
                this.fixTotal.setViewConverter(null);
                this.fixTotal.setText(this.createQuantityString());
            } else if (child.getValue() instanceof LinearFunctionSetQuantityCalculationComplete) {
                if (this.formulaList != null) {
                    this.formulaList.removeNodeListener((NodeListener)this);
                }
                this.formulaList = child.getChildNamed(new String[]{"functions"});
                this.table.setComparator(null);
                this.table.getModel().setNode(this.formulaList);
                this.fixTotal.setViewConverter(ConverterRegistry.getConverter(StringConverter.class));
                this.fixTotal.setNode((Node)this.totalView);
                if (this.node.getValue() instanceof ServiceDeliverableComplete) {
                    this.maxLoad.setTitleText(Words.MAX_LOAD_PER_LEG);
                } else {
                    this.maxLoad.setTitleText(Words.MAX_LOAD_PER_FLIGHT);
                }
                this.c.setNode(child.getChildNamed(LinearFunctionSetQuantityCalculationComplete_.maxValue));
                this.c.setVisible(true);
            } else if (child.getValue() instanceof StepFunctionQuantityCalculationComplete) {
                if (this.formulaList != null) {
                    this.formulaList.removeNodeListener((NodeListener)this);
                }
                this.formulaList = child.getChildNamed(new String[]{"steps"});
                this.table.setComparator(ComparatorRegistry.getComparator(StepSorter.class));
                this.table.getModel().setNode(this.formulaList);
                this.table.updateOrder();
                this.fixTotal.setViewConverter(ConverterRegistry.getConverter(StringConverter.class));
                this.fixTotal.setNode((Node)this.totalView);
                this.c.setVisible(false);
            }
            child.addNodeListener((NodeListener)this);
            this.totalView.addChild(this.node.getChildNamed(new String[]{"deliveryInstruction"}).getChildNamed(new String[]{"roundingStrategy"}), 0L);
            this.node.getChildNamed(new String[]{"deliveryInstruction"}).getChildNamed(new String[]{"roundingStrategy"}).addNodeListener(this.totalView);
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean enable = isEnabled && !this.pegasus.isLocked();
        super.setEnabled(enable);
        this.table.enableAddButton(enable);
        this.table.setEditable(enable);
        this.table.setEnabled(isEnabled);
        this.fixTotal.setEnabled(isEnabled);
        if (this.maxLoad != null) {
            this.maxLoad.setEnabled(enable);
        }
        if (this.box != null) {
            this.box.setEnabled(enable);
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
        if (source == this.node) {
            this.setNode(this.node);
        } else if (source == this.formulaList) {
            // empty if block
        }
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void valueChanged(Node<?> node) {
        block5: {
            block6: {
                block7: {
                    if (this.node == null) break block5;
                    if (!node.getName().equals("quantityCalculation")) break block6;
                    this.table.resetTable();
                    if (node.getValue() instanceof AbsolutQuantityCalculationComplete) break block5;
                    if (!(node.getValue() instanceof LinearFunctionSetQuantityCalculationComplete)) break block7;
                    if (this.formulaList != null) {
                        this.formulaList.removeNodeListener((NodeListener)this);
                    }
                    this.formulaList = node.getChildNamed(new String[]{"functions"});
                    this.table.getModel().setNode(this.formulaList);
                    if (this.formulaList.getChildCount() == 0) {
                        this.table.getButtonHandler().addButtonPressed(0, 0, null);
                    }
                    break block5;
                }
                if (!(node.getValue() instanceof StepFunctionQuantityCalculationComplete)) break block5;
                if (this.formulaList != null) {
                    this.formulaList.removeNodeListener((NodeListener)this);
                }
                this.formulaList = node.getChildNamed(new String[]{"steps"});
                this.table.getModel().setNode(this.formulaList);
                this.table.updateOrder();
                break block5;
            }
            if (node.getName().equals("upperLimit")) {
                for (Table2RowPanel p : this.table.getRows()) {
                    if (!(p instanceof StepRow)) continue;
                    StepRow r = (StepRow)p;
                    r.updateFrom();
                }
            }
        }
    }

    private void openPassagenerKeySetChooser(final Table2RowModel model, Component icon, int x, int y) {
        InnerPopUp2 aPopUp = InnerPopUp2.getInnerPopUp();
        aPopUp.setAttributes(null, false, false, Words.DELIVERED_FOR_PASSENGERS);
        InnerPopUpListener2 l = new InnerPopUpListener2(){

            @Override
            public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                if (model.getView() instanceof FormulaRow) {
                    ((ViewNode)((FormulaRow)model.getView()).result.getNode()).updateValue();
                } else if (model.getView() instanceof StepRow) {
                    for (Table2RowPanel p : LoadingInstructionDetailsView.this.table.getRows()) {
                        StepRow pp = (StepRow)p;
                        pp.totalPaxView.updateValue();
                    }
                }
            }
        };
        Node n = model.getParentModel().getNode().getParent().getParent().getParent().getParent().getChildNamed(new String[]{"seatConfigurations"});
        DeliverableComplete deliverable = (DeliverableComplete)model.getNode().getParent().getParent().getParent().getValue();
        boolean isWithLegs = false;
        if (deliverable instanceof ArticleDeliverableLight || deliverable instanceof ArticleDeliverableComplete) {
            isWithLegs = true;
        }
        if (deliverable instanceof ProductDeliverableComplete) {
            isWithLegs = true;
        }
        if (deliverable instanceof EquipmentTemplateDeliverableComplete) {
            isWithLegs = true;
        }
        Node legs = model.getParentModel().getNode().getParent().getParent().getParent().getParent().getChildNamed(new String[]{"legs"});
        Node pn = model.getParentModel().getNode().getParent().getParent().getParent().getParent();
        if (pn.getChildNamed(new String[]{"legs"}) != null) {
            legs = pn.getChildNamed(new String[]{"legs"});
        } else {
            Node legs2 = model.getParentModel().getNode().getParent().getParent().getParent().getParent().getChildNamed(new String[]{"flight-legs"});
            ArrayList legss = new ArrayList();
            legss.addAll((Collection)legs2.getValue());
            legs = INodeCreator.getDefaultImpl().createNodes(legss, false);
        }
        if (model.getNode().getValue() instanceof StepComplete) {
            aPopUp.setView(new PaxKeyChooserPanel((Node<List<SeatConfigurationComplete>>)n, (Node<List<ALegComplete>>)legs, model.getNode().getParent().getParent().getChildNamed(new String[]{"paxKeySets"}), isWithLegs));
        } else {
            aPopUp.setView(new PaxKeyChooserPanel((Node<List<SeatConfigurationComplete>>)n, (Node<List<ALegComplete>>)legs, model.getNode().getChildNamed(new String[]{"paxKeySets"}), isWithLegs));
        }
        aPopUp.showPopUp(x, y, 300, -1, l, icon, PopupType.FRAMELESS);
    }

    private String createQuantityString() {
        int amount = 0;
        if (this.node == null) {
            return "";
        }
        Iterator it = this.node.getChildNamed(new String[]{"deliveryInstruction"}).getChildNamed(new String[]{"galleyDistributionRules"}).getChilds();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            Iterator it2 = n.getChildNamed(new String[]{"equipmentDistributionRules"}).getChilds();
            while (it2.hasNext()) {
                Node nn = (Node)it2.next();
                Iterator it3 = nn.getChildNamed(new String[]{"insertDistributionRule"}).getChilds();
                while (it3.hasNext()) {
                    Node nnn = (Node)it3.next();
                    if (nnn.getChildNamed(new String[]{"quantity"}).getValue() == null) continue;
                    amount += ((Integer)nnn.getChildNamed(new String[]{"quantity"}).getValue()).intValue();
                }
            }
        }
        String us = "";
        if (this.node.getChildNamed(new String[]{"unit"}) != null && this.node.getChildNamed(new String[]{"unit"}).getValue() != null) {
            UnitComplete u = (UnitComplete)this.node.getChildNamed(new String[]{"unit"}).getValue();
            us = " " + u.getShortName();
        } else {
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            us = " " + settings.getPieceUnit().getShortName();
        }
        return "Total: " + amount + us;
    }

    protected void setState(int newState) {
        if (newState != this.state) {
            switch (newState) {
                case 3: {
                    this.table.fadeOut(false);
                    break;
                }
                case 5: {
                    this.table.fadeIn();
                }
            }
            this.state = newState;
        }
    }

    @Override
    public void layoutPanel(int w, int h, boolean resize) {
    }

    @Override
    public void movePanel(int x, int y, boolean smooth) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    public void resetTable() {
        this.table.resetTable();
        this.setNode(null);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.box) {
            if (this.box.isChecked()) {
                this.node.getChildNamed(new String[]{"quantityCalculation-maxValue"}).setValue((Object)10, 0L);
            } else {
                this.node.getChildNamed(new String[]{"quantityCalculation-maxValue"}).setValue(null, 0L);
            }
            this.c.setNode(this.node.getChildNamed(new String[]{"quantityCalculation-maxValue"}));
        }
    }

    private class InnerPanel
    extends DefaultPanel {
        private static final long serialVersionUID = 1L;

        public InnerPanel() {
            this.setLayout(new Layout());
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
        }

        @Override
        public void requestFocusInWindowNow() {
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            super.kill();
        }

        public void setNode(Node node) {
            Node n1 = node;
            if (n1.getValue() == null) {
                LoadingInstructionDetailsView.this.box.setChecked(false);
                LoadingInstructionDetailsView.this.maxLoad.setEnabled(false);
            } else {
                LoadingInstructionDetailsView.this.box.setChecked(true);
                ((TextField)LoadingInstructionDetailsView.this.maxLoad.getElement()).setNode(n1);
                LoadingInstructionDetailsView.this.maxLoad.setEnabled(true);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                int h = (int)LoadingInstructionDetailsView.this.maxLoad.getPreferredSize().getHeight();
                int w = (int)(LoadingInstructionDetailsView.this.box.getPreferredSize().getWidth() + 5.0 + LoadingInstructionDetailsView.this.maxLoad.getPreferredSize().getWidth());
                return new Dimension(w, h);
            }

            @Override
            public void layoutContainer(Container parent) {
                LoadingInstructionDetailsView.this.box.setLocation(0, (int)(((double)parent.getHeight() - LoadingInstructionDetailsView.this.box.getPreferredSize().getHeight()) / 2.0));
                LoadingInstructionDetailsView.this.box.setSize(LoadingInstructionDetailsView.this.box.getPreferredSize());
                LoadingInstructionDetailsView.this.maxLoad.setLocation(LoadingInstructionDetailsView.this.box.getX() + LoadingInstructionDetailsView.this.box.getWidth() + 5, (int)(((double)parent.getHeight() - LoadingInstructionDetailsView.this.maxLoad.getPreferredSize().getHeight()) / 2.0));
                LoadingInstructionDetailsView.this.maxLoad.setSize(parent.getWidth() - LoadingInstructionDetailsView.this.maxLoad.getX(), (int)LoadingInstructionDetailsView.this.maxLoad.getPreferredSize().getHeight());
            }
        }
    }

    private class StepRow
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private Node node;
        private TextLabel step;
        private TextLabel fromPax;
        private ArrowConnectorIcon connectIcon;
        private TextField toPax;
        private TextLabel equals;
        private NumericStepper amount;
        private DeleteButton delete;
        private EditPaxButton icon;
        private TextLabel passangerNr;
        private ViewNode<Integer> totalPaxView;

        public StepRow(Table2RowModel m) {
            super(m);
            this.setLayout(new StepRowLayout());
            this.node = m.getNode();
            this.step = new TextLabel("> " + this.model.getParentModel().getTable().getRowCount());
            this.step.setProgress(1.0f);
            this.icon = new EditPaxButton();
            this.icon.addButtonListener(this);
            this.icon.setProgress(1.0f);
            this.passangerNr = new TextLabel("(x)");
            this.passangerNr.setProgress(1.0f);
            this.totalPaxView = new ViewNode("paxView");
            this.totalPaxView.setChangeHandler((ViewNodeDataChangeHandler)new ViewNodeDataChangeHandler<Integer>(){

                public Integer calculateNewValue(ViewNode node) {
                    Node paxFigures = node.getChildNamed(new String[]{"paxKeySets"});
                    int totalPassangers = 0;
                    if (paxFigures != null) {
                        Iterator it = paxFigures.getFailSafeChildIterator();
                        while (it.hasNext()) {
                            Node n = (Node)it.next();
                            Node paxClass = n.getChildNamed(new String[]{"paxClass"});
                            Node isSPML = n.getChildNamed(new String[]{"onlySPMLPassengers"});
                            if (isSPML != null && isSPML.getValue() != null && ((Boolean)isSPML.getValue()).booleanValue()) continue;
                            totalPassangers += LogicToolkit.getPaxFigure4Class((CabinClassComplete)paxClass.getValue(), LoadingInstructionDetailsView.this.pegasus.getStowingList()).intValue();
                        }
                    }
                    StepRow.this.passangerNr.setText("(" + totalPassangers + ")");
                    return totalPassangers;
                }
            });
            this.totalPaxView.addChild(m.getNode().getParent().getParent().getChildNamed(new String[]{"paxKeySets"}), 0L);
            m.getNode().getParent().getParent().getChildNamed(new String[]{"paxKeySets"}).addNodeListener(this.totalPaxView);
            this.totalPaxView.updateValue();
            LoadingInstructionDetailsView.this.totalView.addChild(this.totalPaxView, 0L);
            m.getNode().getChildNamed(new String[]{"upperLimit"}).addNodeListener((NodeListener)LoadingInstructionDetailsView.this.totalView);
            m.getNode().getChildNamed(new String[]{"quantity"}).addNodeListener((NodeListener)LoadingInstructionDetailsView.this.totalView);
            this.totalPaxView.addNodeListener((NodeListener)LoadingInstructionDetailsView.this.totalView);
            m.getNode().setName("pax");
            this.totalPaxView.addChild(m.getNode(), 0L);
            LoadingInstructionDetailsView.this.totalView.updateValue();
            this.connectIcon = new ArrowConnectorIcon();
            this.connectIcon.setProgress(1.0f);
            ViewNode nn = new ViewNode("");
            nn.setChangeHandler((ViewNodeDataChangeHandler)new ViewNodeDataChangeHandler<String>(){

                public String calculateNewValue(ViewNode node) {
                    int i = LoadingInstructionDetailsView.this.table.getRowIndex(StepRow.this);
                    if (i > 0) {
                        Node n = LoadingInstructionDetailsView.this.table.getRowAt(--i).getModel().getNode();
                        Node uL = n.getChildNamed(new String[]{"upperLimit"});
                        return "" + uL.getValue();
                    }
                    return "0";
                }
            });
            this.node.getChildNamed(new String[]{"upperLimit"}).addNodeListener((NodeListener)LoadingInstructionDetailsView.this);
            this.fromPax = new TextLabel();
            this.fromPax.setNode((Node)nn);
            this.fromPax.setProgress(1.0f);
            this.toPax = new NumberTextField(this.node.getChildNamed(new String[]{"upperLimit"}), TextFieldType.INT);
            this.toPax.setProgress(1.0f);
            this.equals = new TextLabel(Words.EQUALS_SIGN);
            this.equals.setProgress(1.0f);
            this.amount = new NumericStepper(null, 3);
            this.amount.setProgress(1.0f);
            this.amount.setMinValue(0.0);
            this.amount.setNode(m.getNode().getChildNamed(new String[]{"quantity"}));
            this.delete = new DeleteButton(SizedSkin1Field.SkinSize.MEDIUM);
            this.delete.addButtonListener(this);
            this.add(this.step);
            this.add(this.icon);
            this.add(this.passangerNr);
            this.add(this.fromPax);
            this.add(this.connectIcon);
            this.add(this.toPax);
            this.add(this.equals);
            this.add(this.amount);
            this.add(this.delete);
        }

        public void updateFrom() {
            ((ViewNode)this.fromPax.getNode()).updateValue();
        }

        @Override
        public void updateRowOrder() {
            super.updateRowOrder();
            int i = LoadingInstructionDetailsView.this.table.getRowIndex(this);
            this.step.setText("" + (i + 1));
            int i2 = this.getLowerUpperLimit((Integer)this.model.getNode().getChildNamed(new String[]{"upperLimit"}).getValue());
            if (i2 == 0) {
                this.fromPax.setText("0");
            } else {
                int to = i2;
                this.fromPax.setText("> " + to);
            }
        }

        private int getLowerUpperLimit(int i) {
            Iterator it = this.model.getNode().getParent().getFailSafeChildIterator();
            int min = 0;
            while (it.hasNext()) {
                Node n = (Node)it.next();
                int ii = (Integer)n.getChildNamed(new String[]{"upperLimit"}).getValue();
                if (ii <= min || ii >= i) continue;
                min = ii;
            }
            return min;
        }

        @Override
        public Object getObject4Column(int column) {
            return this.model.getNode().getChildNamed(new String[]{"upperLimit"}).getValue();
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.model.getParentModel().getTable().getRowIndex(this) == 0) {
                if (this.icon != null) {
                    this.icon.requestFocusInWindowNow();
                }
            } else if (this.toPax != null) {
                this.toPax.requestFocusInWindowNow();
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            } else if (source == this.icon) {
                LoadingInstructionDetailsView.this.openPassagenerKeySetChooser(this.model, source, x, y);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.model.getNode().getValue() instanceof StepComplete) {
                try {
                    this.model.getNode().getParent().getParent().getChildNamed(new String[]{"paxKeySets"}).removeNodeListener(this.totalPaxView);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.totalPaxView != null) {
                    try {
                        this.totalPaxView.removeChild(this.model.getNode().getParent().getParent().getChildNamed(new String[]{"paxKeySets"}), 0L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                this.model.getNode().getChildNamed(new String[]{"paxKeySets"}).removeNodeListener(this.totalPaxView);
                if (this.totalPaxView != null) {
                    this.totalPaxView.removeChild(this.model.getNode().getChildNamed(new String[]{"paxKeySets"}), 0L);
                }
            }
            this.node.getChildNamed(new String[]{"upperLimit"}).removeNodeListener((NodeListener)LoadingInstructionDetailsView.this);
            LoadingInstructionDetailsView.this.totalView.addChild(this.totalPaxView, 0L);
            this.model.getNode().getChildNamed(new String[]{"upperLimit"}).removeNodeListener((NodeListener)LoadingInstructionDetailsView.this.totalView);
            this.model.getNode().getChildNamed(new String[]{"quantity"}).removeNodeListener((NodeListener)LoadingInstructionDetailsView.this.totalView);
            if (this.totalPaxView != null) {
                this.totalPaxView.removeNodeListener((NodeListener)LoadingInstructionDetailsView.this.totalView);
                this.totalPaxView.removeChild(this.model.getNode(), 0L);
            }
            LoadingInstructionDetailsView.this.totalView.updateValue();
            this.node = null;
            this.step.kill();
            this.step = null;
            this.fromPax.kill();
            this.fromPax = null;
            this.connectIcon.kill();
            this.connectIcon = null;
            this.toPax.kill();
            this.toPax = null;
            this.equals.kill();
            this.equals = null;
            this.amount.kill();
            this.amount = null;
            this.delete.kill();
            this.delete = null;
            this.icon.kill();
            this.icon = null;
            this.passangerNr.kill();
            this.passangerNr = null;
            if (this.totalPaxView != null) {
                this.totalPaxView.kill();
            }
            this.totalPaxView = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean enable = isEnabled && !LoadingInstructionDetailsView.this.pegasus.isLocked();
            super.setEnabled(enable);
            this.icon.setEnabled(enable);
            this.step.setEnabled(isEnabled);
            this.fromPax.setEnabled(isEnabled);
            this.connectIcon.setEnabled(isEnabled);
            this.toPax.setEnabled(enable);
            this.equals.setEnabled(isEnabled);
            this.amount.setEnabled(enable);
            this.delete.setEnabled(enable);
        }

        private class StepRowLayout
        extends DefaultLayout {
            private StepRowLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int inset = StepRow.this.model.getParentModel().getTable().getCellPadding();
                int currentX = 0;
                int w = StepRow.this.model.getParentModel().getColumnWidth(0);
                StepRow.this.step.setLocation(currentX + inset, (int)(((double)parent.getHeight() - StepRow.this.step.getPreferredSize().getHeight()) / 2.0));
                StepRow.this.step.setSize(StepRow.this.step.getPreferredSize());
                StepRow.this.icon.setLocation(30, (int)(((double)parent.getHeight() - StepRow.this.icon.getPreferredSize().getHeight()) / 2.0));
                StepRow.this.icon.setSize(StepRow.this.icon.getPreferredSize());
                StepRow.this.passangerNr.setLocation(StepRow.this.icon.getX() + StepRow.this.icon.getWidth() + LoadingInstructionDetailsView.this.table.getCellPadding(), (int)(((double)parent.getHeight() - StepRow.this.passangerNr.getPreferredSize().getHeight()) / 2.0));
                StepRow.this.passangerNr.setSize(w - (StepRow.this.passangerNr.getX() + LoadingInstructionDetailsView.this.table.getCellPadding()), (int)StepRow.this.passangerNr.getPreferredSize().getHeight());
                currentX += w;
                w = StepRow.this.model.getParentModel().getColumnWidth(1);
                StepRow.this.fromPax.setLocation(currentX + inset, (int)(((double)parent.getHeight() - StepRow.this.fromPax.getPreferredSize().getHeight()) / 2.0));
                StepRow.this.fromPax.setSize(w - 2 * inset, (int)StepRow.this.fromPax.getPreferredSize().getHeight());
                currentX += w;
                w = StepRow.this.model.getParentModel().getColumnWidth(2);
                StepRow.this.connectIcon.setLocation(currentX + inset, (int)(((double)parent.getHeight() - StepRow.this.connectIcon.getPreferredSize().getHeight()) / 2.0));
                StepRow.this.connectIcon.setSize(StepRow.this.connectIcon.getPreferredSize());
                currentX += w;
                w = StepRow.this.model.getParentModel().getColumnWidth(3);
                StepRow.this.toPax.setLocation(currentX + inset, (int)(((double)parent.getHeight() - StepRow.this.toPax.getPreferredSize().getHeight()) / 2.0));
                StepRow.this.toPax.setSize(w - 2 * inset, (int)StepRow.this.toPax.getPreferredSize().getHeight());
                currentX += w;
                w = StepRow.this.model.getParentModel().getColumnWidth(4);
                StepRow.this.equals.setLocation(currentX + inset, (int)(((double)parent.getHeight() - StepRow.this.equals.getPreferredSize().getHeight()) / 2.0));
                StepRow.this.equals.setSize(StepRow.this.equals.getPreferredSize());
                currentX += w;
                w = StepRow.this.model.getParentModel().getColumnWidth(5);
                StepRow.this.amount.setLocation(currentX + inset, (int)(((double)parent.getHeight() - StepRow.this.amount.getPreferredSize().getHeight()) / 2.0));
                StepRow.this.amount.setSize(w - 2 * inset, (int)StepRow.this.amount.getPreferredSize().getHeight());
                currentX += w;
                w = StepRow.this.model.getParentModel().getColumnWidth(6);
                StepRow.this.delete.setLocation((int)((double)(currentX += w) - ((double)inset + StepRow.this.delete.getPreferredSize().getWidth())), (int)(((double)parent.getHeight() - StepRow.this.delete.getPreferredSize().getHeight()) / 2.0));
                StepRow.this.delete.setSize(StepRow.this.delete.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(20, StepRow.this.getDefaultRowHeight());
            }
        }
    }

    private class FormulaRow
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private Node node;
        private LinearFunctionSign sign;
        private EditPaxButton icon;
        private TextLabel x;
        private TextField factor;
        private TextLabel plus;
        private TextField constant;
        private TextLabel equals;
        private TextLabel result;
        private DeleteButton delete;
        private TextLabel selectedPaxes;

        public FormulaRow(Table2RowModel m) {
            super(m);
            this.setLayout(new FormulaRowLayout());
            this.node = m.getNode();
            this.sign = new LinearFunctionSign((Node<Boolean>)this.node.getChildNamed(new String[]{"isAdd"}));
            this.sign.setProgress(1.0f);
            this.sign.addButtonListener(this);
            this.icon = new EditPaxButton();
            this.icon.setProgress(1.0f);
            this.icon.addButtonListener(this);
            this.selectedPaxes = new TextLabel("(0)");
            this.selectedPaxes.setProgress(1.0f);
            this.delete = new DeleteButton(SizedSkin1Field.SkinSize.MEDIUM);
            this.delete.setProgress(1.0f);
            this.delete.addButtonListener(this);
            this.factor = new NumberTextField(this.node.getChildNamed(new String[]{"factor"}), TextFieldType.DOUBLE);
            this.factor.setProgress(1.0f);
            this.constant = new NumberTextField(this.node.getChildNamed(new String[]{"constant"}), TextFieldType.INT);
            this.constant.setProgress(1.0f);
            this.x = new TextLabel(Words.X);
            this.x.setProgress(1.0f);
            this.plus = new TextLabel(Words.PLUS_SIGN);
            this.plus.setProgress(1.0f);
            this.equals = new TextLabel(Words.EQUALS_SIGN);
            this.equals.setProgress(1.0f);
            this.result = new TextLabel((Node)this.createFormula(m.getNode()), ConverterRegistry.getConverter(FormattedDoubleConverter1Decimals.class));
            this.result.setProgress(1.0f);
            LoadingInstructionDetailsView.this.getTotalView().addChild(this.result.getNode(), 0L);
            this.result.getNode().addNodeListener((NodeListener)LoadingInstructionDetailsView.this.getTotalView());
            LoadingInstructionDetailsView.this.getTotalView().updateValue();
            this.fadeIn();
            this.fadeInAll();
            this.add(this.delete);
            this.add(this.icon);
            this.add(this.sign);
            this.add(this.selectedPaxes);
            this.add(this.constant);
            this.add(this.factor);
            this.add(this.x);
            this.add(this.plus);
            this.add(this.equals);
            this.add(this.result);
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        public Node<Double> getRowTotalNode() {
            return this.result.getNode();
        }

        private ViewNode<Double> createFormula(Node node) {
            ViewNode view = new ViewNode("rowPreview");
            view.setChangeHandler(node1 -> {
                try {
                    Node paxFigures = node1.getChildNamed(new String[]{"paxKeySets"});
                    Node constant = node1.getChildNamed(new String[]{"constant"});
                    Node factor = node1.getChildNamed(new String[]{"factor"});
                    Node isAdd = node1.getChildNamed(new String[]{"isAdd"});
                    Node rounding = node1.getChildNamed(new String[]{"roundingStrategy"});
                    int totalPassengers = 0;
                    int legMultiplier = 1;
                    double v = 0.0;
                    Node delivery = null;
                    try {
                        delivery = this.model.getNode().getParent().getParent().getParent();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (delivery != null && delivery.getValue() != null) {
                        if (delivery.getValue() instanceof ProductDeliverableComplete || delivery.getValue() instanceof ArticleDeliverableLight || delivery.getValue() instanceof ArticleDeliverableComplete) {
                            v = 1.0;
                            legMultiplier = paxFigures.getChildCount() > 0 ? paxFigures.getChildAt(0).getChildNamed(new String[]{"legs"}).getChildCount() : 0;
                        } else if (delivery.getValue() instanceof ServiceDeliverableComplete) {
                            ServiceDeliverableComplete d = (ServiceDeliverableComplete)delivery.getValue();
                            if (d.getLoadingGroup().getContainingService() instanceof CateringServiceScheduleVariantComplete) {
                                CateringServiceScheduleVariantComplete ser = (CateringServiceScheduleVariantComplete)d.getLoadingGroup().getContainingService();
                                legMultiplier = ser.getLegs().size();
                                ALoadingGroupComplete g = d.getLoadingGroup();
                                List rot = ((CateringServiceScheduleVariantComplete)d.getLoadingGroup().getContainingService()).getRotations();
                                if (!rot.isEmpty()) {
                                    CateringServiceRotationComplete r = (CateringServiceRotationComplete)rot.get(0);
                                    for (CateringServicePartComplete p : r.getParts()) {
                                        if (!p.getLoadingGroup().equals((Object)g)) continue;
                                        for (CateringServicePartChoiceComplete c : p.getChoices()) {
                                            if (!c.getCalculationType().equals((Object)CateringServicePartChoiceCalculationTypeE.RATIO)) continue;
                                            v += c.getRatio().doubleValue();
                                        }
                                    }
                                }
                                if (v != 0.0) {
                                    v /= 100.0;
                                }
                            } else {
                                ALoadingGroupComplete g = d.getLoadingGroup();
                                for (CateringServicePartComplete p : ((CateringServiceComplete)d.getLoadingGroup().getContainingService()).getParts()) {
                                    if (!p.getLoadingGroup().equals((Object)g)) continue;
                                    for (CateringServicePartChoiceComplete c : p.getChoices()) {
                                        if (!c.getCalculationType().equals((Object)CateringServicePartChoiceCalculationTypeE.RATIO)) continue;
                                        v += c.getRatio().doubleValue();
                                    }
                                }
                                if (v != 0.0) {
                                    v /= 100.0;
                                }
                            }
                        }
                    }
                    Iterator it = paxFigures.getChilds();
                    while (it.hasNext()) {
                        Node n = (Node)it.next();
                        Node paxClass = n.getChildNamed(new String[]{"paxClass"});
                        int tp = LogicToolkit.getPaxFigure4Class((CabinClassComplete)paxClass.getValue(), LoadingInstructionDetailsView.this.pegasus.getStowingList());
                        totalPassengers += (tp *= legMultiplier);
                    }
                    if (this.selectedPaxes != null) {
                        this.selectedPaxes.setText("(" + totalPassengers + ")");
                    }
                    double retValue = (double)totalPassengers * (Double)factor.getValue();
                    retValue += (double)((Integer)constant.getValue()).intValue();
                    retValue *= v;
                    if (!((Boolean)isAdd.getValue()).booleanValue()) {
                        retValue *= -1.0;
                    }
                    retValue = RoundingToolkit.round((Double)retValue, (RoundingStrategyE)((RoundingStrategyE)rounding.getValue()));
                    return retValue;
                }
                catch (Exception e) {
                    return 0.0;
                }
            });
            Node paxFigures = node.getChildNamed(new String[]{"paxKeySets"});
            Node constant = node.getChildNamed(new String[]{"constant"});
            Node factor = node.getChildNamed(new String[]{"factor"});
            Node isAdd = node.getChildNamed(new String[]{"isAdd"});
            Node rounding = node.getParent().getParent().getParent().getChildNamed(new String[]{"deliveryInstruction"}).getChildNamed(new String[]{"roundingStrategy"});
            view.addChild(paxFigures, 0L);
            view.addChild(constant, 0L);
            view.addChild(factor, 0L);
            view.addChild(isAdd, 0L);
            view.addChild(rounding, 0L);
            paxFigures.addNodeListener((NodeListener)view);
            constant.addNodeListener((NodeListener)view);
            factor.addNodeListener((NodeListener)view);
            isAdd.addNodeListener((NodeListener)view);
            rounding.addNodeListener((NodeListener)view);
            view.updateValue();
            return view;
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.model.getParentModel().getTable().getRowIndex(this) == 0) {
                if (this.icon != null) {
                    this.icon.requestFocusInWindowNow();
                }
            } else if (this.factor != null) {
                this.factor.requestFocusInWindowNow();
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.sign);
            CheckedListAdder.addToList(focusList, this.icon);
            CheckedListAdder.addToList(focusList, this.factor);
            CheckedListAdder.addToList(focusList, this.constant);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean enable = isEnabled && !LoadingInstructionDetailsView.this.pegasus.isLocked();
            super.setEnabled(enable);
            this.sign.setEnabled(enable);
            this.icon.setEnabled(enable);
            this.x.setEnabled(isEnabled);
            this.factor.setEnabled(enable);
            this.plus.setEnabled(isEnabled);
            this.constant.setEnabled(enable);
            this.equals.setEnabled(isEnabled);
            this.result.setEnabled(isEnabled);
            this.delete.setEnabled(enable);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (this.icon == source) {
                LoadingInstructionDetailsView.this.openPassagenerKeySetChooser(this.model, source, x, y);
            } else if (this.delete == source) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (LoadingInstructionDetailsView.this.getTotalView() != null && this.result != null) {
                LoadingInstructionDetailsView.this.getTotalView().removeChild(this.result.getNode(), 0L);
                this.result.getNode().removeNodeListener((NodeListener)LoadingInstructionDetailsView.this.getTotalView());
                LoadingInstructionDetailsView.this.getTotalView().updateValue();
            }
            this.node = null;
            if (this.sign != null) {
                this.sign.kill();
            }
            this.sign = null;
            if (this.icon != null) {
                this.icon.kill();
            }
            this.icon = null;
            if (this.x != null) {
                this.x.kill();
            }
            this.x = null;
            if (this.factor != null) {
                this.factor.kill();
            }
            this.factor = null;
            if (this.plus != null) {
                this.plus.kill();
            }
            this.plus = null;
            if (this.constant != null) {
                this.constant.kill();
            }
            this.constant = null;
            if (this.equals != null) {
                this.equals.kill();
            }
            this.equals = null;
            if (this.result != null) {
                this.result.kill();
            }
            this.result = null;
            if (this.delete != null) {
                this.delete.kill();
            }
            this.delete = null;
            if (this.selectedPaxes != null) {
                this.selectedPaxes.kill();
            }
            this.selectedPaxes = null;
        }

        private class FormulaRowLayout
        extends DefaultLayout {
            private FormulaRowLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int inset;
                int w = FormulaRow.this.model.getParentModel().getColumnWidth(0);
                int currentX = inset = FormulaRow.this.model.getParentModel().getTable().getCellPadding();
                int cx = 0;
                if (FormulaRow.this.sign == null) {
                    return;
                }
                FormulaRow.this.sign.setLocation(currentX, (int)((double)parent.getHeight() - FormulaRow.this.sign.getPreferredSize().getHeight()) / 2);
                FormulaRow.this.sign.setSize(FormulaRow.this.sign.getPreferredSize());
                FormulaRow.this.icon.setLocation(currentX += FormulaRow.this.sign.getWidth() + inset, (int)((double)parent.getHeight() - FormulaRow.this.icon.getPreferredSize().getHeight()) / 2);
                FormulaRow.this.icon.setSize(FormulaRow.this.icon.getPreferredSize());
                cx = FormulaRow.this.icon.getX() + FormulaRow.this.icon.getWidth();
                FormulaRow.this.selectedPaxes.setLocation(cx + LoadingInstructionDetailsView.this.table.getCellPadding(), (int)(((double)parent.getHeight() - FormulaRow.this.selectedPaxes.getPreferredSize().getHeight()) / 2.0));
                FormulaRow.this.selectedPaxes.setSize(currentX + w - (FormulaRow.this.selectedPaxes.getX() + LoadingInstructionDetailsView.this.table.getCellPadding()), (int)FormulaRow.this.selectedPaxes.getPreferredSize().getHeight());
                currentX = w;
                w = FormulaRow.this.model.getParentModel().getColumnWidth(1);
                FormulaRow.this.x.setLocation((int)((double)currentX + ((double)w - FormulaRow.this.x.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - FormulaRow.this.x.getPreferredSize().getHeight()) / 2);
                FormulaRow.this.x.setSize(FormulaRow.this.x.getPreferredSize());
                currentX += w;
                w = FormulaRow.this.model.getParentModel().getColumnWidth(2);
                FormulaRow.this.factor.setLocation(currentX + inset, (int)((double)parent.getHeight() - FormulaRow.this.factor.getPreferredSize().getHeight()) / 2);
                FormulaRow.this.factor.setSize(w - 2 * inset, (int)FormulaRow.this.factor.getPreferredSize().getHeight());
                currentX += w;
                w = FormulaRow.this.model.getParentModel().getColumnWidth(3);
                FormulaRow.this.plus.setLocation((int)((double)currentX + ((double)w - FormulaRow.this.plus.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - FormulaRow.this.plus.getPreferredSize().getHeight()) / 2);
                FormulaRow.this.plus.setSize(FormulaRow.this.plus.getPreferredSize());
                currentX += w;
                w = FormulaRow.this.model.getParentModel().getColumnWidth(4);
                FormulaRow.this.constant.setLocation(currentX + inset, (int)((double)parent.getHeight() - FormulaRow.this.constant.getPreferredSize().getHeight()) / 2);
                FormulaRow.this.constant.setSize(w - 2 * inset, (int)FormulaRow.this.constant.getPreferredSize().getHeight());
                currentX += w;
                w = FormulaRow.this.model.getParentModel().getColumnWidth(5);
                FormulaRow.this.equals.setLocation((int)((double)currentX + ((double)w - FormulaRow.this.equals.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - FormulaRow.this.equals.getPreferredSize().getHeight()) / 2);
                FormulaRow.this.equals.setSize(FormulaRow.this.equals.getPreferredSize());
                currentX += w;
                w = FormulaRow.this.model.getParentModel().getColumnWidth(6);
                FormulaRow.this.result.setLocation(currentX + inset, (int)((double)parent.getHeight() - FormulaRow.this.result.getPreferredSize().getHeight()) / 2);
                FormulaRow.this.result.setSize(w - (int)((double)(3 * LoadingInstructionDetailsView.this.table.getCellPadding()) + FormulaRow.this.delete.getPreferredSize().getWidth()), (int)FormulaRow.this.result.getPreferredSize().getHeight());
                FormulaRow.this.delete.setLocation(FormulaRow.this.result.getX() + FormulaRow.this.result.getWidth() + LoadingInstructionDetailsView.this.table.getCellPadding(), (int)(((double)parent.getHeight() - FormulaRow.this.delete.getPreferredSize().getHeight()) / 2.0));
                FormulaRow.this.delete.setSize(FormulaRow.this.delete.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(20, FormulaRow.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            LoadingInstructionDetailsView.this.layoutTitle(parent);
            LoadingInstructionDetailsView.this.fixTotal.setLocation(10, (int)((double)parent.getHeight() - LoadingInstructionDetailsView.this.fixTotal.getPreferredSize().getHeight()));
            LoadingInstructionDetailsView.this.fixTotal.setSize(LoadingInstructionDetailsView.this.fixTotal.getPreferredSize());
            LoadingInstructionDetailsView.this.table.setLocation(1, LoadingInstructionDetailsView.this.getTitleHeight());
            LoadingInstructionDetailsView.this.table.setSize(parent.getWidth() - 2, parent.getHeight() - (LoadingInstructionDetailsView.this.table.getY() + 3 + LoadingInstructionDetailsView.this.fixTotal.getHeight()));
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, LoadingInstructionDetailsView.this.getTitleHeight());
        }
    }
}

