/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.deliveryinstruction;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.SPMLMealTypeDeliverableConverter;
import ch.icit.pegasus.client.converter.ServiceDeliverableConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.InventoryListViewModel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.comparators.DeliveryInstructionComparator;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.converter.DeliveryInstructionConverter;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.deliveryinstruction.utils.CategoryConverter;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListView;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListViewItem;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListViewItemSelectionRule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListViewModel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.search.DeliveryInstructionSearchAlgorithm;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.FadeInOutPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.util.toolkits.MealPlanToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ArticleDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ArticleDeliverableLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.DeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.DeliverableTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.EquipmentTemplateDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.EquipmentTemplateDeliverableComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ProductDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.SPMLMealTypeDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ServiceDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliveryInstructionComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.AlphaComposite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;

public class ProductDetailsView
extends FadeInOutPanel {
    private static final long serialVersionUID = 1L;
    private PegasusSubModule pegasus;
    private ListView productList;
    private DeliveryInstructionSearchAlgorithm searchAlgo;

    public ProductDetailsView(Node<?> node, PegasusSubModule peg) {
        super(true);
        this.pegasus = peg;
        this.setTitleString(Words.PRODUCT);
        this.setHasBackground(true);
        this.productList = new ListView(true, false){

            @Override
            public boolean itemsExpanded() {
                return true;
            }
        };
        this.productList.setName("DeliveryInstructionList");
        this.searchAlgo = new DeliveryInstructionSearchAlgorithm(node);
        this.productList.addSearchAlgorithm(this.searchAlgo);
        this.productList.setDefault(false);
        this.productList.setSelectionRule(new SelectionRule());
        this.productList.setGlobalSelectionController(peg.getSelectionController());
        this.productList.setViewControler(this.pegasus.getListViewController());
        this.productList.setComparator(ComparatorRegistry.getComparator(DeliveryInstructionComparator.class));
        this.productList.setModel(new ProductDetailsModel(node, this.productList));
        this.productList.setProgress(1.0f);
        this.setProgress(1.0f);
        this.setLayout(new ProductLayout());
        this.add(this.productList);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.productList.kill();
        this.productList = null;
        this.pegasus = null;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(AlphaComposite.getInstance(3, this.theProgress));
        if (this.hasBackground) {
            g2.setColor(this.innerBackground);
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.arcW, this.arcH);
        }
        if (this.hasSkin) {
            this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        }
        if (this.useCliping) {
            Shape r = this.getClipingArea();
            g2.clip(r);
        }
        this.paintChildren(g2);
    }

    public void setNode(Node<?> n) {
        if (n == null) {
            this.searchAlgo.setNode(null);
            this.productList.resetList();
            this.setEnabled(false);
        } else {
            this.searchAlgo.setNode(n.getChildNamed(new String[]{"deliverables"}));
            this.productList.getModel().setNode(this.searchAlgo.getFilteredNode());
            this.setEnabled(true);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.productList.setEnabled(isEnabled);
    }

    @Override
    public void layoutPanel(int w, int h, boolean resize) {
    }

    @Override
    public void movePanel(int x, int y, boolean smooth) {
    }

    private class SelectionRule
    implements ListViewItemSelectionRule {
        private SelectionRule() {
        }

        @Override
        public boolean allowedToSelect(ListView list, ListViewItem item) {
            return item.getType() == 11;
        }
    }

    private class ProductDetailsModel
    implements ListViewModel {
        private Node node;
        private final ListView theList;

        public ProductDetailsModel(Node node, ListView theList) {
            this.theList = theList;
            this.setNode(node);
        }

        @Override
        public boolean checkIfContains(Node node) {
            return false;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public int getPegasusState() {
            return ProductDetailsView.this.pegasus.getCurrentState();
        }

        @Override
        public void setNode(Node node) {
            if (this.node != null) {
                this.node.removeNodeListener((NodeListener)this);
            }
            this.node = node;
            if (this.node != null) {
                this.node.addNodeListener((NodeListener)this);
                this.node.getAllChildAddEventsFor((NodeListener)this, new String[0]);
            }
            ProductDetailsView.this.productList.updateOrder();
        }

        public void childAdded(Node source, Node child) {
            if (source == this.node) {
                Node deliverable = null;
                if (child.getValue() instanceof DeliverableComplete) {
                    deliverable = child;
                } else if (child.getValue() instanceof DeliveryInstructionComplete) {
                    deliverable = child.getParent();
                } else {
                    throw new IllegalStateException("Unknown Type found");
                }
                if (deliverable != null && deliverable.getValue() instanceof ProductDeliverableComplete) {
                    Node product = deliverable.getChildNamed(new String[]{"product"});
                    ListViewItem cat = this.ensureAndgetParentCategory(product, DeliverableTypeE.PRODUCT);
                    if (cat == null) {
                        ListViewItem aProduct = ProductDetailsView.this.productList.getItem4Object(product);
                        if (aProduct == null) {
                            aProduct = new ListViewItem(product, null, ProductDetailsView.this.productList, 11, false, ProductDetailsView.this.pegasus);
                            aProduct.getView().setViewConverter(ConverterRegistry.getConverter(DeliveryInstructionConverter.class));
                            ProductDetailsView.this.productList.addChild(aProduct);
                        }
                    } else {
                        ListViewItem aProduct = cat.getItem4Object(product);
                        if (aProduct == null) {
                            aProduct = new ListViewItem(product, cat, ProductDetailsView.this.productList, 11, false, ProductDetailsView.this.pegasus);
                            aProduct.getView().setViewConverter(ConverterRegistry.getConverter(DeliveryInstructionConverter.class));
                            cat.addChild(aProduct);
                        }
                    }
                } else if (deliverable != null && deliverable.getValue() instanceof ServiceDeliverableComplete) {
                    String t;
                    ListViewItem aItem = null;
                    ListViewItem catP = this.ensureAndgetParentCategory(deliverable, DeliverableTypeE.SERVICE);
                    if (catP != null && (aItem = catP.getItem4Object(t = MealPlanToolkit.createServicePartString(deliverable.getChildNamed(new String[]{"loadingGroup"}), true))) == null) {
                        aItem = new ListViewItem(deliverable.getChildNamed(new String[]{"loadingGroup"}), catP, ProductDetailsView.this.productList, 11, true, ProductDetailsView.this.pegasus);
                        aItem.getView().setViewConverter(ConverterRegistry.getConverter(DeliveryInstructionConverter.class));
                        aItem.addUserObject(t);
                        if (catP != null) {
                            catP.addChild(aItem);
                        }
                    }
                } else if (deliverable != null && deliverable.getValue() instanceof SPMLMealTypeDeliverableComplete) {
                    String t;
                    ListViewItem aItem = null;
                    ListViewItem catP = this.ensureAndgetParentCategory(deliverable, DeliverableTypeE.SPML_REPLACE);
                    if (catP != null && (aItem = catP.getItem4Object(t = MealPlanToolkit.createReplacePartString((Node<DeliverableComplete>)deliverable))) == null) {
                        Node nt = new Node();
                        nt.setValue((Object)t, 0L);
                        aItem = new ListViewItem(deliverable, catP, ProductDetailsView.this.productList, 11, true, ProductDetailsView.this.pegasus);
                        aItem.getView().setViewConverter(ConverterRegistry.getConverter(SPMLMealTypeDeliverableConverter.class));
                        aItem.addUserObject(t);
                        if (catP != null) {
                            catP.addChild(aItem);
                        }
                    }
                } else if (deliverable != null && (deliverable.getValue() instanceof ArticleDeliverableLight || deliverable.getValue() instanceof ArticleDeliverableComplete)) {
                    Node article = deliverable.getChildNamed(new String[]{"article"});
                    ListViewItem cat = this.ensureAndgetParentCategory(article, DeliverableTypeE.ARTICLE);
                    if (cat == null) {
                        ListViewItem aArticle = ProductDetailsView.this.productList.getItem4Object(article);
                        if (aArticle == null) {
                            aArticle = new ListViewItem(article, null, ProductDetailsView.this.productList, 11, false, ProductDetailsView.this.pegasus);
                            aArticle.getView().setViewConverter(ConverterRegistry.getConverter(DeliveryInstructionConverter.class));
                            ProductDetailsView.this.productList.addChild(aArticle);
                        }
                    } else {
                        cat.setVisible(true);
                        ListViewItem aArticle = cat.getItem4Object(article);
                        if (aArticle == null) {
                            aArticle = new ListViewItem(article, cat, ProductDetailsView.this.productList, 11, false, ProductDetailsView.this.pegasus);
                            aArticle.getView().setViewConverter(ConverterRegistry.getConverter(DeliveryInstructionConverter.class));
                            cat.addChild(aArticle);
                        }
                    }
                } else if (deliverable != null && deliverable.getValue() instanceof EquipmentTemplateDeliverableComplete) {
                    Node template = deliverable.getChildNamed(EquipmentTemplateDeliverableComplete_.equipment);
                    ListViewItem cat = this.ensureAndgetParentCategory(template, DeliverableTypeE.EQUIPMENT);
                    if (cat == null) {
                        ListViewItem aEq = ProductDetailsView.this.productList.getItem4Object(template);
                        if (aEq == null) {
                            aEq = new ListViewItem(template, null, ProductDetailsView.this.productList, 11, false, ProductDetailsView.this.pegasus);
                            aEq.getView().setViewConverter(ConverterRegistry.getConverter(DeliveryInstructionConverter.class));
                            ProductDetailsView.this.productList.addChild(aEq);
                        }
                    } else {
                        cat.setVisible(true);
                        ListViewItem aEq = cat.getItem4Object(template);
                        if (aEq == null) {
                            aEq = new ListViewItem(template, cat, ProductDetailsView.this.productList, 11, false, ProductDetailsView.this.pegasus);
                            aEq.getView().setViewConverter(ConverterRegistry.getConverter(DeliveryInstructionConverter.class));
                            cat.addChild(aEq);
                        }
                    }
                }
            }
        }

        private ListViewItem ensureAndgetParentCategory(Node dto, DeliverableTypeE type) {
            ListViewItem parentCategory = null;
            ListViewItem firstCategory = null;
            if (type == DeliverableTypeE.ARTICLE || type == DeliverableTypeE.PRODUCT) {
                Node cat1 = null;
                if (type == DeliverableTypeE.ARTICLE) {
                    cat1 = dto.getChildNamed(new String[]{"category"});
                } else if (type == DeliverableTypeE.PRODUCT) {
                    cat1 = dto.getChildNamed(new String[]{"currentVariant-category"});
                }
                if (cat1 != null && cat1.getValue() != null) {
                    Node cat2 = cat1.getChildNamed(new String[]{"parent"});
                    if (cat2 != null && cat2.getValue() != null && (parentCategory = ProductDetailsView.this.productList.getItem4Object(cat2)) == null) {
                        parentCategory = new ListViewItem(cat2, null, ProductDetailsView.this.productList, 3, true, ProductDetailsView.this.pegasus);
                        parentCategory.getView().setViewConverter(ConverterRegistry.getConverter(CategoryConverter.class));
                        ProductDetailsView.this.productList.addChild(parentCategory);
                    }
                    if ((firstCategory = parentCategory != null ? parentCategory.getItem4Object(cat1) : ProductDetailsView.this.productList.getItem4Object(cat1)) == null) {
                        if (parentCategory != null) {
                            firstCategory = new ListViewItem(cat1, parentCategory, ProductDetailsView.this.productList, 5, true, ProductDetailsView.this.pegasus);
                            firstCategory.getView().setViewConverter(ConverterRegistry.getConverter(CategoryConverter.class));
                            parentCategory.addChild(firstCategory);
                        } else {
                            firstCategory = new ListViewItem(cat1, null, ProductDetailsView.this.productList, 3, true, ProductDetailsView.this.pegasus);
                            firstCategory.getView().setViewConverter(ConverterRegistry.getConverter(CategoryConverter.class));
                            ProductDetailsView.this.productList.addChild(firstCategory);
                        }
                    }
                    return firstCategory;
                }
            } else if (type == DeliverableTypeE.SERVICE) {
                Node cat = dto.getChildNamed(new String[]{"loadingGroup"});
                if (cat != null && cat.getValue() != null) {
                    ListViewItem catItem = this.theList.getItem4Object(InventoryListViewModel.serviceString);
                    if (catItem == null) {
                        catItem = new ListViewItem(InventoryListViewModel.serviceString, null, this.theList, 3, true, ProductDetailsView.this.pegasus);
                        this.theList.addChild(catItem);
                    } else {
                        catItem.setVisible(true);
                    }
                    Converter c = ConverterRegistry.getConverter(ServiceDeliverableConverter.class);
                    String t = (String)c.convert(dto.getValue(), dto, new Object[0]);
                    ListViewItem subCat = catItem.getItem4Object(t);
                    if (subCat == null) {
                        subCat = new ListViewItem(t, catItem, this.theList, 5, true, ProductDetailsView.this.pegasus);
                        catItem.addChild(subCat);
                    } else {
                        subCat.setVisible(true);
                    }
                    return subCat;
                }
            } else {
                if (type == DeliverableTypeE.SPML_REPLACE) {
                    SPMLMealTypeDeliverableComplete ds = (SPMLMealTypeDeliverableComplete)dto.getValue();
                    String t = "";
                    if (ds.getService() != null) {
                        t = MealPlanToolkit.createServiceGroupString(ds.getService().getCabinClass(), ds.getService().getLegs(), ds.getService().getType());
                    } else if (ds.getServiceSchedule() != null) {
                        t = MealPlanToolkit.createServiceGroupString(ds.getServiceSchedule().getCabinClass(), ds.getServiceSchedule().getLegs(), ds.getServiceSchedule().getType());
                    }
                    ListViewItem catItem = this.theList.getItem4Object(InventoryListViewModel.serviceString);
                    if (catItem == null) {
                        catItem = new ListViewItem(InventoryListViewModel.serviceString, null, this.theList, 3, true, ProductDetailsView.this.pegasus);
                        this.theList.addChild(catItem);
                    } else {
                        catItem.setVisible(true);
                    }
                    ListViewItem subCat = catItem.getItem4Object(t);
                    if (subCat == null) {
                        subCat = new ListViewItem(t, catItem, this.theList, 5, true, ProductDetailsView.this.pegasus);
                        catItem.addChild(subCat);
                    } else {
                        subCat.setVisible(true);
                    }
                    return subCat;
                }
                if (type == DeliverableTypeE.EQUIPMENT) {
                    ListViewItem catItem = this.theList.getItem4Object(InventoryListViewModel.equipmentString);
                    if (catItem == null) {
                        catItem = new ListViewItem(InventoryListViewModel.equipmentString, null, this.theList, 3, true, ProductDetailsView.this.pegasus);
                        this.theList.addChild(catItem);
                    } else {
                        catItem.setVisible(true);
                    }
                    return catItem;
                }
            }
            return null;
        }

        public void childRemoved(Node source, Node child) {
            Node deliverable = null;
            if (child.getValue() instanceof DeliverableComplete) {
                deliverable = child;
            } else if (child.getValue() instanceof DeliveryInstructionComplete) {
                deliverable = child.getParent();
            } else {
                throw new IllegalStateException("Unknown Type found");
            }
            if (deliverable.getValue() instanceof ProductDeliverableComplete) {
                Node product = deliverable.getChildNamed(new String[]{"product"});
                ListViewItem item = ProductDetailsView.this.productList.getItem4Object(product);
                if (item != null) {
                    ListViewItem aParent = item.getParentItem();
                    if (aParent != null) {
                        aParent.removeChild(item);
                        while (aParent != null && aParent.getType() >= 3) {
                            if (aParent.getChilds().size() == 0) {
                                ListViewItem nP = aParent.getParentItem();
                                if (nP == null) {
                                    ProductDetailsView.this.productList.removeChild(aParent);
                                } else {
                                    nP.removeChild(aParent);
                                }
                                aParent = nP;
                                continue;
                            }
                            aParent = aParent.getParentItem();
                        }
                    } else {
                        ProductDetailsView.this.productList.removeChild(item);
                    }
                }
            } else if (deliverable.getValue() instanceof ArticleDeliverableLight || deliverable.getValue() instanceof ArticleDeliverableComplete) {
                Node product = deliverable.getChildNamed(new String[]{"article"});
                ListViewItem item = ProductDetailsView.this.productList.getItem4Object(product);
                if (item == null) {
                    return;
                }
                ListViewItem aParent = item.getParentItem();
                if (aParent != null) {
                    aParent.removeChild(item);
                    while (aParent != null && aParent.getType() >= 3) {
                        if (aParent.getChilds().size() == 0) {
                            ListViewItem nP = aParent.getParentItem();
                            if (nP == null) {
                                ProductDetailsView.this.productList.removeChild(aParent);
                            } else {
                                nP.removeChild(aParent);
                            }
                            aParent = nP;
                            continue;
                        }
                        aParent = aParent.getParentItem();
                    }
                } else {
                    ProductDetailsView.this.productList.removeChild(item);
                }
            } else if (deliverable.getValue() instanceof ServiceDeliverableComplete) {
                ListViewItem item = ProductDetailsView.this.productList.getItem4Object(deliverable.getChildNamed(new String[]{"loadingGroup"}));
                if (item != null) {
                    ListViewItem aParent = item.getParentItem();
                    if (aParent != null) {
                        aParent.removeChild(item);
                        while (aParent != null && aParent.getType() >= 3) {
                            if (aParent.getChilds().size() == 0) {
                                ListViewItem nP = aParent.getParentItem();
                                if (nP == null) {
                                    ProductDetailsView.this.productList.removeChild(aParent);
                                } else {
                                    nP.removeChild(aParent);
                                }
                                aParent = nP;
                                continue;
                            }
                            aParent = aParent.getParentItem();
                        }
                    } else {
                        ProductDetailsView.this.productList.removeChild(item);
                    }
                }
            } else if (deliverable.getValue() instanceof EquipmentTemplateDeliverableComplete) {
                Node product = deliverable.getChildNamed(EquipmentTemplateDeliverableComplete_.equipment);
                ListViewItem item = ProductDetailsView.this.productList.getItem4Object(product);
                if (item == null) {
                    return;
                }
                ListViewItem aParent = item.getParentItem();
                if (aParent != null) {
                    aParent.removeChild(item);
                    while (aParent != null && aParent.getType() >= 3) {
                        if (aParent.getChilds().size() == 0) {
                            ListViewItem nP = aParent.getParentItem();
                            if (nP == null) {
                                ProductDetailsView.this.productList.removeChild(aParent);
                            } else {
                                nP.removeChild(aParent);
                            }
                            aParent = nP;
                            continue;
                        }
                        aParent = aParent.getParentItem();
                    }
                } else {
                    ProductDetailsView.this.productList.removeChild(item);
                }
            }
        }

        public void valueChanged(Node node) {
        }

        @Override
        public void kill() {
            if (this.node != null) {
                this.node.removeNodeListenerRecursively((NodeListener)this);
            }
            this.node = null;
        }

        public void childrenAdded(Node source, Node ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }
    }

    private class ProductLayout
    extends DefaultLayout {
        private ProductLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            ProductDetailsView.this.layoutTitle(parent);
            ProductDetailsView.this.productList.movePanel(1, ProductDetailsView.this.getTitleHeight(), false);
            ProductDetailsView.this.productList.layoutPanel(w - 2, parent.getHeight() - ProductDetailsView.this.getTitleHeight(), false);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, ProductDetailsView.this.getTitleHeight());
        }
    }
}

