/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.deliveryinstruction.utils;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.SortableTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.ArrowButton;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.multiprint.ScrollablePopupInsert;
import ch.icit.pegasus.client.gui.utils.tables.comparators.AlaCarteSequenceNumberComparator;
import ch.icit.pegasus.client.gui.utils.tables.comparators.SequenceNumberComparator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliveryInstructionComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.EquipmentDistributionRuleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSetTypeE;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ALaCarteConfigurationPopup
extends ScrollablePopupInsert {
    private static final long serialVersionUID = 1L;
    private Table2 table;
    private Comparator<?> comparator;
    private PegasusSubModule pegasus;

    public ALaCarteConfigurationPopup(PegasusSubModule pegasus, Node<DeliveryInstructionComplete> node) {
        this.pegasus = pegasus;
        this.comparator = ComparatorRegistry.getComparator(SequenceNumberComparator.class);
        this.table = new Table2(false, "", false, false);
        this.table.setComparator(ComparatorRegistry.getComparator(AlaCarteSequenceNumberComparator.class));
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(1.0, 0.0, "POSITION", null, null, null, "", 70, 70, 70));
        int tw = 2 * this.table.getCellPadding() + this.table.getInnerCellPadding() + 2 * ArrowButton.getPreferredWidth();
        columns.add(new TableColumnInfo(0.0, 0.0, "", null, null, null, "", tw, tw, tw));
        this.table.setModel(new Table2Model(columns, model -> {
            if (model.getNode().getValue() instanceof EquipmentDistributionRuleComplete) {
                EquipmentDistributionView v = new EquipmentDistributionView(model);
                v.setUseControlSkin(Table2RowPanel.TableControlsType.TWO);
                return v;
            }
            return null;
        }));
        this.setProgress(1.0f);
        this.table.getModel().allInitiated();
        this.table.updateOrder();
        Node n = this.createSPMLList(node);
        this.table.getModel().setNode(this.createSPMLList(node));
        this.table.updateOrder();
        this.table.writeNumber("alaCarteSequenceNumber", 0);
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.table);
    }

    private Node createSPMLList(Node<DeliveryInstructionComplete> instruction) {
        ViewNode currentNode = new ViewNode("");
        Iterator it = instruction.getChildNamed(new String[]{"galleyDistributionRules"}).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node gdrc = (Node)it.next();
            Iterator it2 = gdrc.getChildNamed(new String[]{"equipmentDistributionRules"}).getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node edrc = (Node)it2.next();
                if (!Boolean.TRUE.equals(edrc.getChildNamed(new String[]{"isAlaCarteEquipment"}).getValue())) continue;
                currentNode.addChild(edrc, 0L);
            }
        }
        return currentNode;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.table = null;
        this.comparator = null;
    }

    public void setNode(Node<?> node) {
        if (node == null) {
            this.table.resetTable();
            this.setEnabled(false);
        } else {
            this.table.getModel().setNode("galleyDistributionRules", false, node);
            this.setEnabled(true);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean enable = isEnabled && !this.pegasus.isLocked();
        super.setEnabled(enable);
        this.table.setEditable(enable);
        this.table.setEnabled(isEnabled);
    }

    public void resetTable() {
        this.setNode(null);
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    private class EquipmentDistributionView
    extends SortableTable2RowPanel {
        private static final long serialVersionUID = 1L;
        private Node node;
        private Node equipmentNode;
        private TextLabel position;
        private Node insertDistributionRule;
        private boolean isInit;

        public EquipmentDistributionView(Table2RowModel m) {
            super(m);
            this.setSortAttributeName("alaCarteSequenceNumber");
            this.setStartEndOffset(0, 1);
            this.disableDeleteButton();
            this.isInit = true;
            this.setLayout(new EquipmentRowLayout());
            this.node = m.getNode();
            if (this.node.getChildNamed(new String[]{"alaCarteSequenceNumber"}).getValue() == null) {
                this.node.getChildNamed(new String[]{"alaCarteSequenceNumber"}).setValue((Object)1, 0L);
            }
            this.insertDistributionRule = this.node.getChildNamed(new String[]{"insertDistributionRule"});
            this.equipmentNode = this.node.getChildNamed(new String[]{"galleyEquipment"});
            this.equipmentNode.sortChilds(ALaCarteConfigurationPopup.this.comparator);
            String text = ((GalleyEquipmentComplete)this.equipmentNode.getValue()).getPositionCode();
            if (((GalleyEquipmentComplete)this.equipmentNode.getValue()).getEquipmentSetType() == GalleyEquipmentSetTypeE.HOLD) {
                text = text + " (HOLD)";
            }
            this.position = new TextLabel(text);
            this.position.setProgress(1.0f);
            this.add(this.position);
            this.isInit = false;
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean enable = isEnabled && !ALaCarteConfigurationPopup.this.pegasus.isLocked();
            super.setEnabled(enable);
            this.position.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            if (this.model == null) {
                return;
            }
            super.kill();
            this.node = null;
            this.equipmentNode = null;
            this.insertDistributionRule = null;
            if (this.position != null) {
                this.position.kill();
            }
            this.position = null;
        }

        private class EquipmentRowLayout
        extends DefaultLayout {
            private EquipmentRowLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = EquipmentDistributionView.this.model.getParentModel().getColumnWidth(0);
                int inset = EquipmentDistributionView.this.model.getParentModel().getTable().getCellPadding();
                int currentX = 0;
                if (EquipmentDistributionView.this.position != null) {
                    EquipmentDistributionView.this.position.setLocation(currentX + inset, (int)(((double)parent.getHeight() - EquipmentDistributionView.this.position.getPreferredSize().getHeight()) / 2.0));
                    EquipmentDistributionView.this.position.setSize(w - 2 * inset, (int)EquipmentDistributionView.this.position.getPreferredSize().getHeight());
                }
                currentX += w;
                w = EquipmentDistributionView.this.model.getParentModel().getColumnWidth(1);
                EquipmentDistributionView.this.setControlsX(currentX);
                EquipmentDistributionView.this.layoutSortButtons(currentX, parent.getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(20, EquipmentDistributionView.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ALaCarteConfigurationPopup.this.table.setLocation(0, 0);
            ALaCarteConfigurationPopup.this.table.setSize(parent.getWidth(), parent.getHeight() - ALaCarteConfigurationPopup.this.table.getY());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }
    }
}

