/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.fillPanels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.toolkits.MealPlanToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ArticleDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ArticleDeliverableLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.DeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.EquipmentTemplateDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ProductDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.SPMLMealTypeDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ServiceDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.ACateringServiceComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;

public class LabelTextConverter
implements Converter<Object, String> {
    public String convert(Object o, Node<Object> currentNode, Object ... param) {
        Node<Object> n = currentNode;
        String t = "";
        DeliverableComplete i = (DeliverableComplete)n.getParent().getValue();
        if (i instanceof ArticleDeliverableLight) {
            ArticleDeliverableLight l = (ArticleDeliverableLight)i;
            t = l.getArticle().getNumber() + " - " + l.getArticle().getLabelName();
            if (t == null || t.isEmpty()) {
                t = l.getArticle().getName();
            }
            t = "(A) " + t;
        } else if (i instanceof ArticleDeliverableComplete) {
            ArticleDeliverableComplete l = (ArticleDeliverableComplete)i;
            t = l.getArticle().getNumber() + " - " + l.getArticle().getLabelName();
            if (t == null || t.isEmpty()) {
                t = l.getArticle().getName();
            }
            t = "(A) " + t;
        } else if (i instanceof ProductDeliverableComplete) {
            ProductDeliverableComplete l = (ProductDeliverableComplete)i;
            t = l.getProduct().getNumber() + " - " + l.getProduct().getCurrentVariant().getLabelName();
            if (t == null || t.isEmpty()) {
                t = l.getProduct().getCurrentVariant().getName();
            }
            t = "(P) " + t;
        } else if (i instanceof ServiceDeliverableComplete) {
            ServiceDeliverableComplete l = (ServiceDeliverableComplete)i;
            if (l.getLoadingGroup().getContainingService() == null) {
                t = "(S) - no meal plan found";
            } else {
                t = t + MealPlanToolkit.createPostfixServicePartString(l.getLoadingGroup().getContainingService().getCabinClass(), l.getLoadingGroup().getContainingService().getLegs(), l.getLoadingGroup(), l.getLoadingGroup().getContainingService().getType(), false, null);
                ACateringServiceComplete cs = l.getLoadingGroup().getContainingService();
                if (cs instanceof CateringServiceComplete) {
                    CateringServiceComplete csc = (CateringServiceComplete)cs;
                    if (Boolean.TRUE.equals(csc.getExpire())) {
                        t = t + " - expired";
                    }
                    if (Boolean.TRUE.equals(csc.getReplaceExpired())) {
                        t = t + " - replace expired";
                    }
                } else {
                    CateringServiceScheduleVariantComplete cssc = (CateringServiceScheduleVariantComplete)cs;
                    if (Boolean.TRUE.equals(cssc.getBase().getExpire())) {
                        t = t + " - expired";
                    }
                    if (Boolean.TRUE.equals(cssc.getBase().getReplaceExpired())) {
                        t = t + " - replace expired";
                    }
                }
            }
        } else if (i instanceof EquipmentTemplateDeliverableComplete) {
            EquipmentTemplateDeliverableComplete e = (EquipmentTemplateDeliverableComplete)i;
            t = t + "(E) " + e.getEquipment().getCurrentVariant().getName();
        } else if (i instanceof SPMLMealTypeDeliverableComplete) {
            SPMLMealTypeDeliverableComplete m = (SPMLMealTypeDeliverableComplete)i;
            t = t + "(S) " + (m.getSpml() != false ? "SPML" : "alaCarte") + " Space " + m.getMealType().getCode();
        }
        return t;
    }

    public Class<?> getParameterClass() {
        return null;
    }
}

