/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley;

import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.DefaultGalleyModel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyBox;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.SubGalley;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSetTypeE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Point;
import javax.swing.SwingUtilities;

public class DefaultSubGalleyModel
extends DefaultGalleyModel {
    private PegasusSubModule pegasus;
    private Node inserts;

    public DefaultSubGalleyModel(PegasusSubModule peg) {
        this.pegasus = peg;
    }

    @Override
    public int getPegasusState() {
        return this.pegasus.getCurrentState();
    }

    @Override
    public boolean isDefinition() {
        return true;
    }

    @Override
    public void kill() {
        if (this.isKilled) {
            return;
        }
        super.kill();
        this.pegasus = null;
        if (this.inserts != null) {
            this.inserts.removeNodeListener((NodeListener)this);
        }
        this.inserts = null;
    }

    @Override
    public GalleyEquipmentSetTypeE getCurrentSetType() {
        return null;
    }

    @Override
    public boolean setNode(Node node) {
        if (node == this.theNode && node != null) {
            return false;
        }
        this.theView.getGrid().removeAll();
        if (this.theNode != null) {
            this.theNode.removeNodeListener((NodeListener)this);
        }
        if (this.inserts != null) {
            this.inserts.removeNodeListener((NodeListener)this);
        }
        this.theNode = node;
        ((SubGalley)this.theView).loadBackground(this.theNode);
        if (this.theNode == null) {
            this.theView.setSelectedBox(null, 0);
            this.theView.setNullSelection(true);
            return true;
        }
        this.theView.setNullSelection(false);
        this.theView.setTitleString(Words.EQUIPMENT_VIEWER);
        this.inserts = this.theNode.getChildNamed(new String[]{"deliverySpaces"});
        Node n = this.theNode.getChildNamed(new String[]{"equipmentType"}).getChildNamed(new String[]{"numLayers"});
        int number = 0;
        if (n != null && n.getValue() != null) {
            number = (Integer)n.getValue();
        }
        this.theView.getGrid().setGridYCount(number);
        String t = "Equipment Viewer";
        if (this.theNode != null) {
            t = t + " - " + ((GalleyEquipmentComplete)this.theNode.getValue(GalleyEquipmentComplete.class)).getPositionCode();
        }
        this.theView.setTitleString(t);
        this.inserts.addNodeListener((NodeListener)this);
        this.inserts.getAllChildAddEventsFor((NodeListener)this, new String[0]);
        return true;
    }

    public Node getInsertsNode() {
        return this.inserts;
    }

    @Override
    public void childRemoved(Node parent, Node child) {
        GalleyBox box = this.theView.getBox4Node(child);
        child.removeNodeListener((NodeListener)this);
        this.theView.getGrid().removeBox(box);
        if (box != null) {
            box.fadeOut(true);
        }
        this.theView.deactivateEditorIfDeleted(box);
    }

    @Override
    public void childAdded(Node parent, Node child) {
        if (parent == this.inserts) {
            this.theView.insertBox((Node<String>)child);
        }
    }

    @Override
    public Point getTranslatedPoint() {
        return SwingUtilities.convertPoint(this.theView.getGrid(), 0, 0, this.pegasus);
    }

    public void childrenAdded(Node source, Node ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }
}

