/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusGalleyModel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.AbstractGalleyBoxEditor;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.DefaultSubGalleyModel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.Galley;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyBox;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyBoxEditor;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyGrid;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyGridPanel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.GlobalSelectionController;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentInsertComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentTypeComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.batik.swing.JSVGCanvas;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SubGalley
extends GalleyGridPanel {
    private static final long serialVersionUID = 1L;
    public static final int SVG_NONE = 2;
    public static final int SVG_IMAGE = 3;
    private int svgState = 2;
    private GalleyBoxEditor galleyBoxEditor;
    private JSVGCanvas svgContainer;
    private int northBorder;
    private int eastBorder;
    private int southBorder;
    private int westBorder;
    private int eastInset;
    private double gridXCount;
    private double gridYCount;
    private GalleyGridPanel theSuperPanel;
    private String directionBehind = "";
    private String directionDown = "";

    public SubGalley(PegasusSubModule peg, GalleyGridPanel superPanel) {
        this(peg, superPanel, false);
    }

    public SubGalley(PegasusSubModule peg, GalleyGridPanel superPanel, boolean hasTitle) {
        super(peg, hasTitle);
        this.theSuperPanel = superPanel;
        this.theModel = new DefaultSubGalleyModel(peg);
        this.directionBehind = Words.REAR;
        this.directionDown = Words.FRONT;
        this.install();
        this.theModel.setView(this);
    }

    @Override
    public void deactivateEditorIfDeleted(GalleyBox b) {
        if (this.theSelectedBox == b) {
            this.deactivateEditor();
        }
    }

    @Override
    public GalleyBox getBox4Node(Node node) {
        return this.theGrid.getInsertBox4Node(node);
    }

    @Override
    protected void deactivateEditor() {
        this.activateEditor4Box(null);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }

    private void install() {
        this.theGrid = new GalleyGrid(this);
        this.theGrid.setSubGrid(true);
        this.theGrid.setGridXCount(1.0);
        this.theGrid.setGridYCount(14.0);
        this.setHasBackground(true);
        this.svgContainer = new JSVGCanvas();
        this.svgContainer.setOpaque(false);
        this.svgContainer.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.galleyBoxEditor = new GalleyBoxEditor(((PegasusGalleyModel)this.theSuperPanel.getModel()).getPegasus(), true);
        this.galleyBoxEditor.setSubGalley(true);
        this.theProgress = 1.0f;
        this.setTitleString(Words.NO_BOX_SELECTED);
        this.setLayout(new Layout());
        this.add((Component)this.theGrid, 0);
        this.add((Component)this.galleyBoxEditor, 0);
    }

    @Override
    public void activateEditor4Box(GalleyBox box) {
        if (this.theSelectedBox != null && box != null) {
            this.theSelectedBox.setEditorEnabled(true);
            ((Galley)this.theSuperPanel).activateEditor4Box(null);
            this.galleyBoxEditor.setLabelActive(box.hasLabel());
            this.galleyBoxEditor.setResizerActiv(box.isServiceSpace());
            this.galleyBoxEditor.setCurrentGalleyBox(box);
            if (this.galleyBoxEditor.getProgress() == 0.0f) {
                this.setComponentZOrder(this.galleyBoxEditor, 0);
                this.galleyBoxEditor.setLocation(box.getX() + this.theGrid.getX() - this.galleyBoxEditor.getXOffset(), box.getY() + this.theGrid.getY() - this.galleyBoxEditor.getYOffset());
                this.galleyBoxEditor.setSize(box.getWidth() + this.galleyBoxEditor.getXOffset() + this.galleyBoxEditor.getXEndOffset(), box.getHeight() + this.galleyBoxEditor.getYOffset() + this.galleyBoxEditor.getYEndOffset());
                this.galleyBoxEditor.fadeIn();
            } else {
                this.setComponentZOrder(this.galleyBoxEditor, 0);
                this.galleyBoxEditor.setLocation(box.getX() + this.theGrid.getX() - this.galleyBoxEditor.getXOffset(), box.getY() + this.theGrid.getY() - this.galleyBoxEditor.getYOffset());
                this.galleyBoxEditor.setSize(box.getWidth() + this.galleyBoxEditor.getXOffset() + this.galleyBoxEditor.getXEndOffset(), box.getHeight() + this.galleyBoxEditor.getYOffset() + this.galleyBoxEditor.getYEndOffset());
            }
        } else {
            if (this.theSelectedBox != null) {
                this.theSelectedBox.setEditorEnabled(false);
                this.theSelectedBox.enableNameEdit(false, false);
            }
            if (this.galleyBoxEditor.getProgress() > 0.0f) {
                this.galleyBoxEditor.fadeOut(false);
            }
        }
    }

    protected void loadBackground(Node node) {
        int oldState = this.svgState;
        String props = null;
        if (node != null) {
            Node equip = node;
            Node type = equip.getChildNamed(new String[]{"equipmentType"});
            URL url = null;
            String att = ((GalleyEquipmentTypeComplete)type.getValue()).getSvgImageData();
            if (((GalleyEquipmentTypeComplete)type.getValue()).getCode().equals("CO")) {
                att = null;
            }
            if (att != null) {
                url = AttributesConverter.getSVGFile(LafLoader.getLafLoader().getAttribute(att));
                this.svgState = 3;
            } else {
                this.svgState = 2;
            }
            if (att != null && !att.equals("")) {
                props = AttributeLoader.getAttributeLoader().getAttribute(att);
            }
            if (url != null) {
                try {
                    this.svgContainer.setURI(url.toString());
                }
                catch (Exception e) {
                    ErrorSupport.fireException((Thread)Thread.currentThread(), (Exception)e, (String)("Unable to load SVG data: " + e.getMessage()), (boolean)false, (boolean)true, (UserComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                }
            }
            this.gridXCount = ((GalleyEquipmentTypeComplete)type.getValue()).getSize().getDepth();
            this.gridYCount = ((GalleyEquipmentTypeComplete)type.getValue()).getSize().getHeight();
        } else {
            this.svgState = 2;
            this.gridXCount = -1.0;
            this.gridYCount = -1.0;
        }
        if (props == null) {
            props = AttributeLoader.getAttributeLoader().getAttribute("gc_subgalley_default_svg");
        }
        this.readProps(props);
        if (this.gridXCount == -1.0) {
            this.gridXCount = 1.0;
        }
        if (this.gridYCount == -1.0) {
            this.gridYCount = 2.0;
        }
        if (oldState == 2) {
            if (this.svgState != 2) {
                this.add((Component)this.svgContainer, -1);
            }
        } else if (this.svgState == 2) {
            this.remove((Component)this.svgContainer);
        }
        this.theGrid.setGridXCount(this.gridXCount);
        this.getLayout().layoutContainer(this);
    }

    private void readProps(String p) {
        String[] ps = p.split(",");
        this.northBorder = Integer.parseInt(ps[1]);
        this.eastBorder = Integer.parseInt(ps[2]);
        this.southBorder = Integer.parseInt(ps[3]);
        this.westBorder = Integer.parseInt(ps[0]);
        this.eastInset = Integer.parseInt(ps[5]);
    }

    public static Document string2Dom(String xml) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(new InputSource(new StringReader(xml)));
    }

    private void drawAxis(Graphics2D g2, int x1, int y1, int x2, int y2) {
        int[] xCoo = new int[3];
        int[] yCoo = new int[3];
        g2.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
        if (x1 > x2) {
            xCoo[0] = x1 + 7;
            xCoo[1] = x1;
            xCoo[2] = x1 + 7;
            yCoo[0] = y1 - 3;
            yCoo[1] = y1;
            yCoo[2] = y1 + 3;
            g2.drawLine(x1, y1, x2, y2);
        }
        if (x2 > x1) {
            xCoo[0] = x2 - 7;
            xCoo[1] = x2;
            xCoo[2] = x2 - 7;
            yCoo[0] = y1 - 3;
            yCoo[1] = y1;
            yCoo[2] = y1 + 4;
            g2.drawLine(x1, y1, x2 - 3, y2);
            g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
            g2.drawString(this.directionBehind, x2 - (g2.getFontMetrics().stringWidth(this.directionBehind) + 10), y1 + g2.getFont().getSize() + 5);
        }
        if (y1 > y2) {
            xCoo[0] = x1 - 3;
            xCoo[1] = x1;
            xCoo[2] = x1 + 4;
            yCoo[0] = y2 + 7;
            yCoo[1] = y2;
            yCoo[2] = y2 + 7;
            g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_line_color")));
            g2.drawLine(x1, y1, x2, y2 + 3);
            g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
            g2.drawString(this.directionDown, x1 + 3, y1);
        }
        if (y2 > y1) {
            xCoo[0] = x1 - 4;
            xCoo[1] = x1;
            xCoo[2] = x1 + 4;
            yCoo[0] = y2 - 7;
            yCoo[1] = y2;
            yCoo[2] = y2 - 7;
            g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_line_color")));
            g2.drawLine(x1, y1, x2, y2);
        }
        g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_line_color")));
        g2.fillPolygon(xCoo, yCoo, 3);
    }

    @Override
    public void layoutPanel(int w, int h, boolean resize) {
    }

    @Override
    public void movePanel(int x, int y, boolean smooth) {
        this.setLocation(x, y);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(AlphaComposite.getInstance(3, this.theProgress));
        if (this.hasBackground) {
            g2.setColor(this.innerBackground);
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.arcW, this.arcH);
        }
        if (this.hasSkin) {
            this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        }
        if (this.useCliping) {
            Shape r = this.getClipingArea();
            g2.clip(r);
        }
        this.paintChildren(g2);
        if (this.isNullSelection) {
            if (this.notSelectedShape != null) {
                this.notSelectedShape.paint(g2);
            }
        } else if (this.isExpanded()) {
            g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_line_color")));
            this.drawAxis(g2, 5, this.getHeight() - 5, 5, 5 + this.getTitleHeight());
            this.drawAxis(g2, 2, this.getHeight() - 20, this.getWidth() - 5, this.getHeight() - 20);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.galleyBoxEditor != null) {
            this.galleyBoxEditor.kill();
        }
        this.galleyBoxEditor = null;
        this.svgContainer = null;
    }

    @Override
    public GlobalSelectionController getGlobalSelectionContoller() {
        return this.theSuperPanel.getGlobalSelectionContoller();
    }

    @Override
    public void selectBox(GalleyBox box, int x, int y) {
        if (this.theSelectedBox == null && box == null) {
            return;
        }
        int hint = 11;
        Node node = null;
        if (box == null) {
            node = this.theModel.getNode();
            hint = 5;
        } else if (box.getBoxNode().getValue() instanceof GalleyEquipmentComplete) {
            node = box.getNode();
        } else {
            node = box.getBoxNode();
            if (node.getValue() instanceof GalleyEquipmentInsertComplete) {
                GalleyEquipmentInsertComplete e = (GalleyEquipmentInsertComplete)node.getValue();
                boolean d = false;
                if (node.getChildNamed(new String[]{"labelConfiguration-display"}) != null) {
                    d = (Boolean)node.getChildNamed(new String[]{"labelConfiguration-display"}).getValue();
                }
                node = d ? box.getBoxNode() : box.getNode();
            }
        }
        if (node == null) {
            return;
        }
        this.theSelectedBox = box;
        if (this.theSelectedBox == null) {
            box = this.pegasus.getGalley().getBox4Node(node);
        }
        this.theSuperPanel.getGlobalSelectionContoller().newNodeSelected(node, this, hint, box);
        if (this.theSelectedBox == null && box == null) {
            return;
        }
    }

    public GalleyGridPanel getSuperPanel() {
        return this.theSuperPanel;
    }

    @Override
    public AbstractGalleyBoxEditor getEditor() {
        return this.galleyBoxEditor;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int h = parent.getHeight();
            int titleHeight = 0;
            SubGalley.this.layoutTitle(parent);
            titleHeight = SubGalley.this.getTitleHeight();
            if (SubGalley.this.isExpanded()) {
                SubGalley.this.theGrid.setVisible(true);
                SubGalley.this.svgContainer.setLocation(15, titleHeight + 10);
                SubGalley.this.svgContainer.setSize(parent.getWidth() - (2 * SubGalley.this.svgContainer.getX() + SubGalley.this.eastInset), parent.getHeight() - (SubGalley.this.svgContainer.getY() + 21));
                switch (SubGalley.this.svgState) {
                    case 3: {
                        SubGalley.this.theGrid.setLocation(SubGalley.this.svgContainer.getX() + SubGalley.this.westBorder, SubGalley.this.svgContainer.getY() + SubGalley.this.northBorder);
                        SubGalley.this.theGrid.setSize(SubGalley.this.svgContainer.getWidth() + SubGalley.this.eastBorder, SubGalley.this.svgContainer.getHeight() + SubGalley.this.southBorder);
                        break;
                    }
                    case 2: {
                        SubGalley.this.theGrid.setLocation(SubGalley.this.westBorder, titleHeight + SubGalley.this.northBorder);
                        SubGalley.this.theGrid.setSize(parent.getWidth() - (2 * SubGalley.this.theGrid.getX() + SubGalley.this.eastBorder), parent.getHeight() - (SubGalley.this.theGrid.getY() + SubGalley.this.southBorder));
                    }
                }
            } else {
                SubGalley.this.theGrid.setVisible(false);
            }
            SubGalley.this.generateShape(w, h);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

