/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListViewItem;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.image.ImageConsumer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Timer;

public class DragableItem
extends JPanelKillable
implements ActionListener,
ImageConsumer {
    private static final long serialVersionUID = 1L;
    private static BufferedImage theImage;
    private static ListViewItem theItem;
    private static Point theStartPos;
    private static Timer theAnimationTimer;
    private static long theStartTime;
    private static Point theEndPos;
    private static boolean isAnimating;

    public DragableItem(ListViewItem item) {
        this.setItem(item);
    }

    public void createImage(BufferedImage aImage) {
        theImage = aImage;
        Point p = theItem.getAbsolutPos();
        theStartPos = new Point((int)p.getX() - 5, (int)p.getY() - theImage.getHeight() / 2);
        this.setLocation(theStartPos);
        this.setSize(theImage.getWidth(), theImage.getHeight());
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        theImage.flush();
        theImage = null;
        theItem = null;
        theStartPos = null;
        theAnimationTimer = null;
        theEndPos = null;
    }

    public void moveItem(double dx, double dy) {
        this.setLocation((int)(theStartPos.getX() - dx), (int)(theStartPos.getY() - dy));
    }

    public void setItem(ListViewItem item) {
        theItem = item;
    }

    public void stopAllAnimations(ListViewItem item) {
        isAnimating = false;
        if (theAnimationTimer != null) {
            theAnimationTimer.stop();
            theAnimationTimer = null;
        }
        this.setItem(item);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(AlphaComposite.getInstance(3, 0.8f));
        g2.drawImage(theImage, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), null);
    }

    public void rejectDrag() {
        theEndPos = new Point(this.getX(), this.getY());
        isAnimating = true;
        this.ensureTimer();
    }

    private void ensureTimer() {
        if (theAnimationTimer == null) {
            theAnimationTimer = new Timer(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("animationRate")), this);
            theAnimationTimer.setRepeats(true);
            theStartTime = System.currentTimeMillis();
            theAnimationTimer.start();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!isAnimating) {
            return;
        }
        long cTime = System.currentTimeMillis();
        long dt = cTime - theStartTime;
        if (dt > (long)AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("animationTime")).intValue()) {
            theAnimationTimer.stop();
            this.setVisible(false);
            theItem.dragItemReturned();
            this.getParent().repaint(32L);
            this.getParent().remove(this);
            theAnimationTimer = null;
        } else {
            double p = (double)dt / (double)AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("animationTime")).intValue();
            p = Math.sin(0.7853981633974483 + 0.7853981633974483 * p);
            double dx = theEndPos.getX() - theStartPos.getX();
            double dy = theEndPos.getY() - theStartPos.getY();
            this.setLocation((int)(theEndPos.getX() - (dx *= p)), (int)(theEndPos.getY() - (dy *= p)));
        }
    }

    @Override
    public void loadImages() {
    }

    @Override
    public void clearImages() {
    }

    static {
        isAnimating = false;
    }
}

