/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.DragController;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.DragableItem;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListViewItem;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListViewItemDragRule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListViewItemSelectionRule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListViewModel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListViewViewController;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.search.SearchAlgorithmus;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.FadeInOutPanel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.GlobalSelectionController;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.combobox.CustomScrollBarUI;
import ch.icit.pegasus.client.gui.utils.panels.AnimationPanel;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextField;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.util.LoadingStateComponent;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ListView
extends FadeInOutPanel
implements KeyListener,
LafListener,
AttributeListener,
LoadingStateComponent,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private ArrayList<ListViewItem> theChilds = new ArrayList();
    private GlobalSelectionController theGlobalSelectinController;
    private ListViewModel theModel;
    private DragController theDragController;
    private boolean hasSearchBox = false;
    private SearchTextField theSearchBox;
    private boolean isDefault = true;
    private JScrollPane theScrollPane;
    private JPanel theViewport;
    private ListViewItemDragRule theDragRule;
    private ListViewItemSelectionRule theSelectionRule;
    private ListViewItem theSelectedItem;
    private ListViewViewController theViewControler;
    private String listSearchDefaultText = "";
    private List<SearchAlgorithmus> searchAlgorithm = new ArrayList<SearchAlgorithmus>();
    private Comparator comparator;
    private Color searchBarBackground;
    private int searchBarHeight;
    protected AnimationPanel animationPanel;
    private int gapToTitle;
    private Converter converter;

    public ListView(boolean search) {
        this(search, true);
    }

    public ListView(boolean search, boolean hasBackground) {
        super(hasBackground);
        this.hasSearchBox = search;
        this.lafAttributeChanged("All attribues changed");
        this.attributeChanged("All attributes changed");
        this.install();
        this.listSearchDefaultText = Words.ENTER_YOUR_SEARCH;
        if (this.hasSearchBox) {
            this.theSearchBox.setDefaultText(this.listSearchDefaultText);
        }
    }

    public boolean itemsExpanded() {
        return false;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        for (ListViewItem i : this.theChilds) {
            i.setEnabled(isEnabled);
        }
        this.theScrollPane.setEnabled(isEnabled);
    }

    @Override
    public void activateDataLoadingAnimation(String t, Integer a, Integer b) {
        if (this.animationPanel == null) {
            this.animationPanel = new AnimationPanel();
            this.add((Component)this.animationPanel, 0);
        }
    }

    public void updateOrder() {
        if (this.comparator != null) {
            Collections.sort(this.theChilds, this.comparator);
            for (ListViewItem i : this.theChilds) {
                i.updateOrder(this.comparator);
            }
        }
    }

    public void setComparator(Comparator comp) {
        this.comparator = comp;
    }

    @Override
    public void deactivateDataLoadingAnimation() {
        if (this.animationPanel != null) {
            this.remove(this.animationPanel);
            this.animationPanel = null;
            this.repaint(32L);
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
        super.lafAttributeChanged(att);
        this.searchBarBackground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("gc_searchbar_background"));
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.hasSearchBox) {
            this.disableSearch(false);
        }
        for (ListViewItem i : (List)this.theChilds.clone()) {
            i.kill();
        }
        this.theChilds.clear();
        this.theChilds = null;
        this.theGlobalSelectinController = null;
        this.theModel.kill();
        this.theModel = null;
        this.theDragController = null;
        this.remove(this.theScrollPane);
        this.theScrollPane = null;
        this.theViewport = null;
        this.theDragRule = null;
        this.theSelectionRule = null;
        this.theSelectedItem = null;
        this.theViewControler = null;
        this.searchAlgorithm = null;
        this.comparator = null;
        if (this.animationPanel != null) {
            this.animationPanel.kill();
            this.animationPanel = null;
        }
    }

    public void addChild(ListViewItem aItem) {
        this.theChilds.add(aItem);
        aItem.install();
        this.addToScrollPane(aItem);
        this.layoutPanel(this.getWidth(), this.getHeight(), false);
    }

    private void install() {
        if (this.hasSearchBox) {
            this.enableSearch(false);
        }
        this.theScrollPane = new JScrollPane();
        this.theScrollPane.setHorizontalScrollBarPolicy(31);
        this.theScrollPane.setVerticalScrollBarPolicy(20);
        this.theScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.theScrollPane.getVerticalScrollBar().setUI(new CustomScrollBarUI(1));
        this.theScrollPane.getVerticalScrollBar().setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_table_panel_background_color")));
        this.theViewport = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_table_panel_background_color")));
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.paintChildren(g2);
            }
        };
        this.theViewport.setLayout(null);
        this.theScrollPane.setViewportView(this.theViewport);
        this.theViewport.setVisible(true);
        this.theScrollPane.setVisible(true);
        this.setLayout(null);
        this.add((Component)this.theScrollPane, 0);
    }

    public void addToScrollPane(JComponent item) {
        if (this.theScrollPane != null) {
            this.theViewport.add(item);
        }
    }

    protected void removeFromScrollPane(JComponent item) {
        if (this.theScrollPane != null) {
            this.theViewport.remove(item);
        }
    }

    protected int getScrollBarWidth() {
        int w = 0;
        if (this.theScrollPane.getVerticalScrollBar().isVisible()) {
            w = (int)((double)w + this.theScrollPane.getVerticalScrollBar().getPreferredSize().getWidth());
        }
        return w;
    }

    @Override
    public void layoutPanel(int w, int h, boolean resize) {
        int aHeight = 0;
        int aWidth = w;
        int titleHeight = 0;
        this.layoutTitle(this);
        titleHeight = this.getTitleHeight();
        if (this.isExpanded()) {
            if (this.animationPanel != null) {
                this.animationPanel.setLocation(1, 1);
                this.animationPanel.setSize(w - 2, h - 2);
            }
            this.theScrollPane.setVisible(true);
            if (this.hasSearchBox) {
                this.theSearchBox.setVisible(true);
                this.theSearchBox.setLocation(5, (int)((double)titleHeight + ((double)this.searchBarHeight - this.theSearchBox.getPreferredSize().getHeight()) / 2.0));
                this.theSearchBox.setSize(aWidth - 10, 0);
                aHeight += this.searchBarHeight;
            }
            aHeight += titleHeight;
            int aScrollHeight = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("gc_listview_scrollpane_default_height"));
            if (!this.isDefault) {
                aScrollHeight = h - 1 - aHeight;
            }
            if (!this.hasSkin) {
                this.theScrollPane.setSize(aWidth, aScrollHeight);
            } else {
                this.theScrollPane.setSize(aWidth - 2, aScrollHeight - 1);
            }
            int aTempHeight = 0;
            int aTempWidth = (int)this.theScrollPane.getViewport().getViewSize().getWidth();
            if (aTempWidth <= 1) {
                aTempWidth = aWidth - 13;
            }
            for (ListViewItem aItem : this.theChilds) {
                if (!aItem.isShown()) continue;
                aItem.setVisible(true);
                aItem.setLocation(0, aTempHeight);
                aTempHeight += aItem.layoutItem(aTempWidth, aTempHeight);
                if (!aItem.isExpanded()) continue;
                aTempHeight += AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_default_cellpadding")).intValue();
            }
            this.theViewport.setPreferredSize(new Dimension(aTempWidth, aTempHeight));
            this.theViewport.revalidate();
            if (!this.hasSearchBox) {
                this.theScrollPane.setLocation(1, aHeight + this.gapToTitle + 1);
                aHeight += this.gapToTitle;
            } else if (!this.hasSkin) {
                this.theScrollPane.setLocation(0, aHeight);
            } else {
                this.theScrollPane.setLocation(5, aHeight);
            }
            aHeight += this.theScrollPane.getHeight();
        } else {
            titleHeight += this.getTitleHeight();
            this.theScrollPane.setVisible(false);
            if (this.hasSearchBox) {
                this.theSearchBox.setVisible(false);
            }
            aHeight += titleHeight;
        }
        if (!this.isDefault) {
            this.setSize(w, h);
        } else {
            this.setSize(w, aHeight);
        }
        this.repaint(32L);
    }

    public DragableItem startDrag(ListViewItem item) {
        return this.theDragController.getDragItemImage(item);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(AlphaComposite.getInstance(3, this.theProgress));
        if (this.hasSearchBox) {
            g2.setColor(this.searchBarBackground);
            int t = 0;
            if (this.hasSkin) {
                t = this.getTitleHeight();
            }
            g2.fillRect(0, t, this.getWidth(), this.searchBarHeight - t);
        }
        super.paint(g2);
    }

    public void resetList() {
        for (ListViewItem item : this.theChilds) {
            this.theViewport.remove(item);
            item.kill();
        }
        this.theChilds.clear();
    }

    @Override
    public void movePanel(int x, int y, boolean smooth) {
        this.setLocation(x, y);
    }

    public void selectItem(ListViewItem listViewItem, int level) {
        if (this.theSelectedItem != null && this.theSelectedItem != listViewItem) {
            this.theSelectedItem.setSelected(7);
        }
        if (listViewItem != null) {
            this.theGlobalSelectinController.newNodeSelected(listViewItem.getUserObject(0), this, level, listViewItem);
        }
        this.theSelectedItem = listViewItem;
        this.repaint(32L);
    }

    public void setSelectedItem(ListViewItem item, int level) {
        if (this.theSelectedItem != null && this.theSelectedItem != item) {
            this.theSelectedItem.setSelected(7);
        }
        this.theSelectedItem = item != null ? item : null;
        this.repaint(32L);
    }

    public ListViewItem getItem4Object(Object userObject) {
        for (ListViewItem item : this.theChilds) {
            if (item.checkUserObject(userObject)) {
                return item;
            }
            ListViewItem item2 = item.getItem4Object(userObject);
            if (item2 == null) continue;
            return item2;
        }
        return null;
    }

    public void scrollTo(ListViewItem listViewItem) {
        Rectangle aRect = new Rectangle(listViewItem.getX(), listViewItem.getY(), listViewItem.getWidth(), listViewItem.getHeight());
        Rectangle bRect = this.theScrollPane.getViewport().getViewRect();
        aRect.setSize((int)bRect.getWidth(), (int)aRect.getHeight());
        if (!bRect.contains(aRect)) {
            int yScrollPos = (int)(aRect.getY() - bRect.getHeight() / 2.0);
            if (yScrollPos < 0) {
                yScrollPos = 0;
            }
            this.theScrollPane.getVerticalScrollBar().setValue(yScrollPos);
        }
    }

    public void removeChild(ListViewItem entry) {
        entry.removeChilds();
        this.theChilds.remove(entry);
        this.removeFromScrollPane(entry);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            ListViewItem item = this.getUpperItem(this.theSelectedItem);
            if (item != null) {
                this.selectItem(item, item.getType());
            }
        } else if (e.getKeyCode() == 40) {
            ListViewItem item = this.getLowerItem(this.theSelectedItem);
            if (item != null) {
                this.selectItem(item, item.getType());
            }
        } else if (e.getKeyCode() == 39) {
            this.tryExpand(true, this.theSelectedItem);
            e.consume();
        } else if (e.getKeyCode() == 37) {
            this.tryExpand(false, this.theSelectedItem);
            e.consume();
        }
    }

    private void tryExpand(boolean b, ListViewItem item) {
        if (item != null && item.getType() < 11 && item.setExpanded(b)) {
            this.layoutPanel(this.getWidth(), this.getHeight(), true);
        }
    }

    private ListViewItem getChild(int i) {
        if (i < this.theChilds.size() && i >= 0) {
            return this.theChilds.get(i);
        }
        return null;
    }

    private ListViewItem getLowerItem(ListViewItem item) {
        if (item.isExpanded() && item.getChildCount() > 0) {
            return item.getChild(0);
        }
        if (item.getParentItem() == null) {
            int i = this.theChilds.indexOf(item);
            return this.getChild(i + 1);
        }
        int i = item.getParentItem().getChildIndex(item);
        if (i + 1 < item.getParentItem().getChildCount() && item.isShown()) {
            return item.getParentItem().getChild(i + 1);
        }
        ListViewItem item2 = item.getParentItem();
        if (item2.getParentItem() == null) {
            i = this.theChilds.indexOf(item2);
            ListViewItem i2 = this.getChild(i + 1);
            if (i2 != null && i2.isShown()) {
                return i2;
            }
        } else {
            ListViewItem item3 = item2.getParentItem();
            if (item3 == null || item3.getParentItem() == null) {
                item3 = item2;
            }
            if ((i = item3.getParentItem().getChildIndex(item3)) + 1 == item3.getParentItem().getChildCount()) {
                i = this.theChilds.indexOf(item3.getParentItem());
                ListViewItem i2 = this.getChild(i + 1);
                if (i2 != null && i2.isShown()) {
                    return i2;
                }
            } else {
                ListViewItem i2 = item3.getParentItem().getChild(i + 1);
                if (i2.isShown()) {
                    return i2;
                }
            }
        }
        return null;
    }

    private ListViewItem getUpperItem(ListViewItem item) {
        int i;
        if (item == null) {
            return null;
        }
        ListViewItem item2 = null;
        if (item.getParentItem() == null) {
            i = this.theChilds.indexOf(item);
            item2 = this.getChild(i - 1);
        } else {
            i = item.getParentItem().getChildIndex(item);
            if (i == 0) {
                item2 = item.getParentItem();
                if (item2.isShown()) {
                    return item2;
                }
            } else {
                item2 = item.getParentItem().getChild(i - 1);
            }
        }
        if (item2 != null) {
            while (Boolean.TRUE.equals(item2.isExpanded())) {
                item2 = item2.getChild(item2.getChildCount() - 1);
            }
            if (item2.isShown()) {
                return item2;
            }
        }
        return null;
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public ListViewItem getSelectedItem(int level) {
        ListViewItem selectedItem = null;
        for (ListViewItem item : this.theChilds) {
            selectedItem = item.isSelected() == level ? item : item.getSelectedItem(level);
            if (selectedItem == null) continue;
            return selectedItem;
        }
        return selectedItem;
    }

    public void setTitle(String string) {
        this.setTitleString(string);
    }

    public JScrollPane getScrollPane() {
        return this.theScrollPane;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(0, 0);
    }

    public void setGlobalSelectionController(GlobalSelectionController cont) {
        this.theGlobalSelectinController = cont;
    }

    public GlobalSelectionController getGlobalSelectionController() {
        return this.theGlobalSelectinController;
    }

    public void setDefault(boolean b) {
        this.isDefault = b;
    }

    public void setViewControler(ListViewViewController viewControler) {
        this.theViewControler = viewControler;
    }

    public ListViewViewController getViewControler() {
        return this.theViewControler;
    }

    public ListViewModel getModel() {
        return this.theModel;
    }

    public void setModel(ListViewModel model) {
        this.theModel = model;
    }

    public void setSelectionRule(ListViewItemSelectionRule rule) {
        this.theSelectionRule = rule;
    }

    public ListViewItemSelectionRule getSelectionRule() {
        return this.theSelectionRule;
    }

    public void setDragRule(ListViewItemDragRule rule) {
        this.theDragRule = rule;
    }

    public ListViewItemDragRule getDragRule() {
        return this.theDragRule;
    }

    public ListViewItem getSelectedItem() {
        return this.theSelectedItem;
    }

    public DragController getItemDragController() {
        return this.theDragController;
    }

    public void setItemDragController(DragController cont) {
        this.theDragController = cont;
    }

    public void disableSearch(boolean relayout) {
        this.hasSearchBox = false;
        if (this.theSearchBox != null && this.theSearchBox.getTextField() != null) {
            this.theSearchBox.getDocument().addDocumentListener(this);
            this.remove(this.theSearchBox);
            this.theSearchBox = null;
            if (relayout) {
                this.layoutPanel(this.getWidth(), this.getHeight(), false);
            }
        }
    }

    public void enableSearch(boolean relayout) {
        this.hasSearchBox = true;
        if (this.theSearchBox == null) {
            this.theSearchBox = new SearchTextField();
            this.theSearchBox.getDocument().addDocumentListener(this);
            this.theSearchBox.setProgress(1.0f);
            this.add((Component)this.theSearchBox, 0);
            if (relayout) {
                this.layoutPanel(this.getWidth(), this.getHeight(), false);
            }
        }
    }

    @Override
    public void attributeChanged(String attributeName) {
        super.attributeChanged(attributeName);
        this.searchBarHeight = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("gc_listview_searchbar_height"));
    }

    private void searchTextChanged(DocumentEvent e) {
        String t = this.theSearchBox.getText();
        if (this.searchAlgorithm != null) {
            for (SearchAlgorithmus s : this.searchAlgorithm) {
                s.search(this.theChilds, t);
            }
            this.layoutPanel(this.getWidth(), this.getHeight(), false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.searchTextChanged(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.searchTextChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.searchTextChanged(e);
    }

    public void addSearchAlgorithm(SearchAlgorithmus searchAlgorithm) {
        this.searchAlgorithm.add(searchAlgorithm);
    }

    public SearchAlgorithmus getSearchAlgorithm(int i) {
        return this.searchAlgorithm.size() > i ? this.searchAlgorithm.get(i) : null;
    }

    public SearchAlgorithmus getSearchAlgorithm() {
        return this.searchAlgorithm.size() > 0 ? this.searchAlgorithm.get(0) : null;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public Converter getConverter() {
        return this.converter;
    }
}

