/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.DragableItem;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListView;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListViewItemView;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.SelectableItem;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.gui.utils.skins.Skin9Field;
import ch.icit.pegasus.client.node.impls.Node;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.SwingUtilities;

public class ListViewItem
extends JPanelKillable
implements MouseListener,
MouseMotionListener,
SelectableItem {
    private static final long serialVersionUID = 1L;
    public static final int GROUP1 = 3;
    public static final int GROUP2 = 5;
    public static final int GROUP3 = 7;
    public static final int ITEM = 11;
    protected static int theItemHeight = 16;
    private ArrayList<Object> theUserObjects = new ArrayList();
    private ListViewItem theParent;
    private int theType = -1;
    private boolean isExpanded = false;
    private boolean theBackUpExpandedState = false;
    private ArrayList<ListViewItem> theChilds = new ArrayList();
    private boolean isDragging = false;
    private Point theBackupPoint;
    private static DragableItem theDragItem;
    private int isSelected = 7;
    private ListView theListParent;
    private boolean isGroup = false;
    private ListViewItemView theView;
    private boolean isShown = true;
    private PegasusSubModule pegasus;

    public ListViewItem(Object n, ListViewItem p, ListView lp, int type, boolean group, PegasusSubModule pegasus) {
        this.pegasus = pegasus;
        this.isGroup = group;
        this.theUserObjects.add(n);
        this.theParent = p;
        this.theListParent = lp;
        this.theType = type;
        this.isExpanded = this.theListParent.itemsExpanded();
        this.setView(this.theListParent.getViewControler().getViewClass(this.theListParent, this));
    }

    public DragableItem getDragItem() {
        return theDragItem;
    }

    public void setShown(boolean b) {
        this.isShown = b;
    }

    public boolean isShown() {
        return this.isShown;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
    }

    public Iterator<Object> getUserObjects() {
        return this.theUserObjects.iterator();
    }

    public void addUserObject(Object obj) {
        this.theUserObjects.add(obj);
        this.theView.userObjectAdded();
    }

    public void addChild(ListViewItem aItem) {
        aItem.install();
        this.theChilds.add(aItem);
        this.theListParent.addToScrollPane(aItem);
        this.theListParent.layoutPanel(this.theListParent.getWidth(), this.theListParent.getHeight(), false);
    }

    protected void install() {
        this.setLayout(null);
        this.setFocusable(true);
        this.addKeyListener(this.theListParent);
        switch (this.theType) {
            case 3: {
                if (this.theListParent.getDragRule() == null || !this.theListParent.getDragRule().isDraggAllowed(this.theListParent, this)) break;
                this.addMouseMotionListener(this);
                break;
            }
            case 5: 
            case 11: {
                this.addMouseMotionListener(this);
            }
        }
        this.addMouseListener(this);
    }

    public int layoutItem(int w, int h) {
        switch (this.theType) {
            case 3: 
            case 5: 
            case 7: {
                int aHeight = theItemHeight;
                if (!this.isShown) {
                    aHeight = 0;
                }
                if (this.isExpanded) {
                    for (ListViewItem aItem : this.theChilds) {
                        int subTotalHeight;
                        if (aItem.isShown()) {
                            aItem.setLocation(0, aHeight + h);
                            subTotalHeight = aItem.layoutItem(w, aHeight + h);
                            aHeight += subTotalHeight;
                            continue;
                        }
                        aHeight = 0;
                        subTotalHeight = aItem.layoutItem(w, aHeight + h);
                        aHeight += subTotalHeight;
                    }
                }
                if (this.isShown) {
                    this.setSize(w, theItemHeight);
                } else {
                    this.setSize(w, 0);
                }
                return aHeight;
            }
            case 11: {
                if (this.isShown) {
                    this.setSize(w, theItemHeight);
                } else {
                    this.setSize(w, 0);
                }
                return this.getHeight();
            }
        }
        return 0;
    }

    public void paintItem(Graphics g, boolean isCloning, Skin9Field theShadowSkin, int w, int h) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.theView.paintView(g, isCloning, theShadowSkin, w, h);
        this.paintChildren(g2);
    }

    @Override
    public void paint(Graphics g) {
        this.paintItem(g, false, null, this.getWidth(), this.getHeight());
    }

    public ArrayList<ListViewItem> getChilds() {
        return this.theChilds;
    }

    protected boolean reshowAll() {
        boolean childs = false;
        for (ListViewItem i : this.theChilds) {
            if (!i.reshowAll()) continue;
            childs = true;
        }
        if (!this.isShown) {
            childs = true;
        }
        if (this.theParent != null && !this.theParent.isExpanded()) {
            this.setVisible(false);
        } else if (this.theParent != null) {
            this.setVisible(true);
        }
        this.isShown = true;
        return childs;
    }

    private boolean expand(boolean e, boolean saveState) {
        if (this.theChilds.size() == 0) {
            return false;
        }
        if (e != this.isExpanded) {
            this.theBackUpExpandedState = saveState ? this.isExpanded : false;
            this.isExpanded = e;
            if (e) {
                if (this.theParent != null && !this.theParent.isExpanded()) {
                    this.theParent.expand(true, true);
                }
                for (ListViewItem aItem : this.theChilds) {
                    aItem.setVisible(true);
                    if (!aItem.theBackUpExpandedState) continue;
                    aItem.expand(true, false);
                }
            } else {
                for (ListViewItem aItem : this.theChilds) {
                    aItem.setVisible(false);
                    aItem.expand(false, true);
                }
            }
            return true;
        }
        return false;
    }

    public BufferedImage getCloneImage(Skin9Field theShadowSkin, int minimalHeight, int minWidth) {
        int aWidth = minWidth;
        int aHeight = minimalHeight;
        BufferedImage bi = new BufferedImage(aWidth, aHeight += theShadowSkin.getImage11(Button.ButtonState.UP).getHeight() + theShadowSkin.getImage13(Button.ButtonState.UP).getHeight(), 2);
        this.paintItem(bi.getGraphics(), true, theShadowSkin, aWidth, aHeight);
        return bi;
    }

    public Point getAbsolutPos() {
        Point p = null;
        p = this.theListParent.getModel().getPegasusState() == 3 ? SwingUtilities.convertPoint(this, (int)this.theBackupPoint.getX(), (int)this.theBackupPoint.getY(), this.theListParent.getParent().getParent()) : SwingUtilities.convertPoint(this, (int)this.theBackupPoint.getX(), (int)this.theBackupPoint.getY(), this.theListParent.getParent().getParent().getParent().getParent());
        return p;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public void selectItem() {
        if (!(this.theType >= 11 || this.isExpanded && this.isSelected == 7)) {
            this.expand(!this.isExpanded, false);
            this.theListParent.layoutPanel(this.theListParent.getWidth(), this.theListParent.getHeight(), false);
        }
        if (this.theListParent.getSelectionRule().allowedToSelect(this.theListParent, this)) {
            this.theListParent.selectItem(this, this.theType);
            this.theListParent.scrollTo(this);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.theBackupPoint = new Point(e.getX(), e.getY());
        if (this.theListParent.getSelectionRule().allowedToSelect(this.theListParent, this)) {
            switch (this.theType) {
                case 3: {
                    if (e.getX() >= 8 && e.getX() <= 19 && e.getY() >= 3 && e.getY() <= 11) {
                        this.expand(!this.isExpanded, false);
                        this.theListParent.layoutPanel(this.theListParent.getWidth(), this.theListParent.getHeight(), false);
                        break;
                    }
                    if (!this.contains(e.getPoint())) break;
                    this.selectItem();
                    break;
                }
                case 5: {
                    if (e.getX() >= 18 && e.getX() <= 38 && e.getY() >= 3 && e.getY() <= 11) {
                        this.expand(!this.isExpanded, false);
                        this.theListParent.layoutPanel(this.theListParent.getWidth(), this.theListParent.getHeight(), false);
                        break;
                    }
                    if (!this.contains(e.getPoint())) break;
                    this.selectItem();
                    break;
                }
                case 7: {
                    if (e.getX() >= 29 && e.getX() <= 27 && e.getY() >= 3 && e.getY() <= 11) {
                        this.expand(!this.isExpanded, false);
                        this.theListParent.layoutPanel(this.theListParent.getWidth(), this.theListParent.getHeight(), false);
                        break;
                    }
                    if (!this.contains(e.getPoint())) break;
                    this.selectItem();
                    break;
                }
                case 11: {
                    if (!this.contains(e.getPoint())) break;
                    this.selectItem();
                }
            }
        } else {
            this.expand(!this.isExpanded, false);
            this.theListParent.layoutPanel(this.theListParent.getWidth(), this.theListParent.getHeight(), false);
        }
    }

    public void processDraggReturn(boolean isAccepted) {
        this.theListParent.getItemDragController().stopDragging();
        if (!isAccepted) {
            if (theDragItem != null) {
                theDragItem.rejectDrag();
            }
        } else if (theDragItem != null) {
            theDragItem.setVisible(false);
            theDragItem.getParent().repaint(32L);
            theDragItem.getParent().remove(this);
        }
        this.isDragging = false;
    }

    protected void dragItemReturned() {
        theDragItem = null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isDragging) {
            boolean bl = this.theListParent.getItemDragController().dropItem(this, theDragItem);
        }
    }

    private void requestFocusNow() {
        this.requestFocusInWindow();
    }

    protected boolean checkUserObject(Object obj) {
        for (Object ob : this.theUserObjects) {
            if (ob == obj) {
                return true;
            }
            if (ob != null && ob.equals(obj)) {
                return true;
            }
            if (!(ob instanceof Node) || !(obj instanceof Node) || ((Node)ob).getValue() == null) continue;
            return ((Node)ob).getValue().equals(((Node)obj).getValue());
        }
        return false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.pegasus.isLocked()) {
            return;
        }
        if (!this.isDragging && (Math.abs(this.theBackupPoint.getX() - (double)e.getX()) > (double)AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("gc_minimal_drag_distance")).intValue() || Math.abs(this.theBackupPoint.getY() - (double)e.getY()) > (double)AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("gc_minimal_drag_distance")).intValue())) {
            if (this.theListParent.getDragRule() != null && this.theListParent.getDragRule().isDraggAllowed(this.theListParent, this)) {
                theDragItem = this.theListParent.startDrag(this);
                this.isDragging = true;
            }
        } else if (this.isDragging) {
            double dx = this.theBackupPoint.getX() - (double)e.getX();
            double dy = this.theBackupPoint.getY() - (double)e.getY();
            this.theListParent.getItemDragController().moveItem(dx, dy, theDragItem, this);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public ListViewItem getItem4Object(Object userObject) {
        for (ListViewItem item : this.theChilds) {
            if (item.checkUserObject(userObject)) {
                return item;
            }
            ListViewItem item2 = item.getItem4Object(userObject);
            if (item2 == null) continue;
            return item2;
        }
        return null;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        for (ListViewItem item : this.theChilds) {
            item.kill();
        }
        this.theChilds.clear();
        this.theChilds = null;
        this.theUserObjects.clear();
        this.theUserObjects = null;
        this.theParent = null;
        this.theListParent = null;
        this.theView.kill();
        this.theView = null;
    }

    protected void tempRemove() {
        for (ListViewItem item : this.theChilds) {
            if (item.getParent() == null) continue;
            item.getParent().remove(item);
            item.tempRemove();
        }
    }

    protected void reAddItems() {
        for (ListViewItem item : this.theChilds) {
            this.theListParent.addToScrollPane(item);
            item.reAddItems();
        }
    }

    public void removeChild(ListViewItem item) {
        this.theChilds.remove(item);
        if (item.getParent() != null) {
            item.getParent().remove(item);
        }
        item.removeChilds();
    }

    public void removeChilds() {
        for (ListViewItem item : this.theChilds) {
            if (item.getParent() == null) continue;
            item.getParent().remove(item);
            item.removeChilds();
        }
    }

    public ListViewItem getChild(int i) {
        if (i < this.theChilds.size() && i >= 0) {
            return this.theChilds.get(i);
        }
        return null;
    }

    public int getChildIndex(ListViewItem item2) {
        return this.theChilds.indexOf(item2);
    }

    public ListViewItem getSelectedItem(int level) {
        for (ListViewItem item : this.theChilds) {
            ListViewItem selectedItem = item.isSelected() == level ? item : item.getSelectedItem(level);
            if (selectedItem == null) continue;
            return selectedItem;
        }
        return null;
    }

    @Override
    public void setSelected(int level) {
        this.isSelected = level;
        switch (level) {
            case 2: {
                this.requestFocusNow();
                break;
            }
            case 3: {
                break;
            }
        }
    }

    @Override
    public int isSelected() {
        return this.isSelected;
    }

    @Override
    public Component getTopParent() {
        return this.theListParent;
    }

    public ListViewItem getParentItem() {
        return this.theParent;
    }

    public int getDragOffSetX() {
        return (int)this.theBackupPoint.getX();
    }

    public int getDragOffSetY() {
        return (int)this.theBackupPoint.getY();
    }

    public int getType() {
        return this.theType;
    }

    public Object getUserObject(int i) {
        if (this.theUserObjects.size() > i) {
            return this.theUserObjects.get(i);
        }
        return null;
    }

    public ListView getParentList() {
        return this.theListParent;
    }

    public boolean setExpanded(boolean b) {
        return this.expand(b, false);
    }

    public boolean isGroup() {
        return this.isGroup;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public int getChildCount() {
        return this.theChilds.size();
    }

    public String getText() {
        return this.theUserObjects.get(0).toString();
    }

    public void setView(ListViewItemView view) {
        this.theView = view;
    }

    public ListViewItemView getView() {
        return this.theView;
    }

    public void updateOrder(Comparator comparator) {
        Comparator c = comparator;
        Collections.sort(this.theChilds, c);
        for (ListViewItem i : this.theChilds) {
            i.updateOrder(c);
        }
    }

    @Override
    public boolean stillAlive() {
        return true;
    }
}

