/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.popuppanels;

import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.ListItemDragController;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListViewItem;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.loaders.BasicArticleLoader;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.client.validator.AmountExistenceValidator;
import ch.icit.pegasus.client.validator.ValidationChangedListener;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class AddInventoryPanel
extends PopUpInsert
implements ValidationChangedListener,
RemoteLoader {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextField> amount;
    private TitledItem<InputComboBox2> amount2;
    private final ListItemDragController.DragItemType returnType;
    private boolean isValid = false;
    private SystemSettingsComplete settings;
    private UserComplete currentUser;
    private int state = 0;
    private LoadingAnimation animation;
    private final ListViewItem item;
    boolean allUnitsAllowed = false;

    public AddInventoryPanel(ListItemDragController.DragItemType returnType, ListViewItem item) {
        this.setOpaque(false);
        this.setLayout(new Layout());
        this.item = item;
        this.returnType = returnType;
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        String title = "";
        switch (returnType) {
            case ADD_SERVICE_TO_SERVICE: {
                break;
            }
            case ARTICLE: {
                title = Words.AMOUNT_OF_ARTICLE;
                this.amount2 = new TitledItem<InputComboBox2>(new InputComboBox2(null, null, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG), title, TitledItem.TitledItemOrientation.NORTH);
                break;
            }
            case EQUIPMENT: {
                title = Words.AMOUNT_OF_EQUIPMENT;
                this.amount = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.INT), title, TitledItem.TitledItemOrientation.NORTH);
                this.amount.getElement().setText("1");
                break;
            }
            case PRODUCT: {
                title = Words.AMOUNT_OF_PRODUCT;
                this.amount = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.INT), title, TitledItem.TitledItemOrientation.NORTH);
                this.amount.getElement().setText("1");
                break;
            }
            case SERVICE: {
                break;
            }
        }
        if (this.amount != null) {
            this.amount.getElement().setValidator(new AmountExistenceValidator());
            this.amount.getElement().addValidationStateChangedListener(this);
            this.amount.getElement().setProgress(1.0f);
            this.amount.setProgress(1.0f);
            this.add(this.amount);
        }
        if (this.amount2 != null) {
            this.amount2.getElement().setProgress(1.0f);
            this.amount2.setProgress(1.0f);
            this.add(this.amount2);
        }
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        if (this.returnType == ListItemDragController.DragItemType.ARTICLE) {
            Node n = (Node)this.item.getUserObject(0);
            if (n.getValue(BasicArticleLight.class) != null && n.getValue(BasicArticleComplete.class) == null) {
                this.ensureAnimation(Words.LOAD_ARTICLE);
                this.state = 23;
                new BasicArticleLoader((BasicArticleReference)((BasicArticleLight)n.getValue(BasicArticleLight.class)), this, n, this);
            } else {
                BasicArticleComplete artC = (BasicArticleComplete)n.getValue(BasicArticleComplete.class);
                ViewNode poss = UnitConversionToolkitNodeBased.getUnitList(artC, new Timestamp(System.currentTimeMillis()), this.allUnitsAllowed, this.settings);
                this.amount2.getElement().setPossibleUnits((Node)poss);
                QuantityComplete q = new QuantityComplete(Double.valueOf(1.0), artC.getBaseUnit());
                q.setClientOId(Long.valueOf(q.getNextId()));
                Node am = INodeCreator.getDefaultImpl().getNode4DTO((Object)q, false, false);
                this.amount2.getElement().setNode(am);
            }
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.animation != null) {
            this.animation.kill();
            this.animation = null;
        }
        if (this.amount != null) {
            this.amount.kill();
        }
        if (this.amount2 != null) {
            this.amount2.kill();
        }
        this.amount = null;
        this.amount2 = null;
    }

    @Override
    public boolean validateContent() {
        if (this.amount != null) {
            if (!this.isValid && this.amount != null) {
                this.amount.getElement().ensureValidatorState();
            }
            return this.isValid;
        }
        if (this.amount2 != null) {
            Long a = TransactionToolkit.getLongValue(this.amount2.getElement().getValueNode());
            return a > 0L;
        }
        return true;
    }

    @Override
    public boolean usePictureBorder() {
        return true;
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        final Node n = (Node)this.item.getUserObject(0);
        if (this.returnType == ListItemDragController.DragItemType.ARTICLE) {
            if (n.getValue(BasicArticleLight.class) != null && n.getValue(BasicArticleComplete.class) == null) {
                this.ensureAnimation(Words.LOAD_ARTICLE);
                ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                    @Override
                    public Node<?> loadData() throws Exception {
                        BasicArticleComplete p = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle((BasicArticleReference)((BasicArticleLight)n.getValue(BasicArticleLight.class))).getValue();
                        n.setValue((Object)p, 0L);
                        return n;
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return AddInventoryPanel.this;
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            } else {
                super.enterPressed(isOK);
            }
        } else {
            super.enterPressed(isOK);
        }
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        if (this.amount != null) {
            Object[] o = new Object[]{this.returnType, this.amount.getElement().getText()};
            return o;
        }
        if (this.amount2 != null) {
            Object[] o = new Object[5];
            o[0] = this.returnType;
            StoreQuantityComplete q = new StoreQuantityComplete();
            q.setClientOId(Long.valueOf(q.getNextId()));
            Long a = TransactionToolkit.getLongValue(this.amount2.getElement().getValueNode());
            q.setAmount(a);
            q.setUnit((UnitComplete)this.amount2.getElement().getUnitNode().getValue());
            o[1] = q;
            o[2] = null;
            o[3] = null;
            o[4] = false;
            return o;
        }
        return null;
    }

    @Override
    public void validationChanged(int value) {
        this.isValid = value == 3;
        this.popup.createFocusCycle();
    }

    private void stopAnimation() {
        if (this.animation != null) {
            this.animation.stop();
            this.animation.fadeOut(true);
        }
    }

    private void ensureAnimation(String text) {
        this.popup.enableOKButton(false);
        this.popup.enableCancelButton(false);
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
        }
        this.animation.stateChanged(text);
        this.add(this.animation);
        this.validate();
        this.animation.fadeIn();
        if (this.amount != null) {
            this.amount.setVisible(false);
        }
        if (this.amount2 != null) {
            this.amount2.setVisible(false);
        }
        this.animation.start();
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        if (this.amount != null) {
            a.addAll(this.amount.getFocusComponents());
        }
        if (this.amount2 != null) {
            a.addAll(this.amount2.getFocusComponents());
        }
        return a;
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.stopAnimation();
        if (this.state == 0) {
            super.enterPressed(PopupAction.OK_FOREGROUND);
        } else {
            BasicArticleComplete artC = (BasicArticleComplete)node.getValue(BasicArticleComplete.class);
            ViewNode poss = UnitConversionToolkitNodeBased.getUnitList(artC, new Timestamp(System.currentTimeMillis()), this.allUnitsAllowed, this.settings);
            this.amount2.getElement().setPossibleUnits((Node)poss);
            poss.addChildren(ArticleToolkit.getSelectableUnitsForArticle(node));
            this.amount2.getElement().setPossibleUnits((Node)poss);
            QuantityComplete q = new QuantityComplete(Double.valueOf(1.0), artC.getBaseUnit());
            q.setClientOId(Long.valueOf(q.getNextId()));
            Node am = INodeCreator.getDefaultImpl().getNode4DTO((Object)q, false, false);
            this.amount2.getElement().setNode(am);
            this.popup.enableCancelButton(true);
            this.popup.enableOKButton(true);
        }
        if (this.amount != null) {
            this.amount.setVisible(true);
            this.amount.requestFocusInWindowNow();
        }
        if (this.amount2 != null) {
            this.amount2.setVisible(true);
            this.amount2.requestFocusInWindowNow();
        }
        this.state = 0;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (AddInventoryPanel.this.amount != null) {
                AddInventoryPanel.this.amount.setLocation(0, 0);
                AddInventoryPanel.this.amount.setSize(parent.getWidth(), (int)AddInventoryPanel.this.amount.getPreferredSize().getHeight());
            }
            if (AddInventoryPanel.this.amount2 != null) {
                AddInventoryPanel.this.amount2.setLocation(0, 0);
                AddInventoryPanel.this.amount2.setSize(parent.getWidth(), (int)AddInventoryPanel.this.amount2.getPreferredSize().getHeight());
            }
            if (AddInventoryPanel.this.animation != null) {
                AddInventoryPanel.this.animation.setLocation((int)(((double)parent.getWidth() - AddInventoryPanel.this.animation.getPreferredSize().getWidth()) / 2.0), (int)(((double)parent.getHeight() - AddInventoryPanel.this.animation.getPreferredSize().getHeight()) / 2.0));
                AddInventoryPanel.this.animation.setSize(AddInventoryPanel.this.animation.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(150, 130);
        }
    }
}

