/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.popuppanels;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.DefaultObject2ObjectConverter;
import ch.icit.pegasus.client.converter.GalleyEquipmentInsertTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.ListItemDragController;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListViewItem;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.loaders.BasicArticleLoader;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentInsertTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AddServicePanel
extends PopUpInsert
implements RemoteLoader,
ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextField> amount;
    private TitledItem<ComboBox> tray;
    private TitledItem<CheckBox> reservedSpace;
    private TitledItem<InputComboBox2> amountCombo;
    private TitledItem<TextField> itemsPerTray;
    private Object userObject;
    private SystemSettingsComplete settings;
    private UserComplete currentUser;
    private final ListItemDragController.DragItemType returnType;
    private final ListViewItem item;
    private LoadingAnimation animation;

    public AddServicePanel(Node allTrays, Object userObject, ListItemDragController.DragItemType returnType, Node<GalleyEquipmentInsertTypeComplete> defaultInsertType, ListViewItem item, boolean isCompartment) {
        this.setOpaque(false);
        this.setLayout(new Layout());
        this.item = item;
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.returnType = returnType;
        this.userObject = userObject;
        this.currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        switch (this.returnType) {
            case SERVICE: 
            case ADD_SERVICE_TO_SERVICE: 
            case ALACARTE_SPACE: 
            case SPML_SPACE: {
                this.amount = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.INT), Words.MAX_AMOUNT_OF_SERVICES, TitledItem.TitledItemOrientation.NORTH);
                this.itemsPerTray = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.INT), "Items per Tray (Label configuration only)", TitledItem.TitledItemOrientation.NORTH);
                this.itemsPerTray.getElement().setText("1");
                break;
            }
            case ARTICLE: {
                this.amountCombo = new TitledItem<InputComboBox2>(new InputComboBox2(null, null, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG), Words.MAX_AMOUNT_OF_ARTICLE, TitledItem.TitledItemOrientation.NORTH);
                break;
            }
            case EQUIPMENT: {
                this.amount = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.INT), Words.AMOUNT_OF_EQUIPMENT, TitledItem.TitledItemOrientation.NORTH);
                break;
            }
            case PRODUCT: {
                this.amount = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.INT), Words.AMOUNT_OF_PRODUCT, TitledItem.TitledItemOrientation.NORTH);
                break;
            }
        }
        if (this.amount != null) {
            this.amount.getElement().setText("1");
        }
        this.reservedSpace = new TitledItem<CheckBox>(new CheckBox(), Words.USE_RESERVED_SPACE, TitledItem.TitledItemOrientation.EAST);
        this.reservedSpace.getElement().addButtonListener(this);
        this.tray = new TitledItem<ComboBox>(new ComboBox(null, this.generateListOfTrays(allTrays, false), ConverterRegistry.getConverter(DefaultObject2ObjectConverter.class), ConverterRegistry.getConverter(DefaultObject2ObjectConverter.class), ConverterRegistry.getConverter(GalleyEquipmentInsertTypeConverter.class)), Words.TRAY, TitledItem.TitledItemOrientation.NORTH);
        if (defaultInsertType != null && defaultInsertType.getValue() != null) {
            int i = this.tray.getElement().getItemCount();
            for (int o = 0; o < i; ++o) {
                Node n = (Node)this.tray.getElement().getItemAt(o);
                if (!((GalleyEquipmentInsertTypeComplete)defaultInsertType.getValue()).equals(n.getValue())) continue;
                this.tray.getElement().setSelectedIndex(o);
                o = i;
            }
        }
        switch (this.returnType) {
            case SERVICE: 
            case ALACARTE_SPACE: 
            case SPML_SPACE: {
                this.reservedSpace.getElement().setChecked(true);
            }
            case ADD_SERVICE_TO_SERVICE: {
                this.add(this.amount);
                this.reservedSpace.setEnabled(false);
                String t = this.item.getUserObject(1) instanceof String ? (String)this.item.getUserObject(1) : null;
                int i = this.tray.getElement().getItemCount();
                boolean found = false;
                if (t != null) {
                    for (int o = 0; o < i; ++o) {
                        Node n = (Node)this.tray.getElement().getItemAt(o);
                        if (!((GalleyEquipmentInsertTypeComplete)n.getValue()).getName().toLowerCase().contains(t.toLowerCase())) continue;
                        this.tray.getElement().setSelectedIndex(o);
                        o = i;
                        found = true;
                    }
                }
                if (!found) break;
                this.tray.setEnabled(false);
                break;
            }
            case ARTICLE: {
                this.amountCombo.setProgress(0.0f);
                this.tray.setProgress(0.0f);
                this.reservedSpace.setProgress(0.0f);
                this.add(this.amountCombo);
                break;
            }
            case EQUIPMENT: 
            case PRODUCT: {
                this.amount.setProgress(1.0f);
                this.tray.setProgress(1.0f);
                this.reservedSpace.setProgress(1.0f);
                this.add(this.amount);
                break;
            }
        }
        this.add(this.tray);
        this.add(this.reservedSpace);
        if (this.itemsPerTray != null) {
            this.add(this.itemsPerTray);
        }
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        if (this.returnType == ListItemDragController.DragItemType.ARTICLE) {
            Node n = (Node)this.item.getUserObject(0);
            if (n.getValue(BasicArticleLight.class) != null && n.getValue(BasicArticleComplete.class) == null) {
                this.ensureAnimation(Words.LOAD_ARTICLE);
                new BasicArticleLoader((BasicArticleReference)((BasicArticleLight)n.getValue(BasicArticleLight.class)), this, n, this);
            } else {
                this.remoteObjectLoaded(n);
            }
        }
    }

    private void ensureAnimation(String text) {
        this.popup.enableOKButton(false);
        this.popup.enableCancelButton(false);
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
        }
        this.animation.stateChanged(text);
        this.add(this.animation);
        this.validate();
        this.animation.fadeIn();
        if (this.returnType != ListItemDragController.DragItemType.ARTICLE) {
            this.amount.setVisible(false);
        } else {
            this.amountCombo.setVisible(false);
        }
        this.tray.setVisible(false);
        this.reservedSpace.setVisible(false);
        this.animation.start();
    }

    private void stopAnimation() {
        if (this.animation != null) {
            this.animation.stop();
            this.animation.fadeOut(true);
        }
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (!this.validateContent()) {
            return;
        }
        super.enterPressed(isOK);
    }

    @Override
    public boolean usePictureBorder() {
        return true;
    }

    private Node generateListOfTrays(Node allTrays, boolean isCompartment) {
        ViewNode nn = new ViewNode("list");
        if (isCompartment) {
            GalleyEquipmentInsertTypeComplete t = ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getLooseEquipmentInsertType();
            Node geitcNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)t, true, false);
            nn.addChild(geitcNode, 0L);
        } else {
            Iterator it = allTrays.getChilds();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                GalleyEquipmentInsertTypeComplete space = (GalleyEquipmentInsertTypeComplete)n.getValue();
                nn.addChild(n, 0L);
            }
        }
        return nn;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.animation != null) {
            this.animation.kill();
            this.animation = null;
        }
        this.reservedSpace.kill();
        this.reservedSpace = null;
        if (this.returnType != ListItemDragController.DragItemType.ARTICLE) {
            this.amount.kill();
            this.amount = null;
        } else {
            this.amountCombo.kill();
            this.amountCombo = null;
        }
        this.tray.kill();
        this.tray = null;
        if (this.itemsPerTray != null) {
            this.itemsPerTray.kill();
        }
        this.itemsPerTray = null;
        this.userObject = null;
    }

    @Override
    public boolean validateContent() {
        int i;
        String t;
        boolean isValid = true;
        if (this.itemsPerTray != null) {
            t = this.itemsPerTray.getElement().getText();
            try {
                i = Integer.valueOf(t);
                if (i < 1) {
                    isValid = false;
                    this.itemsPerTray.getElement().setInvalid();
                }
            }
            catch (NumberFormatException e) {
                isValid = false;
                this.itemsPerTray.getElement().setInvalid();
            }
        }
        if (this.amount != null) {
            t = this.amount.getElement().getText();
            try {
                i = Integer.valueOf(t);
                if (i < 1) {
                    isValid = false;
                    this.amount.getElement().setInvalid();
                }
            }
            catch (NumberFormatException e) {
                isValid = false;
                this.amount.getElement().setInvalid();
            }
        }
        return isValid;
    }

    @Override
    public boolean tryToGrabFocus() {
        if (this.returnType != ListItemDragController.DragItemType.ARTICLE) {
            return true;
        }
        return true;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        Object[] o = new Object[6];
        if (this.returnType == ListItemDragController.DragItemType.ARTICLE) {
            Long d = TransactionToolkit.getLongValue(this.amountCombo.getElement().getValueNode());
            UnitComplete unit = (UnitComplete)this.amountCombo.getElement().getUnitNode().getValue();
            StoreQuantityComplete q = new StoreQuantityComplete();
            q.setClientOId(Long.valueOf(q.getNextId()));
            q.setAmount(d);
            q.setUnit(unit);
            o[1] = q;
        } else {
            o[1] = this.amount.getElement().getText();
        }
        o[2] = this.tray.getElement().getSelectedItem();
        o[3] = this.userObject;
        o[4] = this.reservedSpace.getElement().isChecked();
        o[0] = this.returnType;
        if (this.itemsPerTray != null) {
            o[5] = this.itemsPerTray.getElement().getText();
        }
        return o;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.tray.getElement().getCurrentPopUp() != null) {
            for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.tray.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        if (this.returnType == ListItemDragController.DragItemType.ARTICLE) {
            a.addAll(this.amountCombo.getFocusComponents());
        } else {
            a.addAll(this.amount.getFocusComponents());
        }
        a.addAll(this.reservedSpace.getFocusComponents());
        a.addAll(this.tray.getFocusComponents());
        if (this.itemsPerTray != null) {
            a.addAll(this.itemsPerTray.getFocusComponents());
        }
        return a;
    }

    @Override
    public boolean isClosableWithEnter() {
        if (this.tray.getElement().hasFocus()) {
            return !this.tray.getElement().isPopupVisible();
        }
        return true;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.stopAnimation();
        this.tray.setVisible(true);
        this.reservedSpace.setVisible(true);
        if (this.itemsPerTray != null) {
            this.itemsPerTray.setVisible(true);
        }
        if (this.returnType != ListItemDragController.DragItemType.ARTICLE) {
            this.amount.setVisible(true);
            super.enterPressed(PopupAction.OK_FOREGROUND);
        } else {
            BasicArticleComplete article = (BasicArticleComplete)node.getValue(BasicArticleComplete.class);
            Timestamp validity = new Timestamp(System.currentTimeMillis());
            List possibleUnits = StoreToolkit.getPossibleUnits((BasicArticleLight)article, null, (Timestamp)validity, (TransactionType)TransactionType.IN_STOWING_LIST, (UserComplete)this.currentUser, null, null, (SystemSettingsComplete)this.settings);
            ViewNode poss = UnitConversionToolkitNodeBased.getUnitList(possibleUnits);
            StoreQuantityComplete q = new StoreQuantityComplete();
            q.setAmount(Long.valueOf(1L));
            q.setUnit(article.getBaseUnit());
            Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)q, false, false);
            this.amountCombo.getElement().setNode(n);
            this.amountCombo.getElement().setPossibleUnits((Node)poss);
            this.amountCombo.setVisible(true);
            this.amountCombo.getElement().getFocusComponents().get(0).requestFocusInWindow();
            this.amountCombo.fadeIn();
            this.tray.fadeIn();
            this.reservedSpace.fadeIn();
            this.popup.enableCancelButton(true);
            this.popup.enableOKButton(true);
            this.invalidate();
            this.validate();
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.reservedSpace.getElement()) {
            if (this.reservedSpace.getElement().isChecked()) {
                switch (this.returnType) {
                    case SERVICE: 
                    case ADD_SERVICE_TO_SERVICE: 
                    case ALACARTE_SPACE: 
                    case SPML_SPACE: {
                        this.amount.setTitleText(Words.MAX_AMOUNT_OF_SERVICES);
                        break;
                    }
                    case ARTICLE: {
                        this.amountCombo.setTitleText(Words.ST_ADDSERVICE_ARTICLE_AMOUNT_RESERVED_CHECKED);
                        break;
                    }
                    case EQUIPMENT: {
                        this.amount.setTitleText(Words.AMOUNT_OF_EQUIPMENT);
                        break;
                    }
                    case PRODUCT: {
                        this.amount.setTitleText(Words.MAX_AMOUNT_OF_PRODUCTS);
                        break;
                    }
                }
            } else {
                switch (this.returnType) {
                    case SERVICE: 
                    case ADD_SERVICE_TO_SERVICE: 
                    case ALACARTE_SPACE: 
                    case SPML_SPACE: {
                        this.amount.setTitleText(Words.MAX_AMOUNT_OF_SERVICES);
                        break;
                    }
                    case ARTICLE: {
                        this.amountCombo.setTitleText(Words.MAX_AMOUNT_OF_ARTICLE);
                        break;
                    }
                    case EQUIPMENT: {
                        this.amount.setTitleText(Words.MAX_AMOUNT_OF_EQUIPMENT);
                        break;
                    }
                    case PRODUCT: {
                        this.amount.setTitleText(Words.AMOUNT_OF_PRODUCT);
                        break;
                    }
                }
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int yBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("popup_yborder"));
            if (AddServicePanel.this.animation != null) {
                AddServicePanel.this.animation.setLocation((int)(((double)parent.getWidth() - AddServicePanel.this.animation.getPreferredSize().getWidth()) / 2.0), (int)(((double)parent.getHeight() - AddServicePanel.this.animation.getPreferredSize().getHeight()) / 2.0));
                AddServicePanel.this.animation.setSize(AddServicePanel.this.animation.getPreferredSize());
            }
            int currentY = 0;
            if (AddServicePanel.this.returnType != ListItemDragController.DragItemType.ARTICLE) {
                AddServicePanel.this.amount.setLocation(0, 0);
                AddServicePanel.this.amount.setSize(parent.getWidth(), (int)AddServicePanel.this.amount.getPreferredSize().getHeight());
                currentY = AddServicePanel.this.amount.getY() + AddServicePanel.this.amount.getHeight();
            } else {
                AddServicePanel.this.amountCombo.setLocation(0, 0);
                AddServicePanel.this.amountCombo.setSize(parent.getWidth(), (int)AddServicePanel.this.amountCombo.getPreferredSize().getHeight());
                currentY = AddServicePanel.this.amountCombo.getY() + AddServicePanel.this.amountCombo.getHeight();
            }
            AddServicePanel.this.reservedSpace.setLocation(0, currentY + yBorder);
            AddServicePanel.this.reservedSpace.setSize(parent.getWidth(), (int)AddServicePanel.this.reservedSpace.getPreferredSize().getHeight());
            AddServicePanel.this.tray.setLocation(0, AddServicePanel.this.reservedSpace.getY() + AddServicePanel.this.reservedSpace.getHeight() + yBorder);
            AddServicePanel.this.tray.setSize(parent.getWidth(), (int)AddServicePanel.this.tray.getPreferredSize().getHeight());
            if (AddServicePanel.this.itemsPerTray != null) {
                AddServicePanel.this.itemsPerTray.setLocation(0, AddServicePanel.this.tray.getY() + AddServicePanel.this.tray.getHeight() + yBorder);
                AddServicePanel.this.itemsPerTray.setSize(parent.getWidth(), (int)AddServicePanel.this.itemsPerTray.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int yBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("popup_yborder"));
            int h = 0;
            int w = 0;
            h = AddServicePanel.this.returnType == ListItemDragController.DragItemType.ARTICLE ? (int)((double)h + AddServicePanel.this.amountCombo.getPreferredSize().getHeight()) : (int)((double)h + AddServicePanel.this.amount.getPreferredSize().getHeight());
            h += yBorder;
            h = (int)((double)h + AddServicePanel.this.reservedSpace.getPreferredSize().getHeight());
            h += yBorder;
            h = (int)((double)h + AddServicePanel.this.tray.getPreferredSize().getHeight());
            h += yBorder;
            if (AddServicePanel.this.itemsPerTray != null) {
                h = (int)((double)h + AddServicePanel.this.itemsPerTray.getPreferredSize().getHeight());
                h += yBorder;
            }
            if ((double)(w = AddServicePanel.this.returnType == ListItemDragController.DragItemType.ARTICLE ? (int)AddServicePanel.this.amountCombo.getPreferredSize().getWidth() : (int)AddServicePanel.this.amount.getPreferredSize().getWidth()) < AddServicePanel.this.tray.getPreferredSize().getWidth()) {
                w = (int)AddServicePanel.this.tray.getPreferredSize().getWidth();
            }
            return new Dimension(250, h);
        }
    }
}

