/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.popuppanels;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.popuppanels.utils.RowSorter;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.DefaultTable2RowImpl;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowLayoutConstrain;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.ILegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.APassengerSetComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.PassengerSetComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.PassengerSetTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLegComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PaxKeyChooserPanel
extends PopUpInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private Table2 table;
    private Node node;
    private Node paxKeys;
    private final int prefHeight = 200;
    private Node<List<ALegComplete>> currentLegs;
    private boolean isWithLegs;

    public PaxKeyChooserPanel(Node<List<SeatConfigurationComplete>> allSeatConfs, Node<List<ALegComplete>> legs, Node paxKeySets) {
        this(allSeatConfs, legs, paxKeySets, false);
    }

    public PaxKeyChooserPanel(Node<List<SeatConfigurationComplete>> allSeatConfs, Node<List<ALegComplete>> legs, Node paxKeySets, boolean isWithLegs) {
        this.node = allSeatConfs;
        this.paxKeys = paxKeySets;
        this.isWithLegs = isWithLegs;
        this.currentLegs = legs;
        this.table = new Table2(false, "");
        this.table.setComparator(ComparatorRegistry.getComparator(RowSorter.class));
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(1.0, 0.0, Words.CLASS, null, null, null, "", 30, 30, 30));
        Collections.sort((List)legs.getValue());
        if (isWithLegs) {
            for (ILegComplete l : (List)legs.getValue()) {
                columns.add(new TableColumnInfo(0.0, 0.0, "LEG " + (l.getNumber() + 1), null, null, null, "", 60, 60, 60));
            }
        } else {
            columns.add(new TableColumnInfo(0.0, 0.0, Words.DELIVER, null, null, null, "", 70, 70, 70));
        }
        Table2Model tModel = new Table2Model(columns, true);
        tModel.setTransposed(true);
        tModel.setViewFactory(model -> {
            Table2RowLayoutConstrain c1 = new Table2RowLayoutConstrain(new TextLabel(model.getNode().getChildNamed(new String[]{"cabinClass"}), ConverterRegistry.getConverter(CabinClassConverter.class)), 0, 13);
            ArrayList<Table2RowLayoutConstrain> constr = new ArrayList<Table2RowLayoutConstrain>();
            constr.add(c1);
            if (isWithLegs) {
                for (ILegComplete leg : (List)this.currentLegs.getValue()) {
                    Table2RowLayoutConstrain c3 = new Table2RowLayoutConstrain(new CheckBox(), leg.getNumber() + 1, 7, this.table.getCellPadding(), -1, -1);
                    ((CheckBox)c3.getView()).addButtonListener(this);
                    constr.add(c3);
                }
            } else {
                Table2RowLayoutConstrain c2 = new Table2RowLayoutConstrain(new CheckBox(), 1, 7, this.table.getCellPadding(), -1, -1);
                ((CheckBox)c2.getView()).addButtonListener(this);
                constr.add(c2);
            }
            DefaultTable2RowImpl d = new DefaultTable2RowImpl(model, false, false, constr);
            d.setUserObject(model.getNode().getChildNamed(new String[]{"cabinClass"}));
            d.setRequestFocusEnabled(false);
            d.setSelectable(false);
            return d;
        });
        this.table.setModel(tModel);
        this.table.getFader().setPermanent(true);
        this.table.getModel().setNode(this.node);
        this.table.setProgress(1.0f);
        tModel.allInitiated();
        this.setLayout(new Layout());
        this.setOpaque(false);
        this.table.updateOrder();
        this.selectCurrent();
        this.add(this.table);
    }

    private void selectCurrent() {
        for (Table2RowPanel p : this.table.getRows()) {
            DefaultTable2RowImpl d = (DefaultTable2RowImpl)p;
            Iterator it = this.paxKeys.getChilds();
            boolean found = false;
            while (it.hasNext() && !found) {
                Node set = (Node)it.next();
                Node cc = set.getChildNamed(new String[]{"paxClass"});
                if (!((Node)d.getUserObject()).getValue().equals(cc.getValue())) continue;
                if (this.isWithLegs) {
                    Iterator it2 = set.getChildNamed(new String[]{"legs"}).getFailSafeChildIterator();
                    while (it2.hasNext()) {
                        Node legNode = (Node)it2.next();
                        ((CheckBox)d.getComponentViewAt(((ALegComplete)legNode.getValue()).getNumber() + 1)).setChecked(true);
                    }
                } else {
                    ((CheckBox)d.getComponentViewAt(1)).setChecked(true);
                }
                found = true;
            }
            if (found) continue;
            ((CheckBox)d.getComponentViewAt(1)).setChecked(false);
        }
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
    }

    @Override
    public boolean tryToGrabFocus() {
        this.table.requestFocusInWindowNow();
        return true;
    }

    private APassengerSetComplete createPassengerSet() {
        List legs = (List)this.currentLegs.getValue();
        if (legs.isEmpty()) {
            return null;
        }
        if (legs.get(0) instanceof StowingListTemplateLegComplete) {
            return new PassengerSetTemplateComplete();
        }
        if (legs.get(0) instanceof FlightLegComplete) {
            return new PassengerSetComplete();
        }
        if (legs.get(0) instanceof StowingListTemplateVariantLegComplete) {
            return new PassengerSetTemplateComplete();
        }
        throw new IllegalStateException("Invalid Leg type!");
    }

    private Node<APassengerSetComplete> getSetForClass(CabinClassComplete cc) {
        Iterator it = this.paxKeys.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node pc = (Node)it.next();
            if (!((APassengerSetComplete)pc.getValue()).getPaxClass().equals((Object)cc)) continue;
            return pc;
        }
        APassengerSetComplete psk = this.createPassengerSet();
        if (psk != null) {
            psk.setClientOId(Long.valueOf(ADTO.getNextId()));
            psk.setPaxClass(cc);
            if (this.paxKeys.getValue() == null) {
                this.paxKeys.setValue(new ArrayList(), 0L);
            }
        }
        ((List)this.paxKeys.getValue()).add(psk);
        Node nn = INodeCreator.getDefaultImpl().getNode4DTO((Object)psk, true, false);
        this.paxKeys.addChild(nn, 0L);
        return nn;
    }

    private ALegComplete getLegForInt(int i) {
        return (ALegComplete)((List)this.currentLegs.getValue()).get(i);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        for (Table2RowPanel p : this.table.getRows()) {
            DefaultTable2RowImpl d = (DefaultTable2RowImpl)p;
            CabinClassComplete currentCC = (CabinClassComplete)((TextLabel)d.getComponent(0)).getNode().getValue();
            if (this.isWithLegs) {
                for (int i = 1; i < this.table.getModel().getColumnCount(); ++i) {
                    ALegComplete leg;
                    Node<APassengerSetComplete> psk;
                    Component c = d.getComponentViewAt(i);
                    if (c != source) continue;
                    CheckBox check = (CheckBox)c;
                    if (check.isChecked()) {
                        psk = this.getSetForClass(currentCC);
                        leg = this.getLegForInt(i - 1);
                        if (leg instanceof StowingListTemplateVariantLegComplete) {
                            PassengerSetTemplateComplete pstc = (PassengerSetTemplateComplete)psk.getValue();
                            pstc.getLegs().add((StowingListTemplateVariantLegComplete)leg);
                        } else if (leg instanceof FlightLegComplete) {
                            PassengerSetComplete psc = (PassengerSetComplete)psk.getValue();
                            psc.getLegs().add((FlightLegComplete)leg);
                        }
                        psk.getChildNamed(new String[]{"legs"}).addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)leg, false, true), 0L);
                        continue;
                    }
                    psk = this.getSetForClass(currentCC);
                    leg = this.getLegForInt(i - 1);
                    ((APassengerSetComplete)psk.getValue()).getLegs().remove(leg);
                    psk.getChildNamed(new String[]{"legs"}).removeChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)leg, false, true), 0L);
                    if (!((APassengerSetComplete)psk.getValue()).getLegs().isEmpty()) continue;
                    this.paxKeys.removeChild(psk, 0L);
                }
                continue;
            }
            CheckBox b = (CheckBox)d.getComponentViewAt(1);
            if (b != source) continue;
            if (b.isChecked()) {
                APassengerSetComplete psk = this.createPassengerSet();
                if (psk == null) continue;
                psk.setClientOId(Long.valueOf(ADTO.getNextId()));
                psk.setPaxClass((CabinClassComplete)((Node)d.getUserObject()).getValue());
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)psk, true, false);
                this.paxKeys.addChild(n, System.currentTimeMillis());
                continue;
            }
            Iterator it = this.paxKeys.getChilds();
            boolean found = false;
            while (it.hasNext() && !found) {
                Node set = (Node)it.next();
                Node cc = set.getChildNamed(new String[]{"paxClass"});
                if (!((Node)d.getUserObject()).getValue().equals(cc.getValue())) continue;
                set.getParent().removeChild(set, System.currentTimeMillis());
                found = true;
            }
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.table.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            PaxKeyChooserPanel.this.table.setLocation(0, 0);
            PaxKeyChooserPanel.this.table.setSize(parent.getWidth(), parent.getHeight() - 2);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(200, 200);
        }
    }
}

